/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sgkms.ResourceManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;

public class CustomAlert
extends Alert {
    public static final ButtonType YES = ButtonType.YES;
    public static final ButtonType NO = ButtonType.NO;
    public static final ButtonType CANCEL = ButtonType.CANCEL;

    public CustomAlert(Alert.AlertType alertType, String title, String headerText, String contentText) {
        super(alertType);
        this.setTitle(title);
        this.setHeaderText(headerText);
        this.setContentText(contentText);
        this.getDialogPane().getChildren().stream().filter(node -> node instanceof Label).forEach(node -> ((Label)node).setMinHeight(Double.NEGATIVE_INFINITY));
    }

    public CustomAlert(AlertType alertType, String title, String headerText, String contentText) {
        super(Alert.AlertType.CONFIRMATION);
        this.setTitle(title);
        this.setHeaderText(headerText);
        this.setContentText(contentText);
        this.getButtonTypes().setAll((Object[])new ButtonType[]{NO, YES, CANCEL});
        this.getDialogPane().getChildren().stream().filter(node -> node instanceof Label).forEach(node -> ((Label)node).setMinHeight(Double.NEGATIVE_INFINITY));
    }

    public CustomAlert(String title, String headerText, String contentText, Throwable ex) {
        this(Alert.AlertType.ERROR, title, headerText, contentText);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String exceptionText = sw.toString();
        Label label = new Label(ResourceManager.getString("info.alert.ex"));
        TextArea textArea = new TextArea(exceptionText);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)label, 0, 0);
        expContent.add((Node)textArea, 0, 1);
        this.getDialogPane().setExpandableContent((Node)expContent);
        this.getDialogPane().setExpanded(true);
        this.getDialogPane().getScene().getWindow().sizeToScene();
        this.getDialogPane().expandedProperty().addListener(l -> Platform.runLater(() -> {
            this.getDialogPane().requestLayout();
            Stage stage = (Stage)this.getDialogPane().getScene().getWindow();
            stage.sizeToScene();
        }));
    }

    public static enum AlertType {
        YESNOCANCEL;

    }
}

