/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.model.DataSets;
import com.servergeneral.sgkms.model.Policy;
import com.servergeneral.sgkms.util.FileUtil;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.GridPane;
import javafx.stage.Window;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProtectedDataSet
extends Dialog<Void>
implements Initializable {
    @FXML
    private Label fxTitleApp;
    @FXML
    private Hyperlink btnExit;
    @FXML
    private TableView<DataSets> tableView;
    @FXML
    private TableColumn<DataSets, String> pathColumn;
    @FXML
    private TableColumn<DataSets, String> algoColumn;
    @FXML
    private TableColumn<DataSets, String> createOnColumn;
    @FXML
    private TableColumn<DataSets, String> usersColumn;
    @FXML
    private TableColumn<DataSets, String> daColumn;
    @FXML
    private TableColumn<DataSets, String> statusColumn;
    private static final Logger logger = LogManager.getLogger();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.ENGLISH);
    private final SimpleDateFormat reportFormat = new SimpleDateFormat("yyyy-MMM-dd");

    public void initialize(URL url, ResourceBundle rb) {
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.pathColumn.setCellValueFactory(cellData -> ((DataSets)cellData.getValue()).getPath());
        this.algoColumn.setCellValueFactory(cellData -> ((DataSets)cellData.getValue()).getAlgo());
        this.algoColumn.setStyle("-fx-alignment: CENTER;");
        this.createOnColumn.setCellValueFactory(cellData -> ((DataSets)cellData.getValue()).getCreationDate());
        this.createOnColumn.setStyle("-fx-alignment: CENTER;");
        this.usersColumn.setCellValueFactory(cellData -> ((DataSets)cellData.getValue()).getUsers());
        this.daColumn.setCellValueFactory(cellData -> ((DataSets)cellData.getValue()).getDataAdmin());
        this.statusColumn.setCellValueFactory(cellData -> ((DataSets)cellData.getValue()).getStatus());
        this.statusColumn.setStyle("-fx-alignment: CENTER;");
        Platform.runLater(() -> this.loadData());
    }

    public ProtectedDataSet() throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/protected-data-set.fxml"), ResourceManager.resourceBundle);
        fxmlLoader.setController((Object)this);
        GridPane layout = (GridPane)fxmlLoader.load();
        this.getDialogPane().setContent((Node)layout);
        this.setResizable(true);
        this.setTitle(ResourceManager.getString("info.dialog.compliance.data-sets.title"));
        Window window = this.getDialogPane().getScene().getWindow();
        window.setOnCloseRequest(event -> window.hide());
        window.sizeToScene();
    }

    @FXML
    private void close(ActionEvent event) {
        this.getDialogPane().getScene().getWindow().hide();
    }

    private void loadData() {
        FileUtil.chown("/etc/serverg/serverg.conf", "sgadmin", "sgadmin");
        ObservableList<Policy> policies = FileUtil.getPolicyList("/etc/serverg/serverg.conf");
        this.tableView.getItems().clear();
        for (Policy p : policies) {
            if (p.getRepo() == null) continue;
            String fecha = "N/A";
            Properties props = null;
            try {
                props = FileUtil.loadPropertiesFile("/etc/serverg/sg-tde.properties");
                if (props != null) {
                    try {
                        String fechaNum = props.getProperty("policy.create_date." + p.getPolicy_shortname().getValue());
                        fecha = this.reportFormat.format(new Date(Long.parseLong(fechaNum)));
                    }
                    catch (Exception ex) {
                        logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution: ") + ex.getMessage());
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution: ") + ex.getMessage());
            }
            String[] repos = p.getRepo().getValue().split("\\b*,\\b*");
            String[] encrepos = p.getEncodedPath().split("\\b*,\\b*");
            for (int i = 0; i < repos.length; ++i) {
                String status = "Unknown";
                try {
                    status = SGAManager.getInstance().isPolicyMounted(encrepos[i], true) ? ResourceManager.getString("info.status.policy.mounted") : ResourceManager.getString("info.status.policy.unmounted");
                }
                catch (NoSGAdminException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + ex.getMessage());
                }
                if (p.getCreated() != null) {
                    try {
                        fecha = this.reportFormat.format(this.dateFormat.parse(p.getCreated().getValue()));
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                this.tableView.getItems().add((Object)new DataSets(repos[i], p.getCipher().getValue(), fecha, p.getAllowed_users().getValue(), p.getDa_id().getValue(), status));
            }
        }
    }
}

