/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sga.SMKRotateException;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.util.Map;
import javafx.concurrent.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskRotateSMK
extends Task<Boolean> {
    private static final Logger logger = LogManager.getLogger();
    private Map<String, String> userData;

    public TaskRotateSMK(Map<String, String> userData) {
        this.userData = userData;
    }

    protected Boolean call() throws Exception {
        this.updateTitle(ResourceManager.getString("info.smk.rotating"));
        SGAManager sga = SGAManager.getInstance();
        logger.log(Level.INFO, ResourceManager.getString("log.info.smk.rotating"));
        try {
            if (sga.smkRotate()) {
                this.updateTitle(ResourceManager.getString("info.smk.rotate"));
                logger.log(Level.INFO, ResourceManager.getString("info.smk.rotate"));
            } else {
                this.updateMessage(ResourceManager.getString("error.smk.rotate"));
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, ResourceManager.getString("error.smk.rotate"));
            }
        }
        catch (NoSGAdminException | SMKRotateException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.updateMessage(ex.getMessage());
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
            this.userData.clear();
        }
        return Boolean.TRUE;
    }
}

