/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.util;

import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.model.Actor;
import com.servergeneral.sgkms.model.Policy;
import com.servergeneral.system.EnumSysMessages;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import com.servergeneral.system.ProcessExecutor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtil {
    private static final Logger logger = LogManager.getLogger();

    public static String getNextLine(StringBuffer data) {
        int endline = data.indexOf("\n");
        String line = null;
        if (endline == 0) {
            data.deleteCharAt(0);
            line = "";
        } else if (endline > 0) {
            line = data.substring(0, endline);
            data.delete(0, endline + 1);
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLineFromFileContaining(String filename, String regex) {
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = input.readLine()) != null) {
                if (!line.matches(regex)) continue;
                String string = line;
                return string;
            }
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARN, ResourceManager.getString("log.error.inputfile.close"), (Throwable)ex);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Actor getSO(String filename) {
        Actor newSO = null;
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            boolean elements = false;
            newSO = new Actor();
            while ((line = input.readLine()) != null) {
                logger.log(Level.DEBUG, "###so.conf: " + line);
                if (line.matches("so_id=.+")) {
                    newSO.setId((StringProperty)new SimpleStringProperty(line.substring(6).trim()));
                    newSO.setType((StringProperty)new SimpleStringProperty("so"));
                }
                if (line.matches("so_fname=.+")) {
                    newSO.setFname((StringProperty)new SimpleStringProperty(line.substring(9).trim()));
                }
                if (line.matches("so_lname=.+")) {
                    newSO.setLname((StringProperty)new SimpleStringProperty(line.substring(9).trim()));
                }
                if (line.matches("so_email=.+")) {
                    newSO.setEmail((StringProperty)new SimpleStringProperty(line.substring(9).trim()));
                }
                if (line.matches("so_phone=.+")) {
                    newSO.setPhone((StringProperty)new SimpleStringProperty(line.substring(9).trim()));
                }
                if (!line.matches("creation_time=.+")) continue;
                logger.log(Level.DEBUG, "###found: " + line.substring(14).trim());
                newSO.setCreated((StringProperty)new SimpleStringProperty(line.substring(14).trim()));
            }
            Actor actor = newSO;
            return actor;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARN, ResourceManager.getString("log.error.inputfile.close"), (Throwable)ex);
                }
            }
        }
        return null;
    }

    public static ObservableList<Actor> getDAList(String filename) {
        return FileUtil.getDAList(filename, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObservableList<Actor> getDAList(String filename, boolean isRevokeStyle) {
        ObservableList list = FXCollections.observableArrayList();
        FileUtil.chown(filename, "sgadmin", "sgadmin");
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            int elements = 0;
            Actor newDA = new Actor();
            while ((line = input.readLine()) != null) {
                logger.log(Level.DEBUG, "###da.conf: " + line);
                if ((!isRevokeStyle && line.contains("[") || isRevokeStyle && line.contains("da_id=")) && elements > 0) {
                    list.add((Object)newDA);
                }
                if (!isRevokeStyle && line.contains("[") || isRevokeStyle && line.contains("da_id=")) {
                    newDA = new Actor();
                }
                if (line.matches("da_id=.+")) {
                    newDA.setId((StringProperty)new SimpleStringProperty(line.substring(6).trim()));
                    newDA.setType((StringProperty)new SimpleStringProperty("da"));
                    ++elements;
                }
                if (line.matches("da_fname=.+")) {
                    newDA.setFname((StringProperty)new SimpleStringProperty(line.substring(9).trim()));
                }
                if (line.matches("da_lname=.+")) {
                    newDA.setLname((StringProperty)new SimpleStringProperty(line.substring(9).trim()));
                }
                if (line.matches("da_email=.+")) {
                    newDA.setEmail((StringProperty)new SimpleStringProperty(line.substring(9).trim()));
                }
                if (line.matches("da_phone=.+")) {
                    newDA.setPhone((StringProperty)new SimpleStringProperty(line.substring(9).trim()));
                }
                if (line.matches("creation_time=.+")) {
                    logger.log(Level.DEBUG, "###found: " + line.substring(14).trim());
                    newDA.setCreated((StringProperty)new SimpleStringProperty(line.substring(14).trim()));
                }
                if (!line.matches("revoked_time=.+")) continue;
                newDA.setRevoked((StringProperty)new SimpleStringProperty(line.substring(13).trim()));
            }
            if (newDA != null && elements > 0) {
                list.add((Object)newDA);
            }
            ObservableList observableList = list;
            return observableList;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARN, ResourceManager.getString("log.error.inputfile.close"), (Throwable)ex);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObservableList<Policy> getPolicyList(String filename) {
        ObservableList list = FXCollections.observableArrayList();
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            int elements = 0;
            Policy newPolicy = new Policy();
            while ((line = input.readLine()) != null) {
                String value;
                logger.log(Level.DEBUG, "###serverg.conf: " + line);
                if (line.contains("[POLICIES]")) {
                    ++elements;
                    continue;
                }
                if (elements <= 0 || line.contains("[\\")) continue;
                if (line.contains("[") && elements > 1) {
                    list.add((Object)newPolicy);
                }
                if (line.contains("[")) {
                    newPolicy = new Policy();
                    newPolicy.setStatus(0);
                    String shortname = line.substring(line.indexOf("[") + 1).substring(0, line.length() - 2);
                    newPolicy.setPolicy_shortname((StringProperty)new SimpleStringProperty(shortname));
                    ++elements;
                }
                if (line.matches("da_id=.+")) {
                    newPolicy.setDa_id((StringProperty)new SimpleStringProperty(line.substring(6).trim()));
                }
                if (line.matches("cipher=.+")) {
                    newPolicy.setCipher((StringProperty)new SimpleStringProperty(line.substring(7).trim()));
                }
                if (line.matches("repo=.+")) {
                    value = line.substring(5).trim();
                    String[] valueArray = value.split(",");
                    String fvalue = "";
                    if (newPolicy.getRepo() != null) {
                        fvalue = newPolicy.getRepo().getValue() + ",";
                    }
                    fvalue = fvalue + valueArray[0];
                    newPolicy.setRepo((StringProperty)new SimpleStringProperty(fvalue));
                    newPolicy.setEncodedPath((newPolicy.getEncodedPath() == null ? "" : newPolicy.getEncodedPath() + ",") + valueArray[1]);
                }
                if (line.matches("app_name=.+")) {
                    newPolicy.setApp_name((StringProperty)new SimpleStringProperty(line.substring(9).trim()));
                }
                if (line.matches("allowed_users=.+")) {
                    value = line.substring(14).trim();
                    newPolicy.setAllowed_users((StringProperty)new SimpleStringProperty(value));
                }
                if (!line.matches("creation_time=.+")) continue;
                logger.log(Level.DEBUG, "###found: " + line.substring(14).trim());
                newPolicy.setCreated((StringProperty)new SimpleStringProperty(line.substring(14).trim()));
            }
            if (newPolicy != null && elements > 1) {
                list.add((Object)newPolicy);
            }
            ObservableList observableList = list;
            return observableList;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARN, ResourceManager.getString("log.error.inputfile.close"), (Throwable)ex);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResponsibleFor(String filename, String da_id) {
        String valorRet = "";
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            int elements = 0;
            String current_da = "";
            String current_policyName = "";
            String current_paths = "";
            while ((line = input.readLine()) != null) {
                if (line.contains("[POLICIES]")) {
                    ++elements;
                    continue;
                }
                if (elements <= 0 || line.contains("[\\")) continue;
                if (line.contains("[")) {
                    String shortname;
                    if (current_da.equals(da_id)) {
                        if (valorRet.length() > 0) {
                            valorRet = valorRet + ", ";
                        }
                        valorRet = valorRet + current_policyName + "(" + current_paths + ")";
                    }
                    current_da = "";
                    current_policyName = "";
                    current_paths = "";
                    current_policyName = shortname = line.substring(line.indexOf("[") + 1).substring(0, line.length() - 2);
                }
                if (line.matches("da_id=.+")) {
                    current_da = line.substring(6).trim();
                }
                if (!line.matches("repo=.+")) continue;
                String value = line.substring(5).trim();
                String[] valueArray = value.split(",");
                String fvalue = "";
                if (current_paths.length() > 0) {
                    current_paths = current_paths + ", ";
                }
                fvalue = fvalue + valueArray[0];
                current_paths = current_paths + fvalue;
            }
            if (current_da.equals(da_id)) {
                if (valorRet.length() > 0) {
                    valorRet = valorRet + ", ";
                }
                valorRet = valorRet + current_policyName + "(" + current_paths + ")";
            }
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARN, ResourceManager.getString("log.error.inputfile.close"), (Throwable)ex);
                }
            }
        }
        return valorRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAdmFullnameFromSgaFile(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        BufferedReader input = null;
        String fname = null;
        String lname = null;
        try {
            String line;
            input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = input.readLine()) != null) {
                if (line.matches("(so|da)_lname=.+")) {
                    lname = line.substring(9).trim();
                } else if (line.matches("(so|da)_fname=.+")) {
                    fname = line.substring(9).trim();
                }
                if (fname == null || lname == null) continue;
                String string = fname + " " + lname;
                return string;
            }
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARN, ResourceManager.getString("log.error.inputfile.close"), (Throwable)ex);
                }
            }
        }
        return null;
    }

    public static Date getFileModifiedDate(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        return new Date(file.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createAdmConfigFile(String id, String first, String last, String email, String phone, boolean soConfig) {
        BufferedWriter output = null;
        try {
            String prefix = soConfig ? "so_" : "da_";
            File tmpFile = File.createTempFile("sga", ".conf");
            output = new BufferedWriter(new FileWriter(tmpFile));
            output.write("lang=Eng");
            output.newLine();
            output.write(prefix + "id=" + id);
            output.newLine();
            if (first != null && !first.isEmpty()) {
                output.write(prefix + "fname=" + first);
                output.newLine();
            }
            if (last != null && !last.isEmpty()) {
                output.write(prefix + "lname=" + last);
                output.newLine();
            }
            if (email != null && !email.isEmpty()) {
                output.write(prefix + "email=" + email);
                output.newLine();
            }
            if (phone != null && !phone.isEmpty()) {
                output.write(prefix + "phone=" + phone);
                output.newLine();
            }
            output.flush();
            String string = tmpFile.getAbsolutePath();
            return string;
        }
        catch (IOException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.ERROR, "", (Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createPolicyConfigFile(String policy, String repos, String app, String allowedUsers, String da) {
        BufferedWriter output = null;
        try {
            File tmpFile = File.createTempFile("new_policy", ".conf");
            output = new BufferedWriter(new FileWriter(tmpFile));
            output.write("# Short name for the security policy");
            output.newLine();
            output.write("policy_shortname=" + policy);
            output.newLine();
            output.newLine();
            output.write("# Data Admin name");
            output.newLine();
            output.write("da_id=" + da);
            output.newLine();
            output.newLine();
            output.write("# Type of ciphers supported : aes, blowfish, twofish.");
            output.newLine();
            output.write("cipher=aes");
            output.newLine();
            output.write("# Repositories to protect - in the format:");
            output.newLine();
            output.write("# unencrypted_directory_1,unencrypted_directory_2,...");
            output.newLine();
            output.newLine();
            output.write("repo=" + repos);
            output.newLine();
            if (app != null && !app.isEmpty()) {
                output.write("app_name=" + app);
                output.newLine();
            }
            if (allowedUsers != null && !allowedUsers.isEmpty()) {
                output.write("allowed_users=" + allowedUsers);
                output.newLine();
            }
            output.flush();
            String string = tmpFile.getAbsolutePath();
            return string;
        }
        catch (IOException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.ERROR, "", (Throwable)ex);
            }
        }
        return null;
    }

    public static boolean existNonEmptyFolder(String path) throws MaxPwTryiesException, OperationCancelledException, NullUserInfoListenerException {
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return true;
        }
        return !FileUtil.isEmptyFolder(path);
    }

    public static boolean isEmptyFolder(String path) throws MaxPwTryiesException, OperationCancelledException, NullUserInfoListenerException {
        ProcessExecutor.ResultInfo result = null;
        logger.log(Level.INFO, ResourceManager.getString("log.info.folder.empty.check", path));
        try {
            List<ProcessExecutor.ParseOutput> _authCodes = Arrays.asList(EnumSysMessages.SYS_ENTER_SUDO_PW);
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSysMessages.ZERO_OUTPUT, EnumSysMessages.NON_ZERO_OUTPUT, EnumSysMessages.ANY_OUTPUT);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /bin/ls -A " + path + " | /usr/bin/wc -l 2>&1"};
            logger.log(Level.DEBUG, command[2]);
            result = ProcessExecutor.getInstance().runCommand(command, errCodes, null, _authCodes, null);
        }
        catch (MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.info.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSysMessages.NON_ZERO_OUTPUT) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.folder.empty.true", path));
            return false;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.info.folder.empty.false", path));
        return true;
    }

    public static Properties loadPropertiesFile(String filename) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(filename);
        Properties props = new Properties();
        props.load(in);
        in.close();
        return props;
    }

    public static void savePropertiesFile(String filename, Properties props, String comments) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(filename);
        props.store(out, comments);
        out.close();
    }

    public static boolean createAdministrativeFile(String filepath) {
        ProcessExecutor.ResultInfo result = null;
        try {
            List<ProcessExecutor.ParseOutput> _authCodes = Arrays.asList(EnumSysMessages.SYS_ENTER_SUDO_PW);
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSysMessages.ANY_OUTPUT);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S touch " + filepath + " 2>&1"};
            logger.log(Level.DEBUG, command[2]);
            result = ProcessExecutor.getInstance().runCommand(command, errCodes, null, _authCodes, null);
            if (result != null && result.resultCode != EnumSysMessages.ANY_OUTPUT) {
                command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S chmod 666 " + filepath + " 2>&1"};
                logger.log(Level.DEBUG, command[2]);
                result = ProcessExecutor.getInstance().runCommand(command, errCodes, null, _authCodes, null);
            }
        }
        catch (MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            return false;
        }
        if (result == null) {
            return false;
        }
        return result.resultCode != EnumSysMessages.ANY_OUTPUT;
    }

    public static boolean chmod(String filepath, String mode) {
        ProcessExecutor.ResultInfo result = null;
        try {
            List<ProcessExecutor.ParseOutput> _authCodes = Arrays.asList(EnumSysMessages.SYS_ENTER_SUDO_PW);
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSysMessages.ANY_OUTPUT);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S chmod " + mode + " " + filepath + " 2>&1"};
            logger.log(Level.DEBUG, command[2]);
            result = ProcessExecutor.getInstance().runCommand(command, errCodes, null, _authCodes, null);
        }
        catch (MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            return false;
        }
        if (result == null) {
            return false;
        }
        return result.resultCode != EnumSysMessages.ANY_OUTPUT;
    }

    public static boolean chown(String filepath, String owner, String group) {
        ProcessExecutor.ResultInfo result = null;
        try {
            List<ProcessExecutor.ParseOutput> _authCodes = Arrays.asList(EnumSysMessages.SYS_ENTER_SUDO_PW);
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSysMessages.ANY_OUTPUT);
            String own = group != null ? owner + "." + group : owner;
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S chown " + own + " " + filepath + " 2>&1"};
            logger.log(Level.DEBUG, command[2]);
            result = ProcessExecutor.getInstance().runCommand(command, errCodes, null, _authCodes, null);
        }
        catch (MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            return false;
        }
        if (result == null) {
            return false;
        }
        return result.resultCode != EnumSysMessages.ANY_OUTPUT;
    }
}

