/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.util;

import com.servergeneral.sgkms.ResourceManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.IllegalBlockingModeException;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkUtil {
    private static final Logger logger = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pingHost(String host, int port, int timeout) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), timeout);
            boolean bl = true;
            return bl;
        }
        catch (IOException | IllegalArgumentException | IllegalBlockingModeException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    logger.log(Level.ERROR, ResourceManager.getString("log.error.socket.closing"), (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pingHost(String host, int port) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port));
            boolean bl = true;
            return bl;
        }
        catch (IOException | IllegalArgumentException | IllegalBlockingModeException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    logger.log(Level.ERROR, ResourceManager.getString("log.error.socket.closing"), (Throwable)ex);
                }
            }
        }
    }

    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                String ip = NetworkUtil.getInterfaceInformation(netint);
                if (ip == null) continue;
                return ip;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "127.0.0.1";
    }

    public static String getAllIpAddresses() {
        StringBuilder strBuild = new StringBuilder();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                String ip = NetworkUtil.getInterfaceInformation(netint);
                if (ip == null) continue;
                strBuild.append(strBuild.length() > 0 ? "," : "").append(ip);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return strBuild.length() == 0 ? "127.0.0.1" : strBuild.toString();
    }

    private static String getInterfaceInformation(NetworkInterface netint) {
        Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
        for (InetAddress inetAddress : Collections.list(inetAddresses)) {
            if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
            return inetAddress.getHostAddress();
        }
        return null;
    }
}

