/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.conf.ReadableProperty;
import com.mysql.cj.api.io.ResultsHandler;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.RowData;
import com.mysql.cj.core.Constants;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.MysqlType;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.io.FullReadInputStream;
import com.mysql.cj.core.io.MysqlBinaryValueDecoder;
import com.mysql.cj.core.io.MysqlTextValueDecoder;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.core.util.LazyString;
import com.mysql.cj.core.util.Util;
import com.mysql.cj.jdbc.BufferRow;
import com.mysql.cj.jdbc.ByteArrayRow;
import com.mysql.cj.jdbc.ResultSetImpl;
import com.mysql.cj.jdbc.ResultSetRow;
import com.mysql.cj.jdbc.RowDataCursor;
import com.mysql.cj.jdbc.RowDataDynamic;
import com.mysql.cj.jdbc.RowDataStatic;
import com.mysql.cj.jdbc.ServerPreparedStatement;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.UpdatableResultSet;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.mysqla.MysqlaUtils;
import com.mysql.cj.mysqla.io.Buffer;
import com.mysql.cj.mysqla.io.MysqlaProtocol;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class MysqlIO
implements ResultsHandler {
    protected static final int NULL_LENGTH = -1;
    protected static final int MIN_COMPRESS_LEN = 50;
    private static int maxBufferSize = 65535;
    protected static final int MAX_QUERY_SIZE_TO_LOG = 1024;
    protected static final String ZERO_DATE_VALUE_MARKER = "0000-00-00";
    protected static final String ZERO_DATETIME_VALUE_MARKER = "0000-00-00 00:00:00";
    private SoftReference<Buffer> loadFileBufRef;
    private MysqlaProtocol protocol;
    private PropertySet propertySet;
    private JdbcConnection connection;
    protected RowData streamingData = null;
    protected ReadableProperty<Integer> useBufferRowSizeThreshold;
    protected ReadableProperty<Boolean> useDirectRowUnpack;

    public MysqlIO(MysqlaProtocol protocol, PropertySet propertySet, JdbcConnection connection) {
        this.protocol = protocol;
        this.propertySet = propertySet;
        this.connection = connection;
        this.useBufferRowSizeThreshold = this.propertySet.getMemorySizeReadableProperty("largeRowSizeThreshold");
        this.useDirectRowUnpack = this.propertySet.getBooleanReadableProperty("useDirectRowUnpack");
    }

    protected ResultSetImpl getResultSet(StatementImpl callingStatement, long columnCount, int maxRows, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, boolean isBinaryEncoded, Field[] metadataFromCache) throws SQLException {
        int i;
        Field[] fields = null;
        if (metadataFromCache == null) {
            fields = new Field[(int)columnCount];
            i = 0;
            while ((long)i < columnCount) {
                Buffer fieldPacket = null;
                fieldPacket = this.protocol.readPacket();
                fields[i] = this.unpackField(fieldPacket, this.connection.getCharacterSetMetadata());
                ++i;
            }
        } else {
            i = 0;
            while ((long)i < columnCount) {
                this.protocol.skipPacket();
                ++i;
            }
        }
        Buffer packet = this.protocol.reuseAndReadPacket(this.protocol.getReusablePacket());
        this.readServerStatusForResultSets(packet);
        if (this.propertySet.getBooleanReadableProperty("useCursorFetch").getValue().booleanValue() && isBinaryEncoded && callingStatement != null && callingStatement.getFetchSize() != 0 && callingStatement.getResultSetType() == 1003) {
            ServerPreparedStatement prepStmt = (ServerPreparedStatement)callingStatement;
            boolean usingCursor = true;
            usingCursor = this.protocol.getServerSession().cursorExists();
            if (usingCursor) {
                RowDataCursor rows = new RowDataCursor(this.protocol.getServerSession(), this.protocol, prepStmt, fields);
                ResultSetImpl rs = this.buildResultSetWithRows(callingStatement, catalog, fields, rows, resultSetType, resultSetConcurrency);
                if (usingCursor) {
                    rs.setFetchSize(callingStatement.getFetchSize());
                }
                return rs;
            }
        }
        RowData rowData = null;
        if (!streamResults) {
            rowData = this.readSingleRowSet(columnCount, maxRows, resultSetConcurrency, isBinaryEncoded, metadataFromCache == null ? fields : metadataFromCache);
        } else {
            this.streamingData = rowData = new RowDataDynamic(this.protocol, (int)columnCount, metadataFromCache == null ? fields : metadataFromCache, isBinaryEncoded);
        }
        ResultSetImpl rs = this.buildResultSetWithRows(callingStatement, catalog, metadataFromCache == null ? fields : metadataFromCache, rowData, resultSetType, resultSetConcurrency);
        return rs;
    }

    protected Field unpackField(Buffer packet, String characterSetMetadata) {
        packet.fastSkipLenString();
        int offset = packet.getPosition() + 1;
        int length = packet.fastSkipLenString();
        offset = MysqlIO.adjustStartForFieldLength(offset, length);
        LazyString databaseName = new LazyString(packet.getByteBuffer(), offset, length, characterSetMetadata);
        offset = packet.getPosition() + 1;
        length = packet.fastSkipLenString();
        offset = MysqlIO.adjustStartForFieldLength(offset, length);
        LazyString tableName = new LazyString(packet.getByteBuffer(), offset, length, characterSetMetadata);
        offset = packet.getPosition() + 1;
        length = packet.fastSkipLenString();
        offset = MysqlIO.adjustStartForFieldLength(offset, length);
        LazyString originalTableName = new LazyString(packet.getByteBuffer(), offset, length, characterSetMetadata);
        offset = packet.getPosition() + 1;
        length = packet.fastSkipLenString();
        offset = MysqlIO.adjustStartForFieldLength(offset, length);
        LazyString columnName = new LazyString(packet.getByteBuffer(), offset, length, characterSetMetadata);
        offset = packet.getPosition() + 1;
        length = packet.fastSkipLenString();
        offset = MysqlIO.adjustStartForFieldLength(offset, length);
        LazyString originalColumnName = new LazyString(packet.getByteBuffer(), offset, length, characterSetMetadata);
        packet.readByte();
        short collationIndex = (short)packet.readInt();
        long colLength = 0L;
        colLength = packet.readLong();
        int colType = packet.readByte() & 0xFF;
        short colFlag = 0;
        colFlag = this.protocol.getServerSession().hasLongColumnInfo() ? (short)packet.readInt() : (short)(packet.readByte() & 0xFF);
        int colDecimals = packet.readByte() & 0xFF;
        String encoding = this.protocol.getServerSession().getEncodingForIndex(collationIndex);
        MysqlType mysqlType = MysqlaProtocol.findMysqlType(this.propertySet, colType, colFlag, colLength, tableName, originalTableName, collationIndex, encoding);
        return new Field(databaseName, tableName, originalTableName, columnName, originalColumnName, colLength, colType, colFlag, colDecimals, collationIndex, encoding, mysqlType);
    }

    private static int adjustStartForFieldLength(int nameStart, int nameLength) {
        if (nameLength < 251) {
            return nameStart;
        }
        if (nameLength >= 251 && nameLength < 65536) {
            return nameStart + 2;
        }
        if (nameLength >= 65536 && nameLength < 0x1000000) {
            return nameStart + 3;
        }
        return nameStart + 8;
    }

    protected boolean isSetNeededForAutoCommitMode(boolean autoCommitFlag) {
        if (this.propertySet.getBooleanReadableProperty("elideSetAutoCommits").getValue().booleanValue()) {
            boolean autoCommitModeOnServer = this.protocol.getServerSession().isAutocommit();
            if (!autoCommitFlag) {
                boolean inTransactionOnServer = this.protocol.getServerSession().inTransactionOnServer();
                return !inTransactionOnServer;
            }
            return autoCommitModeOnServer != autoCommitFlag;
        }
        return true;
    }

    static int getMaxBuf() {
        return maxBufferSize;
    }

    final ResultSetRow nextRow(Field[] fields, int columnCount, boolean isBinaryEncoded, int resultSetConcurrency, boolean canReuseRowPacketForBufferRow) throws SQLException {
        boolean useBufferRow = canReuseRowPacketForBufferRow || MysqlIO.forceBufferRow(fields);
        Buffer rowPacket = null;
        try {
            int lengthRead = this.protocol.getSocketConnection().getMysqlInput().readFully(this.protocol.getPacketHeaderBuf(), 0, 4);
            if (lengthRead < 4) {
                this.protocol.getSocketConnection().forceClose();
                throw new RuntimeException(Messages.getString("MysqlIO.43"));
            }
            int packetLength = (this.protocol.getPacketHeaderBuf()[0] & 0xFF) + ((this.protocol.getPacketHeaderBuf()[1] & 0xFF) << 8) + ((this.protocol.getPacketHeaderBuf()[2] & 0xFF) << 16);
            boolean bl = useBufferRow = useBufferRow || packetLength >= this.useBufferRowSizeThreshold.getValue();
            if (this.useDirectRowUnpack.getValue().booleanValue() && !isBinaryEncoded && !useBufferRow && packetLength < 0xFFFFFF) {
                return this.nextRowFast(packetLength, columnCount);
            }
            rowPacket = this.protocol.reuseAndReadPacket(this.protocol.getReusablePacket(), packetLength);
            this.protocol.checkErrorPacket(rowPacket);
            rowPacket.setPosition(rowPacket.getPosition() - 1);
        }
        catch (IOException ioEx) {
            throw SQLError.createCommunicationsException(this.connection, this.protocol.getPacketSentTimeHolder().getLastPacketSentTime(), this.protocol.getLastPacketReceivedTimeMs(), ioEx, this.protocol.getExceptionInterceptor());
        }
        if (rowPacket.isLastDataPacket()) {
            this.readServerStatusForResultSets(rowPacket);
            return null;
        }
        if (!isBinaryEncoded) {
            if (resultSetConcurrency == 1008 || !useBufferRow) {
                byte[][] rowData = new byte[columnCount][];
                for (int i = 0; i < columnCount; ++i) {
                    rowData[i] = rowPacket.readLenByteArray(0);
                }
                return new ByteArrayRow(rowData, this.protocol.getExceptionInterceptor());
            }
            if (!canReuseRowPacketForBufferRow) {
                this.protocol.setReusablePacket(new Buffer(rowPacket.getBufLength()));
            }
            return new BufferRow(rowPacket, fields, false, this.protocol.getExceptionInterceptor(), new MysqlTextValueDecoder());
        }
        rowPacket.setPosition(rowPacket.getPosition() + 1);
        if (resultSetConcurrency == 1008 || !useBufferRow) {
            return this.unpackBinaryResultSetRow(fields, rowPacket, resultSetConcurrency);
        }
        if (!canReuseRowPacketForBufferRow) {
            this.protocol.setReusablePacket(new Buffer(rowPacket.getBufLength()));
        }
        return new BufferRow(rowPacket, fields, true, this.protocol.getExceptionInterceptor(), new MysqlBinaryValueDecoder());
    }

    private ResultSetRow nextRowFast(int packetLength, int columnCount) throws SQLException, IOException {
        int remaining = packetLength;
        boolean firstTime = true;
        Object rowData = null;
        FullReadInputStream mysqlInput = this.protocol.getSocketConnection().getMysqlInput();
        for (int i = 0; i < columnCount; ++i) {
            int sw = mysqlInput.read() & 0xFF;
            --remaining;
            if (firstTime) {
                if (sw == 255) {
                    Buffer errorPacket = new Buffer(packetLength + 4);
                    errorPacket.setPosition(0);
                    errorPacket.writeByte(this.protocol.getPacketHeaderBuf()[0]);
                    errorPacket.writeByte(this.protocol.getPacketHeaderBuf()[1]);
                    errorPacket.writeByte(this.protocol.getPacketHeaderBuf()[2]);
                    errorPacket.writeByte((byte)1);
                    errorPacket.writeByte((byte)sw);
                    mysqlInput.readFully(errorPacket.getByteBuffer(), 5, packetLength - 1);
                    errorPacket.setPosition(4);
                    this.protocol.checkErrorPacket(errorPacket);
                }
                if (sw == 254 && packetLength < 9) {
                    this.protocol.setWarningCount(mysqlInput.read() & 0xFF | (mysqlInput.read() & 0xFF) << 8);
                    remaining -= 2;
                    if (this.protocol.getWarningCount() > 0) {
                        this.protocol.setHadWarnings(true);
                    }
                    this.protocol.getServerSession().setStatusFlags(this.protocol.getSocketConnection().getMysqlInput().read() & 0xFF | (this.protocol.getSocketConnection().getMysqlInput().read() & 0xFF) << 8, true);
                    this.protocol.checkTransactionState();
                    if ((remaining -= 2) > 0) {
                        mysqlInput.skipFully(remaining);
                    }
                    return null;
                }
                rowData = new byte[columnCount][];
                firstTime = false;
            }
            int len = 0;
            switch (sw) {
                case 251: {
                    len = -1;
                    break;
                }
                case 252: {
                    len = mysqlInput.read() & 0xFF | (mysqlInput.read() & 0xFF) << 8;
                    remaining -= 2;
                    break;
                }
                case 253: {
                    len = mysqlInput.read() & 0xFF | (mysqlInput.read() & 0xFF) << 8 | (mysqlInput.read() & 0xFF) << 16;
                    remaining -= 3;
                    break;
                }
                case 254: {
                    len = (int)((long)(mysqlInput.read() & 0xFF) | (long)(mysqlInput.read() & 0xFF) << 8 | (long)(mysqlInput.read() & 0xFF) << 16 | (long)(mysqlInput.read() & 0xFF) << 24 | (long)(mysqlInput.read() & 0xFF) << 32 | (long)(mysqlInput.read() & 0xFF) << 40 | (long)(mysqlInput.read() & 0xFF) << 48 | (long)(mysqlInput.read() & 0xFF) << 56);
                    remaining -= 8;
                    break;
                }
                default: {
                    len = sw;
                }
            }
            if (len == -1) {
                rowData[i] = null;
                continue;
            }
            if (len == 0) {
                rowData[i] = Constants.EMPTY_BYTE_ARRAY;
                continue;
            }
            rowData[i] = new byte[len];
            int bytesRead = mysqlInput.readFully(rowData[i], 0, len);
            if (bytesRead != len) {
                throw SQLError.createCommunicationsException(this.connection, this.protocol.getPacketSentTimeHolder().getLastPacketSentTime(), this.protocol.getLastPacketReceivedTimeMs(), new IOException(Messages.getString("MysqlIO.43")), this.protocol.getExceptionInterceptor());
            }
            remaining -= bytesRead;
        }
        if (remaining > 0) {
            throw new IOException("Unable to read entire packet. Found '" + remaining + "' bytes remaining.");
        }
        return new ByteArrayRow((byte[][])rowData, this.protocol.getExceptionInterceptor());
    }

    boolean tackOnMoreStreamingResults(ResultSetImpl addingTo, boolean isBinaryEncoded) throws SQLException {
        if (this.protocol.getServerSession().hasMoreResults()) {
            boolean moreRowSetsExist = true;
            ResultSetImpl currentResultSet = addingTo;
            boolean firstTime = true;
            while (moreRowSetsExist && (firstTime || !currentResultSet.reallyResult())) {
                firstTime = false;
                Buffer fieldPacket = this.protocol.checkErrorPacket();
                fieldPacket.setPosition(0);
                Statement owningStatement = addingTo.getStatement();
                int maxRows = owningStatement.getMaxRows();
                ResultSetImpl newResultSet = this.readResultsForQueryOrUpdate((StatementImpl)owningStatement, maxRows, owningStatement.getResultSetType(), owningStatement.getResultSetConcurrency(), true, owningStatement.getConnection().getCatalog(), fieldPacket, isBinaryEncoded, -1L, null);
                currentResultSet.setNextResultSet(newResultSet);
                currentResultSet = newResultSet;
                moreRowSetsExist = this.protocol.getServerSession().hasMoreResults();
                if (currentResultSet.reallyResult() || moreRowSetsExist) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ResultSetImpl readAllResults(StatementImpl callingStatement, int maxRows, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Buffer resultPacket, boolean isBinaryEncoded, long preSentColumnCount, Field[] metadataFromCache) throws SQLException {
        ResultSetImpl topLevelResultSet;
        resultPacket.setPosition(resultPacket.getPosition() - 1);
        ResultSetImpl currentResultSet = topLevelResultSet = this.readResultsForQueryOrUpdate(callingStatement, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, resultPacket, isBinaryEncoded, preSentColumnCount, metadataFromCache);
        boolean checkForMoreResults = this.protocol.getServerSession().useMultiResults();
        boolean serverHasMoreResults = this.protocol.getServerSession().hasMoreResults();
        if (serverHasMoreResults && streamResults) {
            if (topLevelResultSet.getUpdateCount() != -1L) {
                this.tackOnMoreStreamingResults(topLevelResultSet, isBinaryEncoded);
            }
            this.protocol.reclaimLargeReusablePacket();
            return topLevelResultSet;
        }
        boolean moreRowSetsExist = checkForMoreResults & serverHasMoreResults;
        while (moreRowSetsExist) {
            Buffer fieldPacket = this.protocol.checkErrorPacket();
            fieldPacket.setPosition(0);
            ResultSetImpl newResultSet = this.readResultsForQueryOrUpdate(callingStatement, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, fieldPacket, isBinaryEncoded, preSentColumnCount, metadataFromCache);
            currentResultSet.setNextResultSet(newResultSet);
            currentResultSet = newResultSet;
            moreRowSetsExist = this.protocol.getServerSession().hasMoreResults();
        }
        if (!streamResults) {
            this.protocol.clearInputStream();
        }
        this.protocol.reclaimLargeReusablePacket();
        return topLevelResultSet;
    }

    protected final ResultSetImpl readResultsForQueryOrUpdate(StatementImpl callingStatement, int maxRows, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Buffer resultPacket, boolean isBinaryEncoded, long preSentColumnCount, Field[] metadataFromCache) throws SQLException {
        long columnCount = resultPacket.readFieldLength();
        if (columnCount == 0L) {
            return this.buildResultSetWithUpdates(callingStatement, resultPacket);
        }
        if (columnCount == -1L) {
            String charEncoding = this.propertySet.getStringReadableProperty("characterEncoding").getValue();
            String fileName = null;
            if (this.protocol.doesPlatformDbCharsetMatches()) {
                try {
                    fileName = charEncoding != null ? resultPacket.readString(charEncoding) : resultPacket.readString();
                }
                catch (CJException e) {
                    throw SQLExceptionsMapping.translateException(e, this.protocol.getExceptionInterceptor());
                }
            } else {
                fileName = resultPacket.readString();
            }
            return this.sendFileToServer(callingStatement, fileName);
        }
        ResultSetImpl results = this.getResultSet(callingStatement, columnCount, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, isBinaryEncoded, metadataFromCache);
        return results;
    }

    private int alignPacketSize(int a, int l) {
        return a + l - 1 & ~(l - 1);
    }

    private ResultSetImpl buildResultSetWithRows(StatementImpl callingStatement, String catalog, Field[] fields, RowData rows, int resultSetType, int resultSetConcurrency) throws SQLException {
        ResultSetImpl rs = null;
        switch (resultSetConcurrency) {
            case 1007: {
                rs = ResultSetImpl.getInstance(catalog, fields, rows, this.connection, callingStatement);
                break;
            }
            case 1008: {
                rs = new UpdatableResultSet(catalog, fields, rows, this.connection, callingStatement, this.protocol.getServerSession().hasLongColumnInfo());
                break;
            }
            default: {
                return ResultSetImpl.getInstance(catalog, fields, rows, this.connection, callingStatement);
            }
        }
        rs.setResultSetType(resultSetType);
        rs.setResultSetConcurrency(resultSetConcurrency);
        return rs;
    }

    private ResultSetImpl buildResultSetWithUpdates(StatementImpl callingStatement, Buffer resultPacket) throws SQLException {
        long updateCount = -1L;
        long updateID = -1L;
        String info = null;
        try {
            updateCount = resultPacket.readLength();
            updateID = resultPacket.readLength();
            this.protocol.getServerSession().setStatusFlags(resultPacket.readInt());
            this.protocol.checkTransactionState();
            this.protocol.setWarningCount(resultPacket.readInt());
            if (this.protocol.getWarningCount() > 0) {
                this.protocol.setHadWarnings(true);
            }
            resultPacket.readByte();
            this.protocol.setServerSlowQueryFlags();
            if (this.connection.isReadInfoMsgEnabled()) {
                info = resultPacket.readString(this.protocol.getServerSession().getErrorMessageEncoding());
            }
        }
        catch (CJException ex) {
            SQLException sqlEx = SQLError.createSQLException(SQLError.get("S1000"), "S1000", -1, ex, this.protocol.getExceptionInterceptor());
            throw sqlEx;
        }
        ResultSetImpl updateRs = ResultSetImpl.getInstance(updateCount, updateID, this.connection, callingStatement);
        if (info != null) {
            updateRs.setServerInfo(info);
        }
        return updateRs;
    }

    private final void readServerStatusForResultSets(Buffer rowPacket) throws SQLException {
        rowPacket.readByte();
        this.protocol.setWarningCount(rowPacket.readInt());
        if (this.protocol.getWarningCount() > 0) {
            this.protocol.setHadWarnings(true);
        }
        this.protocol.getServerSession().setStatusFlags(rowPacket.readInt(), true);
        this.protocol.checkTransactionState();
        this.protocol.setServerSlowQueryFlags();
    }

    private RowData readSingleRowSet(long columnCount, int maxRows, int resultSetConcurrency, boolean isBinaryEncoded, Field[] fields) throws SQLException {
        ArrayList<ResultSetRow> rows = new ArrayList<ResultSetRow>();
        ResultSetRow row = this.nextRow(fields, (int)columnCount, isBinaryEncoded, resultSetConcurrency, false);
        int rowCount = 0;
        if (row != null) {
            rows.add(row);
            rowCount = 1;
        }
        while (row != null) {
            row = this.nextRow(fields, (int)columnCount, isBinaryEncoded, resultSetConcurrency, false);
            if (row == null || maxRows != -1 && rowCount >= maxRows) continue;
            rows.add(row);
            ++rowCount;
        }
        RowDataStatic rowData = new RowDataStatic(rows);
        return rowData;
    }

    public static boolean forceBufferRow(Field[] fields) {
        if (fields == null) {
            return false;
        }
        for (int i = 0; i < fields.length; ++i) {
            switch (fields[i].getMysqlType()) {
                case BLOB: 
                case MEDIUMBLOB: 
                case LONGBLOB: 
                case TEXT: 
                case MEDIUMTEXT: 
                case LONGTEXT: {
                    return true;
                }
            }
        }
        return false;
    }

    private final ResultSetImpl sendFileToServer(StatementImpl callingStatement, String fileName) throws SQLException {
        Buffer filePacket = this.loadFileBufRef == null ? null : this.loadFileBufRef.get();
        int maxAllowedPacket = this.propertySet.getIntegerReadableProperty("maxAllowedPacket").getValue();
        int bigPacketLength = Math.min(maxAllowedPacket - 12, this.alignPacketSize(maxAllowedPacket - 16, 4096) - 12);
        int oneMeg = 0x100000;
        int smallerPacketSizeAligned = Math.min(oneMeg - 12, this.alignPacketSize(oneMeg - 16, 4096) - 12);
        int packetLength = Math.min(smallerPacketSizeAligned, bigPacketLength);
        if (filePacket == null) {
            try {
                filePacket = new Buffer(packetLength);
                filePacket.setPosition(0);
                this.loadFileBufRef = new SoftReference<Buffer>(filePacket);
            }
            catch (OutOfMemoryError oom) {
                throw SQLError.createSQLException(Messages.getString("MysqlIO.111", new Object[]{packetLength}), "HY001", this.protocol.getExceptionInterceptor());
            }
        }
        filePacket.setPosition(0);
        this.protocol.incrementPacketSequence();
        byte[] fileBuf = new byte[packetLength];
        BufferedInputStream fileIn = null;
        try {
            if (!this.propertySet.getBooleanReadableProperty("allowLoadLocalInfile").getValue().booleanValue()) {
                throw SQLError.createSQLException(Messages.getString("MysqlIO.LoadDataLocalNotAllowed"), "S1000", this.protocol.getExceptionInterceptor());
            }
            InputStream hookedStream = null;
            if (callingStatement != null) {
                hookedStream = callingStatement.getLocalInfileInputStream();
            }
            if (hookedStream != null) {
                fileIn = new BufferedInputStream(hookedStream);
            } else if (!this.propertySet.getBooleanReadableProperty("allowUrlInLocalInfile").getValue().booleanValue()) {
                fileIn = new BufferedInputStream(new FileInputStream(fileName));
            } else if (fileName.indexOf(58) != -1) {
                try {
                    URL urlFromFileName = new URL(fileName);
                    fileIn = new BufferedInputStream(urlFromFileName.openStream());
                }
                catch (MalformedURLException badUrlEx) {
                    fileIn = new BufferedInputStream(new FileInputStream(fileName));
                }
            } else {
                fileIn = new BufferedInputStream(new FileInputStream(fileName));
            }
            int bytesRead = 0;
            while ((bytesRead = fileIn.read(fileBuf)) != -1) {
                filePacket.setPosition(0);
                filePacket.writeBytesNoNull(fileBuf, 0, bytesRead);
                this.protocol.send(filePacket, filePacket.getPosition());
            }
        }
        catch (IOException ioEx) {
            StringBuilder messageBuf = new StringBuilder(Messages.getString("MysqlIO.60"));
            boolean isParanoid = this.propertySet.getBooleanReadableProperty("paranoid").getValue();
            if (fileName != null && !isParanoid) {
                messageBuf.append("'");
                messageBuf.append(fileName);
                messageBuf.append("'");
            }
            messageBuf.append(Messages.getString("MysqlIO.63"));
            if (!isParanoid) {
                messageBuf.append(Messages.getString("MysqlIO.64"));
                messageBuf.append(Util.stackTraceToString(ioEx));
            }
            throw SQLError.createSQLException(messageBuf.toString(), "S1009", this.protocol.getExceptionInterceptor());
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (Exception ex) {
                    SQLException sqlEx = SQLError.createSQLException(Messages.getString("MysqlIO.65"), "S1000", ex, this.protocol.getExceptionInterceptor());
                    throw sqlEx;
                }
                fileIn = null;
            } else {
                filePacket.setPosition(0);
                this.protocol.send(filePacket, filePacket.getPosition());
                this.protocol.checkErrorPacket();
            }
        }
        filePacket.setPosition(0);
        this.protocol.send(filePacket, filePacket.getPosition());
        Buffer resultPacket = this.protocol.checkErrorPacket();
        return this.buildResultSetWithUpdates(callingStatement, resultPacket);
    }

    private final ResultSetRow unpackBinaryResultSetRow(Field[] fields, Buffer binaryData, int resultSetConcurrency) throws SQLException {
        int numFields = fields.length;
        byte[][] unpackedRowData = new byte[numFields][];
        int nullCount = (numFields + 9) / 8;
        int nullMaskPos = binaryData.getPosition();
        binaryData.setPosition(nullMaskPos + nullCount);
        int bit = 4;
        for (int i = 0; i < numFields; ++i) {
            if ((binaryData.readByte(nullMaskPos) & bit) != 0) {
                unpackedRowData[i] = null;
            } else {
                this.extractNativeEncodedColumn(binaryData, fields, i, unpackedRowData);
            }
            if (((bit <<= 1) & 0xFF) != 0) continue;
            bit = 1;
            ++nullMaskPos;
        }
        return new ByteArrayRow(unpackedRowData, this.protocol.getExceptionInterceptor(), new MysqlBinaryValueDecoder());
    }

    private final void extractNativeEncodedColumn(Buffer binaryData, Field[] fields, int columnIndex, byte[][] unpackedRowData) throws SQLException {
        int type = fields[columnIndex].getMysqlTypeId();
        int len = MysqlaUtils.getBinaryEncodedLength(type);
        if (type != 6) {
            if (len == 0) {
                unpackedRowData[columnIndex] = binaryData.readLenByteArray(0);
            } else if (len > 0) {
                unpackedRowData[columnIndex] = binaryData.getBytes(len);
            } else {
                throw SQLError.createSQLException(Messages.getString("MysqlIO.97") + type + Messages.getString("MysqlIO.98") + columnIndex + Messages.getString("MysqlIO.99") + fields.length + Messages.getString("MysqlIO.100"), "S1000", this.protocol.getExceptionInterceptor());
            }
        }
    }

    protected List<ResultSetRow> fetchRowsViaCursor(List<ResultSetRow> fetchedRows, long statementId, Field[] columnTypes, int fetchSize) throws SQLException {
        if (fetchedRows == null) {
            fetchedRows = new ArrayList<ResultSetRow>(fetchSize);
        } else {
            fetchedRows.clear();
        }
        Buffer sharedSendPacket = this.protocol.getSharedSendPacket();
        sharedSendPacket.setPosition(0);
        sharedSendPacket.writeByte((byte)28);
        sharedSendPacket.writeLong(statementId);
        sharedSendPacket.writeLong(fetchSize);
        this.protocol.sendCommand(28, null, sharedSendPacket, true, null, 0);
        ResultSetRow row = null;
        while ((row = this.nextRow(columnTypes, columnTypes.length, true, 1007, false)) != null) {
            fetchedRows.add(row);
        }
        return fetchedRows;
    }

    public void checkForOutstandingStreamingData() {
        try {
            if (this.streamingData != null) {
                boolean shouldClobber = this.connection.getPropertySet().getBooleanReadableProperty("clobberStreamingResults").getValue();
                if (!shouldClobber) {
                    throw SQLError.createSQLException(Messages.getString("MysqlIO.39") + this.streamingData + Messages.getString("MysqlIO.40") + Messages.getString("MysqlIO.41") + Messages.getString("MysqlIO.42"), this.protocol.getExceptionInterceptor());
                }
                this.streamingData.getOwner().realClose(false);
                this.protocol.clearInputStream();
            }
        }
        catch (SQLException ex) {
            throw ExceptionFactory.createException(ex.getMessage(), ex);
        }
    }

    public void closeStreamer(RowData streamer) throws SQLException {
        if (this.streamingData == null) {
            throw SQLError.createSQLException(Messages.getString("MysqlIO.17") + streamer + Messages.getString("MysqlIO.18"), this.protocol.getExceptionInterceptor());
        }
        if (streamer != this.streamingData) {
            throw SQLError.createSQLException(Messages.getString("MysqlIO.19") + streamer + Messages.getString("MysqlIO.20") + Messages.getString("MysqlIO.21") + Messages.getString("MysqlIO.22"), this.protocol.getExceptionInterceptor());
        }
        this.streamingData = null;
    }

    public void scanForAndThrowDataTruncation() throws SQLException {
        if (this.streamingData == null && this.propertySet.getBooleanReadableProperty("jdbcCompliantTruncation").getValue().booleanValue() && this.protocol.getWarningCount() > 0) {
            SQLError.convertShowWarningsToSQLWarnings(this.connection, this.protocol.getWarningCount(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendDeadlockStatusInformation(String xOpen, StringBuilder errorBuf) {
        if (this.propertySet.getBooleanReadableProperty("includeInnodbStatusInDeadlockExceptions").getValue().booleanValue() && xOpen != null && (xOpen.startsWith("40") || xOpen.startsWith("41")) && this.streamingData == null) {
            ResultSet rs = null;
            try {
                rs = this.protocol.sqlQueryDirect(null, "SHOW ENGINE INNODB STATUS", this.propertySet.getStringReadableProperty("characterEncoding").getValue(), null, -1, 1003, 1007, false, this.connection.getCatalog(), null);
                if (rs.next()) {
                    errorBuf.append("\n\n");
                    errorBuf.append(rs.getString("Status"));
                } else {
                    errorBuf.append("\n\n");
                    errorBuf.append(Messages.getString("MysqlIO.NoInnoDBStatusFound"));
                }
            }
            catch (CJException | SQLException ex) {
                errorBuf.append("\n\n");
                errorBuf.append(Messages.getString("MysqlIO.InnoDBStatusFailed"));
                errorBuf.append("\n\n");
                errorBuf.append(Util.stackTraceToString(ex));
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        throw ExceptionFactory.createException(ex.getMessage(), ex);
                    }
                }
            }
        }
        if (this.propertySet.getBooleanReadableProperty("includeThreadDumpInDeadlockExceptions").getValue().booleanValue()) {
            errorBuf.append("\n\n*** Java threads running at time of deadlock ***\n\n");
            ThreadMXBean threadMBean = ManagementFactory.getThreadMXBean();
            long[] threadIds = threadMBean.getAllThreadIds();
            ThreadInfo[] threads = threadMBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
            ArrayList<ThreadInfo> activeThreads = new ArrayList<ThreadInfo>();
            for (ThreadInfo info : threads) {
                if (info == null) continue;
                activeThreads.add(info);
            }
            for (ThreadInfo threadInfo : activeThreads) {
                StackTraceElement[] stackTrace;
                errorBuf.append('\"');
                errorBuf.append(threadInfo.getThreadName());
                errorBuf.append("\" tid=");
                errorBuf.append(threadInfo.getThreadId());
                errorBuf.append(" ");
                errorBuf.append((Object)threadInfo.getThreadState());
                if (threadInfo.getLockName() != null) {
                    errorBuf.append(" on lock=" + threadInfo.getLockName());
                }
                if (threadInfo.isSuspended()) {
                    errorBuf.append(" (suspended)");
                }
                if (threadInfo.isInNative()) {
                    errorBuf.append(" (running in native)");
                }
                if ((stackTrace = threadInfo.getStackTrace()).length > 0) {
                    errorBuf.append(" in ");
                    errorBuf.append(stackTrace[0].getClassName());
                    errorBuf.append(".");
                    errorBuf.append(stackTrace[0].getMethodName());
                    errorBuf.append("()");
                }
                errorBuf.append("\n");
                if (threadInfo.getLockOwnerName() != null) {
                    errorBuf.append("\t owned by " + threadInfo.getLockOwnerName() + " Id=" + threadInfo.getLockOwnerId());
                    errorBuf.append("\n");
                }
                for (int j = 0; j < stackTrace.length; ++j) {
                    StackTraceElement ste = stackTrace[j];
                    errorBuf.append("\tat " + ste.toString());
                    errorBuf.append("\n");
                }
            }
        }
    }
}

