/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.sgkms.util.FileUtil;
import com.servergeneral.sgkms.util.NetworkUtil;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OSInfo;
import com.servergeneral.system.OperationCancelledException;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Window;

public class ComplianceReportDialog
extends Dialog<Void>
implements Initializable {
    @FXML
    private Label siDate;
    @FXML
    private Label siHostname;
    @FXML
    private Label siIP;
    @FXML
    private Label siOS;
    @FXML
    private Label soMKLenght;
    @FXML
    private Label soMKRD;
    @FXML
    private Label soMKGD;
    @FXML
    private Label soFullname;
    @FXML
    private Label daMKLenght;
    @FXML
    private Label daMKRD;
    @FXML
    private Label daMKGD;
    @FXML
    private Label daFullname;
    @FXML
    private Label mysqlMKLenght;
    @FXML
    private Label mysqlMKRD;
    @FXML
    private Label mysqlMKGD;
    @FXML
    private Label mysqlLockerStatus;
    @FXML
    private Label mysqlLockerType;
    @FXML
    private Label mysqlEncryptAlgo;
    @FXML
    private Label mysqlLogFilesStatus;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMMM-dd HH:mm:ss.SSS");

    public void initialize(URL url, ResourceBundle rb) {
        Platform.runLater(() -> this.showInformation());
    }

    public ComplianceReportDialog() throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/compliance-report.fxml"), ResourceManager.resourceBundle);
        fxmlLoader.setController((Object)this);
        AnchorPane layout = (AnchorPane)fxmlLoader.load();
        this.getDialogPane().setContent((Node)layout);
        this.setResizable(true);
        this.setTitle(ResourceManager.getString("info.dialog.compliance.report.title"));
        Window window = this.getDialogPane().getScene().getWindow();
        window.setOnCloseRequest(event -> window.hide());
        window.sizeToScene();
    }

    @FXML
    private void closeReport(ActionEvent event) {
        this.getDialogPane().getScene().getWindow().hide();
    }

    public void showInformation() {
        this.showSystemInformation();
        this.showSecurityOfficerInformation();
        this.showDataAdministratorInformation();
        this.showMySQLInformation();
    }

    private void showSystemInformation() {
        this.siDate.setText(this.dateFormat.format(Calendar.getInstance().getTime()));
        this.siHostname.setText(OSInfo.getHostname());
        this.siIP.setText(NetworkUtil.getLocalIpAddress());
        this.siOS.setText(OSInfo.getOs().getName() + " " + OSInfo.getOs().getPlatformName());
    }

    private void showSecurityOfficerInformation() {
        String fullname = FileUtil.readAdmFullnameFromSgaFile("/etc/serverg/so.conf");
        Date gdDate = FileUtil.getFileModifiedDate("/etc/serverg/so.conf");
        String rdDate = SGKms.getProperty("smk.rd");
        this.soFullname.setText(fullname == null ? "Unknown" : fullname);
        try {
            this.soMKGD.setText(gdDate != null ? this.dateFormat.format(gdDate) : "Unknown");
        }
        catch (NumberFormatException ex) {
            this.soMKGD.setText("Unknown");
        }
        try {
            this.soMKRD.setText(rdDate == null ? this.soMKGD.getText() : this.dateFormat.format(new Date(Long.parseLong(rdDate))));
        }
        catch (NumberFormatException ex) {
            this.soMKRD.setText("Unknown");
        }
    }

    private void showDataAdministratorInformation() {
        String fullname = FileUtil.readAdmFullnameFromSgaFile("/etc/serverg/da.conf");
        Date gdDate = FileUtil.getFileModifiedDate("/etc/serverg/da.conf");
        String rdDate = SGKms.getProperty("dmk.rd");
        this.daFullname.setText(fullname == null ? "Unknown" : fullname);
        try {
            this.daMKGD.setText(gdDate != null ? this.dateFormat.format(gdDate) : "Unknown");
        }
        catch (NumberFormatException ex) {
            this.daMKGD.setText("Unknown");
        }
        try {
            this.daMKRD.setText(rdDate == null ? this.daMKGD.getText() : this.dateFormat.format(new Date(Long.parseLong(rdDate))));
        }
        catch (NumberFormatException ex) {
            this.daMKRD.setText("Unknown");
        }
    }

    private void showMySQLInformation() {
        try {
            int status = SGKms.lockerStatus();
            switch (status) {
                case 0: {
                    this.mysqlLockerStatus.setText(ResourceManager.getString("label.report.compliance.mysql.locker.status.closed"));
                    break;
                }
                case 1: {
                    this.mysqlLockerStatus.setText(ResourceManager.getString("label.report.compliance.mysql.locker.status.opened"));
                    break;
                }
                case 2: {
                    this.mysqlLockerStatus.setText(ResourceManager.getString("label.report.compliance.mysql.locker.status.stopped"));
                }
            }
        }
        catch (NoSGAdminException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.mysqlLockerStatus.setText("Unknown");
        }
        try {
            if (SGAManager.getInstance().existPolicy("spolicy_mysql_log")) {
                if (SGAManager.getInstance().isPolicyMounted("spolicy_mysql_log")) {
                    this.mysqlLogFilesStatus.setText(ResourceManager.getString("label.report.compliance.mysql.mk.log.status.protected"));
                } else {
                    this.mysqlLogFilesStatus.setText(ResourceManager.getString("label.report.compliance.mysql.mk.log.status.stopped"));
                }
            } else {
                this.mysqlLogFilesStatus.setText(ResourceManager.getString("label.report.compliance.mysql.mk.log.status.unprotected"));
            }
        }
        catch (NoSGAdminException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.mysqlLogFilesStatus.setText("Unknown");
        }
        String gdDate = SGKms.getProperty("mmk.gd");
        String rdDate = SGKms.getProperty("mmk.rd");
        try {
            this.mysqlMKGD.setText(gdDate == null ? "Unknown" : this.dateFormat.format(new Date(Long.parseLong(gdDate))));
        }
        catch (NumberFormatException ex) {
            this.mysqlMKGD.setText("Unknown");
        }
        try {
            this.mysqlMKRD.setText(rdDate == null ? this.mysqlMKGD.getText() : this.dateFormat.format(new Date(Long.parseLong(rdDate))));
        }
        catch (NumberFormatException ex) {
            this.mysqlMKRD.setText("Unknown");
        }
        FileUtil.chmod("/etc/serverg/sgl.conf", "644");
        boolean cloudType = FileUtil.getLineFromFileContaining("/etc/serverg/sgl.conf", "locker1.servergeneral.com") != null && FileUtil.getLineFromFileContaining("/etc/serverg/sgl.conf", "locker2.servergeneral.com") != null && FileUtil.getLineFromFileContaining("/etc/serverg/sgl.conf", "locker3.servergeneral.com") != null;
        this.mysqlLockerType.setText(ResourceManager.getString(cloudType ? "label.report.compliance.mysql.locker.type.cloud" : "label.report.compliance.mysql.locker.type.on-premises"));
    }
}

