/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sga.DAAddException;
import com.servergeneral.sga.EmptyLicenseKeyException;
import com.servergeneral.sga.LicenseAddException;
import com.servergeneral.sga.LicenseCheckException;
import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.PolicyAddException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sga.SOAddException;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.sgkms.gui.CustomAlert;
import com.servergeneral.sgkms.gui.EffectFactory;
import com.servergeneral.sgkms.gui.SgKmsGui;
import com.servergeneral.sgkms.util.DBUtil;
import com.servergeneral.sgkms.util.FileUtil;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SGKmsSetupController
implements Initializable {
    @FXML
    private Button btnPrevious;
    @FXML
    private Button btnNext;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnFinish;
    @FXML
    private StackPane pnlWizard;
    @FXML
    private TextField tfMySQLPort;
    @FXML
    private TextField tfMySQLUser;
    @FXML
    private PasswordField tfCurrDMK;
    @FXML
    private Label lbCurrDMK;
    @FXML
    private TextField tfDAFirst;
    @FXML
    private TextField tfDALast;
    @FXML
    private TextField tfDAEmail;
    @FXML
    private TextField tfDAPhone;
    @FXML
    private PasswordField tfNewDMK;
    @FXML
    private PasswordField tfRetypedDMK;
    @FXML
    private PasswordField tfCurrSMK;
    @FXML
    private Label lbCurrSMK;
    @FXML
    private TextField tfSOFirst;
    @FXML
    private TextField tfSOLast;
    @FXML
    private TextField tfSOEmail;
    @FXML
    private TextField tfSOPhone;
    @FXML
    private PasswordField tfNewSMK;
    @FXML
    private PasswordField tfRetypedSMK;
    @FXML
    private TextArea tfLicenseKey;
    @FXML
    private Pane pnlMySQLInfo;
    @FXML
    private Pane pnlCreateDA;
    @FXML
    private Pane pnlCreateSO;
    @FXML
    private Pane pnlSgaRegister;
    @FXML
    private Label lbLicError;
    @FXML
    private Label lbSOError;
    @FXML
    private Label lbDAError;
    @FXML
    private Label lbMySQLError;
    @FXML
    private PasswordField tfMySQLPass;
    @FXML
    private TextField tfLinuxUsers;
    @FXML
    private Pane pnlFooter;
    @FXML
    private ProgressBar pbProccess;
    @FXML
    private HBox boxButtons;
    @FXML
    private Pane pnlSetupSuccess;
    @FXML
    private Pane pnlLicenseAgreement;
    @FXML
    private TextArea tfLicenseAgreement;
    @FXML
    private CheckBox ckAgree;
    @FXML
    private Label lbSaved;
    private Map<String, String> errorsMsgs;
    private static final Logger logger = LogManager.getLogger();
    private List<Pane> views;
    private Pane currentView;
    private List<Integer> pwRequested;
    private Task updateProgressTask;
    private GuiUserData fromGuiUserData = new GuiUserData(false);
    private GuiUserData fromTaskUserData = new GuiUserData(true);
    private final EventHandler onScheduled = event -> {
        SGAManager.getInstance().setUserInfoListener(this.fromTaskUserData);
        this.pbProccess.setVisible(true);
    };
    private final EventHandler onSucceeded = event -> {
        Task task;
        SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
        this.pbProccess.setVisible(false);
        this.updateProgressTask.cancel();
        if (event.getSource() instanceof Task && (task = (Task)event.getSource()).getValue() != null && ((Boolean)task.getValue()).booleanValue()) {
            this.moveToNextPage();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(URL url, ResourceBundle rb) {
        SGAManager sgaManager = SGAManager.getInstance();
        sgaManager.setUserInfoListener(this.fromGuiUserData);
        try {
            this.views = new LinkedList<Pane>();
            if (!sgaManager.isLicensed()) {
                this.views.add(this.pnlLicenseAgreement);
                this.views.add(this.pnlSgaRegister);
            } else {
                this.pnlSgaRegister.setVisible(false);
            }
            if (!sgaManager.isSOCreated()) {
                this.views.add(this.pnlCreateSO);
            }
            if (!sgaManager.isMySQLDACreated(SGKms.getCurrentDA())) {
                this.views.add(this.pnlCreateDA);
            }
            if (!sgaManager.existPolicy("spolicy_mysql_keyring")) {
                this.views.add(this.pnlMySQLInfo);
            }
            this.views.add(this.pnlSetupSuccess);
            this.currentView = this.views.get(0);
            this.btnPrevious.setDisable(true);
            this.pwRequested = new ArrayList<Integer>();
            this.lbCurrSMK.visibleProperty().bind((ObservableValue)this.tfCurrSMK.visibleProperty());
            this.lbCurrDMK.visibleProperty().bind((ObservableValue)this.tfCurrDMK.visibleProperty());
            this.btnFinish.disableProperty().bind((ObservableValue)this.btnNext.disableProperty().not());
            this.btnCancel.disableProperty().bind((ObservableValue)this.btnNext.disableProperty());
            this.boxButtons.disableProperty().bind((ObservableValue)this.pnlWizard.disableProperty());
            this.pnlWizard.disableProperty().bind((ObservableValue)this.pbProccess.visibleProperty());
            this.showCurretView();
        }
        catch (NoSGAdminException | NullUserInfoListenerException | OperationCancelledException ex) {
            CustomAlert alert = new CustomAlert(ResourceManager.getString("info.alert.error.title"), null, ResourceManager.getString("error.operation.execution"), ex);
            alert.showAndWait();
        }
        finally {
            sgaManager.clearCache();
        }
    }

    private void showCurretView() {
        for (Pane pnl : this.views) {
            pnl.setVisible(pnl == this.currentView);
        }
        if (this.currentView == this.pnlCreateDA) {
            this.tfCurrSMK.setVisible(this.tfNewSMK.getText().isEmpty());
            this.tfCurrSMK.setText(this.tfNewSMK.getText());
        } else if (this.currentView == this.pnlMySQLInfo) {
            boolean isPamEnabled;
            this.tfCurrDMK.setVisible(this.tfNewDMK.getText().isEmpty());
            this.tfCurrDMK.setText(this.tfNewDMK.getText());
            try {
                isPamEnabled = SGAManager.getInstance().isPAMEnabled();
            }
            catch (LicenseCheckException | NoSGAdminException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
                isPamEnabled = false;
            }
            this.tfLinuxUsers.setDisable(!isPamEnabled);
            this.loadMySQLInfo();
        }
        this.btnNext.setDisable(!this.hasNext());
    }

    private boolean hasNext() {
        return this.views.indexOf(this.currentView) < this.views.size() - 1;
    }

    private boolean hasPrior() {
        return this.views.indexOf(this.currentView) > 0;
    }

    private void confirmExitSetup() {
        CustomAlert alert = new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, ResourceManager.getString("info.alert.setup.exit.title"), ResourceManager.getString("info.alert.setup.exit.header"), ResourceManager.getString("info.setup.cancel"));
        Optional confirmation = alert.showAndWait();
        if (confirmation.get() == CustomAlert.YES) {
            Platform.runLater(() -> Platform.exit());
        }
    }

    private void startTasks(Task sgaTask, Task updateProgressTask) {
        Thread th = new Thread((Runnable)sgaTask);
        Thread th2 = new Thread((Runnable)updateProgressTask);
        th.setDaemon(true);
        th2.setDaemon(true);
        th.start();
        th2.start();
    }

    private void validateLicensePage() {
        this.lbLicError.textProperty().unbind();
        if (this.tfLicenseKey.getText().isEmpty()) {
            this.lbLicError.setText(ResourceManager.getString("error.license.empty"));
            return;
        }
        AddLicenseTask addLicenseTask = new AddLicenseTask(this.tfLicenseKey.getText());
        addLicenseTask.setOnScheduled(this.onScheduled);
        addLicenseTask.setOnSucceeded(this.onSucceeded);
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbLicError.textProperty().bind((ObservableValue)addLicenseTask.messageProperty());
        this.startTasks(addLicenseTask, this.updateProgressTask);
    }

    private void validateSOPage() {
        this.errorsMsgs = new HashMap<String, String>();
        boolean result = true;
        this.lbSOError.textProperty().unbind();
        this.lbSOError.setText("");
        if (this.tfSOFirst.getText().isEmpty()) {
            this.tfSOFirst.getStyleClass().remove((Object)"normal-field");
            this.tfSOFirst.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfSOFirst.getId(), ResourceManager.getString("error.fname.required"));
            result = false;
        } else {
            this.tfSOFirst.getStyleClass().remove((Object)"invalid-field");
            this.tfSOFirst.getStyleClass().add((Object)"normal-field");
        }
        if (this.tfSOLast.getText().isEmpty()) {
            this.tfSOLast.getStyleClass().remove((Object)"normal-field");
            this.tfSOLast.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfSOLast.getId(), ResourceManager.getString("error.lname.required"));
            result = false;
        } else {
            this.tfSOLast.getStyleClass().remove((Object)"invalid-field");
            this.tfSOLast.getStyleClass().add((Object)"normal-field");
        }
        if (!this.tfSOEmail.getText().isEmpty() && !this.tfSOEmail.getText().matches("(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*:(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)(?:,\\s*(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*))*)?;\\s*)")) {
            this.tfSOEmail.getStyleClass().remove((Object)"normal-field");
            this.tfSOEmail.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfSOEmail.getId(), ResourceManager.getString("error.email.invalid", this.tfSOEmail.getText()));
            result = false;
        } else {
            this.tfSOEmail.getStyleClass().remove((Object)"invalid-field");
            this.tfSOEmail.getStyleClass().add((Object)"normal-field");
        }
        if (!this.tfSOPhone.getText().isEmpty() && !this.tfSOPhone.getText().matches("([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})")) {
            this.tfSOPhone.getStyleClass().remove((Object)"normal-field");
            this.tfSOPhone.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfSOPhone.getId(), ResourceManager.getString("error.phone.invalid", this.tfSOPhone.getText()));
            result = false;
        } else {
            this.tfSOPhone.getStyleClass().remove((Object)"invalid-field");
            this.tfSOPhone.getStyleClass().add((Object)"normal-field");
        }
        if (this.tfNewSMK.getText().isEmpty() || this.tfNewSMK.getText().length() < 16 || this.tfNewSMK.getText().length() > 60 || !this.tfNewSMK.getText().matches("^([0-9]+[a-zA-Z]+|[a-zA-Z]+[0-9]+)[0-9a-zA-Z]*$")) {
            this.tfNewSMK.getStyleClass().remove((Object)"normal-field");
            this.tfNewSMK.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfNewSMK.getId(), ResourceManager.getString("error.smk.lenght"));
            result = false;
        } else {
            this.tfNewSMK.getStyleClass().remove((Object)"invalid-field");
            this.tfNewSMK.getStyleClass().add((Object)"normal-field");
        }
        if (this.tfRetypedSMK.getText().isEmpty() || !this.tfNewSMK.getText().equals(this.tfRetypedSMK.getText())) {
            this.tfRetypedSMK.getStyleClass().remove((Object)"normal-field");
            this.tfRetypedSMK.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfRetypedSMK.getId(), ResourceManager.getString("error.keys.not_match"));
            result = false;
        } else {
            this.tfRetypedSMK.getStyleClass().remove((Object)"invalid-field");
            this.tfRetypedSMK.getStyleClass().add((Object)"normal-field");
        }
        if (result) {
            logger.log(Level.INFO, ResourceManager.getIcon("log.info.so.configuring"));
            String configFile = FileUtil.createAdmConfigFile("SecurityOfficer1", this.tfSOFirst.getText(), this.tfSOLast.getText(), this.tfSOEmail.getText(), this.tfSOPhone.getText(), true);
            if (configFile == null) {
                this.lbSOError.setText(ResourceManager.getString("error.operation.cancelled"));
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.cancelled"));
                return;
            }
            SOCreateTask soCreateTask = new SOCreateTask(configFile);
            soCreateTask.setOnScheduled(this.onScheduled);
            soCreateTask.setOnSucceeded(this.onSucceeded);
            this.updateProgressTask = new TaskUpdateProgress();
            this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
            this.lbSOError.textProperty().bind((ObservableValue)soCreateTask.messageProperty());
            this.startTasks(soCreateTask, this.updateProgressTask);
        }
    }

    private void validateDAPage() {
        this.errorsMsgs = new HashMap<String, String>();
        boolean result = true;
        this.lbDAError.textProperty().unbind();
        this.lbDAError.setText("");
        if (this.tfDAFirst.getText().isEmpty()) {
            this.tfDAFirst.getStyleClass().remove((Object)"normal-field");
            this.tfDAFirst.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfDAFirst.getId(), ResourceManager.getString("error.fname.required"));
            result = false;
        } else {
            this.tfDAFirst.getStyleClass().remove((Object)"invalid-field");
            this.tfDAFirst.getStyleClass().add((Object)"normal-field");
        }
        if (this.tfDALast.getText().isEmpty()) {
            this.tfDALast.getStyleClass().remove((Object)"normal-field");
            this.tfDALast.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfDALast.getId(), ResourceManager.getString("error.lname.required"));
            result = false;
        } else {
            this.tfDALast.getStyleClass().remove((Object)"invalid-field");
            this.tfDALast.getStyleClass().add((Object)"normal-field");
        }
        if (!this.tfDAEmail.getText().isEmpty() && !this.tfDAEmail.getText().matches("(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*:(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)(?:,\\s*(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*))*)?;\\s*)")) {
            this.tfDAEmail.getStyleClass().remove((Object)"normal-field");
            this.tfDAEmail.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfDAEmail.getId(), ResourceManager.getString("error.email.invalid", this.tfDAEmail.getText()));
            result = false;
        } else {
            this.tfDAEmail.getStyleClass().remove((Object)"invalid-field");
            this.tfDAEmail.getStyleClass().add((Object)"normal-field");
        }
        if (!this.tfDAPhone.getText().isEmpty() && !this.tfDAPhone.getText().matches("([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})")) {
            this.tfDAPhone.getStyleClass().remove((Object)"normal-field");
            this.tfDAPhone.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfDAPhone.getId(), ResourceManager.getString("error.phone.invalid", this.tfDAPhone.getText()));
            result = false;
        } else {
            this.tfDAPhone.getStyleClass().remove((Object)"invalid-field");
            this.tfDAPhone.getStyleClass().add((Object)"normal-field");
        }
        if (this.tfNewDMK.getText().isEmpty() || this.tfNewDMK.getText().length() < 16 || this.tfNewDMK.getText().length() > 60 || !this.tfNewDMK.getText().matches("^([0-9]+[a-zA-Z]+|[a-zA-Z]+[0-9]+)[0-9a-zA-Z]*$")) {
            this.tfNewDMK.getStyleClass().remove((Object)"normal-field");
            this.tfNewDMK.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfNewDMK.getId(), ResourceManager.getString("error.dmk.lenght"));
            result = false;
        } else {
            this.tfNewDMK.getStyleClass().remove((Object)"invalid-field");
            this.tfNewDMK.getStyleClass().add((Object)"normal-field");
        }
        if (this.tfRetypedDMK.getText().isEmpty() || !this.tfNewDMK.getText().equals(this.tfRetypedDMK.getText())) {
            this.tfRetypedDMK.getStyleClass().remove((Object)"normal-field");
            this.tfRetypedDMK.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfRetypedDMK.getId(), ResourceManager.getString("error.keys.not_match"));
            result = false;
        } else {
            this.tfRetypedDMK.getStyleClass().remove((Object)"invalid-field");
            this.tfRetypedDMK.getStyleClass().add((Object)"normal-field");
        }
        if (this.tfCurrSMK.isVisible() && this.tfCurrSMK.getText().isEmpty()) {
            this.tfCurrSMK.getStyleClass().remove((Object)"normal-field");
            this.tfCurrSMK.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfCurrSMK.getId(), ResourceManager.getString("error.smk.required"));
            result = false;
        } else {
            this.tfCurrSMK.getStyleClass().remove((Object)"invalid-field");
            this.tfCurrSMK.getStyleClass().add((Object)"normal-field");
        }
        if (result) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.da.configuring"));
            String configFile = FileUtil.createAdmConfigFile(SGKms.firstDAId(), this.tfDAFirst.getText(), this.tfDALast.getText(), this.tfDAEmail.getText(), this.tfDAPhone.getText(), false);
            if (configFile == null) {
                this.lbDAError.setText(ResourceManager.getString("error.operation.cancelled"));
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.cancelled"));
                return;
            }
            DACreateTask daCreateTask = new DACreateTask(configFile);
            daCreateTask.setOnScheduled(this.onScheduled);
            daCreateTask.setOnSucceeded(this.onSucceeded);
            this.updateProgressTask = new TaskUpdateProgress();
            this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
            this.lbDAError.textProperty().bind((ObservableValue)daCreateTask.messageProperty());
            this.startTasks(daCreateTask, this.updateProgressTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateMySQLPage() {
        this.errorsMsgs = new HashMap<String, String>();
        boolean result = true;
        this.lbMySQLError.textProperty().unbind();
        this.lbMySQLError.setText("");
        if (this.tfMySQLPort.getText().isEmpty()) {
            this.tfMySQLPort.getStyleClass().remove((Object)"normal-field");
            this.tfMySQLPort.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfMySQLPort.getId(), ResourceManager.getString("error.mysql.port.required"));
            result = false;
        } else {
            try {
                Integer.parseInt(this.tfMySQLPort.getText());
                this.tfMySQLPort.getStyleClass().remove((Object)"invalid-field");
                this.tfMySQLPort.getStyleClass().add((Object)"normal-field");
            }
            catch (NumberFormatException ex) {
                this.tfMySQLPort.getStyleClass().remove((Object)"normal-field");
                this.tfMySQLPort.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfMySQLPort.getId(), ResourceManager.getString("error.mysql.port.not_numeric"));
                result = false;
            }
        }
        if (this.tfMySQLUser.getText().isEmpty()) {
            this.tfMySQLUser.getStyleClass().remove((Object)"normal-field");
            this.tfMySQLUser.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfMySQLUser.getId(), ResourceManager.getString("error.mysql.user.required"));
            result = false;
        } else {
            this.tfMySQLUser.getStyleClass().remove((Object)"invalid-field");
            this.tfMySQLUser.getStyleClass().add((Object)"normal-field");
        }
        if (this.tfMySQLPass.getText().isEmpty()) {
            this.tfMySQLPass.getStyleClass().remove((Object)"normal-field");
            this.tfMySQLPass.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfMySQLPass.getId(), ResourceManager.getString("error.mysql.password.required"));
            result = false;
        } else {
            this.tfMySQLPass.getStyleClass().remove((Object)"invalid-field");
            this.tfMySQLPass.getStyleClass().add((Object)"normal-field");
        }
        if (this.tfCurrDMK.isVisible() && this.tfCurrDMK.getText().isEmpty()) {
            this.tfCurrDMK.getStyleClass().remove((Object)"normal-field");
            this.tfCurrDMK.getStyleClass().add((Object)"invalid-field");
            this.errorsMsgs.put(this.tfCurrDMK.getId(), ResourceManager.getString("error.dmk.required"));
            result = false;
        } else {
            this.tfCurrDMK.getStyleClass().remove((Object)"invalid-field");
            this.tfCurrDMK.getStyleClass().add((Object)"normal-field");
        }
        if (result) {
            try {
                String allowedUsers;
                if (DBUtil.dbConfig == null) {
                    DBUtil.dbConfig = new DBUtil.DBConfig();
                }
                DBUtil.dbConfig.setPort(this.tfMySQLPort.getText());
                DBUtil.dbConfig.setUser(this.tfMySQLUser.getText());
                DBUtil.dbConfig.setPassword(this.tfMySQLPass.getText().toCharArray());
                DBUtil.connectMySQLDB();
                DBUtil.saveDBConfig(SGKms.CONFIG_FOLDER, "sg-kms.properties");
                if (!DBUtil.isMySQLTDEActivated()) {
                    logger.log(Level.INFO, ResourceManager.getString("log.info.tde.checking"));
                    if (!DBUtil.isMySQLTDESupported(DBUtil.getMySQlVersion())) {
                        this.lbMySQLError.setText(ResourceManager.getString("error.tde.not_supported"));
                        logger.log(Level.ERROR, ResourceManager.getString("error.tde.not_supported"));
                        return;
                    }
                    if (!DBUtil.enableTDE()) {
                        this.lbMySQLError.setText(ResourceManager.getString("log.error.tde.enable"));
                        logger.log(Level.ERROR, ResourceManager.getString("log.error.tde.enable"));
                        return;
                    }
                    DBUtil.connectMySQLDB();
                }
                if (!DBUtil.isMySQLTDEActivated()) {
                    this.lbMySQLError.setText(ResourceManager.getString("error.tde.not_enabled"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.tde.not_enabled"));
                    return;
                }
                if (!SGAManager.getInstance().isPAMEnabled()) {
                    allowedUsers = "";
                } else {
                    allowedUsers = this.tfLinuxUsers.getText();
                    if (allowedUsers.matches("^.*\\s.*$")) {
                        allowedUsers = !this.tfLinuxUsers.getText().contains(",") ? allowedUsers.replaceAll("\\s", ",") : allowedUsers.replaceAll("\\s", "");
                    }
                    if (!allowedUsers.contains("sgadmin")) {
                        allowedUsers = allowedUsers + (allowedUsers.isEmpty() ? "sgadmin" : ",sgadmin");
                    }
                    if (!allowedUsers.contains("mysql")) {
                        allowedUsers = allowedUsers + ",mysql";
                    }
                }
                String cfgFile = FileUtil.createPolicyConfigFile("spolicy_mysql_keyring", "/var/lib/mysql-keyring", null, allowedUsers, SGKms.getCurrentDA());
                logger.log(Level.INFO, ResourceManager.getString("log.info.kms.configuring"));
                PolicyAddTask polAddTask = new PolicyAddTask(cfgFile);
                polAddTask.setOnScheduled(this.onScheduled);
                polAddTask.setOnSucceeded(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbMySQLError.textProperty().bind((ObservableValue)polAddTask.messageProperty());
                this.startTasks(polAddTask, this.updateProgressTask);
            }
            catch (LicenseCheckException | NoSGAdminException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException | SQLException ex) {
                this.lbMySQLError.setText(ex.getMessage());
            }
            finally {
                if (SGAManager.getInstance() != null) {
                    SGAManager.getInstance().clearCache();
                }
            }
        }
    }

    private void validateCurrentPage() {
        if (this.currentView == this.pnlLicenseAgreement) {
            this.validateLicenseAgreementPage();
        }
        if (this.currentView == this.pnlSgaRegister) {
            this.validateLicensePage();
        } else if (this.currentView == this.pnlCreateSO) {
            this.validateSOPage();
        } else if (this.currentView == this.pnlCreateDA) {
            this.validateDAPage();
        } else if (this.currentView == this.pnlMySQLInfo) {
            this.validateMySQLPage();
        }
    }

    private void moveToNextPage() {
        Platform.runLater(() -> {
            int i = this.views.indexOf(this.currentView);
            this.currentView = this.views.get(i + 1);
            this.showCurretView();
            this.views.remove(i);
        });
    }

    @FXML
    private void previousPage(ActionEvent event) {
    }

    @FXML
    private void nextPage(ActionEvent event) {
        this.validateCurrentPage();
    }

    @FXML
    private void cancel(ActionEvent event) {
        this.confirmExitSetup();
    }

    @FXML
    private void finish(ActionEvent event) {
        Platform.runLater(() -> Platform.exit());
    }

    @FXML
    private void clearErrorIfExist(MouseEvent event) {
        if (this.errorsMsgs != null && !this.errorsMsgs.isEmpty()) {
            this.lbSOError.textProperty().unbind();
            this.lbSOError.setText("");
            this.lbDAError.textProperty().unbind();
            this.lbDAError.setText("");
            this.lbDAError.textProperty().unbind();
            this.lbMySQLError.setText("");
        }
    }

    @FXML
    private void showErrorIfExist(MouseEvent event) {
        Control control = (Control)event.getSource();
        if (this.errorsMsgs == null || !this.errorsMsgs.containsKey(control.getId())) {
            return;
        }
        if (this.currentView == this.pnlCreateSO) {
            this.lbSOError.setText(this.errorsMsgs.get(control.getId()));
        } else if (this.currentView == this.pnlCreateDA) {
            this.lbDAError.setText(this.errorsMsgs.get(control.getId()));
        } else if (this.currentView == this.pnlMySQLInfo) {
            this.lbMySQLError.setText(this.errorsMsgs.get(control.getId()));
        }
    }

    private void loadMySQLInfo() {
        if (DBUtil.loadDBConfig(SGKms.CONFIG_FOLDER + "/" + "sg-kms.properties")) {
            this.tfMySQLPort.setText(DBUtil.dbConfig.getPort());
            this.tfMySQLUser.setText(DBUtil.dbConfig.getUser());
        } else {
            this.tfMySQLPort.setText("3306");
            this.tfMySQLUser.setText("root");
        }
    }

    private void validateLicenseAgreementPage() {
        if (!this.ckAgree.isSelected()) {
            CustomAlert alert = new CustomAlert(Alert.AlertType.ERROR, ResourceManager.getString("info.alert.setup.license.accept.title"), ResourceManager.getString("info.alert.setup.license.accept.header"), ResourceManager.getString("info.license.accept"));
            alert.showAndWait();
        } else {
            this.moveToNextPage();
        }
    }

    @FXML
    private void keyReleased(KeyEvent event) {
        Control ctrl;
        if (event.getCode() != KeyCode.UNDEFINED && event.getCode() != KeyCode.TAB && event.getSource() instanceof Control && (ctrl = (Control)event.getSource()).getStyleClass().contains((Object)"invalid-field")) {
            ctrl.getStyleClass().remove((Object)"invalid-field");
            ctrl.getStyleClass().add((Object)"normal-field");
            if (this.errorsMsgs != null && this.errorsMsgs.containsKey(ctrl.getId())) {
                this.errorsMsgs.remove(ctrl.getId());
            }
        }
    }

    @FXML
    private void saveLicense(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ResourceManager.getString("filechooser.license.save.title"));
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Text Files", new String[]{"*.txt"})});
        fileChooser.setInitialFileName("sg-license-agreement.txt");
        File selectedFile = fileChooser.showSaveDialog(this.pnlLicenseAgreement.getScene().getWindow());
        if (selectedFile != null) {
            try (InputStreamReader input = new InputStreamReader(this.getClass().getResourceAsStream("/others/license.txt"));
                 PrintWriter output = new PrintWriter(selectedFile);){
                int lenght;
                char[] buffer = new char[1024];
                while ((lenght = input.read(buffer, 0, 1024)) != -1) {
                    if (lenght == 0) continue;
                    output.write(buffer, 0, lenght);
                }
                this.lbSaved.setVisible(true);
                Timeline blinker = EffectFactory.createBlinker((Node)this.lbSaved);
                FadeTransition fader = EffectFactory.createFader((Node)this.lbSaved);
                SequentialTransition blinkThenFade = new SequentialTransition((Node)this.lbSaved, new Animation[]{blinker, fader});
                blinkThenFade.play();
            }
            catch (IOException ex) {
                CustomAlert alert = new CustomAlert(ResourceManager.getString("info.alert.save.license.title"), null, ResourceManager.getString("error.save.license"), ex);
                alert.showAndWait();
                logger.log(Level.ERROR, "", (Throwable)ex);
            }
        }
    }

    private class TaskUpdateProgress
    extends Task<Void> {
        private TaskUpdateProgress() {
        }

        protected Void call() throws Exception {
            int iterations = 0;
            while (!this.isCancelled()) {
                this.updateProgress(iterations++, 20L);
                iterations %= 21;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interrupted) {
                    if (!this.isCancelled()) continue;
                    break;
                }
            }
            return null;
        }
    }

    private class PolicyAddTask
    extends Task<Boolean> {
        private final String configFilePath;

        public PolicyAddTask(String configFilePath) {
            this.configFilePath = configFilePath;
        }

        protected Boolean call() throws Exception {
            try {
                SGKmsSetupController.this.pwRequested.clear();
                if (!SGAManager.getInstance().addPolicy(this.configFilePath, SGKms.getCurrentDA())) {
                    this.updateMessage(ResourceManager.getString("error.policy.add"));
                    this.updateValue(Boolean.FALSE);
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                if (SGKms.getProperty("mmk.gd") == null) {
                    SGKms.saveProperty("mmk.gd", String.valueOf(System.currentTimeMillis()));
                }
                this.updateValue(Boolean.TRUE);
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            catch (NoSGAdminException | PolicyAddException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
                this.updateMessage(ex.getMessage());
                logger.error("", (Throwable)ex);
            }
            finally {
                if (SGAManager.getInstance() != null) {
                    SGAManager.getInstance().clearCache();
                }
            }
            this.updateValue(Boolean.FALSE);
            return Boolean.FALSE;
        }
    }

    private class DACreateTask
    extends Task<Boolean> {
        private final String configFilePath;

        public DACreateTask(String configFilePath) {
            this.configFilePath = configFilePath;
        }

        protected Boolean call() throws Exception {
            try {
                SGKmsSetupController.this.pwRequested.clear();
                if (!SGAManager.getInstance().addDA(this.configFilePath)) {
                    this.updateMessage(ResourceManager.getString("error.da.add"));
                    this.updateValue(Boolean.FALSE);
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                this.updateValue(Boolean.TRUE);
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            catch (DAAddException | NoSGAdminException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
                this.updateMessage(ex.getMessage());
                logger.error("", (Throwable)ex);
            }
            finally {
                if (SGAManager.getInstance() != null) {
                    SGAManager.getInstance().clearCache();
                }
            }
            this.updateValue(Boolean.FALSE);
            return Boolean.FALSE;
        }
    }

    private class SOCreateTask
    extends Task<Boolean> {
        private final String configFilePath;

        public SOCreateTask(String configFilePath) {
            this.configFilePath = configFilePath;
        }

        protected Boolean call() throws Exception {
            try {
                SGKmsSetupController.this.pwRequested.clear();
                if (!SGAManager.getInstance().addSO(this.configFilePath)) {
                    this.updateMessage(ResourceManager.getString("error.so.add"));
                    this.updateValue(Boolean.FALSE);
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                this.updateValue(Boolean.TRUE);
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            catch (NoSGAdminException | SOAddException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
                this.updateMessage(ex.getMessage());
                logger.error("", (Throwable)ex);
            }
            finally {
                if (SGAManager.getInstance() != null) {
                    SGAManager.getInstance().clearCache();
                }
            }
            this.updateValue(Boolean.FALSE);
            return Boolean.FALSE;
        }
    }

    private class AddLicenseTask
    extends Task<Boolean> {
        private final String licenseKey;

        public AddLicenseTask(String licenseKey) {
            this.licenseKey = licenseKey;
        }

        protected Boolean call() throws Exception {
            try {
                if (!SGAManager.getInstance().addLicense(this.licenseKey)) {
                    this.updateMessage(ResourceManager.getString("error.license.add"));
                    this.updateValue(Boolean.FALSE);
                    return Boolean.FALSE;
                }
                this.updateMessage("");
                this.updateValue(Boolean.TRUE);
                return Boolean.TRUE;
            }
            catch (EmptyLicenseKeyException | LicenseAddException | NoSGAdminException | NullUserInfoListenerException | OperationCancelledException ex) {
                this.updateMessage(ex.getMessage());
                logger.error("", (Throwable)ex);
                this.updateValue(Boolean.FALSE);
                return Boolean.FALSE;
            }
        }
    }

    private class GuiUserData
    implements SGAManager.SGADataListener {
        private final boolean runFromTask;
        private boolean finished;
        private char[] pwd;

        public GuiUserData(boolean runFromTask) {
            this.runFromTask = runFromTask;
        }

        @Override
        public char[] requestUserData(int dataType, String errMsg) {
            boolean promptForPassw;
            boolean bl = promptForPassw = dataType == 1 || SGKmsSetupController.this.pwRequested.contains(dataType);
            if (promptForPassw) {
                if (this.runFromTask) {
                    this.finished = false;
                    Platform.runLater(() -> {
                        this.pwd = SgKmsGui.promptForPassword(dataType, errMsg);
                        this.finished = true;
                    });
                    while (!this.finished) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            this.pwd = null;
                            break;
                        }
                    }
                    return this.pwd;
                }
                return SgKmsGui.promptForPassword(dataType, errMsg);
            }
            SGKmsSetupController.this.pwRequested.add(dataType);
            switch (dataType) {
                case 7: {
                    return SGKmsSetupController.this.tfCurrDMK.getText().toCharArray();
                }
                case 5: {
                    return SGKmsSetupController.this.tfNewDMK.getText().toCharArray();
                }
                case 6: {
                    return SGKmsSetupController.this.tfRetypedDMK.getText().toCharArray();
                }
                case 4: {
                    return SGKmsSetupController.this.tfCurrSMK.getText().toCharArray();
                }
                case 2: {
                    return SGKmsSetupController.this.tfNewSMK.getText().toCharArray();
                }
                case 3: {
                    return SGKmsSetupController.this.tfRetypedSMK.getText().toCharArray();
                }
            }
            return null;
        }
    }
}

