/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.sgkms.gui.CustomAlert;
import com.servergeneral.sgkms.gui.PasswordDialog;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SgKmsGui
extends Application {
    private static final Logger logger = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Stage stage) {
        SGAManager.getInstance().setUserInfoListener(new UserData());
        try {
            Scene scene;
            if (!SGAManager.isSGAdmin()) {
                throw new NoSGAdminException();
            }
            if (SGAManager.getInstance().isSGAConfiguredForPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                AnchorPane root = (AnchorPane)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/fxml/sg-kms-op.fxml"), (ResourceBundle)ResourceManager.resourceBundle);
                scene = new Scene((Parent)root);
            } else {
                logger.log(Level.INFO, "sga is not configured proceeding to setup");
                AnchorPane root = (AnchorPane)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/fxml/sg-kms-setup.fxml"), (ResourceBundle)ResourceManager.resourceBundle);
                scene = new Scene((Parent)root);
            }
            stage.setTitle("SG-KMS User Interface");
            stage.setScene(scene);
            stage.sizeToScene();
            stage.setResizable(false);
            stage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("/images/sg-kms.png")));
            stage.show();
        }
        catch (NoSGAdminException | MaxPwTryiesException | OperationCancelledException ex) {
            CustomAlert alert = new CustomAlert(Alert.AlertType.ERROR, "SG-KMS Error", "Error starting SG-KMS", ex.getMessage());
            alert.showAndWait();
        }
        catch (NullUserInfoListenerException ex) {
            CustomAlert alert = new CustomAlert("SG-KMS Error", null, "Error starting SG-KMS", ex);
            alert.showAndWait();
        }
        catch (IOException ex) {
            logger.log(Level.FATAL, "", (Throwable)ex);
            CustomAlert alert = new CustomAlert("SG-KMS Error", null, "Error starting SG-KMS", ex);
            alert.showAndWait();
        }
        finally {
            if (SGAManager.getInstance() != null) {
                SGAManager.getInstance().clearCache();
            }
        }
    }

    public static char[] promptForPassword(int dataType, String errMsg) {
        PasswordDialog pwDialog;
        Optional result;
        String headerText = null;
        String prompt = null;
        switch (dataType) {
            case 7: {
                headerText = ResourceManager.getString("label.data-request.sg-dmk.msg");
                prompt = ResourceManager.getString("label.dmk.caption");
                break;
            }
            case 5: {
                headerText = ResourceManager.getString("label.data-request.sg-new-dmk.msg");
                prompt = ResourceManager.getString("label.new-dmk.caption");
                break;
            }
            case 6: {
                headerText = ResourceManager.getString("label.data-request.sg-new-dmk-again.msg");
                prompt = ResourceManager.getString("label.retype-dmk.caption");
                break;
            }
            case 4: {
                headerText = ResourceManager.getString("label.data-request.sg-smk.msg");
                prompt = ResourceManager.getString("label.smk.caption");
                break;
            }
            case 2: {
                headerText = ResourceManager.getString("label.data-request.sg-new-smk.msg");
                prompt = ResourceManager.getString("label.new-smk.caption");
                break;
            }
            case 3: {
                headerText = ResourceManager.getString("label.data-request.sg-new-smk-again.msg");
                prompt = ResourceManager.getString("label.retype-smk.caption");
                break;
            }
            case 1: {
                headerText = ResourceManager.getString("label.data-request.sudo-pw.msg", System.getenv("USER"));
                prompt = ResourceManager.getString("label.sudo.pw.caption");
                break;
            }
            case 8: {
                headerText = ResourceManager.getString("info.alert.overwrite.confirm.header");
                prompt = ResourceManager.getString("label.data-request.sg-overwrite.msg");
                CustomAlert alert = new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, headerText, headerText, prompt);
                Optional confirmation = alert.showAndWait();
                if (confirmation.get() == CustomAlert.YES) {
                    return "YES".toCharArray();
                }
                if (confirmation.get() == CustomAlert.NO) {
                    return "NO".toCharArray();
                }
                return null;
            }
        }
        if (errMsg != null) {
            headerText = errMsg + "\n" + headerText;
        }
        if ((result = (pwDialog = new PasswordDialog("Enter Password", headerText, prompt)).showAndWait()).isPresent()) {
            return ((String)result.get()).toCharArray();
        }
        return null;
    }

    private static class UserData
    implements SGAManager.SGADataListener {
        private UserData() {
        }

        @Override
        public char[] requestUserData(int dataType, String errMsg) {
            return SgKmsGui.promptForPassword(dataType, errMsg);
        }
    }
}

