/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.logging.appender;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="ListView", category="Core", elementType="appender", printObject=true)
public class ListViewAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "ListView";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @PluginFactory
    public static ListViewAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginElement(value="Layout") Layout<?> layout, @PluginElement(value="Filters") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for ListViewAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new ListViewAppender(name, filter, layout, ignoreExceptions);
    }

    public ListViewAppender(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, layout);
    }

    public ListViewAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    @Override
    public void append(LogEvent event) {
        Date date = new Date(event.getTimeMillis());
        ReadOnlyStringMap map = event.getContextData();
        System.err.println("ListViewAppender: " + this.dateFormat.format(date) + " " + this.getLayout().toSerializable(event).toString());
    }
}

