/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.console;

import com.servergeneral.sga.DAAddException;
import com.servergeneral.sga.DARevokeReassingException;
import com.servergeneral.sga.DMKRotateException;
import com.servergeneral.sga.EmptyLicenseKeyException;
import com.servergeneral.sga.LicenseAddException;
import com.servergeneral.sga.LicenseCheckException;
import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.PolicyAddException;
import com.servergeneral.sga.PolicyGetException;
import com.servergeneral.sga.PolicyPutException;
import com.servergeneral.sga.PolicyRemoveException;
import com.servergeneral.sga.PolicyStartException;
import com.servergeneral.sga.PolicyStatusException;
import com.servergeneral.sga.PolicyStopException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sga.SMKRotateException;
import com.servergeneral.sga.SOAddException;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.sgkms.util.ConsoleUtil;
import com.servergeneral.sgkms.util.DBUtil;
import com.servergeneral.sgkms.util.FileUtil;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import com.servergeneral.system.ServiceNotFoundException;
import java.sql.SQLException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SGKmsConsole {
    private static SGKmsConsole instance = null;
    private static final Logger logger = LogManager.getLogger();
    public static final String RETRIEVE_MMK = "retrieve-mmk";
    public static final String STORE_MMK = "store-mmk";
    public static final String MMK_STATUS = "mmk-status";
    public static final String MMK_START = "start-mmk-prot";
    public static final String MMK_STOP = "stop-mmk-prot";
    public static final String UNPROTECT_MMK = "unprotect-mmk";
    public static final String ROTATE_MMK = "rotate-mmk";
    public static final String ROTATE_DMK = "rotate-dmk";
    public static final String ROTATE_SMK = "rotate-smk";
    public static final String REVOKE_DA = "revoke-da";
    public static final String PROTECT_LOG = "protect-logs";
    public static final String UNPROTECT_LOG = "unprotect-logs";
    public static final String LOGS_STATUS = "logs-status";
    public static final String START_LOGS_PROT = "start-log-prot";
    public static final String STOP_LOGS_PROT = "stop-log-prot";
    public static final String RESTART_TDE = "restart-tde";
    public static final String UNINSTALL = "uninstall";

    private SGKmsConsole() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SGKmsConsole getInstance() {
        if (instance != null) return instance;
        Class<SGKmsConsole> clazz = SGKmsConsole.class;
        synchronized (SGKmsConsole.class) {
            if (instance != null) return instance;
            instance = new SGKmsConsole();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void start(String[] args) {
        SGAManager.getInstance().setUserInfoListener(new UserData());
        try {
            if (!SGAManager.isSGAdmin()) {
                throw new NoSGAdminException();
            }
            if (SGAManager.getInstance().isSGAConfiguredForPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                if (args.length != 1) {
                    SGKmsConsole.getInstance().printUsage();
                } else {
                    block19 : switch (args[0]) {
                        case "retrieve-mmk": {
                            SGKmsConsole.getInstance().openLocker();
                            break;
                        }
                        case "store-mmk": {
                            SGKmsConsole.getInstance().closeLocker();
                            break;
                        }
                        case "mmk-status": {
                            switch (SGKms.lockerStatus()) {
                                case 0: {
                                    ConsoleUtil.showMessage(ResourceManager.getString("info.vault.status.closed"), 1);
                                    break block19;
                                }
                                case 1: {
                                    ConsoleUtil.showMessage(ResourceManager.getString("info.vault.status.opened"), 1);
                                    break block19;
                                }
                                case 2: {
                                    ConsoleUtil.showMessage(ResourceManager.getString("info.vault.status.stopped"), 1);
                                }
                            }
                            break;
                        }
                        case "start-mmk-prot": {
                            SGKmsConsole.getInstance().startSgKmsProtection();
                            break;
                        }
                        case "stop-mmk-prot": {
                            SGKmsConsole.getInstance().stopSgKmsProtection();
                            break;
                        }
                        case "unprotect-mmk": {
                            SGKmsConsole.getInstance().unprotectMySQLKey();
                            break;
                        }
                        case "rotate-mmk": {
                            SGKmsConsole.getInstance().rotateDBKey();
                            break;
                        }
                        case "rotate-dmk": {
                            SGKmsConsole.getInstance().rotateDMK();
                            break;
                        }
                        case "rotate-smk": {
                            SGKmsConsole.getInstance().rotateSMK();
                            break;
                        }
                        case "revoke-da": {
                            SGKmsConsole.getInstance().revokeDA();
                            break;
                        }
                        case "protect-logs": {
                            SGKmsConsole.getInstance().protectMySQLLog();
                            break;
                        }
                        case "unprotect-logs": {
                            SGKmsConsole.getInstance().unprotectMySQLLog();
                            break;
                        }
                        case "logs-status": {
                            SGKmsConsole.getInstance().showLogProtectionStatus();
                            break;
                        }
                        case "start-log-prot": {
                            SGKmsConsole.getInstance().startLogsProtection();
                            break;
                        }
                        case "stop-log-prot": {
                            SGKmsConsole.getInstance().stopLogsProtection();
                            break;
                        }
                        case "restart-tde": {
                            SGKmsConsole.getInstance().restartTDE();
                            break;
                        }
                        default: {
                            SGKmsConsole.getInstance().printUsage();
                            break;
                        }
                    }
                }
            } else {
                logger.log(Level.INFO, ResourceManager.getString("log.info.console.sga.not-configured"));
                SGKmsConsole.getInstance().setupSGA();
            }
        }
        catch (NoSGAdminException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            ConsoleUtil.showMessage(ex.getMessage(), 0);
        }
    }

    private static String createConfigFile(boolean soConfig, boolean firstDA) {
        String phone;
        String email;
        String last;
        String first;
        String msg = soConfig ? ResourceManager.getString("label.so.title") : ResourceManager.getString("label.da.title");
        String errMsg = null;
        String id = soConfig ? "SecurityOfficer1" : (firstDA ? SGKms.firstDAId() : SGKms.nextDAId());
        errMsg = null;
        while (true) {
            if ((first = ConsoleUtil.requestString(ResourceManager.getString("label.console.request.fname", msg), errMsg)) == null) {
                if (!soConfig) {
                    return null;
                }
                first = "";
                break;
            }
            errMsg = null;
            if (soConfig || !first.isEmpty()) break;
            errMsg = ResourceManager.getString("error.fname.empty", msg);
        }
        errMsg = null;
        while (true) {
            if ((last = ConsoleUtil.requestString(ResourceManager.getString("label.console.request.lname", msg), errMsg)) == null) {
                if (!soConfig) {
                    return null;
                }
                last = "";
                break;
            }
            errMsg = null;
            if (soConfig || !last.isEmpty()) break;
            errMsg = ResourceManager.getString("error.lname.empty", msg);
        }
        errMsg = null;
        while (true) {
            if ((email = ConsoleUtil.requestString(ResourceManager.getString("label.console.request.email", msg), errMsg)) == null) {
                email = "";
                break;
            }
            errMsg = null;
            if (email.isEmpty() || email.matches("(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*:(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)(?:,\\s*(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*))*)?;\\s*)")) break;
            errMsg = ResourceManager.getString("error.email.invalid", email);
        }
        errMsg = null;
        while (true) {
            if ((phone = ConsoleUtil.requestString(ResourceManager.getString("label.console.request.phone", msg), errMsg)) == null) {
                phone = "";
                break;
            }
            errMsg = null;
            if (phone.isEmpty() || phone.matches("([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})")) break;
            errMsg = ResourceManager.getString("error.phone.invalid", phone);
        }
        return FileUtil.createAdmConfigFile(id, first, last, email, phone, soConfig);
    }

    private boolean requestDBInfo() {
        if (DBUtil.dbConfig == null && !DBUtil.loadDBConfig(SGKms.CONFIG_FOLDER + "/" + "sg-kms.properties")) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.request.db-info"));
            DBUtil.dbConfig = new DBUtil.DBConfig();
            String port = ConsoleUtil.requestString(ResourceManager.getString("label.console.request.mysql.port"), null);
            if (port == null || port.isEmpty()) {
                return false;
            }
            String user = ConsoleUtil.requestString(ResourceManager.getString("label.console.request.mysql.user"), null);
            if (user == null || user.isEmpty()) {
                return false;
            }
            DBUtil.dbConfig.setPort(port);
            DBUtil.dbConfig.setUser(user);
        }
        char[] password = ConsoleUtil.requestPassword(ResourceManager.getString("label.console.request.mysql.password", DBUtil.dbConfig.getUser()), null);
        DBUtil.dbConfig.setPassword(password);
        return true;
    }

    private boolean connectDB() throws SQLException {
        if (!this.requestDBInfo()) {
            return false;
        }
        DBUtil.connectMySQLDB();
        DBUtil.saveDBConfig(SGKms.CONFIG_FOLDER, "sg-kms.properties");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSGA() throws NoSGAdminException, NullUserInfoListenerException, OperationCancelledException, MaxPwTryiesException {
        SGAManager sgaManager = null;
        try {
            String configFile;
            String licenseKey;
            logger.log(Level.INFO, ResourceManager.getString("label.setup.sg-kms"));
            sgaManager = SGAManager.getInstance();
            if (!sgaManager.isLicensed() && !sgaManager.addLicense(licenseKey = ConsoleUtil.requestString(ResourceManager.getString("label.console.request.license"), null))) {
                System.err.println();
                ConsoleUtil.showMessage(ResourceManager.getString("error.license.add"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.license.add"));
                return;
            }
            if (!sgaManager.isSOCreated()) {
                logger.log(Level.INFO, ResourceManager.getString("log.info.so.configuring"));
                configFile = SGKmsConsole.createConfigFile(true, false);
                if (configFile == null) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.operation.cancelled"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.cancelled"));
                    return;
                }
                if (!sgaManager.addSO(configFile)) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.so.add"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.so.add"));
                    return;
                }
            }
            if (!sgaManager.isMySQLDACreated(SGKms.getCurrentDA())) {
                logger.log(Level.INFO, ResourceManager.getString("log.info.da.configuring"));
                configFile = SGKmsConsole.createConfigFile(false, true);
                if (configFile == null) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.operation.cancelled"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.cancelled"));
                    return;
                }
                if (!sgaManager.addDA(configFile)) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.da.add"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.da.add"));
                    return;
                }
            }
            if (!sgaManager.existPolicy("spolicy_mysql_keyring")) {
                String allowedUsers;
                ConsoleUtil.showMessage(ResourceManager.getString("log.info.kms.configuring"), 1);
                logger.log(Level.INFO, ResourceManager.getString("log.info.tde.checking"));
                if (!this.connectDB()) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.operation.user.cancel"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.user.cancel"));
                    System.exit(0);
                }
                if (!DBUtil.isMySQLTDEActivated()) {
                    String confirm;
                    if (!DBUtil.isMySQLTDESupported(DBUtil.getMySQlVersion())) {
                        ConsoleUtil.showMessage(ResourceManager.getString("error.tde.not_supported"), 0);
                        logger.log(Level.ERROR, ResourceManager.getString("error.tde.not_supported"));
                        System.exit(0);
                    }
                    if ((confirm = ConsoleUtil.showConfirm(ResourceManager.getString("info.setup.mysql.restart"), null, true)) == null || !confirm.matches("YES|yes|Yes")) {
                        System.exit(0);
                    }
                    if (!DBUtil.enableTDE()) {
                        ConsoleUtil.showMessage(ResourceManager.getString("log.error.tde.enable"), 0);
                        logger.log(Level.ERROR, ResourceManager.getString("log.error.tde.enable"));
                        System.exit(0);
                    }
                    DBUtil.connectMySQLDB();
                }
                if (!DBUtil.isMySQLTDEActivated()) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.tde.not_enabled"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.tde.not_enabled"));
                    System.exit(0);
                }
                String errMsg = null;
                logger.log(Level.INFO, ResourceManager.getString("log.info.kms.configuring"));
                if (!sgaManager.isPAMEnabled()) {
                    allowedUsers = "";
                } else {
                    System.out.println("");
                    allowedUsers = ConsoleUtil.requestString(ResourceManager.getString("label.console.request.auth-users"), errMsg);
                    if (allowedUsers == null || allowedUsers.isEmpty()) {
                        allowedUsers = "";
                    } else if (allowedUsers.matches("^.*\\s.*$")) {
                        allowedUsers = !allowedUsers.contains(",") ? allowedUsers.replaceAll("\\s", ",") : allowedUsers.replaceAll("\\s", "");
                    }
                    if (!allowedUsers.contains("sgadmin")) {
                        allowedUsers = allowedUsers + (allowedUsers.isEmpty() ? "sgadmin" : ",sgadmin");
                    }
                    if (!allowedUsers.contains("mysql")) {
                        allowedUsers = allowedUsers + ",mysql";
                    }
                }
                String cfgFile = FileUtil.createPolicyConfigFile("spolicy_mysql_keyring", "/var/lib/mysql-keyring", null, allowedUsers, SGKms.getCurrentDA());
                if (!sgaManager.addPolicy(cfgFile, SGKms.getCurrentDA())) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.policy.add"), 0);
                    logger.log(Level.INFO, ResourceManager.getString("error.policy.add"));
                    System.exit(0);
                }
                if (SGKms.getProperty("mmk.gd") == null) {
                    SGKms.saveProperty("mmk.gd", String.valueOf(System.currentTimeMillis()));
                }
            }
            ConsoleUtil.showMessage(ResourceManager.getString("setup.finished.header"), 1);
            logger.log(Level.INFO, ResourceManager.getString("setup.finished.header"));
        }
        catch (DAAddException | EmptyLicenseKeyException | LicenseAddException | LicenseCheckException | NoSGAdminException | PolicyAddException | SOAddException | SQLException ex) {
            ConsoleUtil.showMessage(ex.getMessage(), 0);
            logger.log(Level.ERROR, "", (Throwable)ex);
        }
        finally {
            if (sgaManager != null) {
                sgaManager.clearCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateDBKey() throws MaxPwTryiesException {
        String confirm = ConsoleUtil.showConfirm(ResourceManager.getString("info.setup.mysql.restart"), null, true);
        if (confirm == null || !confirm.matches("YES|yes|Yes")) {
            System.exit(0);
        }
        SGAManager sga = SGAManager.getInstance();
        logger.log(Level.INFO, ResourceManager.getString("log.info.mysql.key-rotating"));
        try {
            int status;
            if (!this.connectDB()) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.operation.user.cancel"), 0);
                logger.log(Level.INFO, ResourceManager.getString("error.operation.user.cancel"));
                System.exit(0);
            }
            if (!DBUtil.isMySQLTDEActivated()) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.tde.not_enabled"), 0);
                System.exit(0);
            }
            if ((status = SGKms.lockerStatus()) == 0) {
                if (!sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.vault.fetching"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.fetching"));
                    System.exit(0);
                }
            } else if (status == 2 && !sga.startPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.vault.starting"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                System.exit(0);
            }
            DBUtil.restartMySQLService();
            DBUtil.connectMySQLDB();
            DBUtil.rotateMySQLDBKey();
            ConsoleUtil.showMessage(ResourceManager.getString("info.mysql.rotate"), 1);
            logger.log(Level.INFO, ResourceManager.getString("info.mysql.rotate"));
            if (status == 0 && !sga.putPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                ConsoleUtil.showMessage(ResourceManager.getString("warn.vault.close"), 1);
                logger.log(Level.WARN, ResourceManager.getString("warn.vault.close"));
            }
        }
        catch (NoSGAdminException | PolicyGetException | PolicyPutException | PolicyStartException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException | SQLException ex) {
            ConsoleUtil.showMessage(ex.getMessage(), 0);
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
        }
    }

    public void openLocker() throws MaxPwTryiesException {
        logger.log(Level.INFO, ResourceManager.getString("info.vault.opening"));
        SGAManager sga = SGAManager.getInstance();
        try {
            int status = sga.policyStatus("spolicy_mysql_keyring", SGKms.getCurrentDA(), 0);
            if (status == 2) {
                ConsoleUtil.showMessage(ResourceManager.getString("info.vault.opened"), 1);
                logger.log(Level.INFO, ResourceManager.getString("info.vault.opened"));
            } else if (status == 3) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.vault.inconsistent"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.vault.inconsistent"));
            } else if (sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                ConsoleUtil.showMessage(ResourceManager.getString("info.vault.open"), 1);
                logger.log(Level.INFO, ResourceManager.getString("info.vault.open"));
            } else {
                ConsoleUtil.showMessage(ResourceManager.getString("error.vault.open"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.vault.open"));
            }
        }
        catch (NoSGAdminException | PolicyGetException | PolicyStatusException | NullUserInfoListenerException | OperationCancelledException ex) {
            ConsoleUtil.showMessage(ex.getMessage(), 0);
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        sga.clearCache();
    }

    public void closeLocker() throws MaxPwTryiesException {
        logger.log(Level.INFO, ResourceManager.getString("info.vault.closing"));
        SGAManager sga = SGAManager.getInstance();
        try {
            int vaultStatus = SGKms.lockerStatus();
            int polStatus = sga.policyStatus("spolicy_mysql_keyring", SGKms.getCurrentDA(), 0);
            if (polStatus == 1 && vaultStatus == 0) {
                ConsoleUtil.showMessage(ResourceManager.getString("info.vault.closed"), 1);
                logger.log(Level.INFO, ResourceManager.getString("info.vault.closed"));
            } else if (polStatus == 3) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.vault.inconsistent"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.vault.inconsistent"));
            } else if (sga.putPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                ConsoleUtil.showMessage(ResourceManager.getString("info.vault.close"), 1);
                logger.log(Level.INFO, ResourceManager.getString("info.vault.close"));
            } else {
                ConsoleUtil.showMessage(ResourceManager.getString("error.vault.close"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.vault.close"));
            }
        }
        catch (NoSGAdminException | PolicyPutException | PolicyStatusException | NullUserInfoListenerException | OperationCancelledException ex) {
            ConsoleUtil.showMessage(ex.getMessage(), 0);
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        sga.clearCache();
    }

    private void rotateDMK() {
        logger.log(Level.INFO, ResourceManager.getString("log.info.dmk.rotating", SGKms.getCurrentDA()));
        SGAManager sga = SGAManager.getInstance();
        try {
            if (sga.dmkRotate(SGKms.getCurrentDA())) {
                ConsoleUtil.showMessage(ResourceManager.getString("info.dmk.rotate"), 1);
                logger.log(Level.INFO, ResourceManager.getString("info.dmk.rotate"));
            } else {
                ConsoleUtil.showMessage(ResourceManager.getString("error.dmk.rotate"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.dmk.rotate"));
            }
        }
        catch (DMKRotateException | NoSGAdminException | NullUserInfoListenerException | OperationCancelledException ex) {
            ConsoleUtil.showMessage(ex.getMessage(), 0);
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeDA() throws MaxPwTryiesException {
        String revokeDA = SGKms.getCurrentDA();
        String reassingDA = SGKms.nextDAId();
        SGAManager sga = SGAManager.getInstance();
        logger.log(Level.INFO, ResourceManager.getString("log.info.da.revoking", revokeDA, reassingDA));
        try {
            if (!sga.isMySQLDACreated(reassingDA)) {
                String configFile = SGKmsConsole.createConfigFile(false, false);
                if (configFile == null) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.operation.cancelled"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.cancelled"));
                    return;
                }
                if (!sga.addDA(configFile)) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.da.add"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.da.add"));
                    return;
                }
            }
            if (!sga.revokeReassingDA(revokeDA, reassingDA)) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.da.revoke.failed"), 1);
                logger.log(Level.ERROR, ResourceManager.getString("error.da.revoke.failed"));
            } else {
                ConsoleUtil.showMessage(ResourceManager.getString("info.da.revoke.success"), 0);
                logger.log(Level.INFO, ResourceManager.getString("info.da.revoke.success"));
            }
        }
        catch (DAAddException | DARevokeReassingException | NoSGAdminException | NullUserInfoListenerException | OperationCancelledException ex) {
            ConsoleUtil.showMessage(ex.getMessage(), 0);
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
        }
    }

    private void rotateSMK() throws MaxPwTryiesException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.smk.rotating", SGKms.getCurrentDA()));
        SGAManager sga = SGAManager.getInstance();
        try {
            if (sga.smkRotate()) {
                ConsoleUtil.showMessage(ResourceManager.getString("info.smk.rotate"), 1);
                logger.log(Level.INFO, ResourceManager.getString("info.smk.rotate"));
            } else {
                ConsoleUtil.showMessage(ResourceManager.getString("error.smk.rotate"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.smk.rotate"));
            }
        }
        catch (NoSGAdminException | SMKRotateException | NullUserInfoListenerException | OperationCancelledException ex) {
            ConsoleUtil.showMessage(ex.getMessage(), 0);
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void protectMySQLLog() throws MaxPwTryiesException {
        String confirm = ConsoleUtil.showConfirm(ResourceManager.getString("info.setup.mysql.restart"), null, true);
        if (confirm == null || !confirm.matches("YES|yes|Yes")) {
            System.exit(0);
        }
        logger.log(Level.INFO, ResourceManager.getString("log.info.mysql.log.protecting"));
        SGAManager sga = SGAManager.getInstance();
        try {
            if (!sga.existPolicy("spolicy_mysql_log")) {
                int lstatus = SGKms.lockerStatus();
                if (lstatus == 0) {
                    if (!sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                        ConsoleUtil.showMessage(ResourceManager.getString("error.vault.fetching"), 0);
                        logger.log(Level.ERROR, ResourceManager.getString("error.vault.fetching"));
                        System.exit(0);
                    }
                } else if (lstatus == 2 && !sga.startPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.vault.starting"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                    System.exit(0);
                }
                String cfgFile = FileUtil.createPolicyConfigFile("spolicy_mysql_log", "/var/log/mysql", DBUtil.getMySQLDaemonName(), sga.isPAMEnabled() ? "sgadmin,mysql" : "", SGKms.getCurrentDA());
                boolean wasAdded = sga.addPolicy(cfgFile, SGKms.getCurrentDA());
                if (lstatus == 0 && !sga.putPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    ConsoleUtil.showMessage(ResourceManager.getString("warn.vault.close"), 1);
                    logger.log(Level.WARN, ResourceManager.getString("warn.vault.close"));
                }
                if (!wasAdded) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.pol.mysql.log.add.failed"), 0);
                } else {
                    ConsoleUtil.showMessage(ResourceManager.getString("info.pol.mysql.log.add.success"), 1);
                }
                return;
            }
            int status = sga.policyStatus("spolicy_mysql_log", SGKms.getCurrentDA(), 0);
            if (status == 2) {
                ConsoleUtil.showMessage(ResourceManager.getString("info.pol.mysql.log.protected"), 1);
                logger.log(Level.INFO, ResourceManager.getString("info.pol.mysql.log.protected"));
            } else if (status == 3) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.pol.mysql.log.inconsistent"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.pol.mysql.log.inconsistent"));
            } else if (sga.startPolicy("spolicy_mysql_log", SGKms.getCurrentDA())) {
                ConsoleUtil.showMessage(ResourceManager.getString("info.pol.mysql.log.protect"), 1);
                logger.log(Level.INFO, ResourceManager.getString("info.pol.mysql.log.protect"));
            } else {
                ConsoleUtil.showMessage(ResourceManager.getString("error.pol.mysql.protect"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.pol.mysql.protect"));
            }
        }
        catch (LicenseCheckException | NoSGAdminException | PolicyAddException | PolicyGetException | PolicyPutException | PolicyStartException | PolicyStatusException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException ex) {
            ConsoleUtil.showMessage(ex.getMessage(), 0);
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unprotectMySQLLog() throws MaxPwTryiesException {
        String confirm = ConsoleUtil.showConfirm(ResourceManager.getString("info.setup.mysql.restart"), null, true);
        if (confirm == null || !confirm.matches("YES|yes|Yes")) {
            System.exit(0);
        }
        logger.log(Level.INFO, ResourceManager.getString("log.info.mysql.log.unprotecting"));
        SGAManager sga = SGAManager.getInstance();
        try {
            if (!sga.existPolicy("spolicy_mysql_log")) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.pol.mysql.log.not_exist"), 0);
                return;
            }
            int status = SGKms.lockerStatus();
            if (status == 0) {
                if (!sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.vault.fetching"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.fetching"));
                    System.exit(0);
                }
            } else if (status == 2 && !sga.startPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.vault.starting"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                System.exit(0);
            }
            boolean wasRemove = sga.removePolicy("spolicy_mysql_log", SGKms.getCurrentDA());
            if (status == 0 && !sga.putPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                ConsoleUtil.showMessage(ResourceManager.getString("warn.vault.close"), 1);
                logger.log(Level.WARN, ResourceManager.getString("warn.vault.close"));
            }
            if (wasRemove) {
                ConsoleUtil.showMessage(ResourceManager.getString("info.pol.mysql.log.unprotect"), 1);
                logger.log(Level.INFO, ResourceManager.getString("info.pol.mysql.log.unprotect"));
            } else {
                ConsoleUtil.showMessage(ResourceManager.getString("error.pol.mysql.unprotect"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.pol.mysql.unprotect"));
            }
        }
        catch (NoSGAdminException | PolicyGetException | PolicyPutException | PolicyRemoveException | PolicyStartException | NullUserInfoListenerException | OperationCancelledException ex) {
            ConsoleUtil.showMessage(ex.getMessage(), 0);
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartTDE() throws MaxPwTryiesException {
        String confirm = ConsoleUtil.showConfirm(ResourceManager.getString("info.setup.mysql.restart"), null, true);
        if (confirm == null || !confirm.matches("YES|yes|Yes")) {
            System.exit(0);
        }
        logger.log(Level.INFO, ResourceManager.getString("info.mysql.tde.restarting"));
        SGAManager sga = SGAManager.getInstance();
        try {
            sga.policyStatus("spolicy_mysql_keyring", SGKms.getCurrentDA(), 0);
            int status = SGKms.lockerStatus();
            if (status == 0) {
                if (!sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.vault.fetching"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.fetching"));
                    System.exit(0);
                }
            } else if (status == 2 && !sga.startPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.vault.starting"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                System.exit(0);
            }
            DBUtil.restartMySQLService();
            logger.log(Level.DEBUG, "MySQL service was restarted");
            if (!sga.putPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                ConsoleUtil.showMessage(ResourceManager.getString("warn.vault.close"), 1);
                logger.log(Level.WARN, ResourceManager.getString("warn.vault.close"));
            }
            ConsoleUtil.showMessage(ResourceManager.getString("info.mysql.tde.restart.success"), 1);
            logger.log(Level.DEBUG, "Restart TDE finished");
        }
        catch (NoSGAdminException | PolicyGetException | PolicyPutException | PolicyStartException | PolicyStatusException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            ConsoleUtil.showMessage(ex.getMessage(), 0);
        }
        finally {
            sga.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSgKmsProtection() throws MaxPwTryiesException {
        String confirm = ConsoleUtil.showConfirm(ResourceManager.getString("info.setup.mysql.restart"), null, true);
        if (confirm == null || !confirm.matches("YES|yes|Yes")) {
            System.exit(0);
        }
        logger.log(Level.INFO, ResourceManager.getString("info.sg-kms.starting"));
        SGAManager sga = SGAManager.getInstance();
        try {
            int status = SGKms.lockerStatus();
            if (status == 2) {
                if (!sga.startPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.vault.starting"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                    System.exit(0);
                }
            } else {
                ConsoleUtil.showMessage(ResourceManager.getString("error.sg-kms.not_stopped"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.sg-kms.not_stopped"));
                System.exit(0);
            }
            DBUtil.restartMySQLService();
            ConsoleUtil.showMessage(ResourceManager.getString("info.sg-kms-start.success"), 1);
        }
        catch (NoSGAdminException | PolicyStartException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            ConsoleUtil.showMessage(ex.getMessage(), 0);
        }
        finally {
            sga.clearCache();
        }
    }

    private void stopSgKmsProtection() throws MaxPwTryiesException {
        logger.log(Level.INFO, ResourceManager.getString("info.sg-kms.stopping"));
        SGAManager sga = SGAManager.getInstance();
        try {
            int status = SGKms.lockerStatus();
            if (status == 1) {
                if (!sga.stopPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.sg-kms.stopping"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.sg-kms.stopping"));
                    System.exit(0);
                }
                ConsoleUtil.showMessage(ResourceManager.getString("info.sg-kms-stop.success"), 1);
            } else {
                ConsoleUtil.showMessage(ResourceManager.getString("info.sg-kms.already_stop"), 1);
            }
        }
        catch (NoSGAdminException | PolicyStopException | NullUserInfoListenerException | OperationCancelledException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            ConsoleUtil.showMessage(ex.getMessage(), 0);
        }
        finally {
            sga.clearCache();
        }
    }

    private void showLogProtectionStatus() throws MaxPwTryiesException {
        try {
            if (!SGAManager.getInstance().existPolicy("spolicy_mysql_log")) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.mysql.log.not_protected"), 0);
                System.exit(0);
            }
            if (!SGAManager.getInstance().isPolicyMounted("spolicy_mysql_log")) {
                ConsoleUtil.showMessage(ResourceManager.getString("info.mysql.log.status.stop"), 1);
            } else {
                ConsoleUtil.showMessage(ResourceManager.getString("info.mysql.log.status.running"), 1);
            }
        }
        catch (NoSGAdminException | NullUserInfoListenerException | OperationCancelledException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            ConsoleUtil.showMessage(ex.getMessage(), 0);
        }
        finally {
            SGAManager.getInstance().clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLogsProtection() throws MaxPwTryiesException {
        String confirm = ConsoleUtil.showConfirm(ResourceManager.getString("info.setup.mysql.restart"), null, true);
        if (confirm == null || !confirm.matches("YES|yes|Yes")) {
            System.exit(0);
        }
        logger.log(Level.INFO, ResourceManager.getString("info.mysql.log.protection.starting"));
        SGAManager sga = SGAManager.getInstance();
        try {
            boolean existPolicy = sga.existPolicy("spolicy_mysql_log");
            if (!existPolicy) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.mysql.log.not_protected"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.mysql.log.not_protected"));
                System.exit(0);
            }
            if (!sga.isPolicyMounted("spolicy_mysql_log")) {
                int lstatus = SGKms.lockerStatus();
                if (lstatus == 0) {
                    if (!sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                        ConsoleUtil.showMessage(ResourceManager.getString("error.vault.fetching"), 0);
                        logger.log(Level.ERROR, ResourceManager.getString("error.vault.fetching"));
                        System.exit(0);
                    }
                } else if (lstatus == 2 && !sga.startPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.vault.starting"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                    System.exit(0);
                }
                DBUtil.stopMySQLService();
                boolean wasStarted = sga.startPolicy("spolicy_mysql_log", SGKms.getCurrentDA());
                if (lstatus == 0 && !sga.putPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    ConsoleUtil.showMessage(ResourceManager.getString("warn.vault.close"), 1);
                    logger.log(Level.WARN, ResourceManager.getString("warn.vault.close"));
                }
                if (!wasStarted) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.pol.mysql.log.starting"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.pol.mysql.log.starting"));
                    System.exit(0);
                }
            } else {
                ConsoleUtil.showMessage(ResourceManager.getString("error.mysql.log.not_stopped"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.mysql.log.not_stopped"));
                System.exit(0);
            }
            ConsoleUtil.showMessage(ResourceManager.getString("info.mysql.log.protection.started.success"), 1);
        }
        catch (NoSGAdminException | PolicyGetException | PolicyPutException | PolicyStartException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            ConsoleUtil.showMessage(ex.getMessage(), 0);
        }
        finally {
            sga.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopLogsProtection() throws MaxPwTryiesException {
        logger.log(Level.INFO, ResourceManager.getString("info.mysql.log.protection.stopping"));
        String confirm = ConsoleUtil.showConfirm(ResourceManager.getString("info.alert.mysql.stop.message"), null, true);
        if (confirm == null || !confirm.matches("YES|yes|Yes")) {
            System.exit(0);
        }
        SGAManager sga = SGAManager.getInstance();
        try {
            boolean existPolicy = sga.existPolicy("spolicy_mysql_log");
            if (!existPolicy) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.mysql.log.not_protected"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.mysql.log.not_protected"));
                System.exit(0);
            }
            if (sga.isPolicyMounted("spolicy_mysql_log")) {
                if (!sga.stopPolicy("spolicy_mysql_log", SGKms.getCurrentDA())) {
                    ConsoleUtil.showMessage(ResourceManager.getString("error.mysql.log.protection.stopping"), 0);
                    logger.log(Level.ERROR, ResourceManager.getString("error.mysql.log.protection.stopping"));
                    System.exit(0);
                }
                ConsoleUtil.showMessage(ResourceManager.getString("info.mysql.log.protection.stop.success"), 1);
            } else {
                ConsoleUtil.showMessage(ResourceManager.getString("info.mysql.log.protection.alreadyd_stop"), 1);
            }
        }
        catch (NoSGAdminException | PolicyStopException | NullUserInfoListenerException | OperationCancelledException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            ConsoleUtil.showMessage(ex.getMessage(), 0);
        }
        finally {
            sga.clearCache();
        }
    }

    private void unprotectMySQLKey() throws MaxPwTryiesException {
        SGAManager sga = SGAManager.getInstance();
        logger.log(Level.INFO, ResourceManager.getString("info.vault.unprotecting"));
        try {
            if (!sga.existPolicy("spolicy_mysql_keyring")) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.vault.not_exist"), 0);
                return;
            }
            if (SGKms.lockerStatus() == 0 && !sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                ConsoleUtil.showMessage(ResourceManager.getString("error.vault.fetching"), 0);
                logger.log(Level.ERROR, ResourceManager.getString("error.vault.fetching"));
                System.exit(0);
            }
            if (sga.removePolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                ConsoleUtil.showMessage(ResourceManager.getString("info.vault.removed"), 1);
                logger.log(Level.INFO, ResourceManager.getString("info.vault.removed"));
                return;
            }
            ConsoleUtil.showMessage(ResourceManager.getString("error.vault.remove"), 0);
            logger.log(Level.ERROR, ResourceManager.getString("error.vault.remove"));
        }
        catch (NoSGAdminException | PolicyGetException | PolicyRemoveException | NullUserInfoListenerException | OperationCancelledException ex) {
            ConsoleUtil.showMessage(ex.getMessage(), 0);
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
        }
    }

    private void printUsage() {
        System.out.println(ResourceManager.getString("info.usage.command"));
        System.out.println();
        System.out.printf("   %-15s%s\n", RETRIEVE_MMK, ResourceManager.getString("info.command.mmk.pol.open.usage"));
        System.out.printf("   %-15s%s\n", STORE_MMK, ResourceManager.getString("info.command.mmk.pol.close.usage"));
        System.out.printf("   %-15s%s\n", MMK_STATUS, ResourceManager.getString("info.command.mmk.pol.status.usage"));
        System.out.printf("   %-15s%s\n", MMK_START, ResourceManager.getString("info.command.mmk.pol.start.usage"));
        System.out.printf("   %-15s%s\n", MMK_STOP, ResourceManager.getString("info.command.mmk.pol.stop.usage"));
        System.out.printf("   %-15s%s\n", UNPROTECT_MMK, ResourceManager.getString("info.command.mmk.pol.remove.usage"));
        System.out.printf("   %-15s%s\n", ROTATE_MMK, ResourceManager.getString("info.command.mmk.rotate.usage"));
        System.out.printf("   %-15s%s\n", ROTATE_DMK, ResourceManager.getString("info.command.sg.rotate-dmk.usage"));
        System.out.printf("   %-15s%s\n", ROTATE_SMK, ResourceManager.getString("info.command.sg.rotate-smk.usage"));
        System.out.printf("   %-15s%s\n", REVOKE_DA, ResourceManager.getString("info.command.sg.revoke-da.usage1"));
        System.out.printf("   %-15s%s\n", "", ResourceManager.getString("info.command.sg.revoke-da.usage2"));
        System.out.printf("   %-15s%s\n", PROTECT_LOG, ResourceManager.getString("info.command.mysql.protect-log.usage"));
        System.out.printf("   %-15s%s\n", UNPROTECT_LOG, ResourceManager.getString("info.command.mysql.unprotect-log.usage"));
        System.out.printf("   %-15s%s\n", LOGS_STATUS, ResourceManager.getString("info.command.mysql.log.pol.status.usage"));
        System.out.printf("   %-15s%s\n", START_LOGS_PROT, ResourceManager.getString("info.command.mysql.log.pol.start.usage"));
        System.out.printf("   %-15s%s\n", STOP_LOGS_PROT, ResourceManager.getString("info.command.mysql.log.pol.stop.usage"));
        System.out.printf("   %-15s%s\n", RESTART_TDE, ResourceManager.getString("info.command.mysql.tde.restart.usage"));
        System.out.printf("   %-15s%s\n", UNINSTALL, ResourceManager.getString("info.command.sg-kms.uninstall"));
    }

    private static class UserData
    implements SGAManager.SGADataListener {
        private UserData() {
        }

        @Override
        public char[] requestUserData(int dataType, String errMsg) {
            String msg = null;
            switch (dataType) {
                case 7: {
                    msg = ResourceManager.getString("label.data-request.sg-dmk.msg");
                    break;
                }
                case 5: {
                    msg = ResourceManager.getString("label.data-request.sg-new-dmk.msg");
                    break;
                }
                case 6: {
                    msg = ResourceManager.getString("label.data-request.sg-new-dmk-again.msg");
                    break;
                }
                case 4: {
                    msg = ResourceManager.getString("label.data-request.sg-smk.msg");
                    break;
                }
                case 2: {
                    msg = ResourceManager.getString("label.data-request.sg-new-smk.msg");
                    break;
                }
                case 3: {
                    msg = ResourceManager.getString("label.data-request.sg-new-smk-again.msg");
                    break;
                }
                case 1: {
                    msg = ResourceManager.getString("label.data-request.sudo-pw.msg", System.getenv("USER"));
                    break;
                }
                case 8: {
                    msg = ResourceManager.getString("label.data-request.sg-overwrite.msg");
                    return ConsoleUtil.showConfirm(msg, errMsg, true).toCharArray();
                }
            }
            return ConsoleUtil.requestPassword(msg, errMsg);
        }
    }
}

