/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;

public class ResultSetUtil {
    public static StringBuilder appendResultSetSlashGStyle(StringBuilder appendTo, ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int numFields = rsmd.getColumnCount();
        int maxWidth = 0;
        String[] fieldNames = new String[numFields];
        for (int i = 0; i < numFields; ++i) {
            fieldNames[i] = rsmd.getColumnLabel(i + 1);
            if (fieldNames[i].length() <= maxWidth) continue;
            maxWidth = fieldNames[i].length();
        }
        int rowCount = 1;
        while (rs.next()) {
            appendTo.append("*************************** ");
            appendTo.append(rowCount++);
            appendTo.append(". row ***************************\n");
            for (int i = 0; i < numFields; ++i) {
                int leftPad = maxWidth - fieldNames[i].length();
                for (int j = 0; j < leftPad; ++j) {
                    appendTo.append(" ");
                }
                appendTo.append(fieldNames[i]);
                appendTo.append(": ");
                String stringVal = rs.getString(i + 1);
                if (stringVal != null) {
                    appendTo.append(stringVal);
                } else {
                    appendTo.append("NULL");
                }
                appendTo.append("\n");
            }
            appendTo.append("\n");
        }
        return appendTo;
    }

    public static void resultSetToMap(Map mappedValues, ResultSet rs) throws SQLException {
        while (rs.next()) {
            mappedValues.put(rs.getObject(1), rs.getObject(2));
        }
    }

    public static void resultSetToMap(Map mappedValues, ResultSet rs, int key, int value) throws SQLException {
        while (rs.next()) {
            mappedValues.put(rs.getObject(key), rs.getObject(value));
        }
    }

    public static Object readObject(ResultSet resultSet, int index) throws IOException, SQLException, ClassNotFoundException {
        ObjectInputStream objIn = new ObjectInputStream(resultSet.getBinaryStream(index));
        Object obj = objIn.readObject();
        objIn.close();
        return obj;
    }
}

