/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.util;

import com.servergeneral.sgkms.ResourceManager;
import java.awt.GraphicsEnvironment;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConsoleUtil {
    private static final Logger logger = LogManager.getLogger();

    public static String requestString(String captionMsg, String errMsg) {
        if (System.console() != null) {
            if (errMsg != null) {
                System.err.println(errMsg);
                System.err.print("\n    ");
            }
            System.out.print(captionMsg);
            return System.console().readLine();
        }
        if (!GraphicsEnvironment.isHeadless()) {
            logger.log(Level.WARN, ResourceManager.getString("log.error.not_console"));
            if (errMsg != null) {
                captionMsg = "<html>" + errMsg + "<br/><br/>   " + captionMsg + "</html>";
            }
            return JOptionPane.showInputDialog(null, captionMsg, ResourceManager.getString("info.dialog.input.title"), 3);
        }
        logger.log(Level.FATAL, ResourceManager.getString("log.error.not_console.pwd"));
        throw new Error(ResourceManager.getString("log.error.not_console.pwd"));
    }

    public static String showConfirm(String captionMsg, String errMsg, boolean confirm) {
        if (System.console() != null) {
            String resp;
            int tryies = 0;
            if (errMsg != null) {
                System.err.println(errMsg);
                System.err.print("\n    ");
            }
            do {
                System.out.print(captionMsg + ResourceManager.getString("label.console.yesno"));
            } while ((resp = System.console().readLine()).isEmpty() && ++tryies < 3);
            if (resp.isEmpty()) {
                return null;
            }
            return resp;
        }
        if (!GraphicsEnvironment.isHeadless()) {
            logger.log(Level.WARN, ResourceManager.getString("log.error.not_console"));
            if (errMsg != null) {
                captionMsg = "<html>" + errMsg + "<br/><br/>   " + captionMsg + "</html>";
            }
            if (JOptionPane.showConfirmDialog(null, captionMsg, ResourceManager.getString("info.dialog.input.title"), 3) == 0) {
                return "YES";
            }
            return "NO";
        }
        logger.log(Level.FATAL, ResourceManager.getString("log.error.not_console.pwd"));
        throw new Error(ResourceManager.getString("log.error.not_console.pwd"));
    }

    public static void showMessage(String msg, int type) {
        if (System.console() != null) {
            if (type == 0) {
                System.err.println(msg);
            } else {
                System.out.println(msg);
            }
        } else if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showMessageDialog(null, msg, "sg-kms", type);
        } else {
            logger.log(Level.FATAL, ResourceManager.getString("log.error.notc_console.output"));
            throw new Error(ResourceManager.getString("log.error.notc_console.output"));
        }
    }

    public static char[] requestPassword(String msg, String errMsg) {
        if (System.console() != null) {
            if (errMsg != null) {
                System.err.println(errMsg);
                System.err.print("\n    ");
            }
            System.out.print(msg);
            return System.console().readPassword();
        }
        if (!GraphicsEnvironment.isHeadless()) {
            logger.log(Level.WARN, ResourceManager.getString("log.error.not_console"));
            if (errMsg != null) {
                msg = "<html>" + errMsg + "<br><br>   " + msg + "</html>";
            }
            JPanel panel = new JPanel();
            JLabel label = new JLabel(msg);
            JPasswordField pass = new JPasswordField(16);
            Object[] options = new String[]{"OK", "Cancel"};
            panel.add(label);
            panel.add(pass);
            int option = JOptionPane.showOptionDialog(null, panel, ResourceManager.getString("info.dialog.input.pwd.title"), 1, -1, null, options, options[0]);
            if (option == 0) {
                return pass.getPassword();
            }
            return new char[]{'\u0000'};
        }
        logger.log(Level.FATAL, ResourceManager.getString("log.error.not_console.pwd"));
        throw new Error(ResourceManager.getString("log.error.not_console.pwd"));
    }
}

