/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.system;

import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.util.FileUtil;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ProcessExecutor {
    private static final Logger logger = LogManager.getLogger();
    private static ProcessExecutor instance;
    private final Map<Integer, char[]> pwds = new HashMap<Integer, char[]>();
    private UserDataListener userInfoListener;
    private final Map<Integer, Integer> savePwdSlots = new HashMap<Integer, Integer>();

    private ProcessExecutor() {
        this.savePwdAs(1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProcessExecutor getInstance() {
        if (instance != null) return instance;
        Class<ProcessExecutor> clazz = ProcessExecutor.class;
        synchronized (ProcessExecutor.class) {
            if (instance != null) return instance;
            instance = new ProcessExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void savePwdAs(Integer key, Integer slot) {
        this.savePwdSlots.put(key, slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultInfo runCommand(String[] command, List<ParseOutput> _errCodes, List<ParseOutput> _commonCodes, List<ParseOutput> _requestDataCodes, List<String> _customRegexes) throws NullUserInfoListenerException, MaxPwTryiesException, OperationCancelledException {
        InputStreamReader input = null;
        OutputStreamWriter output = null;
        Process pb = null;
        int tryies = 1;
        ParseOutput lastPwType = null;
        ResultInfo res = new ResultInfo();
        res.resultCode = null;
        try {
            int bytes;
            pb = new ProcessBuilder(command).start();
            output = new OutputStreamWriter(pb.getOutputStream());
            input = new InputStreamReader(pb.getInputStream());
            String line = "";
            char[] buffer = new char[1024];
            StringBuffer data = new StringBuffer(128);
            String errMsg = null;
            logger.log(Level.DEBUG, "#begin loop: ");
            block11: while (res.resultCode == null && (bytes = input.read(buffer, 0, 1023)) != -1) {
                if (bytes == 0) continue;
                data.append(buffer, 0, bytes);
                Arrays.fill(buffer, '\u0000');
                block12: while (res.resultCode == null && (line = FileUtil.getNextLine(data)) != null) {
                    logger.log(Level.DEBUG, "##read: " + line + "##");
                    res.lastLine = line;
                    if (_errCodes != null) {
                        for (ParseOutput code : _errCodes) {
                            String regex;
                            if (code.regex() == null) {
                                if (code.customRgxId() < 0 || _customRegexes == null || code.customRgxId() >= _customRegexes.size()) continue;
                                regex = _customRegexes.get(code.customRgxId());
                            } else {
                                regex = code.regex();
                            }
                            if (!line.matches(regex)) continue;
                            if (code.saveError()) {
                                errMsg = line;
                                break;
                            }
                            logger.log(Level.DEBUG, "##found code: " + code + "##");
                            res.resultCode = code;
                            break;
                        }
                    }
                    if (res.resultCode != null || _commonCodes == null) continue;
                    for (ParseOutput code : _commonCodes) {
                        if (!line.matches(code.regex())) continue;
                        if (code.saveError()) {
                            errMsg = line;
                            continue block12;
                        }
                        logger.log(Level.DEBUG, "##found common code: " + code + "##");
                        res.resultCode = code;
                        continue block12;
                    }
                }
                if (res.resultCode != null || data.length() <= 0 || data.indexOf("\n") >= 0 || _requestDataCodes == null) continue;
                String str = data.toString();
                logger.log(Level.DEBUG, "##data: " + str + "##");
                for (ParseOutput code : _requestDataCodes) {
                    if (!str.matches(code.regex())) continue;
                    if (code.resetData()) {
                        tryies = code != lastPwType ? 1 : tryies + 1;
                        lastPwType = code;
                        if (tryies > 1) {
                            this.savePassword(code.associatedData(), null);
                        }
                    }
                    if (tryies > 1 && code.associatedData() == 1) {
                        errMsg = ResourceManager.getString("error.incorrect.pwd");
                    }
                    if (!this.requestPassword(output, code.associatedData(), errMsg)) {
                        throw new OperationCancelledException();
                    }
                    data.delete(0, data.length() - 1);
                    errMsg = null;
                    continue block11;
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
        }
        finally {
            try {
                if (pb != null) {
                    pb.destroy();
                }
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARN, "", (Throwable)ex);
            }
        }
        logger.log(Level.DEBUG, "##loop finished");
        if (res.resultCode == null && tryies == 3) {
            throw new MaxPwTryiesException(lastPwType != null ? lastPwType.associatedData() : 0);
        }
        return res;
    }

    /*
     * Exception decompiling
     */
    public static String runCommandToString(String command) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private char[] getSavedPassword(int type) {
        int key;
        int n = key = this.savePwdSlots.values().contains(type) ? type : -1;
        if (key == -1) {
            return null;
        }
        if (this.pwds.containsKey(key)) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.pe.previouspwd.return"));
            return this.pwds.get(key);
        }
        return null;
    }

    private boolean savePassword(int type, char[] password) {
        int key;
        int n = key = this.savePwdSlots.containsKey(type) ? this.savePwdSlots.get(type) : -1;
        if (key == -1) {
            return false;
        }
        if (this.pwds.containsKey(key)) {
            char[] pwd = this.pwds.get(type);
            if (pwd != null && pwd != password) {
                Arrays.fill(pwd, '\u0000');
            }
            if (password == null) {
                this.pwds.remove(key);
            }
        }
        if (password != null) {
            this.pwds.put(key, password);
            logger.log(Level.INFO, ResourceManager.getString("log.info.pe.pwd.changed"));
        }
        return true;
    }

    public void clearPasswords() {
        logger.log(Level.INFO, ResourceManager.getString("log.info.pe.clearpwds.begin"));
        if (this.pwds.isEmpty()) {
            return;
        }
        for (char[] pwd : this.pwds.values()) {
            if (pwd == null) continue;
            Arrays.fill(pwd, '\u0000');
            Object var2_2 = null;
        }
        this.pwds.clear();
        logger.log(Level.INFO, ResourceManager.getString("log.info.pe.clearpwds.end"));
    }

    private boolean requestPassword(OutputStreamWriter output, int type, String errMsg) throws IOException, NullUserInfoListenerException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.pe.requestdata.begin"));
        if (this.userInfoListener == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.pe.userinfo.unset"));
            throw new NullUserInfoListenerException();
        }
        char[] password = this.getSavedPassword(type);
        char[] cArray = password = password == null ? this.userInfoListener.requestUserData(type, errMsg) : password;
        if (password != null) {
            logger.log(Level.DEBUG, "Sendig data: " + String.valueOf(password));
            output.write(password, 0, password.length);
        }
        output.write(10);
        output.flush();
        if (!this.savePassword(type, password) && password != null) {
            Arrays.fill(password, '\u0000');
        }
        return password != null;
    }

    public void setUserInfoListener(UserDataListener listener) {
        logger.log(Level.INFO, ResourceManager.getString("log.info.pe.setuserinfo.begin"));
        this.userInfoListener = listener;
    }

    public void removeUserInfoListener() {
        logger.log(Level.INFO, ResourceManager.getString("log.info.pe.remuserinfo.begin"));
        this.userInfoListener = null;
    }

    public class ResultInfo {
        public String lastLine = null;
        public ParseOutput resultCode = null;
    }

    public static interface UserDataListener {
        public static final int SUDO_PW = 1;

        public char[] requestUserData(int var1, String var2);
    }

    public static interface ParseOutput {
        public String regex();

        public boolean saveError();

        public int associatedData();

        public boolean resetData();

        public int customRgxId();
    }
}

