/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sgkms.gui.SGKmsOPController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.spi.StandardLevel;

public class LogViewerDialog
extends Dialog<Void> {
    private LogView logView;
    private List<String> logFiles;
    private Button nextButton;
    private Button prevButton;
    private int currentLog;
    private static String LOG_FOLDER = "/var/log/serverg";
    private static String LOG_PREFIX = "sg-kms";
    private Label currentPage;
    private EventHandler<ActionEvent> onNext = event -> {
        if (this.currentLog >= this.logFiles.size()) {
            return;
        }
        if (this.currentLog == this.logFiles.size() - 1) {
            this.currentLog = -1;
        }
        ++this.currentLog;
        this.loadLogFile(this.logFiles.get(this.currentLog));
        this.updateControls();
    };
    private EventHandler<ActionEvent> onPrev = event -> {
        if (this.currentLog < 0) {
            return;
        }
        if (this.currentLog == 0) {
            this.currentLog = this.logFiles.size();
        }
        --this.currentLog;
        this.loadLogFile(this.logFiles.get(this.currentLog));
        this.updateControls();
    };

    public LogViewerDialog() {
        this.logView = new LogView();
        this.logView.setPrefWidth(600.0);
        ChoiceBox filterLevel = new ChoiceBox(FXCollections.observableArrayList((Object[])Level.values()));
        filterLevel.getItems().remove((Object)Level.OFF);
        filterLevel.getItems().remove((Object)Level.TRACE);
        filterLevel.getSelectionModel().select((Object)Level.ALL);
        this.logView.filterLevelProperty().bind((ObservableValue)filterLevel.getSelectionModel().selectedItemProperty());
        this.prevButton = new Button("Prev");
        this.nextButton = new Button("Next");
        HBox navButtons = new HBox(5.0, new Node[]{this.prevButton, this.nextButton});
        navButtons.setAlignment(Pos.CENTER_RIGHT);
        Region region0 = new Region();
        HBox.setHgrow((Node)region0, (Priority)Priority.ALWAYS);
        Region region1 = new Region();
        HBox.setHgrow((Node)region1, (Priority)Priority.ALWAYS);
        this.currentPage = new Label(".../...");
        this.prevButton.setOnAction(this.onPrev);
        this.nextButton.setOnAction(this.onNext);
        HBox controls = new HBox(10.0, new Node[]{filterLevel, region0, this.currentPage, region1, navButtons});
        controls.setMinHeight(Double.NEGATIVE_INFINITY);
        VBox layout = new VBox(10.0, new Node[]{controls, this.logView});
        VBox.setVgrow((Node)this.logView, (Priority)Priority.ALWAYS);
        this.getDialogPane().setContent((Node)layout);
        this.getDialogPane().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/styles/log-view.css").toExternalForm());
        this.setResizable(true);
        Window window = this.getDialogPane().getScene().getWindow();
        window.setOnCloseRequest(event -> window.hide());
        this.logFiles = this.listLogFiles();
        this.currentLog = -1;
        if (this.logFiles.size() > 0) {
            this.loadLogFile(this.logFiles.get(0));
            this.currentLog = 0;
        }
        this.updateControls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLogFile(String file) {
        BufferedReader buffer = null;
        try {
            String line;
            File logFile = new File(file);
            buffer = new BufferedReader(new FileReader(logFile));
            this.logView.logItems.clear();
            while ((line = buffer.readLine()) != null) {
                this.logView.logItems.add((Object)LogRecord.parse(line));
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SGKmsOPController.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SGKmsOPController.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        finally {
            try {
                buffer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SGKmsOPController.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
            }
        }
    }

    private void updateControls() {
        this.nextButton.setDisable(this.currentLog <= 0);
        this.prevButton.setDisable(this.currentLog < 0 || this.currentLog == 1 || this.logFiles.size() == 1);
        String total = String.valueOf(this.logFiles.size());
        if (this.currentLog == 0) {
            this.currentPage.setText(total + "/" + total);
        } else {
            this.currentPage.setText(this.currentLog + "/" + total);
        }
    }

    private List<String> listLogFiles() {
        File folder = new File(LOG_FOLDER);
        File[] listOfFiles = folder.listFiles();
        ArrayList<String> result = new ArrayList<String>();
        Arrays.sort(listOfFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                int n1 = this.extractNumber(o1.getName());
                int n2 = this.extractNumber(o2.getName());
                return n1 - n2;
            }

            private int extractNumber(String name) {
                int i = 0;
                try {
                    int s = 7;
                    int e = name.lastIndexOf(46);
                    String number = name.substring(s, e);
                    i = Integer.parseInt(number);
                }
                catch (Exception e) {
                    i = 0;
                }
                return i;
            }
        });
        for (int i = 0; i < listOfFiles.length; ++i) {
            String name;
            if (!listOfFiles[i].isFile() || !(name = listOfFiles[i].getName()).startsWith(LOG_PREFIX)) continue;
            result.add(listOfFiles[i].getAbsolutePath());
        }
        return result;
    }

    class LogView
    extends ListView<LogRecord> {
        private static final int MAX_ENTRIES = 10000;
        private final PseudoClass debug = PseudoClass.getPseudoClass((String)"debug");
        private final PseudoClass info = PseudoClass.getPseudoClass((String)"info");
        private final PseudoClass warn = PseudoClass.getPseudoClass((String)"warn");
        private final PseudoClass error = PseudoClass.getPseudoClass((String)"error");
        private final PseudoClass fatal = PseudoClass.getPseudoClass((String)"fatal");
        private final BooleanProperty showTimestamp = new SimpleBooleanProperty(false);
        private final ObjectProperty<Level> filterLevel = new SimpleObjectProperty(null);
        private final BooleanProperty tail = new SimpleBooleanProperty(false);
        private final BooleanProperty paused = new SimpleBooleanProperty(false);
        private final DoubleProperty refreshRate = new SimpleDoubleProperty(60.0);
        private final ObservableList<LogRecord> logItems = FXCollections.observableArrayList();

        public BooleanProperty showTimeStampProperty() {
            return this.showTimestamp;
        }

        public ObjectProperty<Level> filterLevelProperty() {
            return this.filterLevel;
        }

        public BooleanProperty tailProperty() {
            return this.tail;
        }

        public BooleanProperty pausedProperty() {
            return this.paused;
        }

        public DoubleProperty refreshRateProperty() {
            return this.refreshRate;
        }

        public LogView() {
            this.getStyleClass().add((Object)"log-view");
            this.filterLevel.addListener((observable, oldValue, newValue) -> this.setItems((ObservableList)new FilteredList(this.logItems, logRecord -> logRecord.getLevel().intLevel() <= ((Level)this.filterLevel.get()).intLevel())));
            this.filterLevel.set((Object)Level.DEBUG);
            this.setCellFactory(param -> new ListCell<LogRecord>(){
                {
                    LogView.this.showTimestamp.addListener(observable -> this.updateItem((LogRecord)this.getItem(), this.isEmpty()));
                }

                protected void updateItem(LogRecord item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.pseudoClassStateChanged(LogView.this.debug, false);
                    this.pseudoClassStateChanged(LogView.this.info, false);
                    this.pseudoClassStateChanged(LogView.this.warn, false);
                    this.pseudoClassStateChanged(LogView.this.error, false);
                    if (item == null || empty) {
                        this.setText(null);
                        return;
                    }
                    this.setText(item.toString());
                    if (item.getLevel().intLevel() == StandardLevel.DEBUG.intLevel()) {
                        this.pseudoClassStateChanged(LogView.this.debug, true);
                    } else if (item.getLevel().intLevel() == StandardLevel.INFO.intLevel()) {
                        this.pseudoClassStateChanged(LogView.this.info, true);
                    } else if (item.getLevel().intLevel() == StandardLevel.WARN.intLevel()) {
                        this.pseudoClassStateChanged(LogView.this.warn, true);
                    } else if (item.getLevel().intLevel() == StandardLevel.ERROR.intLevel()) {
                        this.pseudoClassStateChanged(LogView.this.error, true);
                    } else if (item.getLevel().intLevel() == StandardLevel.FATAL.intLevel()) {
                        this.pseudoClassStateChanged(LogView.this.fatal, true);
                    }
                }
            });
        }
    }

    static class LogRecord {
        private String timestamp;
        private Level level;
        private String user;
        private String host;
        private String thread;
        private String message;

        public LogRecord() {
        }

        public LogRecord(String timestamp, Level level, String user, String host, String thread, String message) {
            this.timestamp = timestamp;
            this.level = level;
            this.user = user;
            this.host = host;
            this.thread = thread;
            this.message = message;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public Level getLevel() {
            return this.level;
        }

        public void setLevel(Level level) {
            this.level = level;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getThread() {
            return this.thread;
        }

        public void setThread(String thread) {
            this.thread = thread;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String toString() {
            return this.timestamp + " [" + this.level + "] " + this.user + " " + this.host + " " + this.thread + " " + this.message;
        }

        public static LogRecord parse(String log) {
            String[] values = log.split(";");
            values[1] = values[1].replaceAll("[ \\[\\]]", "");
            String msg = values[5];
            for (int i = 6; i < values.length; ++i) {
                msg = msg + ";" + values[i];
            }
            return new LogRecord(values[0], Level.getLevel(values[1]), values[2], values[3], values[4], StringEscapeUtils.unescapeXml(msg));
        }
    }
}

