/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAGeneralException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import javafx.concurrent.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskEditDA
extends Task<Boolean> {
    private static final Logger logger = LogManager.getLogger();
    private String daId;
    private String fName;
    private String lName;
    private String email;
    private String phone;

    public TaskEditDA(String daId, String fName, String lName, String email, String phone, String dmk) {
        this.daId = daId;
        this.fName = fName;
        this.lName = lName;
        this.email = email;
        this.phone = phone;
    }

    public String getDaId() {
        return this.daId;
    }

    public void setDaId(String daId) {
        this.daId = daId;
    }

    public String getfName() {
        return this.fName;
    }

    public void setfName(String fName) {
        this.fName = fName;
    }

    public String getlName() {
        return this.lName;
    }

    public void setlName(String lName) {
        this.lName = lName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    protected Boolean call() throws Exception {
        this.updateTitle(ResourceManager.getString("log.info.da.editing", this.daId));
        SGAManager sga = SGAManager.getInstance();
        logger.log(Level.INFO, ResourceManager.getString("log.info.da.editing", this.daId));
        try {
            if (sga.editDA(this.daId, this.fName, this.lName, this.email, this.phone)) {
                this.updateTitle(ResourceManager.getString("log.info.da.editing"));
                logger.log(Level.INFO, ResourceManager.getString("log.info.da.editing"));
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            this.updateMessage(ResourceManager.getString("error.da.edit", this.daId));
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, ResourceManager.getString("error.da.edit", this.daId));
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        catch (NoSGAdminException | SGAGeneralException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.updateMessage(ex.getMessage());
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
        }
        return Boolean.FALSE;
    }
}

