/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAGeneralException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import javafx.concurrent.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskEditSO
extends Task<Boolean> {
    private static final Logger logger = LogManager.getLogger();
    private String fName;
    private String lName;
    private String email;
    private String phone;

    public TaskEditSO(String fName, String lName, String email, String phone) {
        this.fName = fName;
        this.lName = lName;
        this.email = email;
        this.phone = phone;
    }

    public String getfName() {
        return this.fName;
    }

    public void setfName(String fName) {
        this.fName = fName;
    }

    public String getlName() {
        return this.lName;
    }

    public void setlName(String lName) {
        this.lName = lName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    protected Boolean call() throws Exception {
        this.updateTitle(ResourceManager.getString("info.smk.editing"));
        SGAManager sga = SGAManager.getInstance();
        logger.log(Level.INFO, ResourceManager.getString("log.info.smk.editing"));
        try {
            if (sga.editSO(this.fName, this.lName, this.email, this.phone)) {
                this.updateTitle(ResourceManager.getString("info.smk.edit"));
                logger.log(Level.INFO, ResourceManager.getString("info.smk.edit"));
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            this.updateMessage(ResourceManager.getString("error.smk.edit"));
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, ResourceManager.getString("error.smk.edit"));
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        catch (NoSGAdminException | SGAGeneralException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.updateMessage(ex.getMessage());
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
        }
        return Boolean.FALSE;
    }
}

