/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAGeneralException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskRevokeDA
extends Task<Boolean> {
    private List<Integer> pwRequested;
    private static final Logger logger = LogManager.getLogger();
    private String DAId;

    public TaskRevokeDA(List<Integer> pwRequested, String DAId) {
        this.pwRequested = pwRequested;
        this.DAId = DAId;
    }

    protected Boolean call() throws Exception {
        try {
            if (SGAManager.getInstance().revokeDA(this.DAId)) {
                this.updateTitle(ResourceManager.getString("log.info.sgamanager.revoke-da.success", this.DAId));
                logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.revoke-da.success", this.DAId));
                this.updateValue(Boolean.TRUE);
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            this.updateMessage(ResourceManager.getString("log.error.sgamanager.revoke-da.succes", this.DAId));
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.revoke-da.succes", this.DAId));
        }
        catch (NoSGAdminException | SGAGeneralException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.updateMessage(ex.getMessage());
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            if (SGAManager.getInstance() != null) {
                SGAManager.getInstance().clearCache();
            }
        }
        this.updateValue(Boolean.FALSE);
        return Boolean.FALSE;
    }
}

