/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.PolicyStopException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskStopPolicy
extends Task<Boolean> {
    private List<Integer> pwRequested;
    private static final Logger logger = LogManager.getLogger();
    private String DAId;
    private String Policy;

    public TaskStopPolicy(List<Integer> pwRequested, String DAId, String Policy2) {
        this.pwRequested = pwRequested;
        this.DAId = DAId;
        this.Policy = Policy2;
    }

    protected Boolean call() throws Exception {
        logger.log(Level.INFO, ResourceManager.getString("info.policy.stopping"));
        this.updateTitle(ResourceManager.getString("info.policy.stopping"));
        SGAManager sga = SGAManager.getInstance();
        try {
            if (sga.isPolicyMounted(this.Policy)) {
                if (!sga.stopPolicy(this.Policy, this.DAId)) {
                    this.updateMessage(ResourceManager.getString("error.policy.stopping"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.policy.stopping"));
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                this.updateTitle(ResourceManager.getString("info.policy-stop.success"));
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            this.updateTitle(ResourceManager.getString("info.policy.already_stop"));
        }
        catch (NoSGAdminException | PolicyStopException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            this.updateMessage(ex.getMessage());
            this.updateTitle(ResourceManager.getString("error.operation"));
        }
        finally {
            sga.clearCache();
        }
        return Boolean.FALSE;
    }
}

