/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sga;

import com.servergeneral.sga.DAAddException;
import com.servergeneral.sga.DARevokeReassingException;
import com.servergeneral.sga.DMKRotateException;
import com.servergeneral.sga.EmptyLicenseKeyException;
import com.servergeneral.sga.EnumSGAMessages;
import com.servergeneral.sga.LicenseAddException;
import com.servergeneral.sga.LicenseCheckException;
import com.servergeneral.sga.LicenseUpgradeException;
import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.PolicyAddException;
import com.servergeneral.sga.PolicyGetException;
import com.servergeneral.sga.PolicyPutException;
import com.servergeneral.sga.PolicyRemoveException;
import com.servergeneral.sga.PolicyStartException;
import com.servergeneral.sga.PolicyStatusException;
import com.servergeneral.sga.PolicyStopException;
import com.servergeneral.sga.SGAGeneralException;
import com.servergeneral.sga.SMKRotateException;
import com.servergeneral.sga.SOAddException;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.sgkms.util.FileUtil;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import com.servergeneral.system.ProcessExecutor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SGAManager {
    private static final Logger logger = LogManager.getLogger();
    private static final int CMD_NONE = 0;
    private static final int CMD_LICENSE_ADD = 1;
    private static final int CMD_LICENSE_CHECK = 2;
    private static final int CMD_SO_ADD = 3;
    private static final int CMD_DA_ADD = 4;
    private static final int CMD_POLICY_ADD = 5;
    private static final int CMD_POLICY_EXIST = 6;
    private static final int CMD_POLICY_STATUS = 7;
    private static final int CMD_POLICY_PUT = 8;
    private static final int CMD_POLICY_GET = 9;
    private static final int CMD_DMK_ROTATE = 10;
    private static final int CMD_POLICY_START = 11;
    private static final int CMD_POLICY_REMOVE = 12;
    private static final int CMD_REVOKE_REASSING_DA = 13;
    private static final int CMD_POLICY_STOP = 14;
    private static final int CMD_PAM_CHECK = 15;
    private static final int CMD_DA_EDIT = 16;
    private static final int CMD_DA_REVOKE = 17;
    private static final int CMD_POLICY_REASSING = 18;
    private static final int CMD_POLICY_EDIT = 19;
    private static final int CMD_SO_EDIT = 20;
    private static final int CMD_LICENSE_UPGRADE = 21;
    public static final int STATUS_ERROR = 0;
    public static final int STATUS_STOPPED = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_INCONSISTENT = 3;
    private static final int LAST_STATUS = 4;
    public static final int DA_MASTER_KEY = 0;
    public static final int SO_MASTER_KEY = 1;
    private static final int LAST_MK_TYPE = 3;
    private int srvgCommand;
    private static SGAManager instance;
    private final List<ProcessExecutor.ParseOutput> requestDataCodes;
    private final List<ProcessExecutor.ParseOutput> commonCodes;

    private SGAManager() {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.init.begin"));
        this.requestDataCodes = Arrays.asList(EnumSGAMessages.SYS_ENTER_SUDO_PW, EnumSGAMessages.SG_ENTER_EXIST_SMK, EnumSGAMessages.SG_ENTER_NEW_SMK, EnumSGAMessages.SG_ENTER_NEW_SMK_AGAIN, EnumSGAMessages.SG_ENTER_EXIST_DMK, EnumSGAMessages.SG_ENTER_NEW_DMK, EnumSGAMessages.SG_ENTER_NEW_DMK_AGAIN, EnumSGAMessages.SG_ENTER_CONFIRMATION, EnumSGAMessages.SG_ENTER_DA_FIRST_NAME, EnumSGAMessages.SG_ENTER_DA_LAST_NAME, EnumSGAMessages.SG_ENTER_DA_EMAIL_ID, EnumSGAMessages.SG_ENTER_DA_PHONE_NUMBER, EnumSGAMessages.SG_ENTER_SO_FIRST_NAME, EnumSGAMessages.SG_ENTER_SO_LAST_NAME, EnumSGAMessages.SG_ENTER_SO_EMAIL_ID, EnumSGAMessages.SG_ENTER_SO_PHONE_NUMBER);
        this.commonCodes = Arrays.asList(EnumSGAMessages.SRVG_LOGIN_AS_SGADMIN, EnumSGAMessages.SRVG_ERR_RUN_AS_SUDO, EnumSGAMessages.SRVG_ERR_ROOT_USER);
        ProcessExecutor pe = ProcessExecutor.getInstance();
        pe.savePwdAs(2, 4);
        pe.savePwdAs(4, 4);
        pe.savePwdAs(5, 7);
        pe.savePwdAs(7, 7);
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.init.end"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SGAManager getInstance() {
        if (instance != null) return instance;
        Class<SGAManager> clazz = SGAManager.class;
        synchronized (SGAManager.class) {
            if (instance != null) return instance;
            instance = new SGAManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isSGAdmin() {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.sgaadmin.check.begin"));
        if (!System.getenv("USER").equals("sgadmin")) {
            logger.log(Level.FATAL, ResourceManager.getString("log.fatal.sgamanager.not_sgadmin"));
            return false;
        }
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.sgaadmin.check.end"));
        return true;
    }

    public boolean isPAMEnabled() throws NullUserInfoListenerException, MaxPwTryiesException, NoSGAdminException, OperationCancelledException, LicenseCheckException {
        ProcessExecutor.ResultInfo result = null;
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.license.check.begin"));
        try {
            List<ProcessExecutor.ParseOutput> _authCodes = Arrays.asList(EnumSGAMessages.SYS_ENTER_SUDO_PW);
            this.srvgCommand = 15;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.RESULT_LICENSED_TRUE, EnumSGAMessages.ERR_CAT_NOT_SUCH_FILE);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /bin/cat /etc/serverg/serverg.conf 2>&1"};
            result = this.beforeRunCommand(command, errCodes, null, _authCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.info.sgamanager.run.nullresult"));
            throw new LicenseCheckException(ResourceManager.getString("error.sga.license.invalid"));
        }
        if (result.resultCode != EnumSGAMessages.RESULT_LICENSED_TRUE) {
            logger.log(Level.ERROR, ResourceManager.getString("log.info.sgamanager.license.invalid"));
            throw new LicenseCheckException(ResourceManager.getString("error.sga.license.invalid"));
        }
        String license = result.lastLine.replaceFirst("license\\s*=\\s*", "").toLowerCase();
        int licSize = 0;
        int pamPos = 0;
        if (license.length() == 199) {
            logger.debug("Old License Key");
            licSize = 80;
            pamPos = 56;
        } else if (license.length() == 219) {
            logger.debug("New License Key");
            licSize = 88;
            pamPos = 64;
        } else {
            throw new LicenseCheckException(ResourceManager.getString("error.sga.license.incorrect"));
        }
        String base_16 = "0123456789abcdef";
        byte[] clicense = new byte[licSize];
        int j = 0;
        for (int i = 0; i < license.length(); ++i) {
            byte c2;
            byte c1;
            byte c = (byte)license.charAt(i);
            if (c == 45) {
                ++i;
            }
            if ((c1 = (byte)base_16.indexOf(c = (byte)license.charAt(i))) < 0) {
                throw new LicenseCheckException(ResourceManager.getString("error.sga.license.incorrect"));
            }
            if ((c = (byte)license.charAt(++i)) == 45) {
                ++i;
            }
            if ((c2 = (byte)base_16.indexOf(c = (byte)license.charAt(i))) < 0) {
                throw new LicenseCheckException(ResourceManager.getString("error.sga.license.incorrect"));
            }
            clicense[j++] = (byte)((c1 << 4) + c2);
        }
        ByteBuffer buffer = ByteBuffer.wrap(clicense);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer.getInt(pamPos) == 1;
    }

    public boolean isLicensed() throws NullUserInfoListenerException, MaxPwTryiesException, NoSGAdminException, OperationCancelledException {
        ProcessExecutor.ResultInfo result = null;
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.license.check.begin"));
        try {
            List<ProcessExecutor.ParseOutput> _authCodes = Arrays.asList(EnumSGAMessages.SYS_ENTER_SUDO_PW);
            this.srvgCommand = 2;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.RESULT_LICENSED_TRUE, EnumSGAMessages.ERR_CAT_NOT_SUCH_FILE);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /bin/cat /etc/serverg/serverg.conf 2>&1"};
            result = this.beforeRunCommand(command, errCodes, null, _authCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.info.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_LICENSED_TRUE) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.license.valid"));
            return true;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.info.sgamanager.license.invalid"));
        return false;
    }

    public boolean isSOCreated() {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.so.check.begin"));
        return FileUtil.getLineFromFileContaining("/etc/serverg/so.conf", "so_id=[^ \n]+") != null;
    }

    public boolean isMySQLDACreated(String daId) {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.da.check.begin", daId));
        return FileUtil.getLineFromFileContaining("/etc/serverg/da.conf", "da_id= *" + daId) != null;
    }

    public boolean isDACreated() {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.da.check.begin"));
        return FileUtil.getLineFromFileContaining("/etc/serverg/da.conf", "da_id= *") != null;
    }

    public boolean isSGAConfiguredForPolicy(String policy, String daId) throws NullUserInfoListenerException, MaxPwTryiesException, NoSGAdminException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.sga-configure.check.begin", daId, policy));
        return this.isLicensed() && this.isSOCreated() && this.isMySQLDACreated(daId) && this.existPolicy(policy);
    }

    public boolean addLicense(String licenseKey) throws EmptyLicenseKeyException, NoSGAdminException, NullUserInfoListenerException, LicenseAddException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.add-license.called"));
        if (licenseKey == null || licenseKey.length() == 0) {
            logger.log(Level.INFO, ResourceManager.getString("exception.emptylicensekey.msg"));
            throw new EmptyLicenseKeyException();
        }
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 1;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_LICENSE_MAC_LIMIT_REACHED, EnumSGAMessages.ERR_UPDATE_LICENSE, EnumSGAMessages.ERR_LICENSE_FILE_OPEN, EnumSGAMessages.ERR_UPDATE_CONF_LEDGER, EnumSGAMessages.ERR_REMOTE_ACCESS, EnumSGAMessages.ERR_KEYSTORE_INIT_FAIL, EnumSGAMessages.ERR_UPDATE_CONF_KEYSTORE, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_PERM_FILE, EnumSGAMessages.ERR_LICENSE_DEACTIVATE_FAIL, EnumSGAMessages.ERR_CREATE_CONFIG_FOLDER, EnumSGAMessages.ERR_LICENSE_EMPTY, EnumSGAMessages.ERR_UNABLE_PROT_ROOT, EnumSGAMessages.ERR_UPDATE_CONF_LICENSE_KEY, EnumSGAMessages.ERR_MC_ALREADY_LICENSED, EnumSGAMessages.RESULT_LICENSE_ADD_SUCCESSFUL, EnumSGAMessages.RESULT_LICENSE_ADD_FAILED, EnumSGAMessages.SRVG_ERR_LICENSED_NOT_ADDED);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S  /usr/sbin/srvg license-add -l " + licenseKey + " 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_LICENSE_ADD_FAILED && result.resultCode != EnumSGAMessages.RESULT_LICENSE_ADD_SUCCESSFUL) {
            LicenseAddException ex = new LicenseAddException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        if (this.isLicensed()) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.add-license.success"));
            return true;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.add-license.failed", licenseKey));
        return false;
    }

    public boolean upgradeLicense() throws MaxPwTryiesException, OperationCancelledException, NoSGAdminException, NullUserInfoListenerException, LicenseUpgradeException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.license-upgrade.called"));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 21;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_SO_EEXIST, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_PERM_FILE, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SO_MK, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_SO_PASS_EMPTY, EnumSGAMessages.ERR_LICENSE_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_UPDATE_CONF_LICENSE_KEY, EnumSGAMessages.ERR_UNABLE_PROT_ROOT, EnumSGAMessages.RESULT_LICENSE_UPDATE_SUCCESSFUL, EnumSGAMessages.ERR_LICENSE_NOT_UPDATED_BACKED, EnumSGAMessages.RESULT_LICENSE_UPDATE_FAILED);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S  /usr/sbin/srvg license-upgrade 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_LICENSE_UPDATE_FAILED && result.resultCode != EnumSGAMessages.RESULT_LICENSE_UPDATE_SUCCESSFUL) {
            LicenseUpgradeException ex = result.resultCode == EnumSGAMessages.ERR_LICENSE_NOT_UPDATED_BACKED ? new LicenseUpgradeException(ResourceManager.getString("error.license.noupdated.backend")) : new LicenseUpgradeException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_LICENSE_UPDATE_FAILED) {
            return false;
        }
        if (this.isLicensed()) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.license-upgrade.success"));
            return true;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.license-upgrade.failed"));
        return false;
    }

    public boolean uninstall() throws MaxPwTryiesException, OperationCancelledException, NoSGAdminException, NullUserInfoListenerException, SGAGeneralException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.uninstall.called"));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 21;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_UNINSTALL_REQ_SUDO, EnumSGAMessages.ERR_UNINSTALL_NOT_ROOT, EnumSGAMessages.ERR_UNINSTALL_REQ_SGADMIN, EnumSGAMessages.ERR_UNINSTALL_REM_POLICIES, EnumSGAMessages.ERR_UNINSTALL_SG_PACKAGE, EnumSGAMessages.ERR_UNINSTALL_UNSOPPORTED, EnumSGAMessages.RESULT_UNINSTALL_SUCCESSFULL, EnumSGAMessages.ERR_UNINSTALL_SG_FAILED, EnumSGAMessages.ERR_UNINSTALL_CANCELLED);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/sg-tde uninstall y 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_UNINSTALL_SUCCESSFULL) {
            SGAGeneralException ex = new SGAGeneralException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.info.sgamanager.uninstall.success"));
        return true;
    }

    public boolean addSO(String configFilePath) throws NoSGAdminException, NullUserInfoListenerException, SOAddException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.add-so.called"));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 3;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PERM_FILE, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_SO_ID_EMPTY, EnumSGAMessages.ERR_SO_PASS_EMPTY, EnumSGAMessages.ERR_PASSWD_EMPTY, EnumSGAMessages.ERR_PERM_GENERIC, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_REMOTE_ACCESS, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_RCOPY_FAIL, EnumSGAMessages.ERR_SO_CREDS_SAVE, EnumSGAMessages.ERR_SG_SO_FILE_OPEN, EnumSGAMessages.ERR_SO_CONFLICT, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.RESULT_SO_ADD_SUCCESSFUL, EnumSGAMessages.RESULT_SO_ADD_FAILED, EnumSGAMessages.SRVG_ERR_EMPTY_CFG_FILE);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg so-add -c \"" + configFilePath + "\" 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_SO_ADD_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.add-so.success"));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_SO_ADD_FAILED) {
            SOAddException ex = new SOAddException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.add-so.failed"));
        return false;
    }

    public boolean editSO(String fName, String lName, String email, String phone) throws MaxPwTryiesException, OperationCancelledException, NoSGAdminException, NullUserInfoListenerException, SGAGeneralException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.so-edit.called"));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 20;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_SO_EEXIST, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_PERM_FILE, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SO_MK, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_SO_PASS_EMPTY, EnumSGAMessages.ERR_SO_EDIT_EMPTY, EnumSGAMessages.ERR_SG_SO_FILE_OPEN, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.RESULT_SO_EDIT_SUCCESSFUL, EnumSGAMessages.RESULT_SO_EDIT_FAILED);
            StringBuilder srvgCmd = new StringBuilder("/usr/bin/sudo -S /usr/sbin/srvg so-edit");
            srvgCmd.append(" 2>&1");
            String[] command = new String[]{"/bin/bash", "-c", srvgCmd.toString()};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_SO_EDIT_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.so-edit.success"));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_SO_EDIT_FAILED) {
            SGAGeneralException ex = new SGAGeneralException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.so-edit.failed"));
        return false;
    }

    public boolean addDA(String configFilePath) throws NoSGAdminException, NullUserInfoListenerException, DAAddException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.add-da.called"));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 4;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_SO_EEXIST, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_PERM_FILE, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SO_MK, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_SO_PASS_EMPTY, EnumSGAMessages.ERR_MAX_DA_REACHED, EnumSGAMessages.ERR_DA_ID_EMPTY, EnumSGAMessages.ERR_DANAME_EMPTY, EnumSGAMessages.ERR_DANAME_CONFLICT, EnumSGAMessages.ERR_DANAME_REVOKED_CONFLICT, EnumSGAMessages.ERR_DA_PASS_EMPTY, EnumSGAMessages.ERR_PERM_GENERIC, EnumSGAMessages.ERR_REMOTE_ACCESS, EnumSGAMessages.ERR_RCOPY_FAIL, EnumSGAMessages.ERR_DA_CREDS_SAVE, EnumSGAMessages.ERR_SG_DA_FILE_OPEN, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.RESULT_DA_ADD_SUCCESSFUL, EnumSGAMessages.RESULT_DA_ADD_FAILED, EnumSGAMessages.SRVG_ERR_EMPTY_CFG_FILE);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg da-add -c \"" + configFilePath + "\" 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_DA_ADD_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.add-da.success"));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_DA_ADD_FAILED) {
            DAAddException ex = new DAAddException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.add-da.failed"));
        return false;
    }

    public boolean revokeReassingDA(String revokedDA, String reassingDA) throws NoSGAdminException, NullUserInfoListenerException, DARevokeReassingException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.rev-rea-da.called", revokedDA, reassingDA));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 13;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_SO_EEXIST, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_PERM_FILE, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SO_MK, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_SO_PASS_EMPTY, EnumSGAMessages.ERR_PERM_GENERIC, EnumSGAMessages.ERR_REMOTE_ACCESS, EnumSGAMessages.ERR_RCOPY_FAIL, EnumSGAMessages.ERR_ENC_PASS_DEL2, EnumSGAMessages.ERR_REQ_DEL, EnumSGAMessages.ERR_ENC_PASS_DEL1, EnumSGAMessages.ERR_SG_DA_FILE_OPEN, EnumSGAMessages.ERR_SG_DA_REVOKE_FILE_OPEN, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.ERR_REVOKE_REASSIGN, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.RESULT_DA_REVOKE_REASSING_SUCCESSFUL, EnumSGAMessages.RESULT_DA_REVOKE_REASSING_FAILED, EnumSGAMessages.ERR_FREE_VERSION);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg da-revoke-reassign -r " + revokedDA + " -a " + reassingDA + " 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (EnumSGAMessages.RESULT_DA_REVOKE_REASSING_SUCCESSFUL == result.resultCode) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.rev-rea-da.success", revokedDA, reassingDA));
            return true;
        }
        if (EnumSGAMessages.RESULT_DA_REVOKE_REASSING_FAILED != result.resultCode) {
            DARevokeReassingException ex = new DARevokeReassingException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.rev-rea-da.failed", revokedDA, reassingDA));
        return false;
    }

    public boolean dmkRotate(String daId) throws NoSGAdminException, NullUserInfoListenerException, DMKRotateException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.da-mk-rotate.called", daId));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 10;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_DA_PASS_EMPTY, EnumSGAMessages.ERR_PERM_GENERIC, EnumSGAMessages.ERR_REMOTE_ACCESS, EnumSGAMessages.ERR_RCOPY_FAIL, EnumSGAMessages.ERR_DMK_SAME, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.ERR_FREE_VERSION, EnumSGAMessages.RESULT_DMK_ROTATE_SUCCESSFUL, EnumSGAMessages.RESULT_DMK_ROTATE_FAILED);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg da-mk-rotate -d " + daId + " 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_DMK_ROTATE_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.da-mk.rotate.success", daId));
            SGKms.saveProperty("dmk.rd_" + daId, String.valueOf(System.currentTimeMillis()));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_DMK_ROTATE_FAILED) {
            DMKRotateException ex = new DMKRotateException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.da-mk-rotate.failed", daId));
        return false;
    }

    public boolean revokeDA(String daId) throws MaxPwTryiesException, OperationCancelledException, NoSGAdminException, NullUserInfoListenerException, SGAGeneralException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.da-revoke.called", daId));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 17;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_SO_EEXIST, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_PERM_FILE, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SO_MK, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_SO_PASS_EMPTY, EnumSGAMessages.ERR_REMOTE_ACCESS, EnumSGAMessages.ERR_ENC_PASS_DEL2, EnumSGAMessages.ERR_REQ_DEL, EnumSGAMessages.ERR_ENC_PASS_DEL1, EnumSGAMessages.ERR_SG_DA_FILE_OPEN, EnumSGAMessages.ERR_SG_DA_REVOKE_FILE_OPEN, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.ERR_SG_DA_ACTIVE, EnumSGAMessages.ERR_SG_DA_REVOKE_ONLY_FAIL, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.RESULT_DA_REVOKE_SUCCESSFUL, EnumSGAMessages.RESULT_DA_REVOKE_FAILED);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg da-revoke -r " + daId + " 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_DA_REVOKE_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.da-revoke.success", daId));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_DA_REVOKE_FAILED) {
            SGAGeneralException ex = new SGAGeneralException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.da-revoke.failed", daId));
        return false;
    }

    public boolean editDA(String daId, String fName, String lName, String email, String phone) throws MaxPwTryiesException, OperationCancelledException, NullUserInfoListenerException, NoSGAdminException, SGAGeneralException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.da-edit.called", daId));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 16;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_DA_PASS_EMPTY, EnumSGAMessages.ERR_DA_EDIT_EMPTY, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.RESULT_DA_EDIT_SUCCESSFUL, EnumSGAMessages.RESULT_DA_EDIT_SUCCESSFUL);
            StringBuilder srvgCmd = new StringBuilder("/usr/bin/sudo -S /usr/sbin/srvg da-edit");
            srvgCmd.append(" -d ").append(daId);
            srvgCmd.append(" 2>&1");
            String[] command = new String[]{"/bin/bash", "-c", srvgCmd.toString()};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_DA_EDIT_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.da-edit.success", daId));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_DA_EDIT_FAILED) {
            SGAGeneralException ex = new SGAGeneralException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.da-edit.failed", daId));
        return false;
    }

    public boolean smkRotate() throws NoSGAdminException, NullUserInfoListenerException, SMKRotateException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.smk-rotate.called"));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 10;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_SO_EEXIST, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_PERM_FILE, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SO_MK, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_SO_PASS_EMPTY, EnumSGAMessages.ERR_PERM_GENERIC, EnumSGAMessages.ERR_REMOTE_ACCESS, EnumSGAMessages.ERR_RCOPY_FAIL, EnumSGAMessages.ERR_SO_CREDS_SAVE, EnumSGAMessages.ERR_SMK_SAME, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.RESULT_SMK_ROTATE_SUCCESSFUL, EnumSGAMessages.RESULT_SMK_ROTATE_FAILED, EnumSGAMessages.ERR_FREE_VERSION);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg smk-rotate 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_SMK_ROTATE_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.smk-rotate.success"));
            SGKms.saveProperty("smk.rd", String.valueOf(System.currentTimeMillis()));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_SMK_ROTATE_FAILED) {
            SMKRotateException ex = new SMKRotateException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.smk-rotate.failed"));
        return false;
    }

    public boolean addPolicy(String configFilePath, String da) throws NoSGAdminException, NoSGAdminException, NullUserInfoListenerException, PolicyAddException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.add-pol.called"));
        ProcessExecutor.ResultInfo res = null;
        try {
            this.srvgCommand = 5;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_MAX_APPS_REACHED, EnumSGAMessages.ERR_MAX_REPOS_REACHED, EnumSGAMessages.ERR_MAX_PAM_USERS_REACHED, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_DA_PASS_EMPTY, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_SG_NOT_SGADMIN, EnumSGAMessages.ERR_ILLEGAL_USER, EnumSGAMessages.ERR_EXCEED_VAULTS, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_STOP_SRVC, EnumSGAMessages.ERR_APP_CONFLICT, EnumSGAMessages.ERR_REPO_CONFLICT, EnumSGAMessages.ERR_PAM_NOT_SUPPORTED, EnumSGAMessages.ERR_PAM_USER_EEXIST, EnumSGAMessages.ERR_PROFILE_CONFLICT, EnumSGAMessages.ERR_INCORRECT_CIPHER, EnumSGAMessages.ERR_INCORRECT_REPOS, EnumSGAMessages.ERR_LOCAL_RELATIVE_PATH, EnumSGAMessages.ERR_PERM2, EnumSGAMessages.ERR_PATH_INUSE, EnumSGAMessages.ERR_CREATE_ACCESS_DIR, EnumSGAMessages.ERR_SG_PW_FILE, EnumSGAMessages.ERR_UMOUNT2, EnumSGAMessages.ERR_PERM_PROP_FAIL, EnumSGAMessages.ERR_COPY, EnumSGAMessages.ERR_MOUNT3, EnumSGAMessages.ERR_RESTORE_FAIL, EnumSGAMessages.ERR_RESTORE_FAIL1, EnumSGAMessages.ERR_ENC_FILE_DEL, EnumSGAMessages.ERR_RCOPY_FAIL, EnumSGAMessages.ERR_REPO_ACCESS, EnumSGAMessages.ERR_SRVC_UNKNOWN, EnumSGAMessages.ERR_ENC_KEY_GEN, EnumSGAMessages.RESULT_POL_ADD_SUCCESSFUL, EnumSGAMessages.RESULT_POL_ADD_FAILED, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.ERR_POL_FILE_EMPTY, EnumSGAMessages.ERR_PERM_GENERIC);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg policy-add -c \"" + configFilePath + "\" 2>&1"};
            res = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (res == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (res.resultCode == EnumSGAMessages.RESULT_POL_ADD_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.add-pol.success"));
            return true;
        }
        if (res.resultCode != EnumSGAMessages.RESULT_POL_ADD_FAILED) {
            PolicyAddException ex = new PolicyAddException(res.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.add-pol.failed"));
        return false;
    }

    public boolean isPolicyMounted(String policy) throws NullUserInfoListenerException, MaxPwTryiesException, NoSGAdminException, OperationCancelledException {
        return this.isPolicyMounted(policy, false);
    }

    public boolean isPolicyMounted(String data, boolean fullPath) throws NullUserInfoListenerException, MaxPwTryiesException, NoSGAdminException, OperationCancelledException {
        ProcessExecutor.ResultInfo result = null;
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.policy.mounted.begin", data));
        try {
            this.srvgCommand = 6;
            String path = fullPath ? data : "/vault/serverg/" + data;
            List<ProcessExecutor.ParseOutput> _authCodes = Arrays.asList(EnumSGAMessages.SYS_ENTER_SUDO_PW);
            List<String> _customRegexes = Arrays.asList("^" + path + ".*type ecryptfs.*$");
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.CUSTOM_REGEX_0, EnumSGAMessages.ERR_CAT_NOT_SUCH_FILE);
            String[] command = new String[]{"/bin/bash", "-c", "/bin/mount 2>&1"};
            result = this.beforeRunCommand(command, errCodes, null, _authCodes, _customRegexes);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.CUSTOM_REGEX_0) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.policy.mounted.success", data));
            return true;
        }
        logger.log(Level.WARN, ResourceManager.getString("log.error.sgamanager.policy.mounted.failed", data));
        return false;
    }

    public boolean startPolicy(String policy, String daId) throws NoSGAdminException, NullUserInfoListenerException, PolicyStartException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol-start.called", policy));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 11;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PROFILE_EEXIST, EnumSGAMessages.ERR_INCORRECT_DA_ID, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_DA_PASS_EMPTY, EnumSGAMessages.ERR_SG_NOT_SGADMIN, EnumSGAMessages.ERR_ILLEGAL_USER, EnumSGAMessages.ERR_PATH_INUSE, EnumSGAMessages.ERR_ENC_DATA_PATH, EnumSGAMessages.ERR_MOUNT_FAILED, EnumSGAMessages.ERR_SG_PW_FILE, EnumSGAMessages.ERR_MOUNT3, EnumSGAMessages.ERR_APP_START, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.ERR_SG_RUNNING_MSG, EnumSGAMessages.ERR_SG_INCONSISTENT, EnumSGAMessages.RESULT_POL_START_SUCCESSFUL, EnumSGAMessages.RESULT_POL_START_FAILED);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg policy-start -p " + policy + " -d " + daId + " 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_POL_START_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol-start.success", policy));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_POL_START_FAILED) {
            PolicyStartException ex = new PolicyStartException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.pol-start.failed", policy));
        return false;
    }

    public boolean stopPolicy(String policy, String daId) throws NoSGAdminException, NullUserInfoListenerException, PolicyStopException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol-stop.called", policy));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 14;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PROFILE_EEXIST, EnumSGAMessages.ERR_INCORRECT_DA_ID, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_DA_PASS_EMPTY, EnumSGAMessages.ERR_SG_NOT_SGADMIN, EnumSGAMessages.ERR_ILLEGAL_USER, EnumSGAMessages.ERR_STOP_SRVC, EnumSGAMessages.ERR_PATH_INUSE, EnumSGAMessages.ERR_UMOUNT2, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.SG_STOP1, EnumSGAMessages.ERR_SG_INCONSISTENT, EnumSGAMessages.RESULT_POL_STOP_SUCCESSFUL, EnumSGAMessages.RESULT_POL_STOP_FAILED);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg policy-stop -p " + policy + " -d " + daId + " 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_POL_STOP_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol-stop.success", policy));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_POL_STOP_FAILED) {
            PolicyStopException ex = new PolicyStopException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.pol-stop.failed", policy));
        return false;
    }

    public boolean removePolicy(String policy, String daId) throws NoSGAdminException, NullUserInfoListenerException, PolicyRemoveException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.rem-pol.called", policy));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 12;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PROFILE_EEXIST, EnumSGAMessages.ERR_INCORRECT_DA_ID, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_DA_PASS_EMPTY, EnumSGAMessages.ERR_SG_NOT_SGADMIN, EnumSGAMessages.ERR_ILLEGAL_USER, EnumSGAMessages.ERR_STOP_SRVC, EnumSGAMessages.ERR_ENC_DATA_PATH, EnumSGAMessages.ERR_MOUNT_FAILED, EnumSGAMessages.ERR_SG_PW_FILE, EnumSGAMessages.ERR_MOUNT3, EnumSGAMessages.ERR_PATH_INUSE, EnumSGAMessages.ERR_COPY, EnumSGAMessages.ERR_UMOUNT2, EnumSGAMessages.ERR_RESTORE_FAIL, EnumSGAMessages.ERR_RESTORE_FAIL1, EnumSGAMessages.ERR_REMOTE_ACCESS, EnumSGAMessages.ERR_ENC_PASS_DEL2, EnumSGAMessages.ERR_REQ_DEL, EnumSGAMessages.ERR_ENC_PASS_DEL1, EnumSGAMessages.ERR_REPO_ACCESS, EnumSGAMessages.ERR_SG_DA_FILE_OPEN, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.ERR_SG_INCONSISTENT, EnumSGAMessages.RESULT_POL_REMOVE_SUCCESSFUL, EnumSGAMessages.RESULT_POL_REMOVE_FAILED);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg policy-remove -p " + policy + " -d " + daId + " 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_POL_REMOVE_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.rem-pol.success", policy));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_POL_REMOVE_FAILED) {
            PolicyRemoveException ex = new PolicyRemoveException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.rem-pol.failed", policy));
        return false;
    }

    public int policyStatus(String policy, String daId, int mkType) throws NoSGAdminException, NullUserInfoListenerException, PolicyStatusException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol-status.called", policy));
        ProcessExecutor.ResultInfo res = null;
        try {
            this.srvgCommand = 7;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_SO_EEXIST, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_PERM_FILE, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SO_MK, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_SO_PASS_EMPTY, EnumSGAMessages.ERR_DA_PASS_EMPTY, EnumSGAMessages.ERR_PROFILE_EEXIST, EnumSGAMessages.ERR_INCORRECT_DA_ID, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.RESULT_POL_RUNNING, EnumSGAMessages.RESULT_POL_STOPPED, EnumSGAMessages.RESULT_POL_INCONSISTENT, EnumSGAMessages.RESULT_POL_STATUS_FAILED);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg policy-status -d " + daId + " -p " + policy + " -t " + (mkType == 0 ? "DMK" : "SMK") + " 2>&1"};
            res = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (res == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return 0;
        }
        if (res.resultCode == EnumSGAMessages.RESULT_POL_RUNNING) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol-status.running", policy));
            return 2;
        }
        if (res.resultCode == EnumSGAMessages.RESULT_POL_STOPPED) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol-status.stopped", policy));
            return 1;
        }
        if (res.resultCode == EnumSGAMessages.RESULT_POL_INCONSISTENT) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.pol-status.inconsistent", policy));
            return 3;
        }
        PolicyStatusException ex = new PolicyStatusException(res.lastLine);
        logger.log(Level.ERROR, "", (Throwable)ex);
        throw ex;
    }

    public boolean existPolicy(String policy) throws NullUserInfoListenerException, MaxPwTryiesException, NoSGAdminException, OperationCancelledException {
        ProcessExecutor.ResultInfo result = null;
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol.exists.begin", policy));
        try {
            this.srvgCommand = 6;
            List<ProcessExecutor.ParseOutput> _authCodes = Arrays.asList(EnumSGAMessages.SYS_ENTER_SUDO_PW);
            List<String> _customRegexes = Arrays.asList("^\\[" + policy + "\\]$");
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.CUSTOM_REGEX_0, EnumSGAMessages.ERR_CAT_NOT_SUCH_FILE);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /bin/cat /etc/serverg/serverg.conf 2>&1"};
            result = this.beforeRunCommand(command, errCodes, null, _authCodes, _customRegexes);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.CUSTOM_REGEX_0) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol.exists.sucess", policy));
            return true;
        }
        logger.log(Level.WARN, ResourceManager.getString("log.error.sgamanager.pol.exists.failed", policy));
        return false;
    }

    public boolean putPolicy(String policy, String daId) throws NoSGAdminException, NullUserInfoListenerException, PolicyPutException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.put-pol.called", policy));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 8;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PROFILE_EEXIST, EnumSGAMessages.ERR_INCORRECT_DA_ID, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_DA_PASS_EMPTY, EnumSGAMessages.ERR_SG_NOT_SGADMIN, EnumSGAMessages.ERR_ILLEGAL_USER, EnumSGAMessages.ERR_STOP_SRVC, EnumSGAMessages.ERR_PATH_INUSE, EnumSGAMessages.ERR_UMOUNT2, EnumSGAMessages.ERR_SG_DA_FILE_OPEN, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.ERR_SG_INCONSISTENT, EnumSGAMessages.ERR_CHECKING_SIGNATURE, EnumSGAMessages.ERR_PACKING_PROFILE, EnumSGAMessages.ERR_POL_BACKUP_FAIL, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.RESULT_POL_PUT_SUCCESSFUL, EnumSGAMessages.RESULT_POL_PUT_FAILED);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg put -p " + policy + " -d " + daId + " 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_POL_PUT_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.put-pol.success", policy));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_POL_PUT_FAILED) {
            PolicyPutException ex = new PolicyPutException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.put-pol.failed", policy));
        return false;
    }

    public boolean getPolicy(String policy, String daId) throws NoSGAdminException, NullUserInfoListenerException, PolicyGetException, MaxPwTryiesException, OperationCancelledException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.get-pol.called", policy));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 9;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PROFILE_EEXIST, EnumSGAMessages.ERR_INCORRECT_DA_ID, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_DA_PASS_EMPTY, EnumSGAMessages.ERR_SG_NOT_SGADMIN, EnumSGAMessages.ERR_ILLEGAL_USER, EnumSGAMessages.ERR_STOP_SRVC, EnumSGAMessages.ERR_PATH_INUSE, EnumSGAMessages.ERR_UMOUNT2, EnumSGAMessages.ERR_ENC_DATA_PATH, EnumSGAMessages.ERR_MOUNT_FAILED, EnumSGAMessages.ERR_SG_PW_FILE, EnumSGAMessages.ERR_MOUNT3, EnumSGAMessages.ERR_APP_START, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.ERR_NOT_EXIST_REMOTE_BACKUP, EnumSGAMessages.ERR_CHECKING_SIGNATURE, EnumSGAMessages.ERR_SG_INCONSISTENT, EnumSGAMessages.ERR_POL_RESTORE_ALL_SGL, EnumSGAMessages.RESULT_POL_GET_SUCCESSFUL, EnumSGAMessages.RESULT_POL_GET_FAILED, EnumSGAMessages.ERR_INVALID_ANSWER);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg get -p " + policy + " -d " + daId + " 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_POL_GET_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.get-pol.success", policy));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_POL_GET_FAILED) {
            PolicyGetException ex = new PolicyGetException(result.lastLine);
            logger.log(Level.INFO, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.get-pol.failed", policy));
        return false;
    }

    public boolean reassignPolicy(String policy, String revokeDAId, String assingDAId) throws MaxPwTryiesException, OperationCancelledException, NoSGAdminException, NullUserInfoListenerException, SGAGeneralException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol-reassign.called", policy));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 18;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_SO_EEXIST, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_PERM_FILE, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SO_MK, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_SO_PASS_EMPTY, EnumSGAMessages.ERR_PERM_GENERIC, EnumSGAMessages.ERR_REMOTE_ACCESS, EnumSGAMessages.ERR_RCOPY_FAIL, EnumSGAMessages.ERR_ENC_PASS_DEL2, EnumSGAMessages.ERR_REQ_DEL, EnumSGAMessages.ERR_ENC_PASS_DEL1, EnumSGAMessages.ERR_POLICY_REASSIGN, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.ERR_SG_NOT_LICENSED, EnumSGAMessages.RESULT_POLICY_REASSIGN_SUCCESSFUL, EnumSGAMessages.RESULT_POLICY_REASSIGN_SUCCESSFUL);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg policy-reassign -p " + policy + " -r " + revokeDAId + " -a " + assingDAId + " 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_POLICY_REASSIGN_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol-reassign.success", policy));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_POLICY_REASSIGN_FAILED) {
            SGAGeneralException ex = new SGAGeneralException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.pol-reassign.failed", policy));
        return false;
    }

    public boolean editPolicy(String policy, String daId, String newConfigFilePath) throws MaxPwTryiesException, OperationCancelledException, NoSGAdminException, NullUserInfoListenerException, SGAGeneralException {
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol-edit.called", policy));
        ProcessExecutor.ResultInfo result = null;
        try {
            this.srvgCommand = 19;
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSGAMessages.ERR_INCORRECT_LICENSE_KEY, EnumSGAMessages.ERR_LICENSE_INCORRECT_SIZE, EnumSGAMessages.ERR_SG_CONFIG_FILE_OPEN, EnumSGAMessages.ERR_SGL_FILE_OPEN, EnumSGAMessages.ERR_DA_EEXIST, EnumSGAMessages.ERR_SG_LANG_FILE_OPEN, EnumSGAMessages.ERR_LICENSE_SERVER_UNREACHABLE, EnumSGAMessages.ERR_SG_TEMP_FILE_OPEN, EnumSGAMessages.ERR_COPY_CONF_FILE, EnumSGAMessages.ERR_LICENSE_EXPIRED, EnumSGAMessages.ERR_LICENSE_GRACE_PERIOD_EXIST, EnumSGAMessages.ERR_LICENSE_NO_GRACE_PERIOD, EnumSGAMessages.ERR_PROFILE_EEXIST, EnumSGAMessages.ERR_INCORRECT_DA_ID, EnumSGAMessages.ERR_MAX_APPS_REACHED, EnumSGAMessages.ERR_MAX_REPOS_REACHED, EnumSGAMessages.ERR_MAX_PAM_USERS_REACHED, EnumSGAMessages.ERR_PASSPHRASE1, EnumSGAMessages.ERR_PASSPHRASE2, EnumSGAMessages.ERR_DEC_PASS, EnumSGAMessages.ERR_PASS_READ, EnumSGAMessages.ERR_RESULT_FILE_OPEN, EnumSGAMessages.ERR_SGL_LICENSE_EXPIRED, EnumSGAMessages.ERR_SGL_LICENSE_GRACE, EnumSGAMessages.ERR_DA_AUTH_FAIL, EnumSGAMessages.ERR_DA_PASS_EMPTY, EnumSGAMessages.ERR_STOP_SRVC, EnumSGAMessages.ERR_SG_NOT_SGADMIN, EnumSGAMessages.ERR_ILLEGAL_USER, EnumSGAMessages.ERR_USER_DELETED, EnumSGAMessages.ERR_EXCEED_VAULTS, EnumSGAMessages.ERR_APP_CONFLICT, EnumSGAMessages.ERR_REPO_CONFLICT, EnumSGAMessages.ERR_PAM_NOT_SUPPORTED, EnumSGAMessages.ERR_PAM_USER_EEXIST, EnumSGAMessages.ERR_PROFILE_CONFLICT, EnumSGAMessages.ERR_INCORRECT_CIPHER, EnumSGAMessages.ERR_INCORRECT_REPOS, EnumSGAMessages.ERR_LOCAL_RELATIVE_PATH, EnumSGAMessages.ERR_PERM2, EnumSGAMessages.ERR_PATH_INUSE, EnumSGAMessages.ERR_CREATE_ACCESS_DIR, EnumSGAMessages.ERR_ENC_DATA_PATH, EnumSGAMessages.ERR_SG_PW_FILE, EnumSGAMessages.ERR_MOUNT3, EnumSGAMessages.ERR_COPY, EnumSGAMessages.ERR_UMOUNT2, EnumSGAMessages.ERR_RESTORE_FAIL, EnumSGAMessages.ERR_SRVC_UNKNOWN, EnumSGAMessages.ERR_DA_EDIT_NOT_ALLOWED, EnumSGAMessages.ERR_SHORTAME_CHANGE, EnumSGAMessages.RESULT_PROFILE_EDIT_SUCCESSFUL, EnumSGAMessages.RESULT_PROFILE_EDIT_FAILED);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg policy-edit -p " + policy + " -d " + daId + " -c \"" + newConfigFilePath + "\" 2>&1"};
            result = this.beforeRunCommand(command, errCodes, this.commonCodes, this.requestDataCodes, null);
        }
        catch (NoSGAdminException | NullUserInfoListenerException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        finally {
            this.srvgCommand = 0;
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode == EnumSGAMessages.RESULT_PROFILE_EDIT_SUCCESSFUL) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.pol-edit.success", policy));
            return true;
        }
        if (result.resultCode != EnumSGAMessages.RESULT_PROFILE_EDIT_FAILED) {
            SGAGeneralException ex = new SGAGeneralException(result.lastLine);
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.pol-edit.failed", policy));
        return false;
    }

    public LicenseInfo getSGAInfo() throws NullUserInfoListenerException, OperationCancelledException, IOException, SGAGeneralException {
        String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S /usr/sbin/srvg sg-status 2>&1"};
        logger.log(Level.DEBUG, "getSGAInfo command called");
        String result = ProcessExecutor.getInstance().runCommandToBuffer(command, this.requestDataCodes);
        int data = 0;
        String licenseReg = "License Key: ";
        String license = null;
        String dataVaultsReg = "Total number of Data Vaults allowed: ";
        String dataVaults = null;
        String dataAdminsReg = "Total number of Data Administrators allowed: ";
        String dataAdmins = null;
        String machinesReg = "Total number of Machines allowed: ";
        String machines = null;
        String expiryReg = "License expiry date: ";
        String expiryDate = null;
        String typeReg = "License Type: ";
        String type = null;
        String failed = "Command: SG Status Failed";
        String badSMK = "Incorrect Security Officer Master Key";
        String sgaVersion = "Version: ";
        String version = null;
        String sgaBuild = "Build: ";
        String build = null;
        ByteArrayInputStream buffer = new ByteArrayInputStream(result.getBytes());
        BufferedReader reader = new BufferedReader(new InputStreamReader(buffer));
        String line = reader.readLine();
        while (line != null && data < 8) {
            if (line.contains(licenseReg)) {
                license = line.substring(licenseReg.length());
                ++data;
            } else if (line.contains(dataVaultsReg)) {
                dataVaults = line.substring(dataVaultsReg.length());
                ++data;
            } else if (line.contains(dataAdminsReg)) {
                dataAdmins = line.substring(dataAdminsReg.length());
                ++data;
            } else if (line.contains(machinesReg)) {
                machines = line.substring(machinesReg.length());
                ++data;
            } else if (line.contains(expiryReg)) {
                expiryDate = line.substring(expiryReg.length());
                ++data;
            } else if (line.contains(typeReg)) {
                type = line.substring(typeReg.length());
                ++data;
            } else if (line.contains(sgaVersion)) {
                version = line.substring(sgaVersion.length());
                ++data;
            } else if (line.contains(sgaBuild)) {
                build = line.substring(sgaBuild.length());
                ++data;
            } else {
                if (line.contains(badSMK)) {
                    throw new SGAGeneralException(line);
                }
                if (line.contains(failed)) {
                    throw new SGAGeneralException("sg-status command failed.");
                }
            }
            line = reader.readLine();
        }
        if (license != null && dataVaults != null && dataAdmins != null && machines != null && expiryDate != null && type != null) {
            return new LicenseInfo(license, Integer.parseInt(dataVaults), Integer.parseInt(dataAdmins), Integer.parseInt(machines), expiryDate, Integer.parseInt(type), version, build);
        }
        return null;
    }

    private ProcessExecutor.ResultInfo beforeRunCommand(String[] command, List<ProcessExecutor.ParseOutput> _errCodes, List<ProcessExecutor.ParseOutput> _commonCodes, List<ProcessExecutor.ParseOutput> _requestDataCodes, List<String> _customRegexes) throws NoSGAdminException, NullUserInfoListenerException, MaxPwTryiesException, OperationCancelledException {
        ProcessExecutor.ResultInfo res = ProcessExecutor.getInstance().runCommand(command, _errCodes, _commonCodes, _requestDataCodes, _customRegexes);
        if (this.srvgCommand == 1 && res.resultCode == null) {
            res.resultCode = EnumSGAMessages.RESULT_LICENSE_ADD_SUCCESSFUL;
        }
        if (res.resultCode == EnumSGAMessages.SRVG_LOGIN_AS_SGADMIN || res.resultCode == EnumSGAMessages.ERR_SG_NOT_SGADMIN) {
            throw new NoSGAdminException();
        }
        return res;
    }

    public void setUserInfoListener(SGADataListener listener) {
        ProcessExecutor.getInstance().setUserInfoListener(listener);
    }

    public void clearCache() {
        ProcessExecutor.getInstance().clearPasswords();
    }

    public static interface SGADataListener
    extends ProcessExecutor.UserDataListener {
        public static final int SG_NEW_SMK = 2;
        public static final int SG_NEW_SMK_AGAIN = 3;
        public static final int SG_SMK = 4;
        public static final int SG_NEW_DMK = 5;
        public static final int SG_NEW_DMK_AGAIN = 6;
        public static final int SG_DMK = 7;
        public static final int SG_OVERWRITE = 8;
        public static final int SG_DA_FNAME = 9;
        public static final int SG_DA_LNAME = 10;
        public static final int SG_DA_EMAIL = 11;
        public static final int SG_DA_PHONE = 12;
        public static final int SG_SO_FNAME = 13;
        public static final int SG_SO_LNAME = 14;
        public static final int SG_SO_EMAIL = 15;
        public static final int SG_SO_PHONE = 16;
    }

    public class LicenseInfo {
        String licenseKey;
        int maxDataVaults;
        int maxDataAdmins;
        int maxMachines;
        String expiryDate;
        int licenseType;
        String version;
        String build;

        public LicenseInfo(String licenseKey, int maxDataVaults, int maxDataAdmins, int maxMachines, String expiryDate, int licenseType, String version, String build) {
            this.licenseKey = licenseKey;
            this.maxDataVaults = maxDataVaults;
            this.maxDataAdmins = maxDataAdmins;
            this.maxMachines = maxMachines;
            this.expiryDate = expiryDate;
            this.licenseType = licenseType;
            this.version = version;
            this.build = build;
        }

        public String getLicenseKey() {
            return this.licenseKey;
        }

        public int getMaxDataVaults() {
            return this.maxDataVaults;
        }

        public int getMaxDataAdmins() {
            return this.maxDataAdmins;
        }

        public int getMaxMachines() {
            return this.maxMachines;
        }

        public String getExpiryDate() {
            return this.expiryDate;
        }

        public int getLicenseType() {
            return this.licenseType;
        }

        public String getVersion() {
            return this.version;
        }

        public String getBuild() {
            return this.build;
        }
    }
}

