/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sga.DAAddException;
import com.servergeneral.sga.DARevokeReassingException;
import com.servergeneral.sga.DMKRotateException;
import com.servergeneral.sga.LicenseCheckException;
import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.PolicyAddException;
import com.servergeneral.sga.PolicyGetException;
import com.servergeneral.sga.PolicyPutException;
import com.servergeneral.sga.PolicyRemoveException;
import com.servergeneral.sga.PolicyStartException;
import com.servergeneral.sga.PolicyStatusException;
import com.servergeneral.sga.PolicyStopException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sga.SMKRotateException;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.sgkms.gui.ChangeMKDialog;
import com.servergeneral.sgkms.gui.ComplianceReportDialog;
import com.servergeneral.sgkms.gui.CustomAlert;
import com.servergeneral.sgkms.gui.LogViewerDialog;
import com.servergeneral.sgkms.gui.MySQLConnectionDialog;
import com.servergeneral.sgkms.gui.RevokeDADialog;
import com.servergeneral.sgkms.gui.SgKmsGui;
import com.servergeneral.sgkms.util.DBUtil;
import com.servergeneral.sgkms.util.FileUtil;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import com.servergeneral.system.ServiceNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SGKmsOPController
implements Initializable {
    @FXML
    private Button btnOpenLocker;
    @FXML
    private Button btnCloseLocker;
    @FXML
    private Button btnRotateDBKey;
    @FXML
    private Label lblStatusMsg;
    @FXML
    private ProgressBar pbProccess;
    @FXML
    private Label lbError;
    @FXML
    private Label lbStatus;
    @FXML
    private MenuBar menuBar;
    @FXML
    private MenuItem miStoreKey;
    @FXML
    private MenuItem miProtectLog;
    @FXML
    private MenuItem miUnprotectLog;
    @FXML
    private TabPane tabPaneButtons;
    @FXML
    private Pane pnlSGKms;
    @FXML
    private Button btnRotateDMK;
    @FXML
    private Button btnRotateSMK;
    @FXML
    private Button btnRevokeDA;
    @FXML
    private Button btnViewLog;
    @FXML
    private Pane pnlMySQL;
    @FXML
    private Button btnProtectLogs;
    @FXML
    private MenuItem miGetKey;
    @FXML
    private Button btnCompliance;
    @FXML
    private Button btnRestartTDE;
    @FXML
    private MenuItem miStartSgKmsProt;
    @FXML
    private MenuItem miStartLogProt;
    @FXML
    private Hyperlink btnExit;
    @FXML
    private Button btnStartMMKProtection;
    @FXML
    private Button btnStartLogsProtection;
    private Task updateProgressTask;
    private static final Logger logger = LogManager.getLogger();
    private char[] pwd;
    private boolean finished;
    private Map<String, String> userData;
    final ImageView stopLogProtImg = new ImageView(new Image(this.getClass().getResourceAsStream("/images/stop-protection-logs-menu.png")));
    final ImageView startLogProtImg = new ImageView(new Image(this.getClass().getResourceAsStream("/images/start-protection-logs-menu.png")));
    final ImageView stopMMKProtImg = new ImageView(new Image(this.getClass().getResourceAsStream("/images/stop-protection-mmk-menu.png")));
    final ImageView startMMKProtImg = new ImageView(new Image(this.getClass().getResourceAsStream("/images/start-protection-mmk-menu.png")));
    private final EventHandler onSucceeded = event -> {
        this.pnlMySQL.setDisable(false);
        this.pbProccess.setVisible(false);
        this.menuBar.setDisable(false);
        this.updateProgressTask.cancel();
        this.updateLockerStatus();
    };
    private final EventHandler onScheduled = event -> {
        this.pnlMySQL.setDisable(true);
        this.pbProccess.setVisible(true);
        this.menuBar.setDisable(true);
    };

    public void initialize(URL url, ResourceBundle rb) {
        SGAManager.getInstance().setUserInfoListener(new OPUserData());
        this.updateLockerStatus();
        this.userData = new HashMap<String, String>();
        this.miStoreKey.disableProperty().bind((ObservableValue)this.btnCloseLocker.disableProperty());
        this.pnlSGKms.disableProperty().bind((ObservableValue)this.pnlMySQL.disableProperty());
        this.tabPaneButtons.getSelectionModel().select(1);
        this.btnOpenLocker.disableProperty().bind((ObservableValue)this.btnCloseLocker.disableProperty().not());
        this.miGetKey.disableProperty().bind((ObservableValue)this.btnOpenLocker.disableProperty());
        this.btnExit.disableProperty().bind((ObservableValue)this.pnlMySQL.disableProperty());
        this.btnStartLogsProtection.disableProperty().bind((ObservableValue)this.miStartLogProt.disableProperty());
        this.btnStartMMKProtection.disableProperty().bind((ObservableValue)this.miStartSgKmsProt.disableProperty());
    }

    private void updateLockerStatus() {
        logger.log(Level.DEBUG, "updating the messages");
        try {
            int status = SGKms.lockerStatus();
            this.updateProtectLogControls(SGAManager.getInstance().existPolicy("spolicy_mysql_log"));
            this.updateControls(status);
        }
        catch (NoSGAdminException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.lbStatus.setText("");
        }
    }

    private void changeControlStyle(Control control, String oldStyle, String newStyle) {
        if (control.getStyleClass().contains((Object)oldStyle)) {
            control.getStyleClass().remove((Object)oldStyle);
        }
        if (!control.getStyleClass().contains((Object)newStyle)) {
            control.getStyleClass().add((Object)newStyle);
        }
    }

    private void updateProtectLogControls(boolean logProtected) {
        this.miProtectLog.setDisable(logProtected);
        this.miUnprotectLog.setDisable(!logProtected);
        this.btnProtectLogs.setDisable(false);
        if (logProtected) {
            this.changeControlStyle((Control)this.btnProtectLogs, "protect-log-icon", "unprotect-log-icon");
            this.btnProtectLogs.setText(ResourceManager.getString("button.mysql-log.unprotect.caption"));
            this.btnProtectLogs.getTooltip().setText(ResourceManager.getString("button.mysql-log.unprotect.tooltip"));
            boolean isMounted = false;
            try {
                isMounted = SGAManager.getInstance().isPolicyMounted("spolicy_mysql_log");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!isMounted) {
                this.changeControlStyle((Control)this.btnStartLogsProtection, "stop-protection-logs-icon", "start-protection-logs-icon");
                this.btnStartLogsProtection.setText(ResourceManager.getString("button.start-protection-logs.label"));
                this.miStartLogProt.setGraphic((Node)this.startLogProtImg);
                this.miStartLogProt.setText(ResourceManager.getString("menu.mysql.log.protection.start.caption"));
            } else {
                this.changeControlStyle((Control)this.btnStartLogsProtection, "start-protection-logs-icon", "stop-protection-logs-icon");
                this.btnStartLogsProtection.setText(ResourceManager.getString("button.stop-protection-logs.label"));
                this.miStartLogProt.setGraphic((Node)this.stopLogProtImg);
                this.miStartLogProt.setText(ResourceManager.getString("menu.mysql.log.protection.stop.caption"));
            }
            this.miStartLogProt.setDisable(false);
        } else {
            this.changeControlStyle((Control)this.btnProtectLogs, "unprotect-log-icon", "protect-log-icon");
            this.btnProtectLogs.setText(ResourceManager.getString("button.mysql-log.protect.caption"));
            this.btnProtectLogs.getTooltip().setText(ResourceManager.getString("button.mysql-log.protect.tooltip"));
            this.miStartLogProt.setGraphic((Node)this.startLogProtImg);
            this.miStartLogProt.setText(ResourceManager.getString("menu.mysql.log.protection.start.caption"));
            this.miStartLogProt.setDisable(true);
            this.changeControlStyle((Control)this.btnStartLogsProtection, "stop-protection-logs-icon", "start-protection-logs-icon");
            this.btnStartLogsProtection.setText(ResourceManager.getString("button.start-protection-logs.label"));
        }
    }

    private void updateControls(int status) {
        switch (status) {
            case 0: {
                this.btnCloseLocker.setDisable(true);
                this.lbStatus.setText(ResourceManager.getString("info.vault.status.closed"));
                this.miStartSgKmsProt.setGraphic((Node)this.stopMMKProtImg);
                this.miStartSgKmsProt.setDisable(true);
                this.miStartSgKmsProt.setText(ResourceManager.getString("menu.sg-kms.stop.caption"));
                logger.debug("Setting stop mmk button");
                this.changeControlStyle((Control)this.btnStartMMKProtection, "start-protection-mmk-icon", "stop-protection-mmk-icon");
                this.btnStartMMKProtection.setText(ResourceManager.getString("button.stop-protection-mmk.label"));
                break;
            }
            case 1: {
                this.btnCloseLocker.setDisable(false);
                this.lbStatus.setText(ResourceManager.getString("info.vault.status.opened"));
                this.miStartSgKmsProt.setGraphic((Node)this.stopMMKProtImg);
                this.miStartSgKmsProt.setDisable(false);
                this.miStartSgKmsProt.setText(ResourceManager.getString("menu.sg-kms.stop.caption"));
                logger.debug("Setting stop mmk button");
                this.changeControlStyle((Control)this.btnStartMMKProtection, "start-protection-mmk-icon", "stop-protection-mmk-icon");
                this.btnStartMMKProtection.setText(ResourceManager.getString("button.stop-protection-mmk.label"));
                break;
            }
            case 2: {
                this.btnCloseLocker.setDisable(false);
                this.lbStatus.setText(ResourceManager.getString("info.vault.status.stopped"));
                this.miStartSgKmsProt.setGraphic((Node)this.startMMKProtImg);
                this.miStartSgKmsProt.setDisable(false);
                this.miStartSgKmsProt.setText(ResourceManager.getString("menu.sg-kms.start.caption"));
                logger.debug("Setting start mmk button");
                this.changeControlStyle((Control)this.btnStartMMKProtection, "stop-protection-mmk-icon", "start-protection-mmk-icon");
                this.btnStartMMKProtection.setText(ResourceManager.getString("button.start-protection-mmk.label"));
            }
        }
    }

    @FXML
    private void openLocker(ActionEvent event) {
        TaskOpenLocker openLockerTask = new TaskOpenLocker();
        openLockerTask.setOnScheduled(this.onScheduled);
        openLockerTask.setOnSucceeded(this.onSucceeded);
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbError.textProperty().bind((ObservableValue)openLockerTask.messageProperty());
        this.lblStatusMsg.textProperty().bind((ObservableValue)openLockerTask.titleProperty());
        this.startTasks(openLockerTask, this.updateProgressTask);
    }

    @FXML
    private void closeLocker(ActionEvent event) {
        TaskCloseLocker closeLockerTask = new TaskCloseLocker();
        closeLockerTask.setOnScheduled(this.onScheduled);
        closeLockerTask.setOnSucceeded(this.onSucceeded);
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbError.textProperty().bind((ObservableValue)closeLockerTask.messageProperty());
        this.lblStatusMsg.textProperty().bind((ObservableValue)closeLockerTask.titleProperty());
        this.startTasks(closeLockerTask, this.updateProgressTask);
    }

    @FXML
    private void rotateDbKey(ActionEvent event) {
        CustomAlert alert = new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, ResourceManager.getString("info.alert.mysql.restart.confirm.title"), ResourceManager.getString("info.alert.mysql.restart.confirm.header"), ResourceManager.getString("info.alert.mysql.restart.confirm.message"));
        Optional confirmation = alert.showAndWait();
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        if (confirmation.get() != CustomAlert.YES) {
            this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
            this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            return;
        }
        this.lblStatusMsg.setText(ResourceManager.getString("info.mysql.rotating"));
        this.lbError.setText("");
        MySQLConnectionDialog dialog = new MySQLConnectionDialog(ResourceManager.getString("info.dialog.mysql.title"), ResourceManager.getString("info.dialog.mysql.header"));
        Optional result = dialog.showAndWait();
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        if (!result.isPresent()) {
            this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
            this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            return;
        }
        Map m = (Map)result.get();
        if (DBUtil.dbConfig == null) {
            DBUtil.dbConfig = new DBUtil.DBConfig();
        }
        DBUtil.dbConfig.setPort((String)m.get("port"));
        DBUtil.dbConfig.setUser((String)m.get("username"));
        DBUtil.dbConfig.setPassword(((String)m.get("password")).toCharArray());
        TaskRotateDBKey rotateDBKey = new TaskRotateDBKey();
        rotateDBKey.setOnScheduled(this.onScheduled);
        rotateDBKey.setOnSucceeded(this.onSucceeded);
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbError.textProperty().bind((ObservableValue)rotateDBKey.messageProperty());
        this.lblStatusMsg.textProperty().bind((ObservableValue)rotateDBKey.titleProperty());
        this.startTasks(rotateDBKey, this.updateProgressTask);
    }

    private void startTasks(Task sgaTask, Task updateProgressTask) {
        Thread th = new Thread((Runnable)sgaTask);
        th.setDaemon(true);
        th.start();
        Thread th2 = new Thread((Runnable)updateProgressTask);
        th2.setDaemon(true);
        th2.start();
    }

    @FXML
    private void close(ActionEvent event) {
        Platform.exit();
    }

    @FXML
    private void rotateDMK(ActionEvent event) {
        ChangeMKDialog changeMK = new ChangeMKDialog(ResourceManager.getString("info.dialog.dmk.title"), ResourceManager.getString("info.dialog.dmk.header"), 1);
        Optional result = changeMK.showAndWait();
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        if (!result.isPresent()) {
            this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
            this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            return;
        }
        TaskRotateDMK rotateDMKTask = new TaskRotateDMK();
        this.userData = (Map)result.get();
        rotateDMKTask.setOnScheduled(this.onScheduled);
        rotateDMKTask.setOnSucceeded(this.onSucceeded);
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbError.textProperty().bind((ObservableValue)rotateDMKTask.messageProperty());
        this.lblStatusMsg.textProperty().bind((ObservableValue)rotateDMKTask.titleProperty());
        this.startTasks(rotateDMKTask, this.updateProgressTask);
    }

    @FXML
    private void rotateSMK(ActionEvent event) {
        ChangeMKDialog changeMK = new ChangeMKDialog(ResourceManager.getString("info.dialog.smk.title"), ResourceManager.getString("info.dialog.smk.header"), 0);
        Optional result = changeMK.showAndWait();
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        if (!result.isPresent()) {
            this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
            this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            return;
        }
        TaskRotateSMK rotateSMKTask = new TaskRotateSMK();
        this.userData = (Map)result.get();
        rotateSMKTask.setOnScheduled(this.onScheduled);
        rotateSMKTask.setOnSucceeded(this.onSucceeded);
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbError.textProperty().bind((ObservableValue)rotateSMKTask.messageProperty());
        this.lblStatusMsg.textProperty().bind((ObservableValue)rotateSMKTask.titleProperty());
        this.startTasks(rotateSMKTask, this.updateProgressTask);
    }

    @FXML
    private void revokeDA(ActionEvent event) {
        String revokeDA = SGKms.getCurrentDA();
        String reassingDA = SGKms.nextDAId();
        SGAManager sga = SGAManager.getInstance();
        logger.log(Level.INFO, ResourceManager.getString("log.info.da.revoking"));
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        if (!sga.isMySQLDACreated(reassingDA)) {
            RevokeDADialog dlg = new RevokeDADialog(ResourceManager.getString("info.dialog.revokeDA.title"), ResourceManager.getString("info.dialog.revokeDA.header"));
            Optional result = dlg.showAndWait();
            if (!result.isPresent()) {
                this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
                this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
                return;
            }
            this.userData = (Map)result.get();
        }
        TaskRevokeDA revokeDATask = new TaskRevokeDA(revokeDA, reassingDA);
        revokeDATask.setOnScheduled(this.onScheduled);
        revokeDATask.setOnSucceeded(this.onSucceeded);
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbError.textProperty().bind((ObservableValue)revokeDATask.messageProperty());
        this.lblStatusMsg.textProperty().bind((ObservableValue)revokeDATask.titleProperty());
        this.startTasks(revokeDATask, this.updateProgressTask);
    }

    @FXML
    private void viewLog(ActionEvent event) {
        LogViewerDialog logViewer = new LogViewerDialog();
        logViewer.showAndWait();
    }

    @FXML
    private void unprotectKey(ActionEvent event) {
        TaskUnprotectKey unprotectKeyTask = new TaskUnprotectKey();
        unprotectKeyTask.setOnScheduled(this.onScheduled);
        unprotectKeyTask.setOnSucceeded(this.onSucceeded);
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbError.textProperty().bind((ObservableValue)unprotectKeyTask.messageProperty());
        this.lblStatusMsg.textProperty().bind((ObservableValue)unprotectKeyTask.titleProperty());
        this.startTasks(unprotectKeyTask, this.updateProgressTask);
    }

    private void lockerStatus(ActionEvent event) {
        this.updateLockerStatus();
    }

    @FXML
    private void protectMySQLLog(ActionEvent event) {
        CustomAlert alert = new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, ResourceManager.getString("info.alert.mysql.restart.confirm.title"), ResourceManager.getString("info.alert.mysql.restart.confirm.header"), ResourceManager.getString("info.alert.mysql.restart.confirm.message"));
        Optional confirmation = alert.showAndWait();
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        if (confirmation.get() != CustomAlert.YES) {
            this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
            this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            return;
        }
        TaskProtectLog protectLogTask = new TaskProtectLog();
        protectLogTask.setOnScheduled(this.onScheduled);
        protectLogTask.setOnSucceeded(this.onSucceeded);
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbError.textProperty().bind((ObservableValue)protectLogTask.messageProperty());
        this.lblStatusMsg.textProperty().bind((ObservableValue)protectLogTask.titleProperty());
        this.startTasks(protectLogTask, this.updateProgressTask);
    }

    @FXML
    private void unprotectMySQLLog(ActionEvent event) {
        CustomAlert alert = new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, ResourceManager.getString("info.alert.mysql.restart.confirm.title"), ResourceManager.getString("info.alert.mysql.restart.confirm.header"), ResourceManager.getString("info.alert.mysql.restart.confirm.message"));
        Optional confirmation = alert.showAndWait();
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        if (confirmation.get() != CustomAlert.YES) {
            this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
            this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            return;
        }
        TaskUnprotectLog unprotectLogTask = new TaskUnprotectLog();
        unprotectLogTask.setOnScheduled(this.onScheduled);
        unprotectLogTask.setOnSucceeded(this.onSucceeded);
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbError.textProperty().bind((ObservableValue)unprotectLogTask.messageProperty());
        this.lblStatusMsg.textProperty().bind((ObservableValue)unprotectLogTask.titleProperty());
        this.startTasks(unprotectLogTask, this.updateProgressTask);
    }

    @FXML
    private void showCompliance(ActionEvent event) {
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        this.lbError.setText("");
        this.lblStatusMsg.setText("");
        try {
            ComplianceReportDialog report = new ComplianceReportDialog();
            report.showAndWait();
        }
        catch (IOException ex) {
            this.lbError.setText(ResourceManager.getString(ex.getMessage()));
            this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, "", (Throwable)ex);
        }
    }

    @FXML
    private void restartMySQLTDE(ActionEvent event) {
        CustomAlert alert = new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, ResourceManager.getString("info.alert.mysql.restart.confirm.title"), ResourceManager.getString("info.alert.mysql.restart.confirm.header"), ResourceManager.getString("info.alert.mysql.restart.confirm.message"));
        Optional confirmation = alert.showAndWait();
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        if (confirmation.get() != CustomAlert.YES) {
            this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
            this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            return;
        }
        TaskRestartTDE restartTDE = new TaskRestartTDE();
        restartTDE.setOnScheduled(this.onScheduled);
        restartTDE.setOnSucceeded(this.onSucceeded);
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbError.textProperty().bind((ObservableValue)restartTDE.messageProperty());
        this.lblStatusMsg.textProperty().bind((ObservableValue)restartTDE.titleProperty());
        this.startTasks(restartTDE, this.updateProgressTask);
    }

    @FXML
    private void toggleLogProtection(ActionEvent event) {
        if (this.btnProtectLogs.getText().equals(ResourceManager.getString("button.mysql-log.unprotect.caption"))) {
            this.unprotectMySQLLog(event);
        } else {
            this.protectMySQLLog(event);
        }
    }

    @FXML
    private void startSgKmsProtection(ActionEvent event) {
        boolean startProt = this.miStartSgKmsProt.getText().equals(ResourceManager.getString("menu.sg-kms.start.caption"));
        if (startProt) {
            CustomAlert alert = new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, ResourceManager.getString("info.alert.mysql.restart.confirm.title"), ResourceManager.getString("info.alert.mysql.restart.confirm.header"), ResourceManager.getString("info.alert.mysql.restart.confirm.message"));
            Optional confirmation = alert.showAndWait();
            this.lbError.textProperty().unbind();
            this.lblStatusMsg.textProperty().unbind();
            if (confirmation.get() != CustomAlert.YES) {
                this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
                this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
                return;
            }
        }
        Task sgKMSProt = startProt ? new TaskStartSgKms() : new TaskStopSgKms();
        sgKMSProt.setOnScheduled(this.onScheduled);
        sgKMSProt.setOnSucceeded(this.onSucceeded);
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbError.textProperty().bind((ObservableValue)sgKMSProt.messageProperty());
        this.lblStatusMsg.textProperty().bind((ObservableValue)sgKMSProt.titleProperty());
        this.startTasks(sgKMSProt, this.updateProgressTask);
    }

    @FXML
    private void startLogProtection(ActionEvent event) {
        boolean startProtection = this.miStartLogProt.getText().equals(ResourceManager.getString("menu.mysql.log.protection.start.caption"));
        CustomAlert alert = startProtection ? new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, ResourceManager.getString("info.alert.mysql.restart.confirm.title"), ResourceManager.getString("info.alert.mysql.restart.confirm.header"), ResourceManager.getString("info.alert.mysql.restart.confirm.message")) : new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, ResourceManager.getString("info.alert.mysql.stop.confirm.title"), ResourceManager.getString("info.alert.mysql.stop.confirm.header"), ResourceManager.getString("info.alert.mysql.stop.confirm.message"));
        Optional confirmation = alert.showAndWait();
        this.lbError.textProperty().unbind();
        this.lblStatusMsg.textProperty().unbind();
        if (confirmation.get() != CustomAlert.YES) {
            this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
            this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            return;
        }
        Task logProtection = startProtection ? new TaskStartLogProtection() : new TaskStopLogProtection();
        logProtection.setOnScheduled(this.onScheduled);
        logProtection.setOnSucceeded(this.onSucceeded);
        this.updateProgressTask = new TaskUpdateProgress();
        this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
        this.lbError.textProperty().bind((ObservableValue)logProtection.messageProperty());
        this.lblStatusMsg.textProperty().bind((ObservableValue)logProtection.titleProperty());
        this.startTasks(logProtection, this.updateProgressTask);
    }

    public void promptForPassword(int dataType, String errMsg) {
        this.pwd = null;
        this.pwd = SgKmsGui.promptForPassword(dataType, errMsg);
        this.finished = true;
    }

    static /* synthetic */ char[] access$1602(SGKmsOPController x0, char[] x1) {
        x0.pwd = x1;
        return x1;
    }

    private class OPUserData
    implements SGAManager.SGADataListener {
        private OPUserData() {
        }

        @Override
        public char[] requestUserData(int dataType, String errMsg) {
            switch (dataType) {
                case 4: 
                case 7: {
                    if (SGKmsOPController.this.userData.containsKey("mk")) {
                        SGKmsOPController.access$1602(SGKmsOPController.this, ((String)SGKmsOPController.this.userData.get("mk")).toCharArray());
                        SGKmsOPController.this.userData.remove("mk");
                        return SGKmsOPController.this.pwd;
                    }
                    if (!SGKmsOPController.this.userData.containsKey("smk")) break;
                    SGKmsOPController.access$1602(SGKmsOPController.this, ((String)SGKmsOPController.this.userData.get("smk")).toCharArray());
                    SGKmsOPController.this.userData.remove("smk");
                    return SGKmsOPController.this.pwd;
                }
                case 2: 
                case 5: {
                    if (SGKmsOPController.this.userData.containsKey("new-mk")) {
                        SGKmsOPController.access$1602(SGKmsOPController.this, ((String)SGKmsOPController.this.userData.get("new-mk")).toCharArray());
                        SGKmsOPController.this.userData.remove("new-mk");
                        return SGKmsOPController.this.pwd;
                    }
                    if (!SGKmsOPController.this.userData.containsKey("new-dmk")) break;
                    SGKmsOPController.access$1602(SGKmsOPController.this, ((String)SGKmsOPController.this.userData.get("new-dmk")).toCharArray());
                    SGKmsOPController.this.userData.remove("new-dmk");
                    return SGKmsOPController.this.pwd;
                }
                case 3: 
                case 6: {
                    if (SGKmsOPController.this.userData.containsKey("new-mk-again")) {
                        SGKmsOPController.access$1602(SGKmsOPController.this, ((String)SGKmsOPController.this.userData.get("new-mk-again")).toCharArray());
                        SGKmsOPController.this.userData.remove("new-mk-again");
                        return SGKmsOPController.this.pwd;
                    }
                    if (!SGKmsOPController.this.userData.containsKey("new-dmk-again")) break;
                    SGKmsOPController.access$1602(SGKmsOPController.this, ((String)SGKmsOPController.this.userData.get("new-dmk-again")).toCharArray());
                    SGKmsOPController.this.userData.remove("new-dmk-again");
                    return SGKmsOPController.this.pwd;
                }
            }
            SGKmsOPController.this.finished = false;
            Platform.runLater(() -> SGKmsOPController.this.promptForPassword(dataType, errMsg));
            while (!SGKmsOPController.this.finished) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    SGKmsOPController.access$1602(SGKmsOPController.this, null);
                    break;
                }
            }
            return SGKmsOPController.this.pwd;
        }
    }

    private class TaskUpdateProgress
    extends Task<Void> {
        private TaskUpdateProgress() {
        }

        protected Void call() throws Exception {
            int iterations = 0;
            while (!this.isCancelled()) {
                this.updateProgress(iterations++, 20L);
                iterations %= 21;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interrupted) {
                    if (!this.isCancelled()) continue;
                    break;
                }
            }
            return null;
        }
    }

    private class TaskStopLogProtection
    extends Task<Void> {
        private TaskStopLogProtection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void call() throws Exception {
            logger.log(Level.INFO, ResourceManager.getString("info.mysql.log.protection.stopping"));
            this.updateTitle(ResourceManager.getString("info.mysql.log.protection.stopping"));
            SGAManager sga = SGAManager.getInstance();
            try {
                boolean existPolicy = sga.existPolicy("spolicy_mysql_log");
                if (!existPolicy) {
                    this.updateMessage(ResourceManager.getString("error.mysql.log.not_protected"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.mysql.log.not_protected"));
                    Void void_ = null;
                    return void_;
                }
                if (sga.isPolicyMounted("spolicy_mysql_log")) {
                    if (!sga.stopPolicy("spolicy_mysql_log", SGKms.getCurrentDA())) {
                        this.updateMessage(ResourceManager.getString("error.mysql.log.protection.stopping"));
                        this.updateTitle(ResourceManager.getString("error.operation"));
                        logger.log(Level.ERROR, ResourceManager.getString("error.mysql.log.protection.stopping"));
                        Void void_ = null;
                        return void_;
                    }
                    this.updateTitle(ResourceManager.getString("info.mysql.log.protection.stop.success"));
                } else {
                    this.updateTitle(ResourceManager.getString("info.mysql.log.protection.already_stop"));
                }
            }
            catch (NoSGAdminException | PolicyStopException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
                logger.log(Level.ERROR, "", (Throwable)ex);
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
            }
            finally {
                sga.clearCache();
            }
            return null;
        }
    }

    private class TaskStartLogProtection
    extends Task<Void> {
        private TaskStartLogProtection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void call() throws Exception {
            this.updateTitle(ResourceManager.getString("info.mysql.log.protection.starting"));
            SGAManager sga = SGAManager.getInstance();
            try {
                boolean existPolicy = sga.existPolicy("spolicy_mysql_log");
                if (!existPolicy) {
                    this.updateMessage(ResourceManager.getString("error.mysql.log.not_protected"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.mysql.log.not_protected"));
                    Void void_ = null;
                    return void_;
                }
                if (!sga.isPolicyMounted("spolicy_mysql_log")) {
                    int status = SGKms.lockerStatus();
                    if (status == 0) {
                        if (!sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                            this.updateMessage(ResourceManager.getString("error.vault.fetching"));
                            this.updateTitle(ResourceManager.getString("error.operation"));
                            logger.log(Level.ERROR, ResourceManager.getString("error.vault.fetching"));
                            Void void_ = null;
                            return void_;
                        }
                    } else if (status == 2 && !sga.startPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                        this.updateMessage(ResourceManager.getString("error.vault.starting"));
                        this.updateTitle(ResourceManager.getString("error.operation"));
                        logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                        Void void_ = null;
                        return void_;
                    }
                    DBUtil.stopMySQLService();
                    boolean polStarted = true;
                    if (!sga.startPolicy("spolicy_mysql_log", SGKms.getCurrentDA())) {
                        this.updateMessage(ResourceManager.getString("error.vault.starting"));
                        this.updateTitle(ResourceManager.getString("error.operation"));
                        logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                        polStarted = false;
                    }
                    if (status == 0 && !sga.putPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                        if (polStarted) {
                            this.updateMessage(ResourceManager.getString("warn.vault.close"));
                        }
                        logger.log(Level.WARN, ResourceManager.getString("warn.vault.close"));
                    }
                    if (!polStarted) {
                        Void void_ = null;
                        return void_;
                    }
                } else {
                    this.updateMessage(ResourceManager.getString("error.mysql.log.not_stopped"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.mysql.log.not_stopped"));
                    Void void_ = null;
                    return void_;
                }
                this.updateTitle(ResourceManager.getString("info.mysql.log.protection.started.success"));
            }
            catch (NoSGAdminException | PolicyGetException | PolicyPutException | PolicyStartException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException ex) {
                logger.log(Level.ERROR, "", (Throwable)ex);
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
            }
            finally {
                sga.clearCache();
            }
            return null;
        }
    }

    private class TaskStopSgKms
    extends Task<Void> {
        private TaskStopSgKms() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void call() throws Exception {
            logger.log(Level.INFO, ResourceManager.getString("info.sg-kms.stopping"));
            this.updateTitle(ResourceManager.getString("info.sg-kms.stopping"));
            SGAManager sga = SGAManager.getInstance();
            try {
                int status = SGKms.lockerStatus();
                if (status == 1) {
                    if (!sga.stopPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                        this.updateMessage(ResourceManager.getString("error.sg-kms.stopping"));
                        this.updateTitle(ResourceManager.getString("error.operation"));
                        logger.log(Level.ERROR, ResourceManager.getString("error.sg-kms.stopping"));
                        Void void_ = null;
                        return void_;
                    }
                    this.updateTitle(ResourceManager.getString("info.sg-kms-stop.success"));
                } else {
                    this.updateTitle(ResourceManager.getString("info.sg-kms.already_stop"));
                }
            }
            catch (NoSGAdminException | PolicyStopException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
                logger.log(Level.ERROR, "", (Throwable)ex);
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
            }
            finally {
                sga.clearCache();
            }
            return null;
        }
    }

    private class TaskStartSgKms
    extends Task<Void> {
        private TaskStartSgKms() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void call() throws Exception {
            this.updateTitle(ResourceManager.getString("info.sg-kms.starting"));
            SGAManager sga = SGAManager.getInstance();
            try {
                int status = SGKms.lockerStatus();
                if (status == 2) {
                    if (!sga.startPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                        this.updateMessage(ResourceManager.getString("error.vault.starting"));
                        this.updateTitle(ResourceManager.getString("error.operation"));
                        logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                        Void void_ = null;
                        return void_;
                    }
                } else {
                    this.updateMessage(ResourceManager.getString("error.sg-kms.not_stopped"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.sg-kms.not_stopped"));
                    Void void_ = null;
                    return void_;
                }
                DBUtil.restartMySQLService();
                this.updateTitle(ResourceManager.getString("info.sg-kms-start.success"));
            }
            catch (NoSGAdminException | PolicyStartException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException ex) {
                logger.log(Level.ERROR, "", (Throwable)ex);
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
            }
            finally {
                sga.clearCache();
            }
            return null;
        }
    }

    private class TaskRestartTDE
    extends Task<Void> {
        private TaskRestartTDE() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void call() throws Exception {
            this.updateTitle(ResourceManager.getString("info.mysql.tde.restarting"));
            SGAManager sga = SGAManager.getInstance();
            try {
                sga.policyStatus("spolicy_mysql_keyring", SGKms.getCurrentDA(), 0);
                int status = SGKms.lockerStatus();
                if (status == 0) {
                    if (!sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                        this.updateMessage(ResourceManager.getString("error.vault.fetching"));
                        this.updateTitle(ResourceManager.getString("error.operation"));
                        logger.log(Level.ERROR, ResourceManager.getString("error.vault.fetching"));
                        Void void_ = null;
                        return void_;
                    }
                } else if (status == 2 && !sga.startPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    this.updateMessage(ResourceManager.getString("error.vault.starting"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                    Void void_ = null;
                    return void_;
                }
                DBUtil.restartMySQLService();
                logger.log(Level.DEBUG, "MySQL service was restarted");
                if (!sga.putPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    this.updateMessage(ResourceManager.getString("warn.vault.close"));
                    logger.log(Level.WARN, ResourceManager.getString("warn.vault.close"));
                }
                this.updateTitle(ResourceManager.getString("info.mysql.tde.restart.success"));
                logger.log(Level.DEBUG, "Restart TDE finished");
            }
            catch (NoSGAdminException | PolicyGetException | PolicyPutException | PolicyStartException | PolicyStatusException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException ex) {
                logger.log(Level.ERROR, "", (Throwable)ex);
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
            }
            finally {
                sga.clearCache();
            }
            return null;
        }
    }

    private class TaskUnprotectKey
    extends Task<Void> {
        private TaskUnprotectKey() {
        }

        protected Void call() throws Exception {
            this.updateTitle(ResourceManager.getString("info.vault.unprotecting"));
            SGAManager sga = SGAManager.getInstance();
            logger.log(Level.INFO, ResourceManager.getString("info.vault.unprotecting"));
            try {
                if (!sga.existPolicy("spolicy_mysql_keyring")) {
                    this.updateMessage(ResourceManager.getString("error.vault.not_exist"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    Platform.runLater(() -> {
                        CustomAlert alert = new CustomAlert(Alert.AlertType.ERROR, ResourceManager.getString("info.alert.vault.not_exists.title"), ResourceManager.getString("info.alert.vault.not_exists.header"), "error.vault.not_exist");
                        alert.showAndWait();
                        Platform.exit();
                    });
                    Void void_ = null;
                    return void_;
                }
                if (SGKms.lockerStatus() == 0 && !sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    this.updateMessage(ResourceManager.getString("error.vault.fetching"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.fetching"));
                    Void void_ = null;
                    return void_;
                }
                if (sga.removePolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    this.updateTitle(ResourceManager.getString("info.vault.removed"));
                    logger.log(Level.INFO, ResourceManager.getString("info.vault.removed"));
                    Platform.runLater(() -> {
                        CustomAlert alert = new CustomAlert(Alert.AlertType.ERROR, ResourceManager.getString("info.alert.vault.removed.title"), ResourceManager.getString("info.alert.vault.removed.header"), ResourceManager.getString("info.vault.removed"));
                        alert.showAndWait();
                        Platform.exit();
                    });
                } else {
                    this.updateMessage(ResourceManager.getString("error.vault.remove"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.remove"));
                }
            }
            catch (NoSGAdminException | PolicyRemoveException | NullUserInfoListenerException | OperationCancelledException ex) {
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
            }
            finally {
                sga.clearCache();
            }
            return null;
        }
    }

    private class TaskUnprotectLog
    extends Task<Void> {
        private TaskUnprotectLog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void call() throws Exception {
            this.updateTitle(ResourceManager.getString("info.pol.mysql.log.unprotecting"));
            SGAManager sga = SGAManager.getInstance();
            logger.log(Level.INFO, ResourceManager.getString("log.info.mysql.log.unprotecting"));
            try {
                if (!sga.existPolicy("spolicy_mysql_log")) {
                    this.updateMessage(ResourceManager.getString("error.pol.mysql.log.not_exist"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    Void void_ = null;
                    return void_;
                }
                int status = SGKms.lockerStatus();
                if (status == 0) {
                    if (!sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                        this.updateMessage(ResourceManager.getString("error.vault.fetching"));
                        this.updateTitle(ResourceManager.getString("error.operation"));
                        logger.log(Level.ERROR, ResourceManager.getString("error.vault.fetching"));
                        Void void_ = null;
                        return void_;
                    }
                } else if (status == 2 && !sga.startPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    this.updateMessage(ResourceManager.getString("error.vault.starting"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                    Void void_ = null;
                    return void_;
                }
                boolean wasRemoved = sga.removePolicy("spolicy_mysql_log", SGKms.getCurrentDA());
                if (status == 0 && !sga.putPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    this.updateMessage(ResourceManager.getString("warn.vault.close"));
                    logger.log(Level.WARN, ResourceManager.getString("warn.vault.close"));
                }
                if (wasRemoved) {
                    this.updateTitle(ResourceManager.getString("info.pol.mysql.log.unprotect"));
                    logger.log(Level.INFO, ResourceManager.getString("info.pol.mysql.log.unprotect"));
                } else {
                    this.updateMessage(ResourceManager.getString("error.pol.mysql.unprotect"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.pol.mysql.unprotect"));
                }
            }
            catch (NoSGAdminException | PolicyGetException | PolicyPutException | PolicyRemoveException | PolicyStartException | NullUserInfoListenerException | OperationCancelledException ex) {
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
            }
            finally {
                sga.clearCache();
            }
            return null;
        }
    }

    private class TaskProtectLog
    extends Task<Void> {
        private TaskProtectLog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void call() throws Exception {
            this.updateTitle(ResourceManager.getString("info.pol.mysql.log.protecting"));
            SGAManager sga = SGAManager.getInstance();
            logger.log(Level.INFO, ResourceManager.getString("log.info.mysql.log.protecting"));
            try {
                if (!sga.existPolicy("spolicy_mysql_log")) {
                    int lstatus = SGKms.lockerStatus();
                    if (lstatus == 0) {
                        if (!sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                            this.updateMessage(ResourceManager.getString("error.vault.fetching"));
                            this.updateTitle(ResourceManager.getString("error.operation"));
                            logger.log(Level.ERROR, ResourceManager.getString("error.vault.fetching"));
                            Void void_ = null;
                            return void_;
                        }
                    } else if (lstatus == 2 && !sga.startPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                        this.updateMessage(ResourceManager.getString("error.vault.starting"));
                        this.updateTitle(ResourceManager.getString("error.operation"));
                        logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                        Void void_ = null;
                        return void_;
                    }
                    String cfgFile = FileUtil.createPolicyConfigFile("spolicy_mysql_log", "/var/log/mysql", DBUtil.getMySQLDaemonName(), sga.isPAMEnabled() ? "sgadmin,mysql" : "", SGKms.getCurrentDA());
                    boolean wasAdded = sga.addPolicy(cfgFile, SGKms.getCurrentDA());
                    if (lstatus == 0 && !sga.putPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                        this.updateMessage(ResourceManager.getString("warn.vault.close"));
                        logger.log(Level.WARN, ResourceManager.getString("warn.vault.close"));
                    }
                    if (!wasAdded) {
                        this.updateMessage(ResourceManager.getString("error.pol.mysql.log.add.failed"));
                        this.updateTitle(ResourceManager.getString("error.operation"));
                    } else {
                        this.updateTitle(ResourceManager.getString("info.pol.mysql.log.add.success"));
                    }
                    Void void_ = null;
                    return void_;
                }
                int status = sga.policyStatus("spolicy_mysql_log", SGKms.getCurrentDA(), 0);
                if (status == 2) {
                    this.updateTitle(ResourceManager.getString("info.pol.mysql.log.protected"));
                    logger.log(Level.INFO, ResourceManager.getString("info.pol.mysql.log.protected"));
                } else if (status == 3) {
                    this.updateMessage(ResourceManager.getString("error.pol.mysql.log.inconsistent"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.pol.mysql.log.inconsistent"));
                } else if (sga.startPolicy("spolicy_mysql_log", SGKms.getCurrentDA())) {
                    this.updateTitle(ResourceManager.getString("info.pol.mysql.log.protect"));
                    logger.log(Level.INFO, ResourceManager.getString("info.pol.mysql.log.protect"));
                } else {
                    this.updateMessage(ResourceManager.getString("error.pol.mysql.protect"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.pol.mysql.protect"));
                }
            }
            catch (LicenseCheckException | NoSGAdminException | PolicyAddException | PolicyGetException | PolicyPutException | PolicyStartException | PolicyStatusException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException ex) {
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
            }
            finally {
                sga.clearCache();
            }
            return null;
        }
    }

    private class TaskRotateSMK
    extends Task<Void> {
        private TaskRotateSMK() {
        }

        protected Void call() throws Exception {
            this.updateTitle(ResourceManager.getString("info.smk.rotating"));
            SGAManager sga = SGAManager.getInstance();
            logger.log(Level.INFO, ResourceManager.getString("log.info.smk.rotating"));
            try {
                if (sga.smkRotate()) {
                    this.updateTitle(ResourceManager.getString("info.smk.rotate"));
                    logger.log(Level.INFO, ResourceManager.getString("info.smk.rotate"));
                } else {
                    this.updateMessage(ResourceManager.getString("error.smk.rotate"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.smk.rotate"));
                }
            }
            catch (NoSGAdminException | SMKRotateException | NullUserInfoListenerException | OperationCancelledException ex) {
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
            }
            finally {
                sga.clearCache();
                SGKmsOPController.this.userData.clear();
            }
            return null;
        }
    }

    private class TaskRevokeDA
    extends Task<Void> {
        String revokeDA;
        String reassingDA;

        public TaskRevokeDA(String revokeDA, String reassingDA) {
            this.revokeDA = revokeDA;
            this.reassingDA = reassingDA;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void call() throws Exception {
            this.updateTitle(ResourceManager.getString("info.da.revoking"));
            SGAManager sga = SGAManager.getInstance();
            logger.log(Level.INFO, ResourceManager.getString("log.info.da.revoking", this.revokeDA, this.reassingDA));
            try {
                if (!sga.isMySQLDACreated(this.reassingDA)) {
                    String configFile = FileUtil.createAdmConfigFile(this.reassingDA, (String)SGKmsOPController.this.userData.get("fname"), (String)SGKmsOPController.this.userData.get("lname"), (String)SGKmsOPController.this.userData.get("email"), (String)SGKmsOPController.this.userData.get("phone"), false);
                    if (configFile == null) {
                        this.updateMessage(ResourceManager.getString("error.operation.cancelled"));
                        this.updateTitle(ResourceManager.getString("error.operation"));
                        logger.log(Level.ERROR, ResourceManager.getString("error.operation.cancelled"));
                        Void void_ = null;
                        return void_;
                    }
                    if (!sga.addDA(configFile)) {
                        this.updateMessage(ResourceManager.getString("error.da.add"));
                        this.updateTitle(ResourceManager.getString("error.operation"));
                        logger.log(Level.ERROR, ResourceManager.getString("error.da.add"));
                        Void void_ = null;
                        return void_;
                    }
                }
                if (!sga.revokeReassingDA(this.revokeDA, this.reassingDA)) {
                    this.updateMessage(ResourceManager.getString("error.da.revoke.failed"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.da.revoke.failed"));
                } else {
                    this.updateTitle(ResourceManager.getString("info.da.revoke.success"));
                    logger.log(Level.INFO, ResourceManager.getString("info.da.revoke.success"));
                }
            }
            catch (DAAddException | DARevokeReassingException | NoSGAdminException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
            }
            finally {
                sga.clearCache();
                SGKmsOPController.this.userData.clear();
            }
            return null;
        }
    }

    private class TaskRotateDMK
    extends Task<Void> {
        private TaskRotateDMK() {
        }

        protected Void call() throws Exception {
            this.updateTitle(ResourceManager.getString("info.dmk.rotating"));
            SGAManager sga = SGAManager.getInstance();
            logger.log(Level.INFO, ResourceManager.getString("log.info.dmk.rotating", SGKms.getCurrentDA()));
            try {
                if (sga.dmkRotate(SGKms.getCurrentDA())) {
                    this.updateTitle(ResourceManager.getString("info.dmk.rotate"));
                    logger.log(Level.INFO, ResourceManager.getString("info.dmk.rotate"));
                } else {
                    this.updateMessage(ResourceManager.getString("error.dmk.rotate"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.dmk.rotate"));
                }
            }
            catch (DMKRotateException | NoSGAdminException | NullUserInfoListenerException | OperationCancelledException ex) {
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
            }
            finally {
                sga.clearCache();
                SGKmsOPController.this.userData.clear();
            }
            return null;
        }
    }

    class TaskRotateDBKey
    extends Task<Void> {
        TaskRotateDBKey() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void call() throws Exception {
            this.updateTitle(ResourceManager.getString("info.mysql.rotating"));
            SGAManager sga = SGAManager.getInstance();
            try {
                int status = SGKms.lockerStatus();
                if (status == 0) {
                    if (!sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                        this.updateMessage(ResourceManager.getString("error.vault.fetching"));
                        this.updateTitle(ResourceManager.getString("error.operation"));
                        logger.log(Level.ERROR, ResourceManager.getString("error.vault.fetching"));
                        Void void_ = null;
                        return void_;
                    }
                } else if (status == 2 && !sga.startPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    this.updateMessage(ResourceManager.getString("error.vault.starting"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                    Void void_ = null;
                    return void_;
                }
                DBUtil.restartMySQLService();
                logger.log(Level.DEBUG, "MySQL service was restarted");
                DBUtil.connectMySQLDB();
                DBUtil.saveDBConfig(SGKms.CONFIG_FOLDER, "sg-tde.properties");
                if (!DBUtil.isMySQLTDEActivated()) {
                    this.updateMessage(ResourceManager.getString("error.tde.not_enabled"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                } else {
                    logger.log(Level.DEBUG, "rotating the key");
                    DBUtil.rotateMySQLDBKey();
                    logger.log(Level.DEBUG, "key rotation success");
                    this.updateTitle(ResourceManager.getString("info.mysql.rotate"));
                    logger.log(Level.INFO, ResourceManager.getString("info.mysql.rotate"));
                }
                if (status == 0 && !sga.putPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    this.updateMessage(ResourceManager.getString("warn.vault.close"));
                    logger.log(Level.WARN, ResourceManager.getString("warn.vault.close"));
                }
            }
            catch (NoSGAdminException | PolicyGetException | PolicyPutException | PolicyStartException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException | SQLException ex) {
                logger.log(Level.ERROR, "", (Throwable)ex);
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
            }
            finally {
                sga.clearCache();
            }
            return null;
        }
    }

    private class TaskCloseLocker
    extends Task<Void> {
        private TaskCloseLocker() {
        }

        protected Void call() throws Exception {
            logger.log(Level.INFO, ResourceManager.getString("info.vault.closing"));
            this.updateTitle(ResourceManager.getString("info.vault.closing"));
            SGAManager sga = SGAManager.getInstance();
            try {
                int vaultStatus = SGKms.lockerStatus();
                int polStatus = sga.policyStatus("spolicy_mysql_keyring", SGKms.getCurrentDA(), 0);
                if (polStatus == 1 && vaultStatus == 0) {
                    this.updateTitle(ResourceManager.getString("info.vault.closed"));
                    logger.log(Level.INFO, ResourceManager.getString("info.vault.closed"));
                } else if (polStatus == 3) {
                    this.updateMessage(ResourceManager.getString("error.vault.inconsistent"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.inconsistent"));
                } else if (sga.putPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    this.updateTitle(ResourceManager.getString("info.vault.close"));
                    logger.log(Level.INFO, ResourceManager.getString("info.vault.close"));
                } else {
                    this.updateTitle(ResourceManager.getString("error.vault.close"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.close"));
                }
            }
            catch (NoSGAdminException | PolicyPutException | PolicyStatusException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
            }
            sga.clearCache();
            return null;
        }
    }

    private class TaskOpenLocker
    extends Task<Void> {
        private TaskOpenLocker() {
        }

        protected Void call() throws Exception {
            logger.log(Level.INFO, ResourceManager.getString("info.vault.opening"));
            this.updateTitle(ResourceManager.getString("info.vault.opening"));
            SGAManager sga = SGAManager.getInstance();
            try {
                int status = sga.policyStatus("spolicy_mysql_keyring", SGKms.getCurrentDA(), 0);
                if (status == 2) {
                    this.updateTitle(ResourceManager.getString("info.vault.opened"));
                    logger.log(Level.INFO, ResourceManager.getString("info.vault.opened"));
                } else if (status == 3) {
                    this.updateMessage(ResourceManager.getString("error.vault.inconsistent"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.inconsistent"));
                } else if (sga.getPolicy("spolicy_mysql_keyring", SGKms.getCurrentDA())) {
                    this.updateTitle(ResourceManager.getString("info.vault.open"));
                    logger.log(Level.INFO, ResourceManager.getString("info.vault.open"));
                } else {
                    this.updateMessage(ResourceManager.getString("error.vault.open"));
                    this.updateTitle(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.vault.open"));
                }
            }
            catch (NoSGAdminException | PolicyGetException | PolicyStatusException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
                this.updateMessage(ex.getMessage());
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
            }
            sga.clearCache();
            return null;
        }
    }
}

