/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.PolicyRemoveException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskRemovePolicy
extends Task<Boolean> {
    private List<Integer> pwRequested;
    private static final Logger logger = LogManager.getLogger();
    private String DAId;
    private String Policy;

    public TaskRemovePolicy(List<Integer> pwRequested, String DAId, String Policy2) {
        this.pwRequested = pwRequested;
        this.DAId = DAId;
        this.Policy = Policy2;
    }

    protected Boolean call() throws Exception {
        try {
            if (SGAManager.getInstance().removePolicy(this.Policy, this.DAId)) {
                this.updateTitle(ResourceManager.getString("log.info.sgamanager.rem-pol.success", this.Policy));
                logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.rem-pol.success", this.Policy));
                SGKms.removeProperty("policy.create_date." + this.DAId);
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            this.updateMessage(ResourceManager.getString("log.error.sgamanager.rem-pol.success", this.Policy));
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.rem-pol.success", this.Policy));
        }
        catch (NoSGAdminException | PolicyRemoveException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.updateMessage(ex.getMessage());
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            if (SGAManager.getInstance() != null) {
                SGAManager.getInstance().clearCache();
            }
        }
        this.updateValue(Boolean.FALSE);
        return Boolean.FALSE;
    }
}

