/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;

@Plugin(name="notEmpty", category="Converter")
@ConverterKeys(value={"notEmpty", "varsNotEmpty", "variablesNotEmpty"})
public final class VariablesNotEmptyReplacementConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;

    private VariablesNotEmptyReplacementConverter(List<PatternFormatter> formatters) {
        super("notEmpty", "notEmpty");
        this.formatters = formatters;
    }

    public static VariablesNotEmptyReplacementConverter newInstance(Configuration config, String[] options) {
        if (options.length != 1) {
            LOGGER.error("Incorrect number of options on varsNotEmpty. Expected 1 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on varsNotEmpty");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser(config);
        List<PatternFormatter> formatters = parser.parse(options[0]);
        return new VariablesNotEmptyReplacementConverter(formatters);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        StringBuilder buf = new StringBuilder();
        int emptyVars = 0;
        int vars = 0;
        for (PatternFormatter formatter : this.formatters) {
            int start = buf.length();
            formatter.format(event, buf);
            boolean isVariable = formatter.getConverter().isVariable();
            vars += isVariable ? 1 : 0;
            if (!isVariable || buf.length() - start != 0) continue;
            ++emptyVars;
        }
        if (vars > 0 && emptyVars != vars) {
            toAppendTo.append(buf.toString());
        }
    }
}

