/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.ResultSetInternalMethods;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.MysqlType;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.profiler.ProfilerEventHandlerFactory;
import com.mysql.cj.core.profiler.ProfilerEventImpl;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.core.util.LogUtils;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.core.util.TestUtils;
import com.mysql.cj.jdbc.ConnectionImpl;
import com.mysql.cj.jdbc.MysqlParameterMetadata;
import com.mysql.cj.jdbc.PreparedStatement;
import com.mysql.cj.jdbc.ResultSetMetaData;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.exceptions.MySQLStatementCancelledException;
import com.mysql.cj.jdbc.exceptions.MySQLTimeoutException;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.util.TimeUtil;
import com.mysql.cj.mysqla.io.Buffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.TimerTask;

public class ServerPreparedStatement
extends PreparedStatement {
    protected static final int BLOB_STREAM_READ_BUF_SIZE = 8192;
    private boolean hasOnDuplicateKeyUpdate = false;
    private boolean detectedLongParameterSwitch = false;
    private int fieldCount;
    private boolean invalid = false;
    private CJException invalidationException;
    private Buffer outByteBuffer;
    private BindValue[] parameterBindings;
    private Field[] parameterFields;
    private Field[] resultFields;
    private boolean sendTypesToServer = false;
    private long serverStatementId;
    private int netBufferLength = 16384;
    protected boolean isCached = false;
    private boolean useAutoSlowLog;
    private boolean hasCheckedRewrite = false;
    private boolean canRewrite = false;
    private int locationOfOnDuplicateKeyUpdate = -2;

    private void storeTime(Buffer intoBuf, Time tm, TimeZone tz) throws SQLException {
        intoBuf.ensureCapacity(9);
        intoBuf.writeByte((byte)8);
        intoBuf.writeByte((byte)0);
        intoBuf.writeLong(0L);
        Calendar cal = Calendar.getInstance(tz);
        cal.setTime(tm);
        intoBuf.writeByte((byte)cal.get(11));
        intoBuf.writeByte((byte)cal.get(12));
        intoBuf.writeByte((byte)cal.get(13));
    }

    protected static ServerPreparedStatement getInstance(JdbcConnection conn, String sql, String catalog, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ServerPreparedStatement(conn, sql, catalog, resultSetType, resultSetConcurrency);
    }

    protected ServerPreparedStatement(JdbcConnection conn, String sql, String catalog, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(conn, catalog);
        this.checkNullOrEmptyQuery(sql);
        int startOfStatement = ServerPreparedStatement.findStartOfStatement(sql);
        this.firstCharOfStmt = StringUtils.firstAlphaCharUc(sql, startOfStatement);
        this.hasOnDuplicateKeyUpdate = this.firstCharOfStmt == 'I' && this.containsOnDuplicateKeyInString(sql);
        this.useAutoSlowLog = this.session.getPropertySet().getBooleanReadableProperty("autoSlowLog").getValue();
        this.netBufferLength = this.session.getServerVariable("net_buffer_length", 16384);
        String statementComment = this.connection.getStatementComment();
        this.originalSql = statementComment == null ? sql : "/* " + statementComment + " */ " + sql;
        try {
            this.serverPrepare(sql);
        }
        catch (CJException | SQLException sqlEx) {
            this.realClose(false, true);
            throw SQLExceptionsMapping.translateException(sqlEx, this.getExceptionInterceptor());
        }
        this.setResultSetType(resultSetType);
        this.setResultSetConcurrency(resultSetConcurrency);
        this.parameterTypes = new MysqlType[this.parameterCount];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (this.batchedArgs == null) {
                    this.batchedArgs = new ArrayList();
                }
                this.batchedArgs.add(new BatchedBindValues(this.parameterBindings));
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String asSql(boolean quoteStreamsAndUnknowns) throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            String string;
            block21: {
                PreparedStatement pStmtForSub = null;
                try {
                    pStmtForSub = PreparedStatement.getInstance(this.connection, this.originalSql, this.currentCatalog);
                    int numParameters = pStmtForSub.parameterCount;
                    int ourNumParameters = this.parameterCount;
                    block18: for (int i = 0; i < numParameters && i < ourNumParameters; ++i) {
                        if (this.parameterBindings[i] == null) continue;
                        if (this.parameterBindings[i].isNull) {
                            pStmtForSub.setNull(i + 1, MysqlType.NULL);
                            continue;
                        }
                        BindValue bindValue = this.parameterBindings[i];
                        switch (bindValue.bufferType) {
                            case 1: {
                                pStmtForSub.setByte(i + 1, (byte)bindValue.longBinding);
                                continue block18;
                            }
                            case 2: {
                                pStmtForSub.setShort(i + 1, (short)bindValue.longBinding);
                                continue block18;
                            }
                            case 3: {
                                pStmtForSub.setInt(i + 1, (int)bindValue.longBinding);
                                continue block18;
                            }
                            case 8: {
                                pStmtForSub.setLong(i + 1, bindValue.longBinding);
                                continue block18;
                            }
                            case 4: {
                                pStmtForSub.setFloat(i + 1, bindValue.floatBinding);
                                continue block18;
                            }
                            case 5: {
                                pStmtForSub.setDouble(i + 1, bindValue.doubleBinding);
                                continue block18;
                            }
                            default: {
                                pStmtForSub.setObject(i + 1, this.parameterBindings[i].value);
                            }
                        }
                    }
                    string = pStmtForSub.asSql(quoteStreamsAndUnknowns);
                    if (pStmtForSub == null) break block21;
                }
                catch (Throwable throwable) {
                    if (pStmtForSub != null) {
                        try {
                            pStmtForSub.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    pStmtForSub.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return string;
        }
    }

    @Override
    protected JdbcConnection checkClosed() {
        if (this.invalid) {
            throw this.invalidationException;
        }
        return super.checkClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.clearParametersInternal(true);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void clearParametersInternal(boolean clearServerParameters) {
        boolean hadLongData = false;
        if (this.parameterBindings != null) {
            for (int i = 0; i < this.parameterCount; ++i) {
                if (this.parameterBindings[i] != null && this.parameterBindings[i].isLongData) {
                    hadLongData = true;
                }
                this.parameterBindings[i].reset();
            }
        }
        if (clearServerParameters && hadLongData) {
            this.serverResetStatement();
            this.detectedLongParameterSwitch = false;
        }
    }

    protected void setClosed(boolean flag) {
        this.isClosed = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            JdbcConnection locallyScopedConn = this.connection;
            if (locallyScopedConn == null) {
                return;
            }
            Object object = locallyScopedConn.getConnectionMutex();
            synchronized (object) {
                if (this.isCached && !this.isClosed) {
                    this.clearParameters();
                    this.isClosed = true;
                    this.connection.recachePreparedStatement(this);
                    return;
                }
                this.realClose(true, true);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpCloseForTestcase() throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            StringBuilder buf = new StringBuilder();
            this.connection.generateConnectionCommentBlock(buf);
            buf.append("DEALLOCATE PREPARE debug_stmt_");
            buf.append(this.statementId);
            buf.append(";\n");
            TestUtils.dumpTestcaseQuery(buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpExecuteForTestcase() throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            int i;
            StringBuilder buf = new StringBuilder();
            for (i = 0; i < this.parameterCount; ++i) {
                this.connection.generateConnectionCommentBlock(buf);
                buf.append("SET @debug_stmt_param");
                buf.append(this.statementId);
                buf.append("_");
                buf.append(i);
                buf.append("=");
                if (this.parameterBindings[i].isNull) {
                    buf.append("NULL");
                } else {
                    buf.append(this.parameterBindings[i].toString(true));
                }
                buf.append(";\n");
            }
            this.connection.generateConnectionCommentBlock(buf);
            buf.append("EXECUTE debug_stmt_");
            buf.append(this.statementId);
            if (this.parameterCount > 0) {
                buf.append(" USING ");
                for (i = 0; i < this.parameterCount; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append("@debug_stmt_param");
                    buf.append(this.statementId);
                    buf.append("_");
                    buf.append(i);
                }
            }
            buf.append(";\n");
            TestUtils.dumpTestcaseQuery(buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpPrepareForTestcase() throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            StringBuilder buf = new StringBuilder(this.originalSql.length() + 64);
            this.connection.generateConnectionCommentBlock(buf);
            buf.append("PREPARE debug_stmt_");
            buf.append(this.statementId);
            buf.append(" FROM \"");
            buf.append(this.originalSql);
            buf.append("\";\n");
            TestUtils.dumpTestcaseQuery(buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long[] executeBatchSerially(int batchTimeout) throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            long[] lArray;
            JdbcConnection locallyScopedConn = this.connection;
            if (locallyScopedConn.isReadOnly()) {
                throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.2") + Messages.getString("ServerPreparedStatement.3"), "S1009", this.getExceptionInterceptor());
            }
            this.clearWarnings();
            BindValue[] oldBindValues = this.parameterBindings;
            try {
                long[] updateCounts = null;
                if (this.batchedArgs != null) {
                    int nbrCommands = this.batchedArgs.size();
                    updateCounts = new long[nbrCommands];
                    if (this.retrieveGeneratedKeys) {
                        this.batchedGeneratedKeys = new ArrayList(nbrCommands);
                    }
                    for (int i = 0; i < nbrCommands; ++i) {
                        updateCounts[i] = -3L;
                    }
                    SQLException sqlEx = null;
                    int commandIndex = 0;
                    BindValue[] previousBindValuesForBatch = null;
                    TimerTask timeoutTask = null;
                    try {
                        if (locallyScopedConn.getPropertySet().getBooleanReadableProperty("enableQueryTimeouts").getValue().booleanValue() && batchTimeout != 0) {
                            timeoutTask = new StatementImpl.CancelTask(this, this);
                            locallyScopedConn.getCancelTimer().schedule(timeoutTask, batchTimeout);
                        }
                        for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                            Object arg = this.batchedArgs.get(commandIndex);
                            try {
                                if (arg instanceof String) {
                                    updateCounts[commandIndex] = this.executeUpdateInternal((String)arg, true, this.retrieveGeneratedKeys);
                                    this.getBatchedGeneratedKeys(this.results.getFirstCharOfQuery() == 'I' && this.containsOnDuplicateKeyInString((String)arg) ? 1 : 0);
                                    continue;
                                }
                                this.parameterBindings = ((BatchedBindValues)arg).batchedParameterValues;
                                if (previousBindValuesForBatch != null) {
                                    for (int j = 0; j < this.parameterBindings.length; ++j) {
                                        if (this.parameterBindings[j].bufferType == previousBindValuesForBatch[j].bufferType) continue;
                                        this.sendTypesToServer = true;
                                        break;
                                    }
                                }
                                try {
                                    updateCounts[commandIndex] = this.executeUpdateInternal(false, true);
                                }
                                finally {
                                    previousBindValuesForBatch = this.parameterBindings;
                                }
                                this.getBatchedGeneratedKeys(this.containsOnDuplicateKeyUpdateInSQL() ? 1 : 0);
                                continue;
                            }
                            catch (SQLException ex) {
                                updateCounts[commandIndex] = -3L;
                                if (this.continueBatchOnError && !(ex instanceof MySQLTimeoutException) && !(ex instanceof MySQLStatementCancelledException) && !this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
                                    sqlEx = ex;
                                    continue;
                                }
                                long[] newUpdateCounts = new long[commandIndex];
                                System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                                throw SQLError.createBatchUpdateException(ex, newUpdateCounts, this.getExceptionInterceptor());
                            }
                        }
                    }
                    finally {
                        if (timeoutTask != null) {
                            timeoutTask.cancel();
                            locallyScopedConn.getCancelTimer().purge();
                        }
                        this.resetCancelledState();
                    }
                    if (sqlEx != null) {
                        throw SQLError.createBatchUpdateException(sqlEx, updateCounts, this.getExceptionInterceptor());
                    }
                }
                lArray = updateCounts != null ? updateCounts : new long[]{};
                this.parameterBindings = oldBindValues;
                this.sendTypesToServer = true;
            }
            catch (Throwable throwable) {
                this.parameterBindings = oldBindValues;
                this.sendTypesToServer = true;
                this.clearBatch();
                throw throwable;
            }
            this.clearBatch();
            return lArray;
        }
    }

    @Override
    protected ResultSetInternalMethods executeInternal(int maxRowsToRetrieve, Buffer sendPacket, boolean createStreamingResultSet, boolean queryIsSelectOnly, Field[] metadataFromCache, boolean isBatch) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                ++this.numberOfExecutions;
                try {
                    return this.serverExecute(maxRowsToRetrieve, createStreamingResultSet, metadataFromCache);
                }
                catch (SQLException sqlEx) {
                    if (this.session.getPropertySet().getBooleanReadableProperty("enablePacketDebug").getValue().booleanValue()) {
                        this.session.dumpPacketRingBuffer();
                    }
                    if (((Boolean)this.dumpQueriesOnException.getValue()).booleanValue()) {
                        String extractedSql = this.toString();
                        StringBuilder messageBuf = new StringBuilder(extractedSql.length() + 32);
                        messageBuf.append("\n\nQuery being executed when exception was thrown:\n");
                        messageBuf.append(extractedSql);
                        messageBuf.append("\n\n");
                        sqlEx = ConnectionImpl.appendMessageToException(sqlEx, messageBuf.toString(), this.getExceptionInterceptor());
                    }
                    throw sqlEx;
                }
                catch (Exception ex) {
                    if (this.session.getPropertySet().getBooleanReadableProperty("enablePacketDebug").getValue().booleanValue()) {
                        this.session.dumpPacketRingBuffer();
                    }
                    SQLException sqlEx = SQLError.createSQLException(ex.toString(), "S1000", ex, this.getExceptionInterceptor());
                    if (((Boolean)this.dumpQueriesOnException.getValue()).booleanValue()) {
                        String extractedSql = this.toString();
                        StringBuilder messageBuf = new StringBuilder(extractedSql.length() + 32);
                        messageBuf.append("\n\nQuery being executed when exception was thrown:\n");
                        messageBuf.append(extractedSql);
                        messageBuf.append("\n\n");
                        sqlEx = ConnectionImpl.appendMessageToException(sqlEx, messageBuf.toString(), this.getExceptionInterceptor());
                    }
                    throw sqlEx;
                }
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    protected Buffer fillSendPacket() throws SQLException {
        return null;
    }

    @Override
    protected Buffer fillSendPacket(byte[][] batchedParameterStrings, InputStream[] batchedParameterStreams, boolean[] batchedIsStream, int[] batchedStreamLengths) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BindValue getBinding(int parameterIndex, boolean forLongData) throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            if (this.parameterBindings.length == 0) {
                throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.8"), "S1009", this.getExceptionInterceptor());
            }
            if (--parameterIndex < 0 || parameterIndex >= this.parameterBindings.length) {
                throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.9") + (parameterIndex + 1) + Messages.getString("ServerPreparedStatement.10") + this.parameterBindings.length, "S1009", this.getExceptionInterceptor());
            }
            if (this.parameterBindings[parameterIndex] == null) {
                this.parameterBindings[parameterIndex] = new BindValue();
            } else if (this.parameterBindings[parameterIndex].isLongData && !forLongData) {
                this.detectedLongParameterSwitch = true;
            }
            this.parameterBindings[parameterIndex].isSet = true;
            this.parameterBindings[parameterIndex].boundBeforeExecutionNum = this.numberOfExecutions;
            return this.parameterBindings[parameterIndex];
        }
    }

    public BindValue[] getParameterBindValues() {
        return this.parameterBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes(int parameterIndex) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                BindValue bindValue = this.getBinding(parameterIndex, false);
                if (bindValue.isNull) {
                    return null;
                }
                if (bindValue.isLongData) {
                    throw SQLError.createSQLFeatureNotSupportedException();
                }
                if (this.outByteBuffer == null) {
                    this.outByteBuffer = new Buffer(this.netBufferLength);
                }
                this.outByteBuffer.clear();
                int originalPosition = this.outByteBuffer.getPosition();
                this.storeBinding(this.outByteBuffer, bindValue);
                int newPosition = this.outByteBuffer.getPosition();
                int length = newPosition - originalPosition;
                byte[] valueAsBytes = new byte[length];
                System.arraycopy(this.outByteBuffer.getByteBuffer(), originalPosition, valueAsBytes, 0, length);
                return valueAsBytes;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (this.resultFields == null) {
                    return null;
                }
                return new ResultSetMetaData(this.session, this.resultFields, this.session.getPropertySet().getBooleanReadableProperty("useOldAliasMetadataBehavior").getValue(), this.session.getPropertySet().getBooleanReadableProperty("yearIsDateType").getValue(), this.getExceptionInterceptor());
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (this.parameterMetaData == null) {
                    this.parameterMetaData = new MysqlParameterMetadata(this.session, this.parameterFields, this.parameterCount, this.getExceptionInterceptor());
                }
                return this.parameterMetaData;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    boolean isNull(int paramIndex) {
        throw new IllegalArgumentException(Messages.getString("ServerPreparedStatement.7"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realClose(boolean calledExplicitly, boolean closeOpenResults) throws SQLException {
        try {
            JdbcConnection locallyScopedConn = this.connection;
            if (locallyScopedConn == null) {
                return;
            }
            Object object = locallyScopedConn.getConnectionMutex();
            synchronized (object) {
                if (this.connection != null) {
                    if (((Boolean)this.autoGenerateTestcaseScript.getValue()).booleanValue()) {
                        this.dumpCloseForTestcase();
                    }
                    CJException exceptionDuringClose = null;
                    if (calledExplicitly && !this.connection.isClosed()) {
                        Object object2 = this.connection.getConnectionMutex();
                        synchronized (object2) {
                            try {
                                Buffer packet = this.session.getSharedSendPacket();
                                packet.writeByte((byte)25);
                                packet.writeLong(this.serverStatementId);
                                this.session.sendCommand(25, null, packet, true, null, 0);
                            }
                            catch (CJException sqlEx) {
                                exceptionDuringClose = sqlEx;
                            }
                        }
                    }
                    if (this.isCached) {
                        this.connection.decachePreparedStatement(this);
                    }
                    super.realClose(calledExplicitly, closeOpenResults);
                    this.clearParametersInternal(false);
                    this.parameterBindings = null;
                    this.parameterFields = null;
                    this.resultFields = null;
                    if (exceptionDuringClose != null) {
                        throw exceptionDuringClose;
                    }
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rePrepare() {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            this.invalidationException = null;
            try {
                this.serverPrepare(this.originalSql);
            }
            catch (SQLException sqlEx) {
                this.invalidationException = ExceptionFactory.createException(sqlEx.getMessage(), sqlEx);
            }
            catch (Exception ex) {
                this.invalidationException = ExceptionFactory.createException(ex.getMessage(), ex);
            }
            if (this.invalidationException != null) {
                this.invalid = true;
                this.parameterBindings = null;
                this.parameterFields = null;
                this.resultFields = null;
                if (this.results != null) {
                    try {
                        this.results.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.generatedKeysResults != null) {
                    try {
                        this.generatedKeysResults.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    this.closeAllOpenResults();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.connection != null && !((Boolean)this.dontTrackOpenResources.getValue()).booleanValue()) {
                    this.connection.unregisterStatement(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultSetInternalMethods serverExecute(int maxRowsToRetrieve, boolean createStreamingResultSet, Field[] metadataFromCache) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                int i;
                int i2;
                int i3;
                ResultSetInternalMethods interceptedResults;
                if (this.session.shouldIntercept() && (interceptedResults = this.session.invokeStatementInterceptorsPre(this.originalSql, this, true)) != null) {
                    return interceptedResults;
                }
                if (this.detectedLongParameterSwitch) {
                    boolean firstFound = false;
                    long boundTimeToCheck = 0L;
                    for (i3 = 0; i3 < this.parameterCount - 1; ++i3) {
                        if (!this.parameterBindings[i3].isLongData) continue;
                        if (firstFound && boundTimeToCheck != this.parameterBindings[i3].boundBeforeExecutionNum) {
                            throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.11") + Messages.getString("ServerPreparedStatement.12"), "S1C00", this.getExceptionInterceptor());
                        }
                        firstFound = true;
                        boundTimeToCheck = this.parameterBindings[i3].boundBeforeExecutionNum;
                    }
                    this.serverResetStatement();
                }
                for (i2 = 0; i2 < this.parameterCount; ++i2) {
                    if (this.parameterBindings[i2].isSet) continue;
                    throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.13") + (i2 + 1) + Messages.getString("ServerPreparedStatement.14"), "S1009", this.getExceptionInterceptor());
                }
                for (i2 = 0; i2 < this.parameterCount; ++i2) {
                    if (!this.parameterBindings[i2].isLongData) continue;
                    this.serverLongData(i2, this.parameterBindings[i2]);
                }
                if (((Boolean)this.autoGenerateTestcaseScript.getValue()).booleanValue()) {
                    this.dumpExecuteForTestcase();
                }
                Buffer packet = this.session.getSharedSendPacket();
                packet.writeByte((byte)23);
                packet.writeLong(this.serverStatementId);
                if (this.resultFields != null && this.useCursorFetch && this.getResultSetType() == 1003 && this.getResultSetConcurrency() == 1007 && this.getFetchSize() > 0) {
                    packet.writeByte((byte)1);
                } else {
                    packet.writeByte((byte)0);
                }
                packet.writeLong(1L);
                int nullCount = (this.parameterCount + 7) / 8;
                int nullBitsPosition = packet.getPosition();
                for (i3 = 0; i3 < nullCount; ++i3) {
                    packet.writeByte((byte)0);
                }
                byte[] nullBitsBuffer = new byte[nullCount];
                packet.writeByte(this.sendTypesToServer ? (byte)1 : 0);
                if (this.sendTypesToServer) {
                    for (i = 0; i < this.parameterCount; ++i) {
                        packet.writeInt(this.parameterBindings[i].bufferType);
                    }
                }
                for (i = 0; i < this.parameterCount; ++i) {
                    if (this.parameterBindings[i].isLongData) continue;
                    if (!this.parameterBindings[i].isNull) {
                        this.storeBinding(packet, this.parameterBindings[i]);
                        continue;
                    }
                    int n = i / 8;
                    nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << (i & 7));
                }
                int endPosition = packet.getPosition();
                packet.setPosition(nullBitsPosition);
                packet.writeBytesNoNull(nullBitsBuffer);
                packet.setPosition(endPosition);
                long begin = 0L;
                boolean gatherPerformanceMetrics = (Boolean)this.gatherPerfMetrics.getValue();
                if (this.profileSQL || this.logSlowQueries || gatherPerformanceMetrics) {
                    begin = this.session.getCurrentTimeNanosOrMillis();
                }
                this.resetCancelledState();
                TimerTask timeoutTask = null;
                try {
                    ResultSetInternalMethods interceptedResults2;
                    if (this.connection.getPropertySet().getBooleanReadableProperty("enableQueryTimeouts").getValue().booleanValue() && this.timeoutInMillis != 0) {
                        timeoutTask = new StatementImpl.CancelTask(this, this);
                        this.connection.getCancelTimer().schedule(timeoutTask, this.timeoutInMillis);
                    }
                    this.statementBegins();
                    Buffer resultPacket = this.session.sendCommand(23, null, packet, false, null, 0);
                    long queryEndTime = 0L;
                    if (this.logSlowQueries || gatherPerformanceMetrics || this.profileSQL) {
                        queryEndTime = this.session.getCurrentTimeNanosOrMillis();
                    }
                    if (timeoutTask != null) {
                        timeoutTask.cancel();
                        this.connection.getCancelTimer().purge();
                        if (((StatementImpl.CancelTask)timeoutTask).caughtWhileCancelling != null) {
                            throw ((StatementImpl.CancelTask)timeoutTask).caughtWhileCancelling;
                        }
                        timeoutTask = null;
                    }
                    Object object2 = this.cancelTimeoutMutex;
                    synchronized (object2) {
                        if (this.wasCancelled) {
                            SQLException cause = null;
                            cause = this.wasCancelledByTimeout ? new MySQLTimeoutException() : new MySQLStatementCancelledException();
                            this.resetCancelledState();
                            throw cause;
                        }
                    }
                    boolean queryWasSlow = false;
                    if (this.logSlowQueries || gatherPerformanceMetrics) {
                        long elapsedTime = queryEndTime - begin;
                        if (this.logSlowQueries) {
                            if (this.useAutoSlowLog) {
                                queryWasSlow = elapsedTime > (long)((Integer)this.slowQueryThresholdMillis.getValue()).intValue();
                            } else {
                                queryWasSlow = this.connection.isAbonormallyLongQuery(elapsedTime);
                                this.connection.reportQueryTime(elapsedTime);
                            }
                        }
                        if (queryWasSlow) {
                            StringBuilder mesgBuf = new StringBuilder(48 + this.originalSql.length());
                            mesgBuf.append(Messages.getString("ServerPreparedStatement.15"));
                            mesgBuf.append(this.session.getSlowQueryThreshold());
                            mesgBuf.append(Messages.getString("ServerPreparedStatement.15a"));
                            mesgBuf.append(elapsedTime);
                            mesgBuf.append(Messages.getString("ServerPreparedStatement.16"));
                            mesgBuf.append("as prepared: ");
                            mesgBuf.append(this.originalSql);
                            mesgBuf.append("\n\n with parameters bound:\n\n");
                            mesgBuf.append(this.asSql(true));
                            this.eventSink.consumeEvent(new ProfilerEventImpl(6, "", this.currentCatalog, this.connection.getId(), this.getId(), 0, System.currentTimeMillis(), elapsedTime, this.session.getQueryTimingUnits(), null, LogUtils.findCallingClassAndMethod(new Throwable()), mesgBuf.toString()));
                        }
                        if (gatherPerformanceMetrics) {
                            this.connection.registerQueryExecutionTime(elapsedTime);
                        }
                    }
                    this.connection.incrementNumberOfPreparedExecutes();
                    if (this.profileSQL) {
                        this.eventSink = ProfilerEventHandlerFactory.getInstance(this.connection);
                        this.eventSink.consumeEvent(new ProfilerEventImpl(4, "", this.currentCatalog, this.connectionId, this.statementId, -1, System.currentTimeMillis(), this.session.getCurrentTimeNanosOrMillis() - begin, this.session.getQueryTimingUnits(), null, LogUtils.findCallingClassAndMethod(new Throwable()), this.truncateQueryToLog(this.asSql(true))));
                    }
                    ResultSetInternalMethods rs = this.session.getResultsHandler().readAllResults(this, maxRowsToRetrieve, this.resultSetType, this.resultSetConcurrency, createStreamingResultSet, this.currentCatalog, resultPacket, true, this.fieldCount, metadataFromCache);
                    if (this.session.shouldIntercept() && (interceptedResults2 = this.session.invokeStatementInterceptorsPost(this.originalSql, this, rs, true, null)) != null) {
                        rs = interceptedResults2;
                    }
                    if (this.profileSQL) {
                        long fetchEndTime = this.session.getCurrentTimeNanosOrMillis();
                        this.eventSink.consumeEvent(new ProfilerEventImpl(5, "", this.currentCatalog, this.connection.getId(), this.getId(), 0, System.currentTimeMillis(), fetchEndTime - queryEndTime, this.session.getQueryTimingUnits(), null, LogUtils.findCallingClassAndMethod(new Throwable()), null));
                    }
                    if (queryWasSlow && ((Boolean)this.explainSlowQueries.getValue()).booleanValue()) {
                        String queryAsString = this.asSql(true);
                        this.session.explainSlowQuery(StringUtils.getBytes(queryAsString), queryAsString);
                    }
                    this.sendTypesToServer = false;
                    this.results = rs;
                    if (this.session.hadWarnings()) {
                        this.session.getResultsHandler().scanForAndThrowDataTruncation();
                    }
                    ResultSetInternalMethods resultSetInternalMethods = rs;
                    return resultSetInternalMethods;
                }
                catch (CJException | SQLException sqlEx) {
                    if (this.session.shouldIntercept()) {
                        this.session.invokeStatementInterceptorsPost(this.originalSql, this, null, true, sqlEx);
                    }
                    throw sqlEx;
                }
                finally {
                    this.statementExecuting.set(false);
                    if (timeoutTask != null) {
                        timeoutTask.cancel();
                        this.connection.getCancelTimer().purge();
                    }
                }
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverLongData(int parameterIndex, BindValue longData) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                Buffer packet = this.session.getSharedSendPacket();
                Object value = longData.value;
                if (value instanceof byte[]) {
                    packet.writeByte((byte)24);
                    packet.writeLong(this.serverStatementId);
                    packet.writeInt(parameterIndex);
                    packet.writeBytesNoNull((byte[])longData.value);
                    this.session.sendCommand(24, null, packet, true, null, 0);
                } else if (value instanceof InputStream) {
                    this.storeStream(parameterIndex, packet, (InputStream)value);
                } else if (value instanceof Blob) {
                    this.storeStream(parameterIndex, packet, ((Blob)value).getBinaryStream());
                } else if (value instanceof Reader) {
                    this.storeReader(parameterIndex, packet, (Reader)value);
                } else {
                    throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.18") + value.getClass().getName() + "'", "S1009", this.getExceptionInterceptor());
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverPrepare(String sql) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (((Boolean)this.autoGenerateTestcaseScript.getValue()).booleanValue()) {
                    this.dumpPrepareForTestcase();
                }
                try {
                    int i;
                    long begin = 0L;
                    this.isLoadDataQuery = StringUtils.startsWithIgnoreCaseAndWs(sql, "LOAD DATA");
                    if (this.profileSQL) {
                        begin = System.currentTimeMillis();
                    }
                    String characterEncoding = null;
                    String connectionEncoding = this.session.getPropertySet().getStringReadableProperty("characterEncoding").getValue();
                    if (!this.isLoadDataQuery && connectionEncoding != null) {
                        characterEncoding = connectionEncoding;
                    }
                    Buffer prepareResultPacket = this.session.sendCommand(22, sql, null, false, characterEncoding, 0);
                    prepareResultPacket.setPosition(1);
                    this.serverStatementId = prepareResultPacket.readLong();
                    this.fieldCount = prepareResultPacket.readInt();
                    this.parameterCount = prepareResultPacket.readInt();
                    this.parameterBindings = new BindValue[this.parameterCount];
                    for (int i2 = 0; i2 < this.parameterCount; ++i2) {
                        this.parameterBindings[i2] = new BindValue();
                    }
                    this.connection.incrementNumberOfPrepares();
                    if (this.profileSQL) {
                        this.eventSink.consumeEvent(new ProfilerEventImpl(2, "", this.currentCatalog, this.connectionId, this.statementId, -1, System.currentTimeMillis(), this.session.getCurrentTimeNanosOrMillis() - begin, this.session.getQueryTimingUnits(), null, LogUtils.findCallingClassAndMethod(new Throwable()), this.truncateQueryToLog(sql)));
                    }
                    if (this.parameterCount > 0) {
                        this.parameterFields = new Field[this.parameterCount];
                        Buffer metaDataPacket = this.session.readPacket();
                        i = 0;
                        while (!metaDataPacket.isLastDataPacket() && i < this.parameterCount) {
                            this.parameterFields[i++] = this.session.getResultsHandler().unpackField(metaDataPacket, this.connection.getCharacterSetMetadata());
                            metaDataPacket = this.session.readPacket();
                        }
                    }
                    if (this.fieldCount > 0) {
                        this.resultFields = new Field[this.fieldCount];
                        Buffer fieldPacket = this.session.readPacket();
                        i = 0;
                        while (!fieldPacket.isLastDataPacket() && i < this.fieldCount) {
                            this.resultFields[i++] = this.session.getResultsHandler().unpackField(fieldPacket, this.connection.getCharacterSetMetadata());
                            fieldPacket = this.session.readPacket();
                        }
                    }
                }
                catch (CJException | SQLException sqlEx) {
                    SQLException ex;
                    SQLException sQLException = ex = sqlEx instanceof SQLException ? (SQLException)sqlEx : SQLExceptionsMapping.translateException(sqlEx);
                    if (((Boolean)this.dumpQueriesOnException.getValue()).booleanValue()) {
                        StringBuilder messageBuf = new StringBuilder(this.originalSql.length() + 32);
                        messageBuf.append("\n\nQuery being prepared when exception was thrown:\n\n");
                        messageBuf.append(this.originalSql);
                        ex = ConnectionImpl.appendMessageToException(ex, messageBuf.toString(), this.getExceptionInterceptor());
                    }
                    throw ex;
                }
                finally {
                    this.session.clearInputStream();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String truncateQueryToLog(String sql) throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            String query = null;
            int maxQuerySizeToLog = this.session.getPropertySet().getIntegerReadableProperty("maxQuerySizeToLog").getValue();
            if (sql.length() > maxQuerySizeToLog) {
                StringBuilder queryBuf = new StringBuilder(maxQuerySizeToLog + 12);
                queryBuf.append(sql.substring(0, maxQuerySizeToLog));
                queryBuf.append(Messages.getString("MysqlIO.25"));
                query = queryBuf.toString();
            } else {
                query = sql;
            }
            return query;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverResetStatement() {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                Buffer packet = this.session.getSharedSendPacket();
                packet.writeByte((byte)26);
                packet.writeLong(this.serverStatementId);
                try {
                    this.session.sendCommand(26, null, packet, false, null, 0);
                }
                finally {
                    this.session.clearInputStream();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (x == null) {
                    this.setNull(parameterIndex, MysqlType.BINARY);
                } else {
                    BindValue binding = this.getBinding(parameterIndex, true);
                    this.setType(binding, 252);
                    binding.value = x;
                    binding.isNull = false;
                    binding.isLongData = true;
                    binding.bindLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? (long)length : -1L;
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (x == null) {
                    this.setNull(parameterIndex, MysqlType.DECIMAL);
                } else {
                    BindValue binding = this.getBinding(parameterIndex, false);
                    this.setType(binding, 246);
                    binding.value = StringUtils.fixDecimalExponent(x.toPlainString());
                    binding.isNull = false;
                    binding.isLongData = false;
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (x == null) {
                    this.setNull(parameterIndex, MysqlType.BINARY);
                } else {
                    BindValue binding = this.getBinding(parameterIndex, true);
                    this.setType(binding, 252);
                    binding.value = x;
                    binding.isNull = false;
                    binding.isLongData = true;
                    binding.bindLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? (long)length : -1L;
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (x == null) {
                    this.setNull(parameterIndex, MysqlType.BINARY);
                } else {
                    BindValue binding = this.getBinding(parameterIndex, true);
                    this.setType(binding, 252);
                    binding.value = x;
                    binding.isNull = false;
                    binding.isLongData = true;
                    binding.bindLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? x.length() : -1L;
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            this.setByte(parameterIndex, x ? (byte)1 : 0);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            this.checkClosed();
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 1);
            binding.value = null;
            binding.longBinding = x;
            binding.isNull = false;
            binding.isLongData = false;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            this.checkClosed();
            if (x == null) {
                this.setNull(parameterIndex, MysqlType.BINARY);
            } else {
                BindValue binding = this.getBinding(parameterIndex, false);
                this.setType(binding, 253);
                binding.value = x;
                binding.isNull = false;
                binding.isLongData = false;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (reader == null) {
                    this.setNull(parameterIndex, MysqlType.BINARY);
                } else {
                    BindValue binding = this.getBinding(parameterIndex, true);
                    this.setType(binding, 252);
                    binding.value = reader;
                    binding.isNull = false;
                    binding.isLongData = true;
                    binding.bindLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? (long)length : -1L;
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (x == null) {
                    this.setNull(parameterIndex, MysqlType.BINARY);
                } else {
                    BindValue binding = this.getBinding(parameterIndex, true);
                    this.setType(binding, 252);
                    binding.value = x.getCharacterStream();
                    binding.isNull = false;
                    binding.isLongData = true;
                    binding.bindLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? x.length() : -1L;
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.setDateInternal(parameterIndex, x, this.session.getDefaultTimeZone());
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.setDateInternal(parameterIndex, x, cal.getTimeZone());
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void setDateInternal(int parameterIndex, Date x, TimeZone tz) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MysqlType.DATE);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 10);
            binding.value = x;
            binding.tz = tz;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (!this.session.getPropertySet().getBooleanReadableProperty("allowNanAndInf").getValue().booleanValue() && (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY || Double.isNaN(x))) {
                    throw SQLError.createSQLException(Messages.getString("PreparedStatement.64", new Object[]{x}), "S1009", this.getExceptionInterceptor());
                }
                BindValue binding = this.getBinding(parameterIndex, false);
                this.setType(binding, 5);
                binding.value = null;
                binding.doubleBinding = x;
                binding.isNull = false;
                binding.isLongData = false;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            this.checkClosed();
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 4);
            binding.value = null;
            binding.floatBinding = x;
            binding.isNull = false;
            binding.isLongData = false;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            this.checkClosed();
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 3);
            binding.value = null;
            binding.longBinding = x;
            binding.isNull = false;
            binding.isLongData = false;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            this.checkClosed();
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 8);
            binding.value = null;
            binding.longBinding = x;
            binding.isNull = false;
            binding.isLongData = false;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this.checkClosed();
            BindValue binding = this.getBinding(parameterIndex, false);
            if (binding.bufferType == 0) {
                this.setType(binding, 6);
            }
            binding.value = null;
            binding.isNull = true;
            binding.isLongData = false;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            this.checkClosed();
            BindValue binding = this.getBinding(parameterIndex, false);
            if (binding.bufferType == 0) {
                this.setType(binding, 6);
            }
            binding.value = null;
            binding.isNull = true;
            binding.isLongData = false;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            this.checkClosed();
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 2);
            binding.value = null;
            binding.longBinding = x;
            binding.isNull = false;
            binding.isLongData = false;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            this.checkClosed();
            if (x == null) {
                this.setNull(parameterIndex, MysqlType.VARCHAR);
            } else {
                BindValue binding = this.getBinding(parameterIndex, false);
                this.setType(binding, 253);
                binding.value = x;
                binding.isNull = false;
                binding.isLongData = false;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.setTimeInternal(parameterIndex, x, this.session.getDefaultTimeZone());
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.setTimeInternal(parameterIndex, x, cal.getTimeZone());
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void setTimeInternal(int parameterIndex, Time x, TimeZone tz) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MysqlType.TIME);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 11);
            binding.value = x;
            binding.tz = tz;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.setTimestampInternal(parameterIndex, x, this.session.getDefaultTimeZone());
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.setTimestampInternal(parameterIndex, x, cal.getTimeZone());
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void setTimestampInternal(int parameterIndex, Timestamp x, TimeZone tz) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, MysqlType.TIMESTAMP);
        } else {
            BindValue binding = this.getBinding(parameterIndex, false);
            this.setType(binding, 12);
            if (!((Boolean)this.sendFractionalSeconds.getValue()).booleanValue()) {
                x = TimeUtil.truncateFractionalSeconds(x);
            }
            binding.value = x;
            binding.tz = tz;
            binding.isNull = false;
            binding.isLongData = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setType(BindValue oldValue, int bufferType) throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            if (oldValue.bufferType != bufferType) {
                this.sendTypesToServer = true;
            }
            oldValue.bufferType = bufferType;
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.checkClosed();
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        try {
            this.checkClosed();
            this.setString(parameterIndex, x.toString());
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBinding(Buffer packet, BindValue bindValue) throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            try {
                Object value = bindValue.value;
                switch (bindValue.bufferType) {
                    case 1: {
                        packet.writeByte((byte)bindValue.longBinding);
                        return;
                    }
                    case 2: {
                        packet.ensureCapacity(2);
                        packet.writeInt((int)bindValue.longBinding);
                        return;
                    }
                    case 3: {
                        packet.ensureCapacity(4);
                        packet.writeLong((int)bindValue.longBinding);
                        return;
                    }
                    case 8: {
                        packet.ensureCapacity(8);
                        packet.writeLongLong(bindValue.longBinding);
                        return;
                    }
                    case 4: {
                        packet.ensureCapacity(4);
                        packet.writeFloat(bindValue.floatBinding);
                        return;
                    }
                    case 5: {
                        packet.ensureCapacity(8);
                        packet.writeDouble(bindValue.doubleBinding);
                        return;
                    }
                    case 11: {
                        this.storeTime(packet, (Time)value, bindValue.tz);
                        return;
                    }
                    case 7: 
                    case 10: 
                    case 12: {
                        this.storeDateTime(packet, (java.util.Date)value, bindValue.tz, bindValue.bufferType);
                        return;
                    }
                    case 0: 
                    case 15: 
                    case 246: 
                    case 253: 
                    case 254: {
                        if (value instanceof byte[]) {
                            packet.writeLenBytes((byte[])value);
                        } else if (!this.isLoadDataQuery) {
                            packet.writeLenString((String)value, this.charEncoding);
                        } else {
                            packet.writeLenBytes(StringUtils.getBytes((String)value));
                        }
                        return;
                    }
                }
            }
            catch (CJException | SQLException uEE) {
                throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.22") + this.session.getPropertySet().getStringReadableProperty("characterEncoding").getValue() + "'", "S1000", uEE, this.getExceptionInterceptor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDateTime(Buffer intoBuf, java.util.Date dt, TimeZone tz, int bufferType) throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            Calendar cal = Calendar.getInstance(tz);
            cal.setTime(dt);
            if (dt instanceof Date) {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
            }
            byte length = 7;
            if (dt instanceof Timestamp) {
                length = 11;
            }
            intoBuf.ensureCapacity(length);
            intoBuf.writeByte(length);
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            int date = cal.get(5);
            intoBuf.writeInt(year);
            intoBuf.writeByte((byte)month);
            intoBuf.writeByte((byte)date);
            if (dt instanceof Date) {
                intoBuf.writeByte((byte)0);
                intoBuf.writeByte((byte)0);
                intoBuf.writeByte((byte)0);
            } else {
                intoBuf.writeByte((byte)cal.get(11));
                intoBuf.writeByte((byte)cal.get(12));
                intoBuf.writeByte((byte)cal.get(13));
            }
            if (length == 11) {
                intoBuf.writeLong(((Timestamp)dt).getNanos() / 1000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeReader(int parameterIndex, Buffer packet, Reader inStream) throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            String forcedEncoding = this.session.getPropertySet().getStringReadableProperty("clobCharacterEncoding").getStringValue();
            String clobEncoding = forcedEncoding == null ? this.session.getPropertySet().getStringReadableProperty("characterEncoding").getValue() : forcedEncoding;
            int maxBytesChar = 2;
            if (clobEncoding != null) {
                if (!clobEncoding.equals("UTF-16")) {
                    maxBytesChar = this.session.getMaxBytesPerChar(clobEncoding);
                    if (maxBytesChar == 1) {
                        maxBytesChar = 2;
                    }
                } else {
                    maxBytesChar = 4;
                }
            }
            char[] buf = new char[8192 / maxBytesChar];
            int numRead = 0;
            int bytesInPacket = 0;
            int totalBytesRead = 0;
            int bytesReadAtLastSend = 0;
            int packetIsFullAt = this.session.getPropertySet().getMemorySizeReadableProperty("blobSendChunkSize").getValue();
            try {
                packet.clear();
                packet.setPosition(0);
                packet.writeByte((byte)24);
                packet.writeLong(this.serverStatementId);
                packet.writeInt(parameterIndex);
                boolean readAny = false;
                while ((numRead = inStream.read(buf)) != -1) {
                    readAny = true;
                    byte[] valueAsBytes = StringUtils.getBytes(buf, 0, numRead, clobEncoding);
                    packet.writeBytesNoNull(valueAsBytes, 0, valueAsBytes.length);
                    totalBytesRead += valueAsBytes.length;
                    if ((bytesInPacket += valueAsBytes.length) < packetIsFullAt) continue;
                    bytesReadAtLastSend = totalBytesRead;
                    this.session.sendCommand(24, null, packet, true, null, 0);
                    bytesInPacket = 0;
                    packet.clear();
                    packet.setPosition(0);
                    packet.writeByte((byte)24);
                    packet.writeLong(this.serverStatementId);
                    packet.writeInt(parameterIndex);
                }
                if (totalBytesRead != bytesReadAtLastSend) {
                    this.session.sendCommand(24, null, packet, true, null, 0);
                }
                if (!readAny) {
                    this.session.sendCommand(24, null, packet, true, null, 0);
                }
            }
            catch (IOException ioEx) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("ServerPreparedStatement.24") + ioEx.toString(), "S1000", this.getExceptionInterceptor());
                sqlEx.initCause(ioEx);
                throw sqlEx;
            }
            finally {
                if (((Boolean)this.autoClosePStmtStreams.getValue()).booleanValue() && inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeStream(int parameterIndex, Buffer packet, InputStream inStream) throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            byte[] buf = new byte[8192];
            int numRead = 0;
            try {
                int bytesInPacket = 0;
                int totalBytesRead = 0;
                int bytesReadAtLastSend = 0;
                int packetIsFullAt = this.session.getPropertySet().getMemorySizeReadableProperty("blobSendChunkSize").getValue();
                packet.clear();
                packet.setPosition(0);
                packet.writeByte((byte)24);
                packet.writeLong(this.serverStatementId);
                packet.writeInt(parameterIndex);
                boolean readAny = false;
                while ((numRead = inStream.read(buf)) != -1) {
                    readAny = true;
                    packet.writeBytesNoNull(buf, 0, numRead);
                    totalBytesRead += numRead;
                    if ((bytesInPacket += numRead) < packetIsFullAt) continue;
                    bytesReadAtLastSend = totalBytesRead;
                    this.session.sendCommand(24, null, packet, true, null, 0);
                    bytesInPacket = 0;
                    packet.clear();
                    packet.setPosition(0);
                    packet.writeByte((byte)24);
                    packet.writeLong(this.serverStatementId);
                    packet.writeInt(parameterIndex);
                }
                if (totalBytesRead != bytesReadAtLastSend) {
                    this.session.sendCommand(24, null, packet, true, null, 0);
                }
                if (!readAny) {
                    this.session.sendCommand(24, null, packet, true, null, 0);
                }
            }
            catch (IOException ioEx) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("ServerPreparedStatement.25") + ioEx.toString(), "S1000", this.getExceptionInterceptor());
                sqlEx.initCause(ioEx);
                throw sqlEx;
            }
            finally {
                if (((Boolean)this.autoClosePStmtStreams.getValue()).booleanValue() && inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder toStringBuf = new StringBuilder();
        toStringBuf.append("com.mysql.cj.jdbc.ServerPreparedStatement[");
        toStringBuf.append(this.serverStatementId);
        toStringBuf.append("] - ");
        try {
            toStringBuf.append(this.asSql());
        }
        catch (SQLException sqlEx) {
            toStringBuf.append(Messages.getString("ServerPreparedStatement.6"));
            toStringBuf.append(sqlEx);
        }
        return toStringBuf.toString();
    }

    protected long getServerStatementId() {
        return this.serverStatementId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canRewriteAsMultiValueInsertAtSqlLevel() throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            if (!this.hasCheckedRewrite) {
                this.hasCheckedRewrite = true;
                this.canRewrite = ServerPreparedStatement.canRewrite(this.originalSql, this.isOnDuplicateKeyUpdate(), this.getLocationOfOnDuplicateKeyUpdate(), 0);
                this.parseInfo = new PreparedStatement.ParseInfo(this.originalSql, this.connection, this.connection.getMetaData(), this.charEncoding);
            }
            return this.canRewrite;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRewriteAsMultivalueInsertStatement() throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            if (!this.canRewriteAsMultiValueInsertAtSqlLevel()) {
                return false;
            }
            BindValue[] currentBindValues = null;
            Object previousBindValues = null;
            int nbrCommands = this.batchedArgs.size();
            for (int commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                Object arg = this.batchedArgs.get(commandIndex);
                if (arg instanceof String) continue;
                currentBindValues = ((BatchedBindValues)arg).batchedParameterValues;
                if (previousBindValues == null) continue;
                for (int j = 0; j < this.parameterBindings.length; ++j) {
                    if (currentBindValues[j].bufferType == previousBindValues[j].bufferType) continue;
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getLocationOfOnDuplicateKeyUpdate() throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            if (this.locationOfOnDuplicateKeyUpdate == -2) {
                this.locationOfOnDuplicateKeyUpdate = ServerPreparedStatement.getOnDuplicateKeyLocation(this.originalSql, this.dontCheckOnDuplicateKeyUpdateInSQL, (Boolean)this.rewriteBatchedStatements.getValue(), this.connection.isNoBackslashEscapesSet());
            }
            return this.locationOfOnDuplicateKeyUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOnDuplicateKeyUpdate() throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            return this.getLocationOfOnDuplicateKeyUpdate() != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long[] computeMaxParameterSetSizeAndBatchSize(int numBatchedArgs) throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            long sizeOfEntireBatch = 10L;
            long maxSizeOfParameterSet = 0L;
            for (int i = 0; i < numBatchedArgs; ++i) {
                BindValue[] paramArg = ((BatchedBindValues)this.batchedArgs.get((int)i)).batchedParameterValues;
                long sizeOfParameterSet = 0L;
                sizeOfParameterSet += (long)((this.parameterCount + 7) / 8);
                sizeOfParameterSet += (long)(this.parameterCount * 2);
                for (int j = 0; j < this.parameterBindings.length; ++j) {
                    if (paramArg[j].isNull) continue;
                    long size = paramArg[j].getBoundLength();
                    if (paramArg[j].isLongData) {
                        if (size == -1L) continue;
                        sizeOfParameterSet += size;
                        continue;
                    }
                    sizeOfParameterSet += size;
                }
                sizeOfEntireBatch += sizeOfParameterSet;
                if (sizeOfParameterSet <= maxSizeOfParameterSet) continue;
                maxSizeOfParameterSet = sizeOfParameterSet;
            }
            return new long[]{maxSizeOfParameterSet, sizeOfEntireBatch};
        }
    }

    @Override
    protected int setOneBatchedParameterSet(java.sql.PreparedStatement batchedStatement, int batchedParamIndex, Object paramSet) throws SQLException {
        BindValue[] paramArg = ((BatchedBindValues)paramSet).batchedParameterValues;
        block12: for (int j = 0; j < paramArg.length; ++j) {
            Object value;
            if (paramArg[j].isNull) {
                batchedStatement.setNull(batchedParamIndex++, MysqlType.NULL.getJdbcType());
                continue;
            }
            if (paramArg[j].isLongData) {
                value = paramArg[j].value;
                if (value instanceof InputStream) {
                    batchedStatement.setBinaryStream(batchedParamIndex++, (InputStream)value, (int)paramArg[j].bindLength);
                    continue;
                }
                batchedStatement.setCharacterStream(batchedParamIndex++, (Reader)value, (int)paramArg[j].bindLength);
                continue;
            }
            switch (paramArg[j].bufferType) {
                case 1: {
                    batchedStatement.setByte(batchedParamIndex++, (byte)paramArg[j].longBinding);
                    continue block12;
                }
                case 2: {
                    batchedStatement.setShort(batchedParamIndex++, (short)paramArg[j].longBinding);
                    continue block12;
                }
                case 3: {
                    batchedStatement.setInt(batchedParamIndex++, (int)paramArg[j].longBinding);
                    continue block12;
                }
                case 8: {
                    batchedStatement.setLong(batchedParamIndex++, paramArg[j].longBinding);
                    continue block12;
                }
                case 4: {
                    batchedStatement.setFloat(batchedParamIndex++, paramArg[j].floatBinding);
                    continue block12;
                }
                case 5: {
                    batchedStatement.setDouble(batchedParamIndex++, paramArg[j].doubleBinding);
                    continue block12;
                }
                case 11: {
                    batchedStatement.setTime(batchedParamIndex++, (Time)paramArg[j].value);
                    continue block12;
                }
                case 10: {
                    batchedStatement.setDate(batchedParamIndex++, (Date)paramArg[j].value);
                    continue block12;
                }
                case 7: 
                case 12: {
                    batchedStatement.setTimestamp(batchedParamIndex++, (Timestamp)paramArg[j].value);
                    continue block12;
                }
                case 0: 
                case 15: 
                case 246: 
                case 253: 
                case 254: {
                    value = paramArg[j].value;
                    if (value instanceof byte[]) {
                        batchedStatement.setBytes(batchedParamIndex, (byte[])value);
                    } else {
                        batchedStatement.setString(batchedParamIndex, (String)value);
                    }
                    if (batchedStatement instanceof ServerPreparedStatement) {
                        BindValue asBound = ((ServerPreparedStatement)batchedStatement).getBinding(batchedParamIndex, false);
                        asBound.bufferType = paramArg[j].bufferType;
                    }
                    ++batchedParamIndex;
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException(Messages.getString("ServerPreparedStatement.26", new Object[]{batchedParamIndex}));
                }
            }
        }
        return batchedParamIndex;
    }

    @Override
    protected boolean containsOnDuplicateKeyUpdateInSQL() {
        return this.hasOnDuplicateKeyUpdate;
    }

    @Override
    protected PreparedStatement prepareBatchedInsertSQL(JdbcConnection localConn, int numBatches) throws SQLException {
        Object object = this.checkClosed().getConnectionMutex();
        synchronized (object) {
            try {
                ServerPreparedStatement pstmt = new ServerPreparedStatement(localConn, this.parseInfo.getSqlForBatch(numBatches), this.currentCatalog, this.resultSetConcurrency, this.resultSetType);
                pstmt.setRetrieveGeneratedKeys(this.retrieveGeneratedKeys);
                return pstmt;
            }
            catch (UnsupportedEncodingException e) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("ServerPreparedStatement.27"), "S1000", this.getExceptionInterceptor());
                sqlEx.initCause(e);
                throw sqlEx;
            }
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            if (!this.charEncoding.equalsIgnoreCase("UTF-8") && !this.charEncoding.equalsIgnoreCase("utf8")) {
                throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.28"), this.getExceptionInterceptor());
            }
            this.checkClosed();
            if (reader == null) {
                this.setNull(parameterIndex, MysqlType.BINARY);
            } else {
                BindValue binding = this.getBinding(parameterIndex, true);
                this.setType(binding, 252);
                binding.value = reader;
                binding.isNull = false;
                binding.isLongData = true;
                binding.bindLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? length : -1L;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        try {
            this.setNClob(parameterIndex, x.getCharacterStream(), (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? x.length() : -1L);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            if (!this.charEncoding.equalsIgnoreCase("UTF-8") && !this.charEncoding.equalsIgnoreCase("utf8")) {
                throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.29"), this.getExceptionInterceptor());
            }
            this.checkClosed();
            if (reader == null) {
                this.setNull(parameterIndex, MysqlType.TEXT);
            } else {
                BindValue binding = this.getBinding(parameterIndex, true);
                this.setType(binding, 252);
                binding.value = reader;
                binding.isNull = false;
                binding.isLongData = true;
                binding.bindLength = (Boolean)this.useStreamLengthsInPrepStmts.getValue() != false ? length : -1L;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        try {
            if (!this.charEncoding.equalsIgnoreCase("UTF-8") && !this.charEncoding.equalsIgnoreCase("utf8")) {
                throw SQLError.createSQLException(Messages.getString("ServerPreparedStatement.30"), this.getExceptionInterceptor());
            }
            this.setString(parameterIndex, x);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        try {
            super.setSQLXML(parameterIndex, xmlObject);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    public static class BindValue {
        public long boundBeforeExecutionNum = 0L;
        public long bindLength;
        public int bufferType;
        public double doubleBinding;
        public float floatBinding;
        public boolean isLongData;
        public boolean isNull;
        public boolean isSet = false;
        public long longBinding;
        public Object value;
        public TimeZone tz;

        BindValue() {
        }

        BindValue(BindValue copyMe) {
            this.value = copyMe.value;
            this.isSet = copyMe.isSet;
            this.isLongData = copyMe.isLongData;
            this.isNull = copyMe.isNull;
            this.bufferType = copyMe.bufferType;
            this.bindLength = copyMe.bindLength;
            this.longBinding = copyMe.longBinding;
            this.floatBinding = copyMe.floatBinding;
            this.doubleBinding = copyMe.doubleBinding;
            this.tz = copyMe.tz;
        }

        void reset() {
            this.isSet = false;
            this.value = null;
            this.isLongData = false;
            this.longBinding = 0L;
            this.floatBinding = 0.0f;
            this.doubleBinding = 0.0;
            this.tz = null;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean quoteIfNeeded) {
            if (this.isLongData) {
                return "' STREAM DATA '";
            }
            switch (this.bufferType) {
                case 1: 
                case 2: 
                case 3: 
                case 8: {
                    return String.valueOf(this.longBinding);
                }
                case 4: {
                    return String.valueOf(this.floatBinding);
                }
                case 5: {
                    return String.valueOf(this.doubleBinding);
                }
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 15: 
                case 253: 
                case 254: {
                    if (quoteIfNeeded) {
                        return "'" + String.valueOf(this.value) + "'";
                    }
                    return String.valueOf(this.value);
                }
            }
            if (this.value instanceof byte[]) {
                return "byte data";
            }
            if (quoteIfNeeded) {
                return "'" + String.valueOf(this.value) + "'";
            }
            return String.valueOf(this.value);
        }

        long getBoundLength() {
            if (this.isNull) {
                return 0L;
            }
            if (this.isLongData) {
                return this.bindLength;
            }
            switch (this.bufferType) {
                case 1: {
                    return 1L;
                }
                case 2: {
                    return 2L;
                }
                case 3: {
                    return 4L;
                }
                case 8: {
                    return 8L;
                }
                case 4: {
                    return 4L;
                }
                case 5: {
                    return 8L;
                }
                case 11: {
                    return 9L;
                }
                case 10: {
                    return 7L;
                }
                case 7: 
                case 12: {
                    return 11L;
                }
                case 0: 
                case 15: 
                case 246: 
                case 253: 
                case 254: {
                    if (this.value instanceof byte[]) {
                        return ((byte[])this.value).length;
                    }
                    return ((String)this.value).length();
                }
            }
            return 0L;
        }
    }

    public static class BatchedBindValues {
        public BindValue[] batchedParameterValues;

        BatchedBindValues(BindValue[] paramVals) {
            int numParams = paramVals.length;
            this.batchedParameterValues = new BindValue[numParams];
            for (int i = 0; i < numParams; ++i) {
                this.batchedParameterValues[i] = new BindValue(paramVals[i]);
            }
        }
    }
}

