/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.model.Actor;
import com.servergeneral.sgkms.model.Policy;
import com.servergeneral.sgkms.util.FileUtil;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.GridPane;
import javafx.stage.Window;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataAdministrators
extends Dialog<Void>
implements Initializable {
    @FXML
    private Label fxTitleApp;
    @FXML
    private Hyperlink btnExit;
    @FXML
    private TableView<Actor> tableView;
    @FXML
    private TableColumn<Actor, String> nameColumn;
    @FXML
    private TableColumn<Actor, String> creationColumn;
    @FXML
    private TableColumn<Actor, String> statusColumn;
    @FXML
    private TableColumn<Actor, String> resposabilityColumn;
    @FXML
    private TableColumn<Actor, String> rotationColumn;
    @FXML
    private TableColumn<Actor, String> emailColumn;
    private static final Logger logger = LogManager.getLogger();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
    private final SimpleDateFormat reportFormat = new SimpleDateFormat("yyyy-MMM-dd");

    public void initialize(URL url, ResourceBundle rb) {
        this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.nameColumn.setCellValueFactory(cellData -> ((Actor)cellData.getValue()).getName());
        this.creationColumn.setCellValueFactory(cellData -> ((Actor)cellData.getValue()).getCreated());
        this.creationColumn.setStyle("-fx-alignment: CENTER;");
        this.statusColumn.setCellValueFactory(cellData -> ((Actor)cellData.getValue()).getStatus());
        this.statusColumn.setStyle("-fx-alignment: CENTER;");
        this.resposabilityColumn.setCellValueFactory(cellData -> ((Actor)cellData.getValue()).getResponsible());
        this.rotationColumn.setCellValueFactory(cellData -> ((Actor)cellData.getValue()).getRotated());
        this.rotationColumn.setStyle("-fx-alignment: CENTER;");
        this.emailColumn.setCellValueFactory(cellData -> ((Actor)cellData.getValue()).getEmail());
        this.emailColumn.prefWidthProperty().bind((ObservableValue)this.tableView.widthProperty().subtract((ObservableNumberValue)this.creationColumn.widthProperty()).subtract((ObservableNumberValue)this.statusColumn.widthProperty()).subtract((ObservableNumberValue)this.rotationColumn.widthProperty()).subtract((ObservableNumberValue)this.nameColumn.widthProperty()).multiply(0.4));
        this.resposabilityColumn.prefWidthProperty().bind((ObservableValue)this.tableView.widthProperty().subtract((ObservableNumberValue)this.creationColumn.widthProperty()).subtract((ObservableNumberValue)this.statusColumn.widthProperty()).subtract((ObservableNumberValue)this.rotationColumn.widthProperty()).subtract((ObservableNumberValue)this.nameColumn.widthProperty()).subtract((ObservableNumberValue)this.emailColumn.widthProperty()));
        Platform.runLater(() -> this.loadData());
    }

    public DataAdministrators() throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/data-administrators.fxml"), ResourceManager.resourceBundle);
        fxmlLoader.setController((Object)this);
        GridPane layout = (GridPane)fxmlLoader.load();
        this.getDialogPane().setContent((Node)layout);
        this.setResizable(true);
        this.setTitle(ResourceManager.getString("info.dialog.compliance.data-admin.title"));
        Window window = this.getDialogPane().getScene().getWindow();
        window.setOnCloseRequest(event -> window.hide());
        window.sizeToScene();
    }

    @FXML
    private void close(ActionEvent event) {
        this.getDialogPane().getScene().getWindow().hide();
    }

    private void loadData() {
        FileUtil.chown("/etc/serverg/serverg.conf", "sgadmin", "sgadmin");
        ObservableList<Policy> policies = FileUtil.getPolicyList("/etc/serverg/serverg.conf");
        String[] configs = new String[]{"/etc/serverg/da.conf", "/etc/serverg/revoke_da.conf"};
        String[] status = new String[]{"Current", "Revoked"};
        ObservableList<Actor> items = FXCollections.observableArrayList();
        for (int i = 0; i < configs.length; ++i) {
            FileUtil.chown(configs[i], "sgadmin", "sgadmin");
            ObservableList<Actor> admins = FileUtil.getDAList(configs[i], i == 1);
            for (Actor admin : admins) {
                admin.setStatus((StringProperty)new SimpleStringProperty(status[i]));
                if (i < 1) {
                    admin.setResponsible((StringProperty)new SimpleStringProperty(this.getResponsibles(admin, policies)));
                } else {
                    admin.setResponsible((StringProperty)new SimpleStringProperty("N/A"));
                }
                Properties props = null;
                String mkgd = "N/A";
                String mkrd = "Never";
                try {
                    props = FileUtil.loadPropertiesFile("/etc/serverg/sg-tde.properties");
                }
                catch (IOException ex) {
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
                }
                if (props != null) {
                    String fecha;
                    try {
                        fecha = props.getProperty("dmk.gd_" + admin.getId().getValue());
                        mkgd = this.reportFormat.format(new Date(Long.parseLong(fecha)));
                    }
                    catch (Exception ex) {
                        logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + ex.getMessage());
                    }
                    try {
                        fecha = props.getProperty("dmk.rd_" + admin.getId().getValue());
                        mkrd = this.reportFormat.format(new Date(Long.parseLong(fecha)));
                    }
                    catch (Exception ex) {
                        logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + ex.getMessage());
                    }
                }
                if (admin.getCreated() == null) {
                    admin.setCreated((StringProperty)new SimpleStringProperty(mkgd));
                } else {
                    try {
                        admin.setCreated((StringProperty)new SimpleStringProperty(this.reportFormat.format(this.dateFormat.parse(admin.getCreated().getValue()))));
                    }
                    catch (ParseException ex) {
                        admin.setCreated((StringProperty)new SimpleStringProperty("N/A"));
                    }
                }
                if (admin.getRotated() == null) {
                    admin.setRotated((StringProperty)new SimpleStringProperty(mkrd));
                    continue;
                }
                try {
                    admin.setRotated((StringProperty)new SimpleStringProperty(this.reportFormat.format(this.dateFormat.parse(admin.getRotated().getValue()))));
                }
                catch (ParseException ex) {
                    admin.setRotated((StringProperty)new SimpleStringProperty("N/A"));
                }
            }
            if (i == 0) {
                items = admins;
                continue;
            }
            items.addAll(admins);
        }
        this.tableView.setItems((ObservableList)items);
    }

    private String getResponsibles(Actor admin, ObservableList<Policy> policies) {
        String result = "";
        for (Policy p : policies) {
            if (!admin.getId().getValue().equals(p.getDa_id().getValue())) continue;
            result = result + (result.isEmpty() ? "" : ",") + p.getRepo().getValue();
        }
        if (result.isEmpty()) {
            result = "N/A";
        }
        return result;
    }
}

