/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.sgkms.gui.ChangeMKDialog;
import com.servergeneral.sgkms.gui.ComplianceReportDialog;
import com.servergeneral.sgkms.gui.CustomAlert;
import com.servergeneral.sgkms.gui.DataAdministrators;
import com.servergeneral.sgkms.gui.GuiUserData;
import com.servergeneral.sgkms.gui.LogViewerDialog;
import com.servergeneral.sgkms.gui.PasswordDialog;
import com.servergeneral.sgkms.gui.ProtectedDataSet;
import com.servergeneral.sgkms.gui.RevokeReassignDADialog;
import com.servergeneral.sgkms.gui.SecurityStatus;
import com.servergeneral.sgkms.gui.SelectRevokingDA;
import com.servergeneral.sgkms.gui.SgKmsGui;
import com.servergeneral.sgkms.model.Actor;
import com.servergeneral.sgkms.model.Policy;
import com.servergeneral.sgkms.tasks.DACreateTask;
import com.servergeneral.sgkms.tasks.PolicyAddTask;
import com.servergeneral.sgkms.tasks.PolicyEditTask;
import com.servergeneral.sgkms.tasks.TaskEditDA;
import com.servergeneral.sgkms.tasks.TaskEditSO;
import com.servergeneral.sgkms.tasks.TaskPolicyReassign;
import com.servergeneral.sgkms.tasks.TaskRemovePolicy;
import com.servergeneral.sgkms.tasks.TaskRevokeDA;
import com.servergeneral.sgkms.tasks.TaskRevokeReassignDA;
import com.servergeneral.sgkms.tasks.TaskRotateDMK;
import com.servergeneral.sgkms.tasks.TaskRotateSMK;
import com.servergeneral.sgkms.tasks.TaskStartPolicy;
import com.servergeneral.sgkms.tasks.TaskStopPolicy;
import com.servergeneral.sgkms.tasks.TaskUninstall;
import com.servergeneral.sgkms.tasks.TaskUpgradeLicense;
import com.servergeneral.sgkms.util.FileUtil;
import com.servergeneral.sgkms.util.TaskUpdateProgress;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SGKmsOPControllerv2
implements Initializable {
    @FXML
    private Pane pnPolicies;
    @FXML
    private TableView<Policy> tablePolicy;
    @FXML
    private TableColumn<Policy, String> daIDPolicyColumn;
    @FXML
    private TableColumn<Policy, String> policycolumn;
    @FXML
    private TableColumn<Policy, String> statusPolicyColumn;
    @FXML
    private TableColumn<Policy, Boolean> actionsPolicy;
    @FXML
    private Pane pnSGKMS;
    @FXML
    private Button btnRotateSMK;
    @FXML
    private Pane pnDAConfig;
    @FXML
    private TableView<Actor> tableDA;
    @FXML
    private TableColumn<Actor, String> idColumn;
    @FXML
    private TableColumn<Actor, String> NameDAColumn;
    @FXML
    private TableColumn<Actor, Boolean> actionsDA;
    private ObservableList<Actor> dataDA = FXCollections.observableArrayList();
    private ObservableList<Policy> dataPolicy = FXCollections.observableArrayList();
    @FXML
    private Label lblStatusMsg;
    @FXML
    private ProgressBar pbProccess;
    @FXML
    private Label lbStatus;
    @FXML
    private Label lbError;
    @FXML
    private Label fxTitleApp;
    private Task updateProgressTask;
    private static final Logger logger = LogManager.getLogger();
    private Map<String, String> userData;
    final ImageView stopLogProtImg = new ImageView(new Image(this.getClass().getResourceAsStream("/images/stop-protection-logs-menu.png")));
    final ImageView startLogProtImg = new ImageView(new Image(this.getClass().getResourceAsStream("/images/start-protection-logs-menu.png")));
    final ImageView stopMMKProtImg = new ImageView(new Image(this.getClass().getResourceAsStream("/images/stop-protection-mmk-menu.png")));
    final ImageView startMMKProtImg = new ImageView(new Image(this.getClass().getResourceAsStream("/images/start-protection-mmk-menu.png")));
    private SgKmsGui sgKmsGui;
    private Map<String, String> errorsMsgs;
    private List<Integer> pwRequested;
    private GuiUserData fromGuiUserData = new GuiUserData(false);
    private GuiUserData fromTaskUserData = new GuiUserData(true);
    private int updateTaskMessage = 0;
    @FXML
    private MenuButton configMenuBtn;
    private Stage primaryStage;
    @FXML
    private TextField tfShortname;
    @FXML
    private TextField tfAppName;
    @FXML
    private TextField tfAllowedUsers;
    @FXML
    private TextField tfRepo;
    @FXML
    private ComboBox tfDAid;
    @FXML
    private PasswordField tfDAdmk;
    private TextField tfCurrentDA;
    private ComboBox tfnewDA;
    private PasswordField tfSOsmk;
    ObservableList<String> optionsDA = FXCollections.observableArrayList();
    @FXML
    private Pane pnCtrlButtons;
    @FXML
    private Pane pnPolicyForm;
    @FXML
    private ListView listRepo;
    @FXML
    private ListView listAllowedUsers;
    @FXML
    private Label lblTitlePolicyForm;
    private int type = 0;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfDAFirst;
    @FXML
    private TextField tfDALast;
    @FXML
    private TextField tfDAEmail;
    @FXML
    private TextField tfDAPhone;
    @FXML
    private PasswordField tfNewDMK;
    @FXML
    private PasswordField tfRetypedDMK;
    @FXML
    private PasswordField tfCurrSMK;
    @FXML
    private Pane pnlCreateDA;
    @FXML
    private Pane pnCtrlButtonsDA;
    @FXML
    private TextField tfId_dae;
    @FXML
    private TextField tfDAFirst_dae;
    @FXML
    private TextField tfDALast_dae;
    @FXML
    private TextField tfDAEmail_dae;
    @FXML
    private TextField tfDAPhone_dae;
    @FXML
    private PasswordField tfCurrDMK_dae;
    @FXML
    private Pane pnlEditDA;
    @FXML
    private Pane pnControlsDAEdit;
    @FXML
    private TextField tfId_soe;
    @FXML
    private TextField tfDAFirst_soe;
    @FXML
    private TextField tfDALast_soe;
    @FXML
    private TextField tfDAEmail_soe;
    @FXML
    private TextField tfDAPhone_soe;
    @FXML
    private PasswordField tfCurrSMK_soe;
    @FXML
    private Pane pnlEditSO;
    @FXML
    private Pane pnControlsSOE;
    @FXML
    private Pane showDAInforPane;
    @FXML
    private Label Sda_fullname;
    @FXML
    private Label Sda_id;
    @FXML
    private Label Sda_mkgd;
    @FXML
    private Label Sda_mkrd;
    @FXML
    private Label Sda_emailcontact;
    @FXML
    private Label Sda_responsiblefor;
    @FXML
    private Pane showPolicyInforPane;
    @FXML
    private Label Spolicy_name;
    @FXML
    private Label Screation_date;
    @FXML
    private Label Scurrent_status;
    @FXML
    private Label Sauth_users;
    @FXML
    private Label Sdata_admin;
    @FXML
    private Label Sapplication;
    @FXML
    private Label Sproteted_data_paths;
    @FXML
    private Pane showSOInforPane;
    @FXML
    private Label SP_fullname;
    @FXML
    private Label SP_so_id;
    @FXML
    private Label SP_mkgd;
    @FXML
    private Label SP_mkrd;
    @FXML
    private Label SP_email;
    private int indexPolicySelected = -1;
    private int indexDASelected = -1;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
    @FXML
    private MenuItem menuPolicy;
    @FXML
    private MenuItem menuDA;
    @FXML
    private MenuItem menuSGKMS;
    @FXML
    private Hyperlink btnExit;
    @FXML
    private Button btnNewPolicy;
    @FXML
    private ContextMenu PolicyContextMenu;
    @FXML
    private Label lbCurrSMK1;
    @FXML
    private Label lbCurrSMK;
    @FXML
    private Button btnRepoAdd;
    @FXML
    private Button btnSearchPath;
    @FXML
    private ImageView btnFolderSearch;
    @FXML
    private Button btnRemovePath;
    @FXML
    private Button btnAllowedUsers;
    @FXML
    private Button btnRemoveUsers;
    @FXML
    private Button btnNewDA;
    @FXML
    private ContextMenu DAContextMenu;
    @FXML
    private Label lblSOInforPane;
    @FXML
    private Label SP_mk_length;
    @FXML
    private Hyperlink btnBackSO;
    @FXML
    private Label lblPolicyInforPane;
    @FXML
    private Hyperlink btnBackPolicy;
    @FXML
    private Label lblTitleShowDAPane;
    @FXML
    private Hyperlink btnBackDA;
    @FXML
    private Button btnEditSMK;
    @FXML
    private Button btnShowSMK;
    @FXML
    private Button btnUpgradeLicense;
    @FXML
    private Button btnRevokeDA;
    @FXML
    private MenuItem menuReports;
    @FXML
    private Pane pnCompliance;
    @FXML
    private Button btnSecurityStatus;
    @FXML
    private Button btnDataSets;
    @FXML
    private Button btnDataAdmins;
    @FXML
    private Button btnLicenseInfo;
    @FXML
    private MenuItem menuDashboard;
    @FXML
    private Pane pnDashBoard;
    @FXML
    private Button btnPoliciesScreen;
    @FXML
    private Button btnDAScreen;
    @FXML
    private Button btnSOScreen;
    @FXML
    private Button btnReportsSceen;
    @FXML
    private Button btnSGAScreen;
    @FXML
    private Button btnViewAppLogs;
    @FXML
    private Pane pnSGAgent;
    @FXML
    private MenuItem menuSGAgent;
    @FXML
    private Button btnUninstall;
    @FXML
    private Button btnNewDA1;
    @FXML
    private Button btnReassignPolicy;
    private final EventHandler onScheduled = event -> {
        try {
            Platform.runLater(() -> {
                this.pbProccess.setVisible(true);
                this.disabledControls(true);
            });
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.methodName(). " + ex.getMessage());
        }
    };
    private final EventHandler onSucceeded = event -> {
        try {
            Task task;
            logger.log(Level.DEBUG, "## On Succeeded Fired ##");
            Platform.runLater(() -> {
                this.pbProccess.setVisible(false);
                this.disabledControls(false);
            });
            this.updateProgressTask.cancel();
            if (event.getSource() instanceof Task && (task = (Task)event.getSource()).getValue() != null) {
                switch (this.updateTaskMessage) {
                    case 1: {
                        if (this.tablePolicy.getItems() != null && !this.tablePolicy.getItems().isEmpty()) {
                            this.tablePolicy.getItems().clear();
                        }
                        this.setTablePolicy();
                        this.tablePolicy.setItems(this.dataPolicy);
                        break;
                    }
                    case 2: {
                        if (this.tableDA.getItems() != null && !this.tableDA.getItems().isEmpty()) {
                            this.tableDA.getItems().clear();
                        }
                        this.setTableDA();
                        this.tableDA.setItems(this.dataDA);
                        break;
                    }
                    case 3: {
                        this.btnRotateSMK.setDisable(false);
                        break;
                    }
                    case 5: {
                        if (((Boolean)task.getValue()).booleanValue()) {
                            this.handleCancelPolicy();
                            this.lblStatusMsg.setText(ResourceManager.getString("info.policy.create", this.tfShortname.getText()));
                            this.setTablePolicy();
                        }
                        this.pnCtrlButtons.setDisable(false);
                        this.pnPolicyForm.setDisable(false);
                        break;
                    }
                    case 6: {
                        if (((Boolean)task.getValue()).booleanValue()) {
                            this.handleCancelPolicy();
                            this.lblStatusMsg.setText(ResourceManager.getString("info.policy.edit", this.tfShortname.getText()));
                            this.setTablePolicy();
                        }
                        this.pnCtrlButtons.setDisable(false);
                        this.pnPolicyForm.setDisable(false);
                        break;
                    }
                    case 7: {
                        if (((Boolean)task.getValue()).booleanValue()) {
                            this.handleCancelDAForm();
                            this.displayPane(1);
                            this.lblStatusMsg.setText(ResourceManager.getString("info.da.success.create", this.tfId.getText()));
                            this.setTableDA();
                        }
                        this.pnlCreateDA.setDisable(false);
                        this.pnCtrlButtonsDA.setDisable(false);
                        break;
                    }
                    case 8: {
                        if (((Boolean)task.getValue()).booleanValue()) {
                            this.displayPane(1);
                            this.handleCancelDAFormEdit();
                            this.lblStatusMsg.setText(ResourceManager.getString("info.da.success.edit", this.tfId.getText()));
                            this.setTableDA();
                        }
                        this.pnlEditDA.setDisable(false);
                        this.pnControlsDAEdit.setDisable(false);
                        break;
                    }
                    case 9: {
                        if (((Boolean)task.getValue()).booleanValue()) {
                            this.handleCancelSOFormEdit();
                            this.lblStatusMsg.setText(ResourceManager.getString("info.smk.edit", this.tfId.getText()));
                        }
                        this.pnlEditSO.setDisable(false);
                        this.pnControlsSOE.setDisable(false);
                    }
                }
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.methodName(). " + ex.getMessage());
        }
    };

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    public void setPrimaryStage(Stage primaryStage) {
        this.primaryStage = primaryStage;
    }

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.setTableDA();
            this.setTablePolicy();
            this.pwRequested = new ArrayList<Integer>();
            if (this.tableDA.getItems() != null && !this.tableDA.getItems().isEmpty()) {
                SGKms.FixSGAPermissions();
                this.displayPane(11);
                this.fxTitleApp.setText(ResourceManager.getString("label.setup.policy.title"));
            } else {
                this.displayPane(1);
                this.fxTitleApp.setText(ResourceManager.getString("label.setup.da.title"));
            }
            this.btnNewDA.setVisible(false);
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.initialize(). " + ex.getMessage());
        }
    }

    public int getIndexPolicySelected() {
        return this.indexPolicySelected;
    }

    public void setIndexPolicySelected(int indexPolicySelected) {
        this.indexPolicySelected = indexPolicySelected;
    }

    public int getIndexDASelected() {
        return this.indexDASelected;
    }

    public void setIndexDASelected(int indexDASelected) {
        this.indexDASelected = indexDASelected;
    }

    public TableView<Actor> getTableDA() {
        return this.tableDA;
    }

    @FXML
    private void showErrorIfExist(MouseEvent event) {
        try {
            Control control = (Control)event.getSource();
            if (this.errorsMsgs == null || !this.errorsMsgs.containsKey(control.getId())) {
                return;
            }
            this.lbError.setText(this.errorsMsgs.get(control.getId()));
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.showErrorIfExist(). " + ex.getMessage());
        }
    }

    @FXML
    private void clearErrorIfExist(MouseEvent event) {
        try {
            if (this.errorsMsgs != null && !this.errorsMsgs.isEmpty()) {
                this.lbError.textProperty().unbind();
                this.lbError.setText("");
                this.lbError.textProperty().unbind();
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.clearErrorIfExist(). " + ex.getMessage());
        }
    }

    @FXML
    private void keyReleased(KeyEvent event) {
        try {
            Control ctrl;
            if (event.getCode() != KeyCode.UNDEFINED && event.getCode() != KeyCode.TAB && event.getSource() instanceof Control && (ctrl = (Control)event.getSource()).getStyleClass().contains((Object)"invalid-field")) {
                ctrl.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                ctrl.getStyleClass().add((Object)"normal-field");
                if (this.errorsMsgs != null && this.errorsMsgs.containsKey(ctrl.getId())) {
                    this.errorsMsgs.remove(ctrl.getId());
                }
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.keyReleased(). " + ex.getMessage());
        }
    }

    private void cleanForm() {
        try {
            this.tfAllowedUsers.setText("");
            this.tfAppName.setText("");
            this.tfDAdmk.setText("");
            this.tfShortname.setText("");
            this.listAllowedUsers.getItems().clear();
            this.listRepo.getItems().clear();
            if (this.tfDAid.getItems() != null && !this.tfDAid.getItems().isEmpty()) {
                this.tfDAid.getItems().clear();
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.cleanForm(). " + ex.getMessage());
        }
    }

    @FXML
    public void addRepo(ActionEvent ae) {
        if (!this.tfRepo.getText().isEmpty()) {
            if (this.listRepo.getItems().contains((Object)this.tfRepo.getText())) {
                this.lbError.setText(ResourceManager.getString("error.repo.duplicated"));
            } else {
                this.listRepo.getItems().add((Object)this.tfRepo.getText());
                this.tfRepo.setText("");
            }
        } else {
            this.lbError.setText(ResourceManager.getString("error.repo.required"));
        }
    }

    @FXML
    public void addAllowedUsers() {
        if (!this.tfAllowedUsers.getText().isEmpty()) {
            if (this.listAllowedUsers.getItems().contains((Object)this.tfAllowedUsers.getText())) {
                this.lbError.setText(ResourceManager.getString("error.allowed-users.duplicated"));
            } else {
                this.listAllowedUsers.getItems().add((Object)this.tfAllowedUsers.getText());
                this.tfAllowedUsers.setText("");
            }
        } else {
            this.lbError.setText(ResourceManager.getString("error.allowed-users.empty"));
        }
    }

    @FXML
    public void deleteSelectedUsers() {
        if (this.listAllowedUsers.getSelectionModel().getSelectedItem() != null) {
            this.listAllowedUsers.getItems().remove(this.listAllowedUsers.getSelectionModel().getSelectedItem());
            this.lbError.setText("");
        } else {
            this.lbError.setText(ResourceManager.getString("error.remove.noselected.autorized_users"));
        }
    }

    @FXML
    public void searchPath() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File selectedDirectory = directoryChooser.showDialog((Window)this.primaryStage);
        if (selectedDirectory == null) {
            this.lbError.setText(ResourceManager.getString("error.directory.repo.noselect"));
        } else if (this.listRepo.getItems().contains((Object)selectedDirectory.getAbsolutePath())) {
            this.lbError.setText(ResourceManager.getString("error.repo.duplicated"));
        } else {
            this.listRepo.getItems().add((Object)selectedDirectory.getAbsolutePath());
        }
    }

    @FXML
    public void deleteSelectedPatch() {
        if (this.listRepo.getSelectionModel().getSelectedItem() != null) {
            this.listRepo.getItems().remove(this.listRepo.getSelectionModel().getSelectedItem());
            this.lbError.setText("");
        } else {
            this.lbError.setText(ResourceManager.getString("error.remove.noselected.path"));
        }
    }

    @FXML
    private void handleCancelPolicy() {
        SGKms.FixSGAPermissions();
        this.displayPane(2);
        this.cleanForm();
        this.cleanErrorMessages();
    }

    private void handleOkReassign() {
        try {
            this.errorsMsgs = new HashMap<String, String>();
            this.lbError.textProperty().unbind();
            this.lbError.setText("");
            this.lbError.setVisible(true);
            boolean result = true;
            if (this.tfnewDA.getSelectionModel().isEmpty()) {
                this.tfnewDA.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfnewDA.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfnewDA.getId(), ResourceManager.getString("error.shortname.required"));
                result = false;
            }
            if (this.tfSOsmk.getText().isEmpty()) {
                this.tfSOsmk.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfSOsmk.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfSOsmk.getId(), ResourceManager.getString("error.smk.required "));
                result = false;
            }
            if (result) {
                this.pwRequested.clear();
                this.type = 3;
                this.pnPolicyForm.setDisable(true);
                this.pnCtrlButtons.setDisable(true);
                this.fromTaskUserData.setTfCurrSMK(this.tfSOsmk.getText());
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfCurrSMK(this.tfSOsmk.getText());
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                TaskPolicyReassign taskPolicyReassign = new TaskPolicyReassign(this.tfCurrentDA.getText(), this.tfnewDA.getSelectionModel().getSelectedItem().toString(), this.tfShortname.getText());
                taskPolicyReassign.setOnScheduled(this.onScheduled);
                taskPolicyReassign.setOnSucceeded(this.onSucceeded);
                taskPolicyReassign.setOnFailed(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbError.textProperty().bind((ObservableValue)taskPolicyReassign.messageProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(taskPolicyReassign, this.updateProgressTask);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.handleOkReassign(). " + ex.getMessage());
        }
    }

    @FXML
    private void handleOkPolicy() {
        try {
            this.errorsMsgs = new HashMap<String, String>();
            boolean result = true;
            this.lbError.textProperty().unbind();
            this.lbError.setText("");
            this.lbError.setVisible(true);
            if (this.tfShortname.getText().isEmpty()) {
                this.tfShortname.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfShortname.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfShortname.getId(), ResourceManager.getString("error.shortname.required"));
                result = false;
            } else {
                this.tfShortname.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfShortname.getStyleClass().add((Object)"normal-field");
            }
            if (this.listRepo.getItems().isEmpty()) {
                this.listRepo.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.listRepo.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.listRepo.getId(), ResourceManager.getString("error.repo.required"));
                result = false;
            } else {
                this.listRepo.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.listRepo.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDAdmk.getText().isEmpty()) {
                this.tfDAdmk.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAdmk.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAdmk.getId(), ResourceManager.getString("error.dmk.required"));
                result = false;
            } else {
                this.tfDAdmk.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDAdmk.getStyleClass().add((Object)"normal-field");
            }
            if (result) {
                Task polAddTask;
                String configFile;
                this.pnPolicyForm.setDisable(true);
                this.pnCtrlButtons.setDisable(true);
                this.pwRequested.clear();
                this.fromTaskUserData.setTfCurrDMK(this.tfDAdmk.getText());
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfCurrDMK(this.tfDAdmk.getText());
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                logger.log(Level.INFO, ResourceManager.getString("log.info.da.configuring"));
                String DASelected = (String)this.tfDAid.getSelectionModel().getSelectedItem();
                String repo = "";
                for (Object item : this.listRepo.getItems()) {
                    if (repo.trim().length() > 0) {
                        repo = repo + ",";
                    }
                    repo = repo + (String)item;
                }
                String allowedUsers = "";
                for (Object item : this.listAllowedUsers.getItems()) {
                    if (allowedUsers.trim().length() > 0) {
                        allowedUsers = allowedUsers + ",";
                    }
                    allowedUsers = allowedUsers + (String)item;
                }
                if (!allowedUsers.trim().toLowerCase().contains("sgadmin")) {
                    if (allowedUsers.trim().length() > 0) {
                        allowedUsers = allowedUsers + ",";
                    }
                    allowedUsers = allowedUsers + "sgadmin";
                }
                if ((configFile = FileUtil.createPolicyConfigFile(this.tfShortname.getText(), repo, this.tfAppName.getText(), allowedUsers, DASelected)) == null) {
                    this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.cancelled"));
                    return;
                }
                if (this.type == 0) {
                    logger.log(Level.INFO, ResourceManager.getString("log.info.policy-add.configuring"));
                    polAddTask = new PolicyAddTask(configFile, DASelected, this.pwRequested, this.tfShortname.getText());
                    polAddTask.setOnScheduled(this.onScheduled);
                    polAddTask.setOnSucceeded(this.onSucceeded);
                    polAddTask.setOnFailed(this.onSucceeded);
                    this.updateProgressTask = new TaskUpdateProgress();
                    this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                    this.lbError.textProperty().bind((ObservableValue)polAddTask.messageProperty());
                    SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                    this.startTasks(polAddTask, this.updateProgressTask);
                } else {
                    logger.log(Level.INFO, ResourceManager.getString("log.info.policy-edit.configuring"));
                    polAddTask = new PolicyEditTask(configFile, DASelected, this.pwRequested, this.tfShortname.getText());
                    polAddTask.setOnScheduled(this.onScheduled);
                    polAddTask.setOnSucceeded(this.onSucceeded);
                    polAddTask.setOnFailed(this.onSucceeded);
                    this.updateProgressTask = new TaskUpdateProgress();
                    this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                    this.lbError.textProperty().bind((ObservableValue)polAddTask.messageProperty());
                    SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                    this.startTasks(polAddTask, this.updateProgressTask);
                }
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.handleOk(). " + ex.getMessage());
        }
    }

    public int getType() {
        return this.type;
    }

    public void setTfDAid(ObservableList<Actor> daList) {
        try {
            if (this.optionsDA != null && !this.optionsDA.isEmpty()) {
                this.optionsDA.clear();
            }
            for (Actor element : daList) {
                this.optionsDA.add((Object)element.getId().getValue());
            }
            this.tfDAid.setItems(this.optionsDA);
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.setTfDAid(). " + ex.getMessage());
        }
    }

    public void setType(int type, ObservableList<Actor> daList, String currentDA, Policy policy) {
        try {
            this.type = type;
            if (type == 0) {
                this.tfDAid.setDisable(false);
                this.tfShortname.setDisable(false);
                this.setTfDAid(daList);
            } else if (type == 1) {
                String[] value;
                this.setTfDAid(daList);
                this.tfDAid.setDisable(true);
                this.tfShortname.setText(policy.getPolicy_shortname().getValue());
                this.tfShortname.setDisable(true);
                this.tfAppName.setText(policy.getApp_name() == null ? "" : policy.getApp_name().getValue());
                if (policy.getAllowed_users() != null) {
                    value = policy.getAllowed_users().getValue().split(",");
                    this.listAllowedUsers.getItems().addAll(Arrays.asList(value));
                }
                if (policy.getRepo() != null) {
                    value = policy.getRepo().getValue().split(",");
                    this.listRepo.getItems().addAll(Arrays.asList(value));
                }
                this.tfDAid.getSelectionModel().select((Object)policy.getDa_id().getValue());
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.setType(). " + ex.getMessage());
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    private void cleanErrorMessages() {
        this.lbError.textProperty().unbind();
        this.lbError.setText("");
        this.lblStatusMsg.textProperty().unbind();
        this.lblStatusMsg.setText("");
        this.lbStatus.textOverrunProperty().unbind();
        this.lbStatus.setText("");
    }

    private void f_editDA(Actor selectedDA) {
        try {
            this.cleanErrorMessages();
            this.sgKmsGui.showDAInterface("Edit DA", selectedDA, 1, this.lblStatusMsg, this.lbError);
            if (this.tableDA.getItems() != null && !this.tableDA.getItems().isEmpty()) {
                this.tableDA.getItems().clear();
            }
            this.setTableDA();
            this.tableDA.setItems(this.dataDA);
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.editDA(). " + ex.getMessage());
        }
    }

    @FXML
    private void editDA(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.tableDA.getSelectionModel().select(this.indexDASelected);
            this.displayPane(5);
            if (this.tableDA.getSelectionModel().getSelectedItem() != null) {
                this.type = 1;
                Actor daActor = (Actor)this.tableDA.getSelectionModel().getSelectedItem();
                this.setActorDA(daActor);
                this.cleanCurrSMK();
                this.displayPane(5);
                this.tfDAFirst_dae.requestFocus();
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.editDA(). " + ex.getMessage());
        }
    }

    @FXML
    private void showDA(ActionEvent event) {
        this.cleanErrorMessages();
        this.tableDA.getSelectionModel().select(this.indexDASelected);
        String mkgd = "N/A";
        String mkrd = "Never";
        if (this.tableDA.getSelectionModel().getSelectedItem() != null) {
            Actor daActor = (Actor)this.tableDA.getSelectionModel().getSelectedItem();
            this.displayPane(7);
            this.Sda_fullname.setText(daActor.getName().getValue());
            this.Sda_id.setText(daActor.getId().getValue());
            try {
                this.Sda_emailcontact.setText(daActor.getEmail().getValue());
            }
            catch (Exception ex) {
                this.Sda_emailcontact.setText("");
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
            }
            Properties props = null;
            try {
                props = FileUtil.loadPropertiesFile("/etc/serverg/sg-tde.properties");
            }
            catch (IOException ex) {
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
            }
            if (props != null) {
                String fecha;
                try {
                    fecha = props.getProperty("dmk.gd_" + daActor.getId().getValue());
                    mkgd = this.dateFormat.format(new Date(Long.parseLong(fecha)));
                }
                catch (Exception ex) {
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
                    mkgd = "N/A";
                }
                try {
                    fecha = props.getProperty("dmk.rd_" + daActor.getId().getValue());
                    mkrd = this.dateFormat.format(new Date(Long.parseLong(fecha)));
                }
                catch (Exception ex) {
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
                    mkrd = "Never";
                }
            }
            if (daActor.getCreated() == null) {
                daActor.setCreated((StringProperty)new SimpleStringProperty(mkgd));
            }
            if (daActor.getRotated() == null) {
                daActor.setRotated((StringProperty)new SimpleStringProperty(mkrd));
            }
            this.Sda_mkgd.setText(daActor.getCreated().getValue());
            this.Sda_mkrd.setText(daActor.getRotated().getValue());
            try {
                String resposibleFor = FileUtil.getResponsibleFor("/etc/serverg/serverg.conf", daActor.getId().getValue());
                this.Sda_responsiblefor.setText(resposibleFor);
            }
            catch (Exception ex) {
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
            }
        }
    }

    @FXML
    private void showPolicy(ActionEvent event) {
        this.cleanErrorMessages();
        this.tablePolicy.getSelectionModel().select(this.indexPolicySelected);
        if (this.tablePolicy.getSelectionModel().getSelectedItem() != null) {
            Policy selectedPolicy = (Policy)this.tablePolicy.getSelectionModel().getSelectedItem();
            this.displayPane(8);
            String created = "N/A";
            this.Spolicy_name.setText(selectedPolicy.getPolicy_shortname().getValue());
            Properties props = null;
            try {
                props = FileUtil.loadPropertiesFile("/etc/serverg/sg-tde.properties");
            }
            catch (IOException ex) {
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
            }
            if (props != null) {
                try {
                    String fecha = props.getProperty("policy.create_date." + selectedPolicy.getPolicy_shortname().getValue());
                    created = this.dateFormat.format(new Date(Long.parseLong(fecha)));
                }
                catch (Exception ex) {
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
                }
            }
            if (selectedPolicy.getCreated() == null) {
                selectedPolicy.setCreated((StringProperty)new SimpleStringProperty(created));
            }
            this.Screation_date.setText(selectedPolicy.getCreated().getValue());
            this.Scurrent_status.setText(selectedPolicy.getStatus().getValue());
            try {
                this.Sauth_users.setText(selectedPolicy.getAllowed_users().getValue());
            }
            catch (Exception ex) {
                this.Sauth_users.setText("");
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
            }
            this.Sdata_admin.setText(selectedPolicy.getDa_id().getValue());
            try {
                this.Sapplication.setText(selectedPolicy.getApp_name().getValue());
            }
            catch (Exception ex) {
                this.Sapplication.setText("");
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
            }
            try {
                this.Sproteted_data_paths.setText(selectedPolicy.getRepo().getValue());
            }
            catch (Exception ex) {
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
            }
        }
    }

    @FXML
    private void showSOInfo(ActionEvent event) {
        Actor so = FileUtil.getSO("/etc/serverg/so.conf");
        String mkgd = "N/A";
        String mkrd = "Never";
        this.cleanErrorMessages();
        if (so != null) {
            this.displayPane(9);
            this.SP_fullname.setText(so.getName().getValue());
            this.SP_so_id.setText(so.getId().getValue());
            Properties props = null;
            try {
                props = FileUtil.loadPropertiesFile("/etc/serverg/sg-tde.properties");
            }
            catch (IOException ex) {
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
            }
            if (props != null) {
                String fecha;
                try {
                    fecha = props.getProperty("mmk.gd");
                    mkgd = this.dateFormat.format(new Date(Long.parseLong(fecha)));
                }
                catch (Exception ex) {
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
                    mkgd = "N/A";
                }
                try {
                    fecha = props.getProperty("smk.rd");
                    mkrd = this.dateFormat.format(new Date(Long.parseLong(fecha)));
                }
                catch (Exception ex) {
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
                    mkrd = "Never";
                }
            }
            if (so.getCreated() == null) {
                so.setCreated((StringProperty)new SimpleStringProperty(mkgd));
            }
            if (so.getRotated() == null) {
                so.setRotated((StringProperty)new SimpleStringProperty(mkrd));
            }
            this.SP_mkgd.setText(so.getCreated().getValue());
            this.SP_mkrd.setText(so.getRotated().getValue());
            try {
                this.SP_email.setText(so.getEmail().getValue());
            }
            catch (Exception ex) {
                this.SP_email.setText("");
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showDA(). " + ex.getMessage());
            }
        }
    }

    private void f_rotateDA(Actor selectedDA) {
        try {
            this.cleanErrorMessages();
            ChangeMKDialog changeMK = new ChangeMKDialog(ResourceManager.getString("info.dialog.dmk.title"), ResourceManager.getString("info.dialog.dmk.header"), 1);
            Optional result = changeMK.showAndWait();
            if (!result.isPresent()) {
                this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
                this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
                return;
            }
            this.pwRequested.clear();
            this.userData = (Map)result.get();
            this.fromTaskUserData.setTfNewDMK(this.userData.get("new-mk"));
            this.fromTaskUserData.setTfRetypedDMK(this.userData.get("new-mk-again"));
            this.fromTaskUserData.setTfCurrDMK(this.userData.get("mk"));
            this.fromTaskUserData.setPwRequested(this.pwRequested);
            this.fromGuiUserData.setTfNewDMK(this.userData.get("new-mk"));
            this.fromGuiUserData.setTfRetypedDMK(this.userData.get("new-mk-again"));
            this.fromGuiUserData.setTfCurrDMK(this.userData.get("mk"));
            this.fromGuiUserData.setPwRequested(this.pwRequested);
            TaskRotateDMK rotateDMKTask = new TaskRotateDMK(selectedDA.getId().getValue(), this.userData);
            rotateDMKTask.setOnScheduled(this.onScheduled);
            rotateDMKTask.setOnSucceeded(this.onSucceeded);
            rotateDMKTask.setOnFailed(this.onSucceeded);
            this.updateProgressTask = new TaskUpdateProgress();
            this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
            this.lbError.textProperty().bind((ObservableValue)rotateDMKTask.messageProperty());
            this.lblStatusMsg.textProperty().bind((ObservableValue)rotateDMKTask.titleProperty());
            SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
            this.startTasks(rotateDMKTask, this.updateProgressTask);
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.rotateDA(). " + ex.getMessage());
        }
    }

    @FXML
    private void rotateDA(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.tableDA.getSelectionModel().select(this.indexDASelected);
            if (this.tableDA.getSelectionModel().getSelectedItem() != null) {
                Actor selectedDA = (Actor)this.tableDA.getSelectionModel().getSelectedItem();
                this.f_rotateDA(selectedDA);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.editDA(). " + ex.getMessage());
        }
    }

    private void f_revokeDA() {
        try {
            this.cleanErrorMessages();
            this.errorsMsgs = new HashMap<String, String>();
            this.lbStatus.setVisible(true);
            String title = ResourceManager.getString("info.dialog.revokeDA.title");
            String header = ResourceManager.getString("info.dialog.revokeDA.headerDetail2");
            SelectRevokingDA revokeDialog = new SelectRevokingDA(title, header);
            Optional result = revokeDialog.showAndWait();
            if (result.isPresent()) {
                this.updateTaskMessage = 2;
                this.pwRequested.clear();
                String smkPassword = (String)((Map)result.get()).get("smk");
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromTaskUserData.setTfCurrSMK(smkPassword);
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfCurrSMK(smkPassword);
                TaskRevokeDA taskRevokeDA = new TaskRevokeDA(this.pwRequested, (String)((Map)result.get()).get("da-id"));
                taskRevokeDA.setOnScheduled(this.onScheduled);
                taskRevokeDA.setOnSucceeded(this.onSucceeded);
                taskRevokeDA.setOnFailed(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbError.textProperty().bind((ObservableValue)taskRevokeDA.messageProperty());
                this.lblStatusMsg.textProperty().bind((ObservableValue)taskRevokeDA.titleProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(taskRevokeDA, this.updateProgressTask);
            } else {
                this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
                this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            }
        }
        catch (NullPointerException ex) {
            this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
            this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.revokeDA(). " + ex.getMessage());
        }
    }

    @FXML
    private void revokeDA(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.f_revokeDA();
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.editDA(). " + ex.getMessage());
        }
    }

    private void f_removePolicy(Policy selectedPolicy) {
        try {
            this.cleanErrorMessages();
            this.errorsMsgs = new HashMap<String, String>();
            this.lbStatus.setVisible(true);
            CustomAlert alert = new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, ResourceManager.getString("info.dialog.removePolicy.title"), ResourceManager.getString("info.dialog.removePolicy.revoking"), ResourceManager.getString("info.dialog.removePolicy.headerDetail", selectedPolicy.getPolicy_shortname().getValue()));
            Optional confirmation = alert.showAndWait();
            if (confirmation.get() == CustomAlert.YES) {
                String prompt;
                String headerText = ResourceManager.getString("label.data-request.sg-dmk.msg");
                PasswordDialog pwDialog = new PasswordDialog("Enter Password", headerText, prompt = ResourceManager.getString("label.dmk.caption"));
                Optional result = pwDialog.showAndWait();
                if (result.isPresent()) {
                    this.updateTaskMessage = 1;
                    this.pwRequested.clear();
                    String dmkPassword = (String)result.get();
                    this.fromTaskUserData.setTfCurrDMK(dmkPassword);
                    this.fromTaskUserData.setPwRequested(this.pwRequested);
                    this.fromGuiUserData.setTfCurrDMK(dmkPassword);
                    this.fromGuiUserData.setPwRequested(this.pwRequested);
                    TaskRemovePolicy taskRemovePolicy = new TaskRemovePolicy(this.pwRequested, selectedPolicy.getDa_id().getValue(), selectedPolicy.getPolicy_shortname().getValue());
                    taskRemovePolicy.setOnScheduled(this.onScheduled);
                    taskRemovePolicy.setOnSucceeded(this.onSucceeded);
                    taskRemovePolicy.setOnFailed(this.onSucceeded);
                    this.updateProgressTask = new TaskUpdateProgress();
                    this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                    this.lbError.textProperty().bind((ObservableValue)taskRemovePolicy.messageProperty());
                    this.lblStatusMsg.textProperty().bind((ObservableValue)taskRemovePolicy.titleProperty());
                    SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                    this.startTasks(taskRemovePolicy, this.updateProgressTask);
                } else {
                    this.lbError.setText(ResourceManager.getString("error.dmk.required"));
                    this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
                }
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.removePolicy(). " + ex.getMessage());
        }
    }

    @FXML
    private void removePolicy(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.tablePolicy.getSelectionModel().select(this.indexPolicySelected);
            if (this.tablePolicy.getSelectionModel().getSelectedItem() != null) {
                Policy selectedPolicy = (Policy)this.tablePolicy.getSelectionModel().getSelectedItem();
                this.f_removePolicy(selectedPolicy);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.editDA(). " + ex.getMessage());
        }
    }

    private void f_startPolicy(Policy selectedPolicy) {
        try {
            this.cleanErrorMessages();
            this.errorsMsgs = new HashMap<String, String>();
            this.lbStatus.setVisible(true);
            String headerText = ResourceManager.getString("label.data-request.sg-dmk.msg");
            String prompt = ResourceManager.getString("label.dmk.caption");
            PasswordDialog pwDialog = new PasswordDialog("Enter Password", headerText, prompt);
            Optional result = pwDialog.showAndWait();
            if (result.isPresent()) {
                this.pwRequested.clear();
                this.updateTaskMessage = 1;
                String dmkPassword = (String)result.get();
                this.fromTaskUserData.setTfCurrDMK(dmkPassword);
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfCurrDMK(dmkPassword);
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                TaskStartPolicy taskStartPolicy = new TaskStartPolicy(this.pwRequested, selectedPolicy.getDa_id().getValue(), selectedPolicy.getPolicy_shortname().getValue());
                taskStartPolicy.setOnScheduled(this.onScheduled);
                taskStartPolicy.setOnSucceeded(this.onSucceeded);
                taskStartPolicy.setOnFailed(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbError.textProperty().bind((ObservableValue)taskStartPolicy.messageProperty());
                this.lblStatusMsg.textProperty().bind((ObservableValue)taskStartPolicy.titleProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(taskStartPolicy, this.updateProgressTask);
            } else {
                this.lbError.setText(ResourceManager.getString("error.dmk.required"));
                this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.startPolicy(). " + ex.getMessage());
        }
    }

    @FXML
    private void startPolicy(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.tablePolicy.getSelectionModel().select(this.indexPolicySelected);
            if (this.tablePolicy.getSelectionModel().getSelectedItem() != null) {
                Policy selectedPolicy = (Policy)this.tablePolicy.getSelectionModel().getSelectedItem();
                this.f_startPolicy(selectedPolicy);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.editDA(). " + ex.getMessage());
        }
    }

    private void f_stopPolicy(Policy selectedPolicy) {
        try {
            this.cleanErrorMessages();
            this.errorsMsgs = new HashMap<String, String>();
            this.lbStatus.setVisible(true);
            String headerText = ResourceManager.getString("label.data-request.sg-dmk.msg");
            String prompt = ResourceManager.getString("label.dmk.caption");
            PasswordDialog pwDialog = new PasswordDialog("Enter Password", headerText, prompt);
            Optional result = pwDialog.showAndWait();
            if (result.isPresent()) {
                this.updateTaskMessage = 1;
                this.pwRequested.clear();
                String dmkPassword = (String)result.get();
                this.fromTaskUserData.setTfCurrDMK(dmkPassword);
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfCurrDMK(dmkPassword);
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                TaskStopPolicy taskStopPolicy = new TaskStopPolicy(this.pwRequested, selectedPolicy.getDa_id().getValue(), selectedPolicy.getPolicy_shortname().getValue());
                taskStopPolicy.setOnScheduled(this.onScheduled);
                taskStopPolicy.setOnSucceeded(this.onSucceeded);
                taskStopPolicy.setOnFailed(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbError.textProperty().bind((ObservableValue)taskStopPolicy.messageProperty());
                this.lblStatusMsg.textProperty().bind((ObservableValue)taskStopPolicy.titleProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(taskStopPolicy, this.updateProgressTask);
            } else {
                this.lbError.setText(ResourceManager.getString("error.dmk.required"));
                this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.stopPolicy(). " + ex.getMessage());
        }
    }

    @FXML
    private void stopPolicy(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.tablePolicy.getSelectionModel().select(this.indexPolicySelected);
            if (this.tablePolicy.getSelectionModel().getSelectedItem() != null) {
                Policy selectedPolicy = (Policy)this.tablePolicy.getSelectionModel().getSelectedItem();
                this.f_stopPolicy(selectedPolicy);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.editDA(). " + ex.getMessage());
        }
    }

    @FXML
    private void handleCancelDAForm() {
        SGKms.FixSGAPermissions();
        this.displayPane(0);
        this.cleanFormDA();
        this.cleanErrorMessages();
    }

    @FXML
    private void handleCancelDAFormEdit() {
        SGKms.FixSGAPermissions();
        this.displayPane(1);
        this.cleanFormDAEdit();
        this.cleanErrorMessages();
    }

    @FXML
    private void handleCancelSOFormEdit() {
        SGKms.FixSGAPermissions();
        this.displayPane(0);
        this.cleanFormSOEdit();
        this.cleanErrorMessages();
    }

    @FXML
    private void activeSGKMSPane(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.displayPane(0);
            this.fxTitleApp.setText(ResourceManager.getString("tab.sg-kms.caption"));
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.activeSGKMSPane(). " + ex.getMessage());
        }
    }

    @FXML
    private void btnBackSO() {
        this.displayPane(0);
    }

    @FXML
    private void btnBackPolicy() {
        this.displayPane(2);
    }

    @FXML
    private void btnBackDA() {
        this.displayPane(1);
    }

    private void displayPane(int pane) {
        boolean[] display = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false};
        display[pane] = true;
        this.pnSGKMS.setVisible(display[0]);
        this.pnDAConfig.setVisible(display[1]);
        this.pnPolicies.setVisible(display[2]);
        this.pnPolicyForm.setVisible(display[3]);
        this.pnlCreateDA.setVisible(display[4]);
        this.pnlEditDA.setVisible(display[5]);
        this.pnlEditSO.setVisible(display[6]);
        this.showDAInforPane.setVisible(display[7]);
        this.showPolicyInforPane.setVisible(display[8]);
        this.showSOInforPane.setVisible(display[9]);
        this.pnCompliance.setVisible(display[10]);
        this.pnDashBoard.setVisible(display[11]);
        this.pnSGAgent.setVisible(display[12]);
    }

    @FXML
    private void activeDAPane(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.displayPane(1);
            this.fxTitleApp.setText(ResourceManager.getString("label.setup.da.title"));
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.activeDAPane(). " + ex.getMessage());
        }
    }

    @FXML
    private void activePolicyPane(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.displayPane(2);
            this.fxTitleApp.setText(ResourceManager.getString("label.setup.policy.title"));
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.activePolicyPane(). " + ex.getMessage());
        }
    }

    public void cleanCurrSMK() {
        try {
            this.tfCurrSMK.setVisible(true);
            this.tfCurrSMK.setText("");
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.cleanCurrSMK(). " + ex.getMessage());
        }
    }

    public void setActorDA(Actor daActor) {
        try {
            this.tfId_dae.setText(daActor.getId() == null ? "" : daActor.getId().getValue());
            this.tfId_dae.setDisable(true);
            this.tfDAFirst_dae.setText(daActor.getFname() == null ? "" : daActor.getFname().getValue());
            this.tfDALast_dae.setText(daActor.getLname() == null ? "" : daActor.getLname().getValue());
            this.tfDAEmail_dae.setText(daActor.getEmail() == null ? "" : daActor.getEmail().getValue());
            this.tfDAPhone_dae.setText(daActor.getPhone() == null ? "" : daActor.getPhone().getValue());
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.setActor(). " + ex.getMessage());
        }
    }

    public void setActorSO(Actor daActor) {
        try {
            this.tfId_soe.setText(daActor.getId() == null ? "" : daActor.getId().getValue());
            this.tfId_soe.setDisable(true);
            this.tfDAFirst_soe.setText(daActor.getFname() == null ? "" : daActor.getFname().getValue());
            this.tfDALast_soe.setText(daActor.getLname() == null ? "" : daActor.getLname().getValue());
            this.tfDAEmail_soe.setText(daActor.getEmail() == null ? "" : daActor.getEmail().getValue());
            this.tfDAPhone_soe.setText(daActor.getPhone() == null ? "" : daActor.getPhone().getValue());
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.setActor(). " + ex.getMessage());
        }
    }

    private void cleanFormDA() {
        try {
            this.tfId.setText("");
            this.tfDAFirst.setText("");
            this.tfDALast.setText("");
            this.tfDAEmail.setText("");
            this.tfDAPhone.setText("");
            this.tfNewDMK.setText("");
            this.tfRetypedDMK.setText("");
            this.tfCurrSMK.setText("");
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.cleanForm(). " + ex.getMessage());
        }
    }

    private void cleanFormDAEdit() {
        try {
            this.tfId_dae.setText("");
            this.tfDAFirst_dae.setText("");
            this.tfDALast_dae.setText("");
            this.tfDAEmail_dae.setText("");
            this.tfDAPhone_dae.setText("");
            this.tfCurrDMK_dae.setText("");
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.cleanForm(). " + ex.getMessage());
        }
    }

    private void cleanFormSOEdit() {
        try {
            this.tfId_soe.setText("");
            this.tfDAFirst_soe.setText("");
            this.tfDALast_soe.setText("");
            this.tfDAEmail_soe.setText("");
            this.tfDAPhone_soe.setText("");
            this.tfCurrSMK_soe.setText("");
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.cleanForm(). " + ex.getMessage());
        }
    }

    @FXML
    private void onNewDA(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.displayPane(4);
            this.cleanFormDA();
            this.setType(0);
            this.cleanCurrSMK();
            this.tfId.requestFocus();
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.onNewDA(). " + ex.getMessage());
        }
    }

    @FXML
    private void handleOkEditDA() {
        try {
            this.errorsMsgs = new HashMap<String, String>();
            boolean result = true;
            this.lbError.textProperty().unbind();
            this.lbError.setText("");
            this.lbError.setVisible(true);
            if (this.tfId_dae.getText().isEmpty()) {
                this.tfId_dae.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfId_dae.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfId.getId(), ResourceManager.getString("error.da-id.required"));
                result = false;
            } else {
                this.tfId_dae.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfId_dae.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDAFirst_dae.getText().isEmpty()) {
                this.tfDAFirst_dae.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAFirst_dae.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAFirst.getId(), ResourceManager.getString("error.fname.required"));
                result = false;
            } else {
                this.tfDAFirst_dae.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDAFirst_dae.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDALast_dae.getText().isEmpty()) {
                this.tfDALast_dae.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDALast_dae.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDALast.getId(), ResourceManager.getString("error.lname.required"));
                result = false;
            } else {
                this.tfDALast_dae.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDALast_dae.getStyleClass().add((Object)"normal-field");
            }
            if (!this.tfDAEmail_dae.getText().isEmpty() && !this.tfDAEmail_dae.getText().matches("(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*:(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)(?:,\\s*(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*))*)?;\\s*)")) {
                this.tfDAEmail_dae.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAEmail_dae.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAEmail.getId(), ResourceManager.getString("error.email.invalid", this.tfDAEmail_dae.getText()));
                result = false;
            } else {
                this.tfDAEmail_dae.getStyleClass().remove((Object)"invalid-field");
                this.tfDAEmail_dae.getStyleClass().add((Object)"normal-field");
            }
            if (!this.tfDAPhone_dae.getText().isEmpty() && !this.tfDAPhone_dae.getText().matches("([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})")) {
                this.tfDAPhone_dae.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAPhone_dae.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAPhone.getId(), ResourceManager.getString("error.phone.invalid", this.tfDAPhone_dae.getText()));
                result = false;
            } else {
                this.tfDAPhone_dae.getStyleClass().remove((Object)"invalid-field");
                this.tfDAPhone_dae.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfCurrDMK_dae.isVisible() && this.tfCurrDMK_dae.getText().isEmpty()) {
                this.tfCurrDMK_dae.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfCurrDMK_dae.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfCurrDMK_dae.getId(), ResourceManager.getString("error.dmk.required"));
                result = false;
            } else {
                this.tfCurrDMK_dae.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfCurrDMK_dae.getStyleClass().add((Object)"normal-field");
            }
            if (result) {
                this.updateTaskMessage = 8;
                this.pwRequested.clear();
                this.fromTaskUserData.setTfCurrDMK(this.tfCurrDMK_dae.getText());
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromTaskUserData.setTfDAFname(this.tfDAFirst_dae.getText());
                this.fromTaskUserData.setTfDALname(this.tfDALast_dae.getText());
                this.fromTaskUserData.setTfDAEmail(this.tfDAEmail_dae.getText());
                this.fromTaskUserData.setTfDAPhone(this.tfDAPhone_dae.getText());
                this.fromGuiUserData.setTfCurrDMK(this.tfCurrDMK_dae.getText());
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfDAFname(this.tfDAFirst_dae.getText());
                this.fromGuiUserData.setTfDALname(this.tfDALast_dae.getText());
                this.fromGuiUserData.setTfDAEmail(this.tfDAEmail_dae.getText());
                this.fromGuiUserData.setTfDAPhone(this.tfDAPhone_dae.getText());
                logger.log(Level.INFO, ResourceManager.getString("log.info.da.editing"));
                TaskEditDA daEditTask = new TaskEditDA(this.tfId_dae.getText(), this.tfDAFirst_dae.getText(), this.tfDALast_dae.getText(), this.tfDAEmail_dae.getText(), this.tfDAPhone_dae.getText(), this.tfCurrDMK_dae.getText());
                daEditTask.setOnScheduled(this.onScheduled);
                daEditTask.setOnSucceeded(this.onSucceeded);
                daEditTask.setOnFailed(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbError.textProperty().bind((ObservableValue)daEditTask.messageProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(daEditTask, this.updateProgressTask);
                this.pnlEditDA.setDisable(true);
                this.pnCtrlButtonsDA.setDisable(true);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.handleOkEdit(). " + ex.getMessage());
        }
    }

    @FXML
    private void handleOkEditSO() {
        try {
            this.errorsMsgs = new HashMap<String, String>();
            boolean result = true;
            this.lbError.textProperty().unbind();
            this.lbError.setText("");
            this.lbError.setVisible(true);
            if (this.tfId_soe.getText().isEmpty()) {
                this.tfId_soe.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfId_soe.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfId.getId(), ResourceManager.getString("error.da-id.required"));
                result = false;
            } else {
                this.tfId_soe.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfId_soe.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDAFirst_soe.getText().isEmpty()) {
                this.tfDAFirst_soe.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAFirst_soe.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAFirst.getId(), ResourceManager.getString("error.fname.required"));
                result = false;
            } else {
                this.tfDAFirst_soe.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDAFirst_soe.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDALast_soe.getText().isEmpty()) {
                this.tfDALast_soe.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDALast_soe.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDALast.getId(), ResourceManager.getString("error.lname.required"));
                result = false;
            } else {
                this.tfDALast_soe.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDALast_soe.getStyleClass().add((Object)"normal-field");
            }
            if (!this.tfDAEmail_soe.getText().isEmpty() && !this.tfDAEmail_soe.getText().matches("(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*:(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)(?:,\\s*(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*))*)?;\\s*)")) {
                this.tfDAEmail_soe.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAEmail_soe.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAEmail.getId(), ResourceManager.getString("error.email.invalid", this.tfDAEmail.getText()));
                result = false;
            } else {
                this.tfDAEmail_soe.getStyleClass().remove((Object)"invalid-field");
                this.tfDAEmail_soe.getStyleClass().add((Object)"normal-field");
            }
            if (!this.tfDAPhone_soe.getText().isEmpty() && !this.tfDAPhone_soe.getText().matches("([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})")) {
                this.tfDAPhone_soe.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAPhone_soe.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAPhone_soe.getId(), ResourceManager.getString("error.phone.invalid", this.tfDAPhone_soe.getText()));
                result = false;
            } else {
                this.tfDAPhone_soe.getStyleClass().remove((Object)"invalid-field");
                this.tfDAPhone_soe.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfCurrSMK_soe.isVisible() && this.tfCurrSMK_soe.getText().isEmpty()) {
                this.tfCurrSMK_soe.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfCurrSMK_soe.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfCurrSMK_soe.getId(), ResourceManager.getString("error.smk.required"));
                result = false;
            } else {
                this.tfCurrSMK_soe.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfCurrSMK_soe.getStyleClass().add((Object)"normal-field");
            }
            if (result) {
                this.updateTaskMessage = 9;
                this.pwRequested.clear();
                this.fromTaskUserData.setTfCurrSMK(this.tfCurrSMK_soe.getText());
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromTaskUserData.setTfSOFname(this.tfDAFirst_soe.getText());
                this.fromTaskUserData.setTfSOLname(this.tfDALast_soe.getText());
                this.fromTaskUserData.setTfSOEmail(this.tfDAEmail_soe.getText());
                this.fromTaskUserData.setTfSOPhone(this.tfDAPhone_soe.getText());
                this.fromGuiUserData.setTfCurrSMK(this.tfCurrSMK_soe.getText());
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfSOFname(this.tfDAFirst_soe.getText());
                this.fromGuiUserData.setTfSOLname(this.tfDALast_soe.getText());
                this.fromGuiUserData.setTfSOEmail(this.tfDAEmail_soe.getText());
                this.fromGuiUserData.setTfSOPhone(this.tfDAPhone_soe.getText());
                logger.log(Level.INFO, ResourceManager.getString("log.info.so.editing"));
                TaskEditSO soEditTask = new TaskEditSO(this.tfDAFirst_soe.getText(), this.tfDALast_soe.getText(), this.tfDAEmail_soe.getText(), this.tfDAPhone_soe.getText());
                soEditTask.setOnScheduled(this.onScheduled);
                soEditTask.setOnSucceeded(this.onSucceeded);
                soEditTask.setOnFailed(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbError.textProperty().bind((ObservableValue)soEditTask.messageProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(soEditTask, this.updateProgressTask);
                this.pnlEditSO.setDisable(true);
                this.pnControlsSOE.setDisable(true);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.handleOkEditSO(). " + ex.getMessage());
        }
    }

    @FXML
    private void handleOkDA() {
        try {
            this.errorsMsgs = new HashMap<String, String>();
            boolean result = true;
            this.lbError.textProperty().unbind();
            this.lbError.setText("");
            this.lbError.setVisible(true);
            if (this.tfId.getText().isEmpty()) {
                this.tfId.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfId.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfId.getId(), ResourceManager.getString("error.da-id.required"));
                result = false;
            } else {
                this.tfId.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfId.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDAFirst.getText().isEmpty()) {
                this.tfDAFirst.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAFirst.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAFirst.getId(), ResourceManager.getString("error.fname.required"));
                result = false;
            } else {
                this.tfDAFirst.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDAFirst.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDALast.getText().isEmpty()) {
                this.tfDALast.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDALast.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDALast.getId(), ResourceManager.getString("error.lname.required"));
                result = false;
            } else {
                this.tfDALast.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDALast.getStyleClass().add((Object)"normal-field");
            }
            if (!this.tfDAEmail.getText().isEmpty() && !this.tfDAEmail.getText().matches("(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*:(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)(?:,\\s*(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*))*)?;\\s*)")) {
                this.tfDAEmail.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAEmail.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAEmail.getId(), ResourceManager.getString("error.email.invalid", this.tfDAEmail.getText()));
                result = false;
            } else {
                this.tfDAEmail.getStyleClass().remove((Object)"invalid-field");
                this.tfDAEmail.getStyleClass().add((Object)"normal-field");
            }
            if (!this.tfDAPhone.getText().isEmpty() && !this.tfDAPhone.getText().matches("([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})")) {
                this.tfDAPhone.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAPhone.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAPhone.getId(), ResourceManager.getString("error.phone.invalid", this.tfDAPhone.getText()));
                result = false;
            } else {
                this.tfDAPhone.getStyleClass().remove((Object)"invalid-field");
                this.tfDAPhone.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfNewDMK.getText().isEmpty() || this.tfNewDMK.getText().length() < 16 || this.tfNewDMK.getText().length() > 60 || !this.tfNewDMK.getText().matches("^([0-9]+[a-zA-Z]+|[a-zA-Z]+[0-9]+)[0-9a-zA-Z]*$")) {
                this.tfNewDMK.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfNewDMK.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfNewDMK.getId(), ResourceManager.getString("error.dmk.lenght"));
                result = false;
            } else {
                this.tfNewDMK.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfNewDMK.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfRetypedDMK.getText().isEmpty() || !this.tfNewDMK.getText().equals(this.tfRetypedDMK.getText())) {
                this.tfRetypedDMK.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfRetypedDMK.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfRetypedDMK.getId(), ResourceManager.getString("error.keys.not_match"));
                result = false;
            } else {
                this.tfRetypedDMK.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfRetypedDMK.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfCurrSMK.isVisible() && this.tfCurrSMK.getText().isEmpty()) {
                this.tfCurrSMK.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfCurrSMK.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfCurrSMK.getId(), ResourceManager.getString("error.smk.required"));
                result = false;
            } else {
                this.tfCurrSMK.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfCurrSMK.getStyleClass().add((Object)"normal-field");
            }
            if (result) {
                this.updateTaskMessage = 7;
                this.pwRequested.clear();
                this.fromTaskUserData.setTfNewDMK(this.tfNewDMK.getText());
                this.fromTaskUserData.setTfRetypedDMK(this.tfRetypedDMK.getText());
                this.fromTaskUserData.setTfCurrSMK(this.tfCurrSMK.getText());
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfNewDMK(this.tfNewDMK.getText());
                this.fromGuiUserData.setTfRetypedDMK(this.tfRetypedDMK.getText());
                this.fromGuiUserData.setTfCurrSMK(this.tfCurrSMK.getText());
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                logger.log(Level.INFO, ResourceManager.getString("log.info.da.configuring"));
                String configFile = FileUtil.createAdmConfigFile(this.tfId.getText(), this.tfDAFirst.getText(), this.tfDALast.getText(), this.tfDAEmail.getText(), this.tfDAPhone.getText(), false);
                if (configFile == null) {
                    this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.cancelled"));
                    return;
                }
                DACreateTask daCreateTask = new DACreateTask(configFile, this.pwRequested, this.tfId.getText());
                daCreateTask.setOnScheduled(this.onScheduled);
                daCreateTask.setOnSucceeded(this.onSucceeded);
                daCreateTask.setOnFailed(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbError.textProperty().bind((ObservableValue)daCreateTask.messageProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(daCreateTask, this.updateProgressTask);
                this.pnlCreateDA.setDisable(true);
                this.pnCtrlButtonsDA.setDisable(true);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.handleOk(). " + ex.getMessage());
        }
    }

    @FXML
    private void onNewPolicy(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            if (this.tableDA.getItems() != null && !this.tableDA.getItems().isEmpty()) {
                this.pnPolicyForm.setVisible(true);
                this.pnDAConfig.setVisible(false);
                this.pnSGKMS.setVisible(false);
                this.pnPolicies.setVisible(false);
                this.fxTitleApp.setText(ResourceManager.getString("label.setup.policy.title"));
                this.lblTitlePolicyForm.setText(ResourceManager.getString("label.setup.new-policy.title"));
                this.pwRequested = new ArrayList<Integer>();
                this.pnPolicyForm.setDisable(false);
                this.pnCtrlButtons.setDisable(false);
                this.type = 0;
                this.setType(this.type, this.dataDA, null, null);
                this.tfShortname.requestFocus();
                this.updateTaskMessage = 5;
            } else {
                CustomAlert alert = new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, ResourceManager.getString("info.alert.da-missing.confirm.title"), ResourceManager.getString("info.alert.da-missing.confirm.header"), ResourceManager.getString("info.alert.da-missing.confirm.message"));
                Optional confirmation = alert.showAndWait();
                if (confirmation.get() == CustomAlert.YES) {
                    this.cleanErrorMessages();
                    this.sgKmsGui.showDAInterface("New DA", null, 0, this.lblStatusMsg, this.lbError);
                    if (this.tableDA.getItems() != null && !this.tableDA.getItems().isEmpty()) {
                        this.tableDA.getItems().clear();
                    }
                    this.setTableDA();
                    this.tableDA.setItems(this.dataDA);
                    this.pnDAConfig.setVisible(true);
                    this.pnPolicies.setVisible(false);
                    this.pnSGKMS.setVisible(false);
                    this.fxTitleApp.setText(ResourceManager.getString("label.setup.da.title"));
                }
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.onNewPolicy(). " + ex.getMessage());
        }
    }

    private void EditPolicy(Policy selectedPolicy) {
        try {
            this.cleanErrorMessages();
            this.pnPolicyForm.setVisible(true);
            this.pnDAConfig.setVisible(false);
            this.pnSGKMS.setVisible(false);
            this.pnPolicies.setVisible(false);
            this.fxTitleApp.setText(ResourceManager.getString("label.setup.policy.title"));
            this.pwRequested = new ArrayList<Integer>();
            this.pnPolicyForm.setDisable(false);
            this.pnCtrlButtons.setDisable(false);
            this.type = 1;
            this.setType(this.type, this.dataDA, selectedPolicy.getDa_id().getValue(), selectedPolicy);
            this.lblTitlePolicyForm.setText(ResourceManager.getString("label.setup.edit-policy.title"));
            this.updateTaskMessage = 6;
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.onEditPolicy(). " + ex.getMessage());
        }
    }

    @FXML
    private void onEditPolicy(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.tablePolicy.getSelectionModel().select(this.indexPolicySelected);
            if (this.tablePolicy.getSelectionModel().getSelectedItem() != null) {
                Policy selectedPolicy = (Policy)this.tablePolicy.getSelectionModel().getSelectedItem();
                this.EditPolicy(selectedPolicy);
                this.tfShortname.requestFocus();
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.editDA(). " + ex.getMessage());
        }
    }

    private void ReasignPolicy(Policy selectedPolicy) {
        try {
            this.cleanErrorMessages();
            this.sgKmsGui.showReassignPolicy("Reassign Policy", selectedPolicy, this.dataDA, this.lblStatusMsg, this.lbError);
            if (this.tablePolicy.getItems() != null && !this.tablePolicy.getItems().isEmpty()) {
                this.tablePolicy.getItems().clear();
            }
            this.setTablePolicy();
            this.tablePolicy.setItems(this.dataPolicy);
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.onReasignPolicy(). " + ex.getMessage());
        }
    }

    @FXML
    private void ReassignPolicyAction() {
        try {
            this.cleanErrorMessages();
            this.sgKmsGui.showReassignPolicy("Reassign Policy", this.dataPolicy, this.lblStatusMsg, this.lbError);
            if (this.tablePolicy.getItems() != null && !this.tablePolicy.getItems().isEmpty()) {
                this.tablePolicy.getItems().clear();
            }
            this.setTablePolicy();
            this.tablePolicy.setItems(this.dataPolicy);
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.onReasignPolicy(). " + ex.getMessage());
        }
    }

    private void onReasignPolicy(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.tablePolicy.getSelectionModel().select(this.indexPolicySelected);
            if (this.tablePolicy.getSelectionModel().getSelectedItem() != null) {
                Policy selectedPolicy = (Policy)this.tablePolicy.getSelectionModel().getSelectedItem();
                this.ReasignPolicy(selectedPolicy);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.editDA(). " + ex.getMessage());
        }
    }

    @FXML
    private void close(ActionEvent event) {
        Platform.exit();
    }

    public SgKmsGui getSgKmsGui() {
        return this.sgKmsGui;
    }

    public void setSgKmsGui(SgKmsGui sgKmsGui) {
        this.sgKmsGui = sgKmsGui;
    }

    public boolean setTableDA() {
        try {
            this.idColumn.setCellValueFactory(cellData -> ((Actor)cellData.getValue()).getId());
            this.NameDAColumn.setCellValueFactory(cellData -> ((Actor)cellData.getValue()).getName());
            this.actionsDA.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Actor, Boolean>, ObservableValue<Boolean>>(){

                public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<Actor, Boolean> features) {
                    return new SimpleBooleanProperty(features.getValue() != null);
                }
            });
            this.actionsDA.setCellFactory((Callback)new Callback<TableColumn<Actor, Boolean>, TableCell<Actor, Boolean>>(){

                public TableCell<Actor, Boolean> call(TableColumn<Actor, Boolean> actorBooleanTableColumn) {
                    return new AddActorCell(SGKmsOPControllerv2.this.primaryStage, SGKmsOPControllerv2.this.tableDA);
                }
            });
            this.dataDA = FileUtil.getDAList("/etc/serverg/da.conf");
            this.tableDA.setItems(this.dataDA);
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    public boolean setTablePolicy() {
        try {
            SGKms.FixSGAPermissions();
            this.dataPolicy = FileUtil.getPolicyList("/etc/serverg/serverg.conf");
            this.tablePolicy.setItems(this.dataPolicy);
            for (Policy dataPolicy1 : this.dataPolicy) {
                boolean isMounted = false;
                try {
                    isMounted = SGAManager.getInstance().isPolicyMounted(dataPolicy1.getPolicy_shortname().getValue());
                    if (isMounted) {
                        dataPolicy1.setStatus(1);
                        continue;
                    }
                    dataPolicy1.setStatus(2);
                }
                catch (Exception exception) {}
            }
            this.daIDPolicyColumn.setCellValueFactory(cellData -> ((Policy)cellData.getValue()).getDa_id());
            this.policycolumn.setCellValueFactory(cellData -> ((Policy)cellData.getValue()).getPolicy_shortname());
            this.statusPolicyColumn.setCellValueFactory(cellData -> ((Policy)cellData.getValue()).getStatus());
            this.actionsPolicy.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Policy, Boolean>, ObservableValue<Boolean>>(){

                public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<Policy, Boolean> features) {
                    return new SimpleBooleanProperty(features.getValue() != null);
                }
            });
            this.actionsPolicy.setCellFactory((Callback)new Callback<TableColumn<Policy, Boolean>, TableCell<Policy, Boolean>>(){

                public TableCell<Policy, Boolean> call(TableColumn<Policy, Boolean> policyBooleanTableColumn) {
                    return new AddPolicyCell(SGKmsOPControllerv2.this.primaryStage, SGKmsOPControllerv2.this.tablePolicy);
                }
            });
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    private void startTasks(Task sgaTask, Task updateProgressTask) {
        try {
            Thread th = new Thread((Runnable)sgaTask);
            th.setDaemon(true);
            th.start();
            Thread th2 = new Thread((Runnable)updateProgressTask);
            th2.setDaemon(true);
            th2.start();
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.startTasks(). " + ex.getMessage());
        }
    }

    @FXML
    private void editSMK(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            Actor so = FileUtil.getSO("/etc/serverg/so.conf");
            this.setActorSO(so);
            this.setType(2);
            this.displayPane(6);
            this.tfDAFirst_soe.requestFocus();
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.editSMK(). " + ex.getMessage());
        }
    }

    @FXML
    private void upgradeLicense(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            String headerText = ResourceManager.getString("label.data-request.sg-smk.msg");
            String prompt = ResourceManager.getString("label.smk.caption");
            PasswordDialog pwDialog = new PasswordDialog("Enter Password", headerText, prompt);
            Optional result = pwDialog.showAndWait();
            if (result.isPresent()) {
                this.cleanErrorMessages();
                this.updateTaskMessage = 4;
                this.pwRequested.clear();
                String smkPassword = (String)result.get();
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromTaskUserData.setTfCurrSMK(smkPassword);
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfCurrSMK(smkPassword);
                TaskUpgradeLicense upgradeLicenseTask = new TaskUpgradeLicense();
                upgradeLicenseTask.setOnScheduled(this.onScheduled);
                upgradeLicenseTask.setOnSucceeded(this.onSucceeded);
                upgradeLicenseTask.setOnFailed(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbError.textProperty().bind((ObservableValue)upgradeLicenseTask.messageProperty());
                this.lblStatusMsg.textProperty().bind((ObservableValue)upgradeLicenseTask.titleProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(upgradeLicenseTask, this.updateProgressTask);
            } else {
                this.lbError.setText(ResourceManager.getString("error.smk.required"));
                this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.rotateSMK(). " + ex.getMessage());
        }
    }

    @FXML
    private void rotateSMK(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            ChangeMKDialog changeMK = new ChangeMKDialog(ResourceManager.getString("info.dialog.smk.title"), ResourceManager.getString("info.dialog.smk.header"), 0);
            Optional result = changeMK.showAndWait();
            this.lbError.textProperty().unbind();
            this.lblStatusMsg.textProperty().unbind();
            if (!result.isPresent()) {
                this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
                this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
                return;
            }
            this.userData = (Map)result.get();
            this.pwRequested.clear();
            this.fromTaskUserData.setTfNewSMK(this.userData.get("new-mk"));
            this.fromTaskUserData.setTfRetypedSMK(this.userData.get("new-mk-again"));
            this.fromTaskUserData.setTfCurrSMK(this.userData.get("mk"));
            this.fromTaskUserData.setPwRequested(this.pwRequested);
            this.fromGuiUserData.setTfNewSMK(this.userData.get("new-mk"));
            this.fromGuiUserData.setTfRetypedSMK(this.userData.get("new-mk-again"));
            this.fromGuiUserData.setTfCurrSMK(this.userData.get("mk"));
            this.fromGuiUserData.setPwRequested(this.pwRequested);
            TaskRotateSMK rotateSMKTask = new TaskRotateSMK(this.userData);
            rotateSMKTask.setOnScheduled(this.onScheduled);
            rotateSMKTask.setOnSucceeded(this.onSucceeded);
            rotateSMKTask.setOnFailed(this.onSucceeded);
            this.btnRotateSMK.setDisable(true);
            this.updateTaskMessage = 3;
            this.updateProgressTask = new TaskUpdateProgress();
            this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
            this.lbError.textProperty().bind((ObservableValue)rotateSMKTask.messageProperty());
            this.lblStatusMsg.textProperty().bind((ObservableValue)rotateSMKTask.titleProperty());
            SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
            this.startTasks(rotateSMKTask, this.updateProgressTask);
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.rotateSMK(). " + ex.getMessage());
        }
    }

    private void updateLockerStatus() {
        logger.log(Level.DEBUG, "updating the messages");
        try {
            int n = SGKms.lockerStatus();
        }
        catch (NoSGAdminException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.lbStatus.setText("");
        }
    }

    @FXML
    private void viewLog(ActionEvent event) {
        try {
            LogViewerDialog logViewer = new LogViewerDialog();
            logViewer.showAndWait();
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.viewLog(). " + ex.getMessage());
        }
    }

    @FXML
    private void showCompliance(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            String headerText = ResourceManager.getString("label.data-request.sg-smk.msg");
            String prompt = ResourceManager.getString("label.smk.caption");
            PasswordDialog pwDialog = new PasswordDialog("Enter Password", headerText, prompt);
            Optional result = pwDialog.showAndWait();
            if (result.isPresent()) {
                try {
                    ComplianceReportDialog report = new ComplianceReportDialog();
                    this.pwRequested.clear();
                    String smkPassword = (String)result.get();
                    this.fromTaskUserData.setPwRequested(this.pwRequested);
                    this.fromTaskUserData.setTfCurrSMK(smkPassword);
                    this.fromGuiUserData.setPwRequested(this.pwRequested);
                    this.fromGuiUserData.setTfCurrSMK(smkPassword);
                    SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                    report.showAndWait();
                }
                catch (IOException ex) {
                    this.lbError.setText(ResourceManager.getString(ex.getMessage()));
                    this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
                    logger.log(Level.ERROR, "", (Throwable)ex);
                }
            } else {
                this.lbError.setText(ResourceManager.getString("error.smk.required"));
                this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.SGKmsOPControllerv2.showCompliance(). " + ex.getMessage());
        }
    }

    private void disabledControls(boolean action) {
        this.configMenuBtn.setDisable(action);
        this.pnPolicies.setDisable(action);
        this.pnDAConfig.setDisable(action);
        this.pnSGKMS.setDisable(action);
        this.pnCompliance.setDisable(action);
        this.pnSGAgent.setDisable(action);
        this.menuSGKMS.setDisable(action);
    }

    @FXML
    private void activeReportsPane(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.displayPane(10);
            this.fxTitleApp.setText(ResourceManager.getString("label.panel.compliance.title"));
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + "-" + ex.getMessage());
        }
    }

    @FXML
    private void showSecurityStatusReport(ActionEvent event) {
        try {
            SecurityStatus securityStatusReport = new SecurityStatus();
            securityStatusReport.showAndWait();
        }
        catch (Exception ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + ex.getMessage());
        }
    }

    @FXML
    private void showDataSetsReport(ActionEvent event) {
        try {
            ProtectedDataSet dataSetsDialog = new ProtectedDataSet();
            dataSetsDialog.showAndWait();
        }
        catch (Exception ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + ex.getMessage());
        }
    }

    @FXML
    private void showDataAdminsReport(ActionEvent event) {
        try {
            DataAdministrators dataAdminReport = new DataAdministrators();
            dataAdminReport.showAndWait();
        }
        catch (Exception ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + ex.getMessage());
        }
    }

    @FXML
    private void activeDashboardPane(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.displayPane(11);
            this.fxTitleApp.setText(ResourceManager.getString("tab.dashboard.caption"));
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + "-" + ex.getMessage());
        }
    }

    @FXML
    private void activeSGAScreen(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.displayPane(12);
            this.fxTitleApp.setText(ResourceManager.getString("tab.sg-agent.caption"));
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + "-" + ex.getMessage());
        }
    }

    @FXML
    private void uninstallSGA(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.errorsMsgs = new HashMap<String, String>();
            this.lbStatus.setVisible(true);
            CustomAlert alert = new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, ResourceManager.getString("info.dialog.uninstall.title"), ResourceManager.getString("info.dialog.uninstall.header"), ResourceManager.getString("info.dialog.uninstall.content"));
            Optional confirmation = alert.showAndWait();
            if (confirmation.get() == CustomAlert.YES) {
                this.cleanErrorMessages();
                this.updateTaskMessage = 4;
                this.pwRequested.clear();
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                TaskUninstall uninstallTask = new TaskUninstall();
                uninstallTask.setOnScheduled(this.onScheduled);
                uninstallTask.setOnSucceeded(this.onSucceeded);
                uninstallTask.setOnFailed(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbError.textProperty().bind((ObservableValue)uninstallTask.messageProperty());
                this.lblStatusMsg.textProperty().bind((ObservableValue)uninstallTask.titleProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(uninstallTask, this.updateProgressTask);
            } else {
                this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
                this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " - " + ex.getMessage());
        }
    }

    @FXML
    private void reassignDA(ActionEvent event) {
        try {
            this.cleanErrorMessages();
            this.errorsMsgs = new HashMap<String, String>();
            this.lbStatus.setVisible(true);
            String title = ResourceManager.getString("info.dialog.reassignDA.title");
            String header = ResourceManager.getString("info.dialog.reassignDA.headerDetail");
            RevokeReassignDADialog revokeDialog = new RevokeReassignDADialog(title, header);
            Optional result = revokeDialog.showAndWait();
            if (result.isPresent()) {
                this.updateTaskMessage = 2;
                this.pwRequested.clear();
                String smkPassword = (String)((Map)result.get()).get("smk");
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromTaskUserData.setTfCurrSMK(smkPassword);
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfCurrSMK(smkPassword);
                TaskRevokeReassignDA taskRevReaDA = new TaskRevokeReassignDA(this.pwRequested, (String)((Map)result.get()).get("revoked-da-id"), (String)((Map)result.get()).get("reassign-da-id"));
                taskRevReaDA.setOnScheduled(this.onScheduled);
                taskRevReaDA.setOnSucceeded(this.onSucceeded);
                taskRevReaDA.setOnFailed(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbError.textProperty().bind((ObservableValue)taskRevReaDA.messageProperty());
                this.lblStatusMsg.textProperty().bind((ObservableValue)taskRevReaDA.titleProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(taskRevReaDA, this.updateProgressTask);
            } else {
                this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
                this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            }
        }
        catch (NullPointerException ex) {
            this.lbError.setText(ResourceManager.getString("error.operation.cancelled"));
            this.lblStatusMsg.setText(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " " + ex.getMessage());
        }
    }

    private class AddPolicyCell
    extends TableCell<Policy, Boolean> {
        final Button smenu;
        final StackPane paddedButton = new StackPane();
        private final TableView table;
        private final Stage stage;

        AddPolicyCell(Stage stage, TableView table) {
            this.table = table;
            this.paddedButton.setPadding(new Insets(3.0));
            this.stage = stage;
            this.smenu = new Button();
            this.smenu.setStyle("-fx-graphic: url('/images/options.png');");
            this.smenu.setOnAction(this.handleAction());
            this.paddedButton.getChildren().add((Object)this.smenu);
        }

        private EventHandler<ActionEvent> handleAction() {
            return new EventHandler<ActionEvent>(){

                public void handle(ActionEvent aE) {
                    Point p = MouseInfo.getPointerInfo().getLocation();
                    SGKmsOPControllerv2.this.setIndexPolicySelected(AddPolicyCell.this.getTableRow().getIndex());
                    Policy selectedPolicy = (Policy)AddPolicyCell.this.table.getItems().get(AddPolicyCell.this.getTableRow().getIndex());
                    if (selectedPolicy.getStatus().getValue().equals(ResourceManager.getString("info.status.policy.mounted"))) {
                        ((MenuItem)AddPolicyCell.this.table.getContextMenu().getItems().get(1)).setDisable(true);
                    } else {
                        ((MenuItem)AddPolicyCell.this.table.getContextMenu().getItems().get(1)).setDisable(false);
                    }
                    if (selectedPolicy.getStatus().getValue().equals(ResourceManager.getString("info.status.policy.unmounted"))) {
                        ((MenuItem)AddPolicyCell.this.table.getContextMenu().getItems().get(2)).setDisable(true);
                    } else {
                        ((MenuItem)AddPolicyCell.this.table.getContextMenu().getItems().get(2)).setDisable(false);
                    }
                    AddPolicyCell.this.table.getContextMenu().show((Window)AddPolicyCell.this.stage, (double)p.x, (double)p.y);
                }
            };
        }

        protected void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setGraphic((Node)this.paddedButton);
            } else {
                this.setGraphic(null);
            }
        }
    }

    private class AddActorCell
    extends TableCell<Actor, Boolean> {
        final Button smenu;
        final StackPane paddedButton = new StackPane();
        private final TableView table;
        private final Stage stage;

        AddActorCell(Stage stage, TableView table) {
            this.table = table;
            this.paddedButton.setPadding(new Insets(3.0));
            this.stage = stage;
            this.smenu = new Button();
            this.smenu.setStyle("-fx-graphic: url('/images/options.png');");
            this.smenu.setOnAction(this.handleAction());
            this.paddedButton.getChildren().add((Object)this.smenu);
        }

        private EventHandler<ActionEvent> handleAction() {
            return new EventHandler<ActionEvent>(){

                public void handle(ActionEvent aE) {
                    Point p = MouseInfo.getPointerInfo().getLocation();
                    SGKmsOPControllerv2.this.setIndexDASelected(AddActorCell.this.getTableRow().getIndex());
                    AddActorCell.this.table.getContextMenu().show((Window)AddActorCell.this.stage, (double)p.x, (double)p.y);
                }
            };
        }

        protected void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setGraphic((Node)this.paddedButton);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

