/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.PolicyAddException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolicyAddTask
extends Task<Boolean> {
    private final String configFilePath;
    private List<Integer> pwRequested;
    private static final Logger logger = LogManager.getLogger();
    private String DAId;
    private String policyName;

    public PolicyAddTask(String configFilePath, String policyName) {
        this.configFilePath = configFilePath;
        this.policyName = policyName;
    }

    public PolicyAddTask(String configFilePath, String DAId, List<Integer> pwRequested, String policyName) {
        this.configFilePath = configFilePath;
        this.DAId = DAId;
        this.pwRequested = pwRequested;
        this.policyName = policyName;
    }

    protected Boolean call() throws Exception {
        try {
            this.pwRequested.clear();
            if (!SGAManager.getInstance().addPolicy(this.configFilePath, this.DAId)) {
                this.updateMessage(ResourceManager.getString("error.policy.add"));
                this.updateValue(Boolean.FALSE);
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            SGKms.saveProperty("policy.create_date." + this.policyName, String.valueOf(System.currentTimeMillis()));
            this.updateValue(Boolean.TRUE);
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (NoSGAdminException | PolicyAddException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.updateMessage(ex.getMessage());
            logger.error("", (Throwable)ex);
        }
        finally {
            if (SGAManager.getInstance() != null) {
                SGAManager.getInstance().clearCache();
            }
        }
        this.updateValue(Boolean.FALSE);
        return Boolean.FALSE;
    }
}

