/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAGeneralException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.gui.CustomAlert;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.control.Alert;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskUninstall
extends Task<Boolean> {
    private static final Logger logger = LogManager.getLogger();

    protected Boolean call() throws Exception {
        this.updateTitle(ResourceManager.getString("log.info.sgamanager.uninstall.called"));
        SGAManager sga = SGAManager.getInstance();
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.uninstall.called"));
        try {
            if (sga.uninstall()) {
                this.updateTitle(ResourceManager.getString("log.info.sgamanager.uninstall.success"));
                logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.uninstall.success"));
                Platform.runLater(() -> {
                    CustomAlert alert = new CustomAlert(Alert.AlertType.ERROR, ResourceManager.getString("info.alert.uninstall.title"), ResourceManager.getString("info.alert.uninstall.header"), "");
                    alert.showAndWait();
                    Platform.runLater(() -> Platform.exit());
                });
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            this.updateMessage(ResourceManager.getString("log.error.sgamanager.uninstall.failed"));
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.uninstall.failed"));
        }
        catch (NoSGAdminException | SGAGeneralException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.updateMessage(ex.getMessage());
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
        }
        return Boolean.FALSE;
    }
}

