/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.LicenseUpgradeException;
import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import javafx.concurrent.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskUpgradeLicense
extends Task<Boolean> {
    private static final Logger logger = LogManager.getLogger();

    protected Boolean call() throws Exception {
        this.updateTitle(ResourceManager.getString("log.info.sgamanager.license-upgrade.called"));
        SGAManager sga = SGAManager.getInstance();
        logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.license-upgrade.called"));
        try {
            if (sga.upgradeLicense()) {
                this.updateTitle(ResourceManager.getString("log.info.sgamanager.license-upgrade.success"));
                logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.license-upgrade.success"));
            } else {
                this.updateMessage(ResourceManager.getString("log.error.sgamanager.license-upgrade.failed"));
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.license-upgrade.failed"));
            }
        }
        catch (LicenseUpgradeException | NoSGAdminException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.updateMessage(ex.getMessage());
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
        }
        return Boolean.TRUE;
    }
}

