/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.util;

import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.system.EnumSysMessages;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import com.servergeneral.system.ProcessExecutor;
import com.servergeneral.system.ServiceNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DBUtil {
    private static final Logger logger = LogManager.getLogger();
    private static Connection conn = null;
    public static DBConfig dbConfig = null;
    public static String DAEMON_PATH = "/etc/init.d/";
    public static String MYSQLD1 = "mysql";
    public static String MYSQLD2 = "mysqld";

    public static boolean connectMySQLDB() throws SQLException {
        if (conn != null && conn.isValid(3)) {
            return true;
        }
        if (dbConfig == null) {
            return false;
        }
        String url = "jdbc:mysql://localhost:" + dbConfig.port + "/information_schema?useSSL=false";
        conn = DriverManager.getConnection(url, dbConfig.user, String.valueOf(dbConfig.password));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMySQlVersion() {
        Statement st = null;
        ResultSet rs = null;
        String version = null;
        try {
            int score;
            st = conn.createStatement();
            rs = st.executeQuery("SELECT VERSION()");
            if (rs.next() && (score = (version = rs.getString(1)).indexOf(45)) > 0) {
                version = version.substring(0, score);
            }
        }
        catch (SQLException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return version;
    }

    public static boolean isMySQLTDESupported(String version) {
        Integer build;
        Integer minor;
        Integer major;
        if (version == null) {
            return false;
        }
        String[] verSplit = version.split("\\.");
        if (verSplit.length != 3) {
            return false;
        }
        try {
            major = Integer.parseInt(verSplit[0]);
            minor = Integer.parseInt(verSplit[1]);
            build = Integer.parseInt(verSplit[2]);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return major == 5 && minor == 7 && build >= 12 || major == 5 && minor > 7 || major > 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMySQLTDEActivated() {
        Statement st = null;
        ResultSet rs = null;
        boolean result = false;
        try {
            st = conn.createStatement();
            rs = st.executeQuery("SELECT PLUGIN_NAME, PLUGIN_STATUS FROM PLUGINS WHERE PLUGIN_NAME LIKE 'keyring%';");
            if (rs.next()) {
                result = true;
            }
        }
        catch (SQLException ex) {
            logger.log(Level.WARN, "", (Throwable)ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return result;
    }

    public static void rotateMySQLDBKey() throws SQLException {
        Statement st = conn.createStatement();
        st.executeUpdate("ALTER INSTANCE ROTATE INNODB MASTER KEY;");
        st.close();
        SGKms.saveProperty("mmk.rd", String.valueOf(System.currentTimeMillis()));
    }

    public static boolean loadDBConfig(String filename) {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            File f = new File(filename);
            is = new FileInputStream(f);
            props.load(is);
            dbConfig = new DBConfig();
            dbConfig.setPort(props.getProperty("dbport", "3306"));
            dbConfig.setUser(props.getProperty("dbuser", "root"));
            return true;
        }
        catch (Exception e) {
            logger.log(Level.WARN, "", (Throwable)e);
            return false;
        }
    }

    public static boolean saveDBConfig(String path, String filename) {
        if (dbConfig == null) {
            return false;
        }
        try {
            File cfgFolder = new File(path);
            if (!cfgFolder.exists()) {
                cfgFolder.mkdir();
            }
            Properties props = new Properties();
            props.setProperty("dbport", dbConfig.getPort());
            props.setProperty("dbuser", dbConfig.getUser());
            File f = new File(path + "/" + filename);
            FileOutputStream out = new FileOutputStream(f);
            props.store(out, "Database properties");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.WARN, "", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean enableTDE() throws MaxPwTryiesException, OperationCancelledException, NullUserInfoListenerException {
        String configFile;
        ProcessExecutor.ResultInfo result = null;
        logger.log(Level.INFO, ResourceManager.getString("log.info.tde.enable.begin"));
        File dest = null;
        try {
            configFile = new File("/etc/mysql/mysql.conf.d/mysqld.cnf").exists() ? "/etc/mysql/mysql.conf.d/mysqld.cnf" : "/etc/my.cnf";
            URL inputUrl = DBUtil.class.getResource("/scripts/enable-tde");
            dest = File.createTempFile("e-tde", ".sh");
            FileUtils.copyURLToFile(inputUrl, dest);
            if (!dest.setExecutable(true)) {
                logger.log(Level.INFO, ResourceManager.getString("log.error.script.not_exec", dest.getAbsoluteFile()));
                boolean bl = false;
                return bl;
            }
            List<ProcessExecutor.ParseOutput> _authCodes = Arrays.asList(EnumSysMessages.SYS_ENTER_SUDO_PW);
            List<ProcessExecutor.ParseOutput> errCodes = Arrays.asList(EnumSysMessages.ANY_OUTPUT);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S " + dest.getAbsolutePath() + " " + configFile + " 2>&1"};
            logger.log(Level.DEBUG, command[2]);
            result = ProcessExecutor.getInstance().runCommand(command, errCodes, null, _authCodes, null);
        }
        catch (MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
        catch (IOException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (dest != null) {
                dest.delete();
            }
        }
        if (result == null) {
            logger.log(Level.ERROR, ResourceManager.getString("log.info.sgamanager.run.nullresult"));
            return false;
        }
        if (result.resultCode != EnumSysMessages.ANY_OUTPUT) {
            logger.log(Level.INFO, ResourceManager.getString("log.info.tde.enabled", configFile));
            SGKms.saveProperty("mmk.gd", String.valueOf(System.currentTimeMillis()));
            return true;
        }
        logger.log(Level.ERROR, ResourceManager.getString("log.error.tde.enable", configFile));
        return false;
    }

    public static void restartMySQLService() throws MaxPwTryiesException, NullUserInfoListenerException, OperationCancelledException, ServiceNotFoundException {
        ProcessExecutor.ResultInfo result = null;
        logger.log(Level.INFO, ResourceManager.getString("log.info.mysql.restarting"));
        try {
            List<ProcessExecutor.ParseOutput> _authCodes = Arrays.asList(EnumSysMessages.SYS_ENTER_SUDO_PW);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S $(which service) " + DBUtil.getMySQLDaemonName() + " restart > /dev/null 2>&1"};
            logger.log(Level.DEBUG, command[2]);
            result = ProcessExecutor.getInstance().runCommand(command, null, null, _authCodes, null);
        }
        catch (MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
    }

    public static void stopMySQLService() throws MaxPwTryiesException, NullUserInfoListenerException, OperationCancelledException, ServiceNotFoundException {
        ProcessExecutor.ResultInfo result = null;
        logger.log(Level.INFO, ResourceManager.getString("log.info.mysql.stopping"));
        try {
            List<ProcessExecutor.ParseOutput> _authCodes = Arrays.asList(EnumSysMessages.SYS_ENTER_SUDO_PW);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S $(which service) " + DBUtil.getMySQLDaemonName() + " stop > /dev/null 2>&1"};
            logger.log(Level.DEBUG, command[2]);
            result = ProcessExecutor.getInstance().runCommand(command, null, null, _authCodes, null);
        }
        catch (MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
    }

    public static void startMySQLService() throws MaxPwTryiesException, NullUserInfoListenerException, OperationCancelledException, ServiceNotFoundException {
        ProcessExecutor.ResultInfo result = null;
        logger.log(Level.INFO, ResourceManager.getString("log.info.mysql.starting"));
        try {
            List<ProcessExecutor.ParseOutput> _authCodes = Arrays.asList(EnumSysMessages.SYS_ENTER_SUDO_PW);
            String[] command = new String[]{"/bin/bash", "-c", "/usr/bin/sudo -S $(which service) " + DBUtil.getMySQLDaemonName() + " start > /dev/null 2>&1"};
            logger.log(Level.DEBUG, command[2]);
            result = ProcessExecutor.getInstance().runCommand(command, null, null, _authCodes, null);
        }
        catch (MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException | ServiceNotFoundException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            throw ex;
        }
    }

    public static String getMySQLDaemonName() throws ServiceNotFoundException {
        File file = new File(DAEMON_PATH + MYSQLD1);
        if (file.exists()) {
            return MYSQLD1;
        }
        file = new File(DAEMON_PATH + MYSQLD2);
        if (file.exists()) {
            return MYSQLD2;
        }
        throw new ServiceNotFoundException(ResourceManager.getString("error.mysqld.not_found"));
    }

    public static class DBConfig {
        private String port = null;
        private String user = null;
        private char[] password = null;

        public String getPort() {
            return this.port;
        }

        public void setPort(String dbPort) {
            this.port = dbPort;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String dbUser) {
            this.user = dbUser;
        }

        public char[] getPassword() {
            return this.password;
        }

        public void setPassword(char[] dbPassword) {
            this.password = dbPassword;
        }
    }
}

