/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.internal.ArtifactKey;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyNode;
import org.apache.maven.shared.dependency.graph.internal.Invoker;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DependencyGraphBuilder.class, hint="maven31")
public class Maven31DependencyGraphBuilder
extends AbstractLogEnabled
implements DependencyGraphBuilder {
    @Requirement
    private ProjectDependenciesResolver resolver;
    @Requirement
    private ArtifactFactory factory;

    @Override
    public DependencyNode buildDependencyGraph(MavenProject project, ArtifactFilter filter) throws DependencyGraphBuilderException {
        return this.buildDependencyGraph(project, filter, null);
    }

    @Override
    public DependencyNode buildDependencyGraph(MavenProject project, ArtifactFilter filter, Collection<MavenProject> reactorProjects) throws DependencyGraphBuilderException {
        ProjectBuildingRequest projectBuildingRequest = (ProjectBuildingRequest)Invoker.invoke(project, "getProjectBuildingRequest");
        RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(projectBuildingRequest, "getRepositorySession");
        DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest();
        request.setMavenProject(project);
        Invoker.invoke(request, "setRepositorySession", RepositorySystemSession.class, session);
        DependencyResolutionResult result = this.resolveDependencies(request, reactorProjects);
        org.eclipse.aether.graph.DependencyNode graph = (org.eclipse.aether.graph.DependencyNode)Invoker.invoke(DependencyResolutionResult.class, result, "getDependencyGraph");
        return this.buildDependencyNode(null, graph, project.getArtifact(), filter);
    }

    private DependencyResolutionResult resolveDependencies(DependencyResolutionRequest request, Collection<MavenProject> reactorProjects) throws DependencyGraphBuilderException {
        try {
            return this.resolver.resolve(request);
        }
        catch (DependencyResolutionException e) {
            if (reactorProjects == null) {
                throw new DependencyGraphBuilderException("Could not resolve following dependencies: " + e.getResult().getUnresolvedDependencies(), e);
            }
            return this.collectDependenciesFromReactor(e, reactorProjects);
        }
    }

    private DependencyResolutionResult collectDependenciesFromReactor(DependencyResolutionException e, Collection<MavenProject> reactorProjects) throws DependencyGraphBuilderException {
        DependencyResolutionResult result = e.getResult();
        List<Dependency> reactorDeps = this.getReactorDependencies(reactorProjects, result.getUnresolvedDependencies());
        result.getUnresolvedDependencies().removeAll(reactorDeps);
        Invoker.invoke(result.getResolvedDependencies(), "addAll", Collection.class, reactorDeps);
        if (!result.getUnresolvedDependencies().isEmpty()) {
            throw new DependencyGraphBuilderException("Could not resolve nor collect following dependencies: " + result.getUnresolvedDependencies(), e);
        }
        return result;
    }

    private List<Dependency> getReactorDependencies(Collection<MavenProject> reactorProjects, List<?> dependencies) {
        HashSet<ArtifactKey> reactorProjectsIds = new HashSet<ArtifactKey>();
        for (MavenProject project : reactorProjects) {
            reactorProjectsIds.add(new ArtifactKey(project));
        }
        ArrayList<Dependency> reactorDeps = new ArrayList<Dependency>();
        for (Object untypedDependency : dependencies) {
            Dependency dependency = (Dependency)untypedDependency;
            Artifact depArtifact = dependency.getArtifact();
            ArtifactKey key = new ArtifactKey(depArtifact.getGroupId(), depArtifact.getArtifactId(), depArtifact.getVersion());
            if (!reactorProjectsIds.contains(key)) continue;
            reactorDeps.add(dependency);
        }
        return reactorDeps;
    }

    private org.apache.maven.artifact.Artifact getDependencyArtifact(Dependency dep) {
        Artifact artifact = dep.getArtifact();
        return this.factory.createDependencyArtifact(artifact.getGroupId(), artifact.getArtifactId(), VersionRange.createFromVersion(artifact.getVersion()), artifact.getProperty("type", artifact.getExtension()), artifact.getClassifier(), dep.getScope(), dep.isOptional());
    }

    private DependencyNode buildDependencyNode(DependencyNode parent, org.eclipse.aether.graph.DependencyNode node, org.apache.maven.artifact.Artifact artifact, ArtifactFilter filter) {
        String premanagedVersion = null;
        String premanagedScope = null;
        DefaultDependencyNode current = new DefaultDependencyNode(parent, artifact, premanagedVersion, premanagedScope, this.getVersionSelectedFromRange(node.getVersionConstraint()));
        ArrayList<DependencyNode> nodes = new ArrayList<DependencyNode>(node.getChildren().size());
        for (org.eclipse.aether.graph.DependencyNode child : node.getChildren()) {
            org.apache.maven.artifact.Artifact childArtifact = this.getDependencyArtifact(child.getDependency());
            if (filter != null && !filter.include(childArtifact)) continue;
            nodes.add(this.buildDependencyNode(current, child, childArtifact, filter));
        }
        current.setChildren(Collections.unmodifiableList(nodes));
        return current;
    }

    private String getVersionSelectedFromRange(VersionConstraint constraint) {
        if (constraint == null || constraint.getVersion() != null) {
            return null;
        }
        return constraint.getRange().toString();
    }
}

