/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.gui.GuiUserData;
import com.servergeneral.sgkms.model.Actor;
import com.servergeneral.sgkms.tasks.DACreateTask;
import com.servergeneral.sgkms.tasks.TaskEditDA;
import com.servergeneral.sgkms.tasks.TaskEditSO;
import com.servergeneral.sgkms.util.FileUtil;
import com.servergeneral.sgkms.util.TaskUpdateProgress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DaFormController
implements Initializable {
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfDAFirst;
    @FXML
    private TextField tfDALast;
    @FXML
    private TextField tfDAEmail;
    @FXML
    private TextField tfDAPhone;
    @FXML
    private PasswordField tfNewDMK;
    @FXML
    private PasswordField tfRetypedDMK;
    @FXML
    private PasswordField tfCurrSMK;
    @FXML
    private PasswordField tfCurrDMK;
    @FXML
    private Label lbCurrSMK;
    @FXML
    private Label lbDAError;
    @FXML
    private Label lblStatusMsg;
    @FXML
    private Label lbError;
    @FXML
    private ProgressBar pbProccess;
    @FXML
    private Pane pnlCreateDA;
    @FXML
    private Pane pnCtrlButtons;
    private Map<String, String> errorsMsgs;
    private static final Logger logger = LogManager.getLogger();
    private List<Integer> pwRequested;
    private GuiUserData fromGuiUserData = new GuiUserData(false);
    private GuiUserData fromTaskUserData = new GuiUserData(true);
    private Task updateProgressTask;
    private int type = 0;
    private Stage dialogStage;
    private int updateTaskMessage = 0;
    private final EventHandler onScheduled = event -> {
        try {
            this.pbProccess.setVisible(true);
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.methodName(). " + ex.getMessage());
        }
    };
    private final EventHandler onSucceeded = event -> {
        try {
            this.pbProccess.setVisible(false);
            this.updateProgressTask.cancel();
            if (event.getSource() instanceof Task) {
                Task task = (Task)event.getSource();
                this.pnlCreateDA.setDisable(false);
                this.pnCtrlButtons.setDisable(false);
                if (task.getValue() != null && ((Boolean)task.getValue()).booleanValue()) {
                    this.handleCancel();
                    this.cleanForm();
                    switch (this.updateTaskMessage) {
                        case 1: {
                            this.lblStatusMsg.setText(ResourceManager.getString("info.smk.edit"));
                            break;
                        }
                        case 2: {
                            this.lblStatusMsg.setText(ResourceManager.getString("info.da.success.create", this.tfId.getText()));
                            break;
                        }
                        case 3: {
                            this.lblStatusMsg.setText(ResourceManager.getString("info.da.success.edit", this.tfId.getText()));
                        }
                    }
                }
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.methodName(). " + ex.getMessage());
        }
    };

    public void setActor(Actor daActor) {
        try {
            this.tfId.setText(daActor.getId() == null ? "" : daActor.getId().getValue());
            this.tfId.setDisable(true);
            this.tfDAFirst.setText(daActor.getFname() == null ? "" : daActor.getFname().getValue());
            this.tfDALast.setText(daActor.getLname() == null ? "" : daActor.getLname().getValue());
            this.tfDAEmail.setText(daActor.getEmail() == null ? "" : daActor.getEmail().getValue());
            this.tfDAPhone.setText(daActor.getPhone() == null ? "" : daActor.getPhone().getValue());
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.setActor(). " + ex.getMessage());
        }
    }

    public void setDialogStage(Stage dialogStage) {
        try {
            this.dialogStage = dialogStage;
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.setDialogStage(). " + ex.getMessage());
        }
    }

    @FXML
    private void handleCancel() {
        this.dialogStage.close();
    }

    @FXML
    private void handleOkEdit() {
        try {
            this.errorsMsgs = new HashMap<String, String>();
            boolean result = true;
            this.lbDAError.textProperty().unbind();
            this.lbDAError.setText("");
            this.lbDAError.setVisible(true);
            if (this.tfId.getText().isEmpty()) {
                this.tfId.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfId.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfId.getId(), ResourceManager.getString("error.da-id.required"));
                result = false;
            } else {
                this.tfId.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfId.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDAFirst.getText().isEmpty()) {
                this.tfDAFirst.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAFirst.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAFirst.getId(), ResourceManager.getString("error.fname.required"));
                result = false;
            } else {
                this.tfDAFirst.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDAFirst.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDALast.getText().isEmpty()) {
                this.tfDALast.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDALast.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDALast.getId(), ResourceManager.getString("error.lname.required"));
                result = false;
            } else {
                this.tfDALast.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDALast.getStyleClass().add((Object)"normal-field");
            }
            if (!this.tfDAEmail.getText().isEmpty() && !this.tfDAEmail.getText().matches("(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*:(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)(?:,\\s*(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*))*)?;\\s*)")) {
                this.tfDAEmail.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAEmail.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAEmail.getId(), ResourceManager.getString("error.email.invalid", this.tfDAEmail.getText()));
                result = false;
            } else {
                this.tfDAEmail.getStyleClass().remove((Object)"invalid-field");
                this.tfDAEmail.getStyleClass().add((Object)"normal-field");
            }
            if (!this.tfDAPhone.getText().isEmpty() && !this.tfDAPhone.getText().matches("([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})")) {
                this.tfDAPhone.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAPhone.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAPhone.getId(), ResourceManager.getString("error.phone.invalid", this.tfDAPhone.getText()));
                result = false;
            } else {
                this.tfDAPhone.getStyleClass().remove((Object)"invalid-field");
                this.tfDAPhone.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfCurrDMK.isVisible() && this.tfCurrDMK.getText().isEmpty()) {
                this.tfCurrDMK.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfCurrDMK.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfCurrDMK.getId(), ResourceManager.getString("error.dmk.required"));
                result = false;
            } else {
                this.tfCurrDMK.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfCurrDMK.getStyleClass().add((Object)"normal-field");
            }
            if (result) {
                this.updateTaskMessage = 3;
                this.pwRequested.clear();
                this.fromTaskUserData.setTfCurrDMK(this.tfCurrDMK.getText());
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromTaskUserData.setTfDAFname(this.tfDAFirst.getText());
                this.fromTaskUserData.setTfDALname(this.tfDALast.getText());
                this.fromTaskUserData.setTfDAEmail(this.tfDAEmail.getText());
                this.fromTaskUserData.setTfDAPhone(this.tfDAPhone.getText());
                this.fromGuiUserData.setTfCurrDMK(this.tfCurrDMK.getText());
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfDAFname(this.tfDAFirst.getText());
                this.fromGuiUserData.setTfDALname(this.tfDALast.getText());
                this.fromGuiUserData.setTfDAEmail(this.tfDAEmail.getText());
                this.fromGuiUserData.setTfDAPhone(this.tfDAPhone.getText());
                logger.log(Level.INFO, ResourceManager.getString("log.info.da.editing"));
                TaskEditDA daEditTask = new TaskEditDA(this.tfId.getText(), this.tfDAFirst.getText(), this.tfDALast.getText(), this.tfDAEmail.getText(), this.tfDAPhone.getText(), this.tfCurrDMK.getText());
                daEditTask.setOnScheduled(this.onScheduled);
                daEditTask.setOnSucceeded(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbDAError.textProperty().bind((ObservableValue)daEditTask.messageProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(daEditTask, this.updateProgressTask);
                this.pnlCreateDA.setDisable(true);
                this.pnCtrlButtons.setDisable(true);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.handleOkEdit(). " + ex.getMessage());
        }
    }

    @FXML
    private void handleOkEditSO() {
        try {
            this.errorsMsgs = new HashMap<String, String>();
            boolean result = true;
            this.lbDAError.textProperty().unbind();
            this.lbDAError.setText("");
            this.lbDAError.setVisible(true);
            if (this.tfId.getText().isEmpty()) {
                this.tfId.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfId.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfId.getId(), ResourceManager.getString("error.da-id.required"));
                result = false;
            } else {
                this.tfId.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfId.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDAFirst.getText().isEmpty()) {
                this.tfDAFirst.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAFirst.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAFirst.getId(), ResourceManager.getString("error.fname.required"));
                result = false;
            } else {
                this.tfDAFirst.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDAFirst.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDALast.getText().isEmpty()) {
                this.tfDALast.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDALast.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDALast.getId(), ResourceManager.getString("error.lname.required"));
                result = false;
            } else {
                this.tfDALast.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDALast.getStyleClass().add((Object)"normal-field");
            }
            if (!this.tfDAEmail.getText().isEmpty() && !this.tfDAEmail.getText().matches("(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*:(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)(?:,\\s*(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*))*)?;\\s*)")) {
                this.tfDAEmail.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAEmail.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAEmail.getId(), ResourceManager.getString("error.email.invalid", this.tfDAEmail.getText()));
                result = false;
            } else {
                this.tfDAEmail.getStyleClass().remove((Object)"invalid-field");
                this.tfDAEmail.getStyleClass().add((Object)"normal-field");
            }
            if (!this.tfDAPhone.getText().isEmpty() && !this.tfDAPhone.getText().matches("([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})")) {
                this.tfDAPhone.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAPhone.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAPhone.getId(), ResourceManager.getString("error.phone.invalid", this.tfDAPhone.getText()));
                result = false;
            } else {
                this.tfDAPhone.getStyleClass().remove((Object)"invalid-field");
                this.tfDAPhone.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfCurrSMK.isVisible() && this.tfCurrSMK.getText().isEmpty()) {
                this.tfCurrSMK.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfCurrSMK.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfCurrSMK.getId(), ResourceManager.getString("error.smk.required"));
                result = false;
            } else {
                this.tfCurrSMK.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfCurrSMK.getStyleClass().add((Object)"normal-field");
            }
            if (result) {
                this.updateTaskMessage = 1;
                this.pwRequested.clear();
                this.fromTaskUserData.setTfCurrSMK(this.tfCurrSMK.getText());
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromTaskUserData.setTfSOFname(this.tfDAFirst.getText());
                this.fromTaskUserData.setTfSOLname(this.tfDALast.getText());
                this.fromTaskUserData.setTfSOEmail(this.tfDAEmail.getText());
                this.fromTaskUserData.setTfSOPhone(this.tfDAPhone.getText());
                this.fromGuiUserData.setTfCurrSMK(this.tfCurrSMK.getText());
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfSOFname(this.tfDAFirst.getText());
                this.fromGuiUserData.setTfSOLname(this.tfDALast.getText());
                this.fromGuiUserData.setTfSOEmail(this.tfDAEmail.getText());
                this.fromGuiUserData.setTfSOPhone(this.tfDAPhone.getText());
                logger.log(Level.INFO, ResourceManager.getString("log.info.so.editing"));
                TaskEditSO soEditTask = new TaskEditSO(this.tfDAFirst.getText(), this.tfDALast.getText(), this.tfDAEmail.getText(), this.tfDAPhone.getText());
                soEditTask.setOnScheduled(this.onScheduled);
                soEditTask.setOnSucceeded(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbDAError.textProperty().bind((ObservableValue)soEditTask.messageProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(soEditTask, this.updateProgressTask);
                this.pnlCreateDA.setDisable(true);
                this.pnCtrlButtons.setDisable(true);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.handleOkEditSO(). " + ex.getMessage());
        }
    }

    @FXML
    private void handleOk() {
        try {
            this.errorsMsgs = new HashMap<String, String>();
            boolean result = true;
            this.lbDAError.textProperty().unbind();
            this.lbDAError.setText("");
            this.lbDAError.setVisible(true);
            if (this.tfId.getText().isEmpty()) {
                this.tfId.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfId.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfId.getId(), ResourceManager.getString("error.da-id.required"));
                result = false;
            } else {
                this.tfId.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfId.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDAFirst.getText().isEmpty()) {
                this.tfDAFirst.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAFirst.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAFirst.getId(), ResourceManager.getString("error.fname.required"));
                result = false;
            } else {
                this.tfDAFirst.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDAFirst.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDALast.getText().isEmpty()) {
                this.tfDALast.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDALast.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDALast.getId(), ResourceManager.getString("error.lname.required"));
                result = false;
            } else {
                this.tfDALast.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDALast.getStyleClass().add((Object)"normal-field");
            }
            if (!this.tfDAEmail.getText().isEmpty() && !this.tfDAEmail.getText().matches("(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*:(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)(?:,\\s*(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*))*)?;\\s*)")) {
                this.tfDAEmail.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAEmail.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAEmail.getId(), ResourceManager.getString("error.email.invalid", this.tfDAEmail.getText()));
                result = false;
            } else {
                this.tfDAEmail.getStyleClass().remove((Object)"invalid-field");
                this.tfDAEmail.getStyleClass().add((Object)"normal-field");
            }
            if (!this.tfDAPhone.getText().isEmpty() && !this.tfDAPhone.getText().matches("([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})")) {
                this.tfDAPhone.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAPhone.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAPhone.getId(), ResourceManager.getString("error.phone.invalid", this.tfDAPhone.getText()));
                result = false;
            } else {
                this.tfDAPhone.getStyleClass().remove((Object)"invalid-field");
                this.tfDAPhone.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfNewDMK.getText().isEmpty() || this.tfNewDMK.getText().length() < 16 || this.tfNewDMK.getText().length() > 60 || !this.tfNewDMK.getText().matches("^([0-9]+[a-zA-Z]+|[a-zA-Z]+[0-9]+)[0-9a-zA-Z]*$")) {
                this.tfNewDMK.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfNewDMK.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfNewDMK.getId(), ResourceManager.getString("error.dmk.lenght"));
                result = false;
            } else {
                this.tfNewDMK.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfNewDMK.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfRetypedDMK.getText().isEmpty() || !this.tfNewDMK.getText().equals(this.tfRetypedDMK.getText())) {
                this.tfRetypedDMK.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfRetypedDMK.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfRetypedDMK.getId(), ResourceManager.getString("error.keys.not_match"));
                result = false;
            } else {
                this.tfRetypedDMK.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfRetypedDMK.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfCurrSMK.isVisible() && this.tfCurrSMK.getText().isEmpty()) {
                this.tfCurrSMK.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfCurrSMK.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfCurrSMK.getId(), ResourceManager.getString("error.smk.required"));
                result = false;
            } else {
                this.tfCurrSMK.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfCurrSMK.getStyleClass().add((Object)"normal-field");
            }
            if (result) {
                this.updateTaskMessage = 2;
                this.pwRequested.clear();
                this.fromTaskUserData.setTfNewDMK(this.tfNewDMK.getText());
                this.fromTaskUserData.setTfRetypedDMK(this.tfRetypedDMK.getText());
                this.fromTaskUserData.setTfCurrSMK(this.tfCurrSMK.getText());
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfNewDMK(this.tfNewDMK.getText());
                this.fromGuiUserData.setTfRetypedDMK(this.tfRetypedDMK.getText());
                this.fromGuiUserData.setTfCurrSMK(this.tfCurrSMK.getText());
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                logger.log(Level.INFO, ResourceManager.getString("log.info.da.configuring"));
                String configFile = FileUtil.createAdmConfigFile(this.tfId.getText(), this.tfDAFirst.getText(), this.tfDALast.getText(), this.tfDAEmail.getText(), this.tfDAPhone.getText(), false);
                if (configFile == null) {
                    this.lbDAError.setText(ResourceManager.getString("error.operation.cancelled"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.cancelled"));
                    return;
                }
                DACreateTask daCreateTask = new DACreateTask(configFile, this.pwRequested, this.tfId.getText());
                daCreateTask.setOnScheduled(this.onScheduled);
                daCreateTask.setOnSucceeded(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbDAError.textProperty().bind((ObservableValue)daCreateTask.messageProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(daCreateTask, this.updateProgressTask);
                this.pnlCreateDA.setDisable(true);
                this.pnCtrlButtons.setDisable(true);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.handleOk(). " + ex.getMessage());
        }
    }

    @FXML
    private void showErrorIfExist(MouseEvent event) {
        try {
            Control control = (Control)event.getSource();
            if (this.errorsMsgs == null || !this.errorsMsgs.containsKey(control.getId())) {
                return;
            }
            this.lbDAError.setText(this.errorsMsgs.get(control.getId()));
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.showErrorIfExist(). " + ex.getMessage());
        }
    }

    @FXML
    private void clearErrorIfExist(MouseEvent event) {
        try {
            if (this.errorsMsgs != null && !this.errorsMsgs.isEmpty()) {
                this.lbDAError.textProperty().unbind();
                this.lbDAError.setText("");
                this.lbDAError.textProperty().unbind();
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.clearErrorIfExist(). " + ex.getMessage());
        }
    }

    @FXML
    private void keyReleased(KeyEvent event) {
        try {
            Control ctrl;
            if (event.getCode() != KeyCode.UNDEFINED && event.getCode() != KeyCode.TAB && event.getSource() instanceof Control && (ctrl = (Control)event.getSource()).getStyleClass().contains((Object)"invalid-field")) {
                ctrl.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                ctrl.getStyleClass().add((Object)"normal-field");
                if (this.errorsMsgs != null && this.errorsMsgs.containsKey(ctrl.getId())) {
                    this.errorsMsgs.remove(ctrl.getId());
                }
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.keyReleased(). " + ex.getMessage());
        }
    }

    private void cleanForm() {
        try {
            this.tfDAFirst.setText("");
            this.tfDALast.setText("");
            this.tfDAEmail.setText("");
            this.tfDAPhone.setText("");
            if (this.type == 0) {
                this.tfNewDMK.setText("");
                this.tfRetypedDMK.setText("");
                this.tfCurrSMK.setText("");
            } else if (this.type == 1) {
                this.tfCurrDMK.setText("");
            } else {
                this.tfCurrSMK.setText("");
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.cleanForm(). " + ex.getMessage());
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.pwRequested = new ArrayList<Integer>();
    }

    public void cleanCurrSMK() {
        try {
            this.tfCurrSMK.setVisible(true);
            this.tfCurrSMK.setText("");
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.cleanCurrSMK(). " + ex.getMessage());
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    private void startTasks(Task sgaTask, Task updateProgressTask) {
        try {
            Thread th = new Thread((Runnable)sgaTask);
            Thread th2 = new Thread((Runnable)updateProgressTask);
            th.setDaemon(true);
            th2.setDaemon(true);
            th.start();
            th2.start();
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.DaFormController.startTasks(). " + ex.getMessage());
        }
    }

    public Label getLbError() {
        return this.lbDAError;
    }

    public void setLbError(Label lbError) {
        this.lbError = lbError;
    }

    public Label getLblStatusMsg() {
        return this.lblStatusMsg;
    }

    public void setLblStatusMsg(Label lblStatusMsg) {
        this.lblStatusMsg = lblStatusMsg;
    }
}

