/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.PolicyStartException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskStartPolicy
extends Task<Boolean> {
    private List<Integer> pwRequested;
    private static final Logger logger = LogManager.getLogger();
    private String DAId;
    private String Policy;

    public TaskStartPolicy(List<Integer> pwRequested, String DAId, String Policy2) {
        this.pwRequested = pwRequested;
        this.DAId = DAId;
        this.Policy = Policy2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean call() throws Exception {
        this.updateTitle(ResourceManager.getString("info.policy.starting"));
        SGAManager sga = SGAManager.getInstance();
        try {
            boolean existPolicy = sga.existPolicy(this.Policy);
            if (!existPolicy) {
                this.updateMessage(ResourceManager.getString("error.policy.log.not_protected"));
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, ResourceManager.getString("error.policy.log.not_protected"));
                Boolean bl = null;
                return bl;
            }
            if (!sga.startPolicy(this.Policy, this.DAId)) {
                this.updateMessage(ResourceManager.getString("error.vault.starting"));
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, ResourceManager.getString("error.vault.starting"));
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            this.updateTitle(ResourceManager.getString("info.policy.log.protection.started.success"));
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (NoSGAdminException | PolicyStartException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            this.updateMessage(ex.getMessage());
            this.updateTitle(ResourceManager.getString("error.operation"));
        }
        finally {
            sga.clearCache();
        }
        return Boolean.FALSE;
    }
}

