/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.DMKRotateException;
import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.util.Map;
import javafx.concurrent.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskRotateDMK
extends Task<Void> {
    private static final Logger logger = LogManager.getLogger();
    private String DAId;
    private Map<String, String> userData;

    public TaskRotateDMK(String DAId, Map<String, String> userData) {
        this.DAId = DAId;
        this.userData = userData;
    }

    TaskRotateDMK() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getDAId() {
        return this.DAId;
    }

    public void setDAId(String DAId) {
        this.DAId = DAId;
    }

    protected Void call() throws Exception {
        this.updateTitle(ResourceManager.getString("info.dmk.rotating"));
        SGAManager sga = SGAManager.getInstance();
        logger.log(Level.INFO, ResourceManager.getString("log.info.dmk.rotating", SGKms.getCurrentDA()));
        try {
            if (sga.dmkRotate(this.getDAId())) {
                this.updateTitle(ResourceManager.getString("info.dmk.rotate"));
                logger.log(Level.INFO, ResourceManager.getString("info.dmk.rotate"));
            } else {
                this.updateMessage(ResourceManager.getString("error.dmk.rotate"));
                this.updateTitle(ResourceManager.getString("error.operation"));
                logger.log(Level.ERROR, ResourceManager.getString("error.dmk.rotate"));
            }
        }
        catch (DMKRotateException | NoSGAdminException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.updateMessage(ex.getMessage());
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            sga.clearCache();
            this.userData.clear();
        }
        return null;
    }
}

