/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.graph.selector;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.sonatype.aether.collection.DependencyCollectionContext;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.graph.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeDependencySelector
implements DependencySelector {
    private final boolean transitive;
    private final Collection<String> included;
    private final Collection<String> excluded;

    public ScopeDependencySelector(Collection<String> included, Collection<String> excluded) {
        this.transitive = false;
        if (included != null) {
            this.included = new HashSet<String>();
            this.included.addAll(included);
        } else {
            this.included = Collections.emptySet();
        }
        if (excluded != null) {
            this.excluded = new HashSet<String>();
            this.excluded.addAll(excluded);
        } else {
            this.excluded = Collections.emptySet();
        }
    }

    public ScopeDependencySelector(String ... excluded) {
        this(null, Arrays.asList(excluded));
    }

    private ScopeDependencySelector(boolean transitive, Collection<String> included, Collection<String> excluded) {
        this.transitive = transitive;
        this.included = included;
        this.excluded = excluded;
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        if (!this.transitive) {
            return true;
        }
        String scope = dependency.getScope();
        return !(!this.included.isEmpty() && !this.included.contains(scope) || !this.excluded.isEmpty() && this.excluded.contains(scope));
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        if (this.transitive || context.getDependency() == null) {
            return this;
        }
        return new ScopeDependencySelector(true, this.included, this.excluded);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScopeDependencySelector that = (ScopeDependencySelector)obj;
        return this.transitive == that.transitive && ((Object)this.included).equals(that.included) && ((Object)this.excluded).equals(that.excluded);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (this.transitive ? 1 : 0);
        hash = hash * 31 + ((Object)this.included).hashCode();
        hash = hash * 31 + ((Object)this.excluded).hashCode();
        return hash;
    }
}

