/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.gui.GuiUserData;
import com.servergeneral.sgkms.model.Actor;
import com.servergeneral.sgkms.model.Policy;
import com.servergeneral.sgkms.tasks.PolicyAddTask;
import com.servergeneral.sgkms.tasks.PolicyEditTask;
import com.servergeneral.sgkms.tasks.TaskPolicyReassign;
import com.servergeneral.sgkms.util.FileUtil;
import com.servergeneral.sgkms.util.TaskUpdateProgress;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolicyFormController
implements Initializable {
    @FXML
    private ComboBox tfPolicies;
    private ObservableList<Policy> policyList;
    @FXML
    private TextField tfShortname;
    @FXML
    private TextField tfAppName;
    @FXML
    private TextField tfAllowedUsers;
    @FXML
    private TextField tfRepo;
    @FXML
    private ComboBox tfDAid;
    @FXML
    private PasswordField tfDAdmk;
    @FXML
    private Label lbDAError;
    @FXML
    private TextField tfCurrentDA;
    @FXML
    private ComboBox tfnewDA;
    @FXML
    private PasswordField tfSOsmk;
    ObservableList<String> optionsDA = FXCollections.observableArrayList();
    ObservableList<String> optionsPolicies = FXCollections.observableArrayList();
    @FXML
    private ProgressBar pbProccess;
    private Map<String, String> errorsMsgs;
    private static final Logger logger = LogManager.getLogger();
    private List<Integer> pwRequested;
    private GuiUserData fromGuiUserData = new GuiUserData(false);
    private GuiUserData fromTaskUserData = new GuiUserData(true);
    private Task updateProgressTask;
    private Stage dialogStage;
    private int type = 0;
    private boolean result = true;
    @FXML
    private Label lblStatusMsg;
    @FXML
    private Label lbError;
    @FXML
    private Pane pnCtrlButtons;
    @FXML
    private Pane pnlCreatePolicy;
    @FXML
    private ListView listRepo;
    @FXML
    private ListView listAllowedUsers;
    private Stage primaryStage;
    private final EventHandler onScheduled = event -> {
        try {
            this.pbProccess.setVisible(true);
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.methodName(). " + ex.getMessage());
        }
    };
    private final EventHandler onSucceeded = event -> {
        try {
            this.pbProccess.setVisible(false);
            this.updateProgressTask.cancel();
            if (event.getSource() instanceof Task) {
                Task task = (Task)event.getSource();
                this.pnlCreatePolicy.setDisable(false);
                this.pnCtrlButtons.setDisable(false);
                if (task.getValue() != null && ((Boolean)task.getValue()).booleanValue()) {
                    this.handleCancel();
                    this.result = true;
                    switch (this.type) {
                        case 0: {
                            this.cleanForm();
                            this.lblStatusMsg.setText(ResourceManager.getString("info.policy.create", this.tfShortname.getText()));
                            break;
                        }
                        case 1: {
                            this.cleanForm();
                            this.lblStatusMsg.setText(ResourceManager.getString("info.policy.edit", this.tfShortname.getText()));
                            break;
                        }
                        case 3: {
                            this.lblStatusMsg.setText(ResourceManager.getString("log.info.sgamanager.pol-reassign.success", this.tfPolicies.getSelectionModel().getSelectedItem().toString()));
                        }
                    }
                }
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.methodName(). " + ex.getMessage());
        }
    };

    public void initialize(URL url, ResourceBundle rb) {
        this.pwRequested = new ArrayList<Integer>();
        this.pnlCreatePolicy.setDisable(false);
        this.pnCtrlButtons.setDisable(false);
    }

    public void setTfDAid(ObservableList<Actor> daList) {
        try {
            if (this.optionsDA != null && !this.optionsDA.isEmpty()) {
                this.optionsDA.clear();
            }
            for (Actor element : daList) {
                this.optionsDA.add((Object)element.getId().getValue());
            }
            this.tfDAid.setItems(this.optionsDA);
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.setTfDAid(). " + ex.getMessage());
        }
    }

    public void prepareReassign(ObservableList<Actor> daList, Policy policy) {
        try {
            if (this.optionsDA != null && !this.optionsDA.isEmpty()) {
                this.optionsDA.clear();
            }
            for (Actor element : daList) {
                if (element.getId().getValue().equals(policy.getDa_id().getValue())) continue;
                this.optionsDA.add((Object)element.getId().getValue());
            }
            this.tfnewDA.setItems(this.optionsDA);
            this.tfCurrentDA.setText(policy.getDa_id().getValue());
            this.tfCurrentDA.setDisable(true);
            this.tfShortname.setDisable(true);
            this.tfShortname.setText(policy.getPolicy_shortname().getValue());
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.prepareReassign(). " + ex.getMessage());
        }
    }

    public void prepareReassign(ObservableList<Policy> policyList) {
        try {
            if (this.optionsDA != null && !this.optionsDA.isEmpty()) {
                this.optionsDA.clear();
            }
            if (this.optionsPolicies != null && !this.optionsPolicies.isEmpty()) {
                this.optionsPolicies.clear();
            }
            this.policyList = policyList;
            for (Policy element : policyList) {
                this.optionsPolicies.add((Object)element.getPolicy_shortname().getValue());
            }
            this.tfPolicies.setItems(this.optionsPolicies);
            this.tfnewDA.setItems(this.optionsDA);
            this.tfCurrentDA.setDisable(true);
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.prepareReassign(). " + ex.getMessage());
        }
    }

    @FXML
    public void onChangePolicySelected() {
        if (!this.tfPolicies.getSelectionModel().isEmpty()) {
            String selectedPolicy = this.tfPolicies.getSelectionModel().getSelectedItem().toString();
            Policy policy = (Policy)this.policyList.get(this.tfPolicies.getSelectionModel().getSelectedIndex());
            this.tfCurrentDA.setText(policy.getDa_id().getValue());
            ObservableList<Actor> daList = FileUtil.getDAList("/etc/serverg/da.conf");
            if (this.optionsDA != null && !this.optionsDA.isEmpty()) {
                this.optionsDA.clear();
            }
            for (Actor element : daList) {
                if (element.getId().getValue().equals(policy.getDa_id().getValue())) continue;
                this.optionsDA.add((Object)element.getId().getValue());
            }
            this.tfnewDA.setItems(this.optionsDA);
        }
    }

    @FXML
    private void showErrorIfExist(MouseEvent event) {
        try {
            Control control = (Control)event.getSource();
            if (this.errorsMsgs == null || !this.errorsMsgs.containsKey(control.getId())) {
                return;
            }
            this.lbDAError.setText(this.errorsMsgs.get(control.getId()));
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.showErrorIfExist(). " + ex.getMessage());
        }
    }

    @FXML
    private void clearErrorIfExist(MouseEvent event) {
        try {
            if (this.errorsMsgs != null && !this.errorsMsgs.isEmpty()) {
                this.lbDAError.textProperty().unbind();
                this.lbDAError.setText("");
                this.lbDAError.textProperty().unbind();
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.clearErrorIfExist(). " + ex.getMessage());
        }
    }

    @FXML
    private void keyReleased(KeyEvent event) {
        try {
            Control ctrl;
            if (event.getCode() != KeyCode.UNDEFINED && event.getCode() != KeyCode.TAB && event.getSource() instanceof Control && (ctrl = (Control)event.getSource()).getStyleClass().contains((Object)"invalid-field")) {
                ctrl.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                ctrl.getStyleClass().add((Object)"normal-field");
                if (this.errorsMsgs != null && this.errorsMsgs.containsKey(ctrl.getId())) {
                    this.errorsMsgs.remove(ctrl.getId());
                }
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.keyReleased(). " + ex.getMessage());
        }
    }

    private void cleanForm() {
        try {
            this.tfAllowedUsers.setText("");
            this.tfAppName.setText("");
            this.tfDAdmk.setText("");
            this.tfShortname.setText("");
            this.listAllowedUsers.getItems().clear();
            this.listRepo.getItems().clear();
            if (this.tfDAid.getItems() != null && !this.tfDAid.getItems().isEmpty()) {
                this.tfDAid.getItems().clear();
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.cleanForm(). " + ex.getMessage());
        }
    }

    @FXML
    public void addRepo(ActionEvent ae) {
        if (!this.tfRepo.getText().isEmpty()) {
            if (this.listRepo.getItems().contains((Object)this.tfRepo.getText())) {
                this.lbDAError.setText(ResourceManager.getString("error.repo.duplicated"));
            } else {
                this.listRepo.getItems().add((Object)this.tfRepo.getText());
                this.tfRepo.setText("");
            }
        } else {
            this.lbDAError.setText(ResourceManager.getString("error.repo.required"));
        }
    }

    @FXML
    public void addAllowedUsers() {
        if (!this.tfAllowedUsers.getText().isEmpty()) {
            if (this.listAllowedUsers.getItems().contains((Object)this.tfAllowedUsers.getText())) {
                this.lbDAError.setText(ResourceManager.getString("error.allowed-users.duplicated"));
            } else {
                this.listAllowedUsers.getItems().add((Object)this.tfAllowedUsers.getText());
                this.tfAllowedUsers.setText("");
            }
        } else {
            this.lbDAError.setText(ResourceManager.getString("error.allowed-users.empty"));
        }
    }

    @FXML
    public void deleteSelectedUsers() {
        this.listAllowedUsers.getItems().remove(this.listAllowedUsers.getSelectionModel().getSelectedItem());
    }

    @FXML
    public void searchPath() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        File selectedDirectory = directoryChooser.showDialog((Window)this.primaryStage);
        if (selectedDirectory == null) {
            this.lbDAError.setText(ResourceManager.getString("error.directory.repo.noselect"));
        } else if (this.listRepo.getItems().contains((Object)selectedDirectory.getAbsolutePath())) {
            this.lbDAError.setText(ResourceManager.getString("error.repo.duplicated"));
        } else {
            this.listRepo.getItems().add((Object)selectedDirectory.getAbsolutePath());
        }
    }

    @FXML
    public void deleteSelectedPatch() {
        this.listRepo.getItems().remove(this.listRepo.getSelectionModel().getSelectedItem());
    }

    public Stage getDialogStage() {
        return this.dialogStage;
    }

    public void setDialogStage(Stage dialogStage) {
        this.dialogStage = dialogStage;
    }

    private void startTasks(Task sgaTask, Task updateProgressTask) {
        try {
            Thread th = new Thread((Runnable)sgaTask);
            Thread th2 = new Thread((Runnable)updateProgressTask);
            th.setDaemon(true);
            th2.setDaemon(true);
            th.start();
            th2.start();
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.startTasks(). " + ex.getMessage());
        }
    }

    @FXML
    private void handleCancel() {
        this.result = false;
        this.dialogStage.close();
    }

    @FXML
    private void handleOkReassign() {
        try {
            this.errorsMsgs = new HashMap<String, String>();
            this.lbDAError.textProperty().unbind();
            this.lbDAError.setText("");
            this.lbDAError.setVisible(true);
            boolean result = true;
            if (this.tfPolicies.getSelectionModel().isEmpty()) {
                this.tfPolicies.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfPolicies.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfPolicies.getId(), ResourceManager.getString("error.policy.required"));
                result = false;
            }
            if (this.tfnewDA.getSelectionModel().isEmpty()) {
                this.tfnewDA.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfnewDA.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfnewDA.getId(), ResourceManager.getString("error.newDA.required"));
                result = false;
            }
            if (this.tfSOsmk.getText().isEmpty()) {
                this.tfSOsmk.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfSOsmk.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfSOsmk.getId(), ResourceManager.getString("error.smk.required"));
                result = false;
            }
            if (result) {
                this.pwRequested.clear();
                this.type = 3;
                this.pnlCreatePolicy.setDisable(true);
                this.pnCtrlButtons.setDisable(true);
                this.fromTaskUserData.setTfCurrSMK(this.tfSOsmk.getText());
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfCurrSMK(this.tfSOsmk.getText());
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                TaskPolicyReassign taskPolicyReassign = new TaskPolicyReassign(this.tfCurrentDA.getText(), this.tfnewDA.getSelectionModel().getSelectedItem().toString(), this.tfPolicies.getSelectionModel().getSelectedItem().toString());
                taskPolicyReassign.setOnScheduled(this.onScheduled);
                taskPolicyReassign.setOnSucceeded(this.onSucceeded);
                this.updateProgressTask = new TaskUpdateProgress();
                this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                this.lbDAError.textProperty().bind((ObservableValue)taskPolicyReassign.messageProperty());
                SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                this.startTasks(taskPolicyReassign, this.updateProgressTask);
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.handleOkReassign(). " + ex.getMessage());
        }
    }

    @FXML
    private void handleOk() {
        try {
            this.errorsMsgs = new HashMap<String, String>();
            boolean result = true;
            this.lbDAError.textProperty().unbind();
            this.lbDAError.setText("");
            this.lbDAError.setVisible(true);
            if (this.tfShortname.getText().isEmpty()) {
                this.tfShortname.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfShortname.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfShortname.getId(), ResourceManager.getString("error.shortname.required"));
                result = false;
            } else {
                this.tfShortname.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfShortname.getStyleClass().add((Object)"normal-field");
            }
            if (this.listRepo.getItems().size() == 0) {
                this.listRepo.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.listRepo.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.listRepo.getId(), ResourceManager.getString("error.repo.required"));
                result = false;
            } else {
                this.listRepo.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.listRepo.getStyleClass().add((Object)"normal-field");
            }
            if (this.tfDAdmk.getText().isEmpty()) {
                this.tfDAdmk.getStyleClass().removeAll((Object[])new String[]{"normal-field"});
                this.tfDAdmk.getStyleClass().add((Object)"invalid-field");
                this.errorsMsgs.put(this.tfDAdmk.getId(), ResourceManager.getString("error.dmk.required"));
                result = false;
            } else {
                this.tfDAdmk.getStyleClass().removeAll((Object[])new String[]{"invalid-field"});
                this.tfDAdmk.getStyleClass().add((Object)"normal-field");
            }
            if (result) {
                Task polAddTask;
                String configFile;
                this.pnlCreatePolicy.setDisable(true);
                this.pnCtrlButtons.setDisable(true);
                this.pwRequested.clear();
                this.fromTaskUserData.setTfCurrDMK(this.tfDAdmk.getText());
                this.fromTaskUserData.setPwRequested(this.pwRequested);
                this.fromGuiUserData.setTfCurrDMK(this.tfDAdmk.getText());
                this.fromGuiUserData.setPwRequested(this.pwRequested);
                logger.log(Level.INFO, ResourceManager.getString("log.info.da.configuring"));
                String DASelected = (String)this.tfDAid.getSelectionModel().getSelectedItem();
                String repo = "";
                for (Object item : this.listRepo.getItems()) {
                    if (repo.trim().length() > 0) {
                        repo = repo + ",";
                    }
                    repo = repo + (String)item;
                }
                String allowedUsers = "";
                for (Object item : this.listAllowedUsers.getItems()) {
                    if (allowedUsers.trim().length() > 0) {
                        allowedUsers = allowedUsers + ",";
                    }
                    allowedUsers = allowedUsers + (String)item;
                }
                if (!allowedUsers.trim().toLowerCase().contains("sgadmin")) {
                    if (allowedUsers.trim().length() > 0) {
                        allowedUsers = allowedUsers + ",";
                    }
                    allowedUsers = allowedUsers + "sgadmin";
                }
                if ((configFile = FileUtil.createPolicyConfigFile(this.tfShortname.getText(), repo, this.tfAppName.getText(), allowedUsers, DASelected)) == null) {
                    this.lbDAError.setText(ResourceManager.getString("error.operation.cancelled"));
                    logger.log(Level.ERROR, ResourceManager.getString("error.operation.cancelled"));
                    return;
                }
                if (this.type == 0) {
                    logger.log(Level.INFO, ResourceManager.getString("log.info.policy-add.configuring"));
                    polAddTask = new PolicyAddTask(configFile, DASelected, this.pwRequested, this.tfShortname.getText());
                    polAddTask.setOnScheduled(this.onScheduled);
                    polAddTask.setOnSucceeded(this.onSucceeded);
                    this.updateProgressTask = new TaskUpdateProgress();
                    this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                    this.lbDAError.textProperty().bind((ObservableValue)polAddTask.messageProperty());
                    SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                    this.startTasks(polAddTask, this.updateProgressTask);
                } else {
                    logger.log(Level.INFO, ResourceManager.getString("log.info.policy-edit.configuring"));
                    polAddTask = new PolicyEditTask(configFile, DASelected, this.pwRequested, this.tfShortname.getText());
                    polAddTask.setOnScheduled(this.onScheduled);
                    polAddTask.setOnSucceeded(this.onSucceeded);
                    this.updateProgressTask = new TaskUpdateProgress();
                    this.pbProccess.progressProperty().bind((ObservableValue)this.updateProgressTask.progressProperty());
                    this.lbDAError.textProperty().bind((ObservableValue)polAddTask.messageProperty());
                    SGAManager.getInstance().setUserInfoListener(this.fromGuiUserData);
                    this.startTasks(polAddTask, this.updateProgressTask);
                }
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.handleOk(). " + ex.getMessage());
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type, ObservableList<Actor> daList, String currentDA, Policy policy) {
        try {
            this.type = type;
            if (type == 0) {
                this.tfDAid.setDisable(false);
                this.tfShortname.setDisable(false);
                this.setTfDAid(daList);
            } else if (type == 1) {
                String[] value;
                this.setTfDAid(daList);
                this.tfDAid.setDisable(true);
                this.tfShortname.setText(policy.getPolicy_shortname().getValue());
                this.tfShortname.setDisable(true);
                this.tfAppName.setText(policy.getApp_name() == null ? "" : policy.getApp_name().getValue());
                if (policy.getAllowed_users() != null) {
                    value = policy.getAllowed_users().getValue().split(",");
                    this.listAllowedUsers.getItems().addAll(Arrays.asList(value));
                }
                if (policy.getRepo() != null) {
                    value = policy.getRepo().getValue().split(",");
                    this.listRepo.getItems().addAll(Arrays.asList(value));
                }
                this.tfDAid.getSelectionModel().select((Object)policy.getDa_id().getValue());
            }
        }
        catch (NullPointerException ex) {
            logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + " com.servergeneral.sgkms.gui.PolicyFormController.setType(). " + ex.getMessage());
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public Label getLblStatusMsg() {
        return this.lblStatusMsg;
    }

    public void setLblStatusMsg(Label lblStatusMsg) {
        this.lblStatusMsg = lblStatusMsg;
    }

    public Label getLbError() {
        return this.lbError;
    }

    public void setLbError(Label lbError) {
        this.lbError = lbError;
    }

    public boolean isResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public void setPrimaryStage(Stage primaryStage) {
        this.primaryStage = primaryStage;
    }
}

