/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sgkms.ResourceManager;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ChangeMKDialog
extends Dialog<Map<String, String>> {
    public static final int SO_MASTER_KEY = 0;
    public static final int DA_MASTER_KEY = 1;
    public static final String MK_VALUE = "mk";
    public static final String NEW_MK_VALUE = "new-mk";
    public static final String NEW_MK_AGAIN_VALUE = "new-mk-again";
    private PasswordField tfMK;
    private PasswordField tfNewMK;
    private PasswordField tfNewMKAgain;
    private Label lbError;
    private Map<String, String> errorsMsgs;
    private int mkType;
    EventHandler<MouseEvent> mouseEntered = event -> {
        Control control = (Control)event.getSource();
        if (this.errorsMsgs == null || !this.errorsMsgs.containsKey(control.getId())) {
            return;
        }
        this.lbError.setText(this.errorsMsgs.get(control.getId()));
    };
    EventHandler<MouseEvent> mouseExited = event -> {
        if (this.errorsMsgs != null && !this.errorsMsgs.isEmpty()) {
            this.lbError.setText("");
        }
    };
    EventHandler<KeyEvent> keyReleased = event -> {
        Control ctrl;
        if (event.getCode() != KeyCode.UNDEFINED && event.getCode() != KeyCode.TAB && event.getSource() instanceof Control && (ctrl = (Control)event.getSource()).getStyleClass().contains((Object)"invalid-field")) {
            ctrl.getStyleClass().remove((Object)"invalid-field");
            ctrl.getStyleClass().add((Object)"normal-field");
            if (this.errorsMsgs != null && this.errorsMsgs.containsKey(ctrl.getId())) {
                this.errorsMsgs.remove(ctrl.getId());
            }
        }
    };

    public ChangeMKDialog(String title, String headerText, int mkType) {
        this.setTitle(title);
        this.setHeaderText(headerText);
        this.mkType = mkType;
        this.errorsMsgs = new HashMap<String, String>();
        this.setGraphic((Node)new ImageView(((Object)((Object)this)).getClass().getResource("/images/password.png").toString()));
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.tfMK = new PasswordField();
        this.tfMK.setId("tfMK");
        this.tfNewMK = new PasswordField();
        this.tfNewMK.setId("tfNewMK");
        this.tfNewMKAgain = new PasswordField();
        this.tfNewMKAgain.setId("tfNewMKAgain");
        Label lbMK = new Label();
        Label lbNewMK = new Label();
        Label lbNewMKAgain = new Label();
        if (mkType == 0) {
            lbMK.setText(ResourceManager.getString("label.smk.caption"));
            this.tfMK.setPromptText(ResourceManager.getString("label.smk.place-holder"));
            this.tfMK.setTooltip(new Tooltip(ResourceManager.getString("label.smk.tooltip")));
            lbNewMK.setText(ResourceManager.getString("label.new-smk.caption"));
            this.tfNewMK.setPromptText(ResourceManager.getString("label.new-smk.place-holder"));
            this.tfNewMK.setTooltip(new Tooltip(ResourceManager.getString("label.new-smk.tooltip")));
            lbNewMKAgain.setText(ResourceManager.getString("label.retype-smk.caption"));
            this.tfNewMKAgain.setPromptText(ResourceManager.getString("label.retype-smk.place-holder"));
            this.tfNewMKAgain.setTooltip(new Tooltip(ResourceManager.getString("label.retype-smk.tooltip")));
        } else {
            lbMK.setText(ResourceManager.getString("label.dmk.caption"));
            this.tfMK.setPromptText(ResourceManager.getString("label.dmk.place-holder"));
            this.tfMK.setTooltip(new Tooltip(ResourceManager.getString("label.dmk.password.tooltip")));
            lbNewMK.setText(ResourceManager.getString("label.new-dmk.caption"));
            this.tfNewMK.setPromptText(ResourceManager.getString("label.new-dmk.place-holder"));
            this.tfNewMK.setTooltip(new Tooltip(ResourceManager.getString("label.new-dmk.tooltip")));
            lbNewMKAgain.setText(ResourceManager.getString("label.retype-dmk.caption"));
            this.tfNewMKAgain.setPromptText(ResourceManager.getString("label.retype-dmk.place-holder"));
            this.tfNewMKAgain.setTooltip(new Tooltip(ResourceManager.getString("label.retype-dmk.tooltip")));
        }
        this.tfMK.getStyleClass().add((Object)"normal-field");
        this.tfNewMK.getStyleClass().add((Object)"normal-field");
        this.tfNewMKAgain.getStyleClass().add((Object)"normal-field");
        this.lbError = new Label();
        this.lbError.prefHeightProperty().bind((ObservableValue)grid.heightProperty());
        this.lbError.prefWidthProperty().bind((ObservableValue)new SimpleDoubleProperty(150.0));
        this.lbError.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        this.lbError.setTextFill((Paint)Color.RED);
        this.lbError.setAlignment(Pos.TOP_LEFT);
        this.lbError.setWrapText(true);
        grid.add((Node)lbMK, 0, 0);
        grid.add((Node)this.tfMK, 1, 0);
        grid.add((Node)lbNewMK, 0, 1);
        grid.add((Node)this.tfNewMK, 1, 1);
        grid.add((Node)lbNewMKAgain, 0, 2);
        grid.add((Node)this.tfNewMKAgain, 1, 2);
        grid.getStylesheets().add((Object)"/styles/validation.css");
        BorderPane mainPane = new BorderPane(null, null, (Node)this.lbError, null, (Node)grid);
        this.getDialogPane().setContent((Node)mainPane);
        grid.setAlignment(Pos.CENTER_LEFT);
        Platform.runLater(() -> this.tfMK.requestFocus());
        this.tfMK.setOnMouseEntered(this.mouseEntered);
        this.tfMK.setOnMouseExited(this.mouseExited);
        this.tfMK.setOnKeyReleased(this.keyReleased);
        this.tfNewMK.setOnMouseEntered(this.mouseEntered);
        this.tfNewMK.setOnMouseExited(this.mouseExited);
        this.tfNewMK.setOnKeyReleased(this.keyReleased);
        this.tfNewMKAgain.setOnMouseEntered(this.mouseEntered);
        this.tfNewMKAgain.setOnMouseExited(this.mouseExited);
        this.tfNewMKAgain.setOnKeyReleased(this.keyReleased);
        Node loginButton = this.getDialogPane().lookupButton(ButtonType.OK);
        loginButton.addEventFilter(ActionEvent.ACTION, ae -> {
            if (!this.isValid()) {
                ae.consume();
            }
        });
        this.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.OK) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put(MK_VALUE, this.tfMK.getText());
                result.put(NEW_MK_VALUE, this.tfNewMK.getText());
                result.put(NEW_MK_AGAIN_VALUE, this.tfNewMKAgain.getText());
                return result;
            }
            return null;
        });
    }

    private boolean isValid() {
        boolean result = true;
        this.errorsMsgs.clear();
        this.lbError.setText("");
        if (this.tfMK.getText().isEmpty()) {
            if (!this.tfMK.getStyleClass().contains((Object)"invalid-field")) {
                this.tfMK.getStyleClass().remove((Object)"normal-field");
                this.tfMK.getStyleClass().add((Object)"invalid-field");
            }
            this.errorsMsgs.put(this.tfMK.getId(), ResourceManager.getString(this.mkType == 0 ? "error.smk.required" : "error.dmk.required"));
        } else if (this.tfMK.getStyleClass().contains((Object)"invalid-field")) {
            this.tfMK.getStyleClass().remove((Object)"invalid-field");
            this.tfMK.getStyleClass().add((Object)"normal-field");
        }
        if (this.tfNewMK.getText().isEmpty() || this.tfNewMK.getText().length() < 16 || this.tfNewMK.getText().length() > 60 || !this.tfNewMK.getText().matches("^([0-9]+[a-zA-Z]+|[a-zA-Z]+[0-9]+)[0-9a-zA-Z]*$")) {
            if (!this.tfNewMK.getStyleClass().contains((Object)"invalid-field")) {
                this.tfNewMK.getStyleClass().remove((Object)"normal-field");
                this.tfNewMK.getStyleClass().add((Object)"invalid-field");
            }
            this.errorsMsgs.put(this.tfNewMK.getId(), ResourceManager.getString(this.mkType == 0 ? "error.smk.lenght" : "error.dmk.lenght"));
            result = false;
        } else if (this.tfNewMK.getStyleClass().contains((Object)"invalid-field")) {
            this.tfNewMK.getStyleClass().remove((Object)"invalid-field");
            this.tfNewMK.getStyleClass().add((Object)"normal-field");
        }
        if (this.tfNewMKAgain.getText().isEmpty() || !this.tfNewMK.getText().equals(this.tfNewMKAgain.getText())) {
            if (!this.tfNewMKAgain.getStyleClass().contains((Object)"invalid-field")) {
                this.tfNewMKAgain.getStyleClass().remove((Object)"normal-field");
                this.tfNewMKAgain.getStyleClass().add((Object)"invalid-field");
            }
            this.errorsMsgs.put(this.tfNewMKAgain.getId(), ResourceManager.getString("error.keys.not_match"));
            result = false;
        } else if (this.tfNewMKAgain.getStyleClass().contains((Object)"invalid-field")) {
            this.tfNewMKAgain.getStyleClass().remove((Object)"invalid-field");
            this.tfNewMKAgain.getStyleClass().add((Object)"normal-field");
        }
        return result;
    }
}

