/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.sgkms.util.DBUtil;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;

public class MySQLConnectionDialog
extends Dialog<Map<String, String>> {
    MySQLConnectionDialog(String title, String headerText) {
        this.setTitle(title);
        this.setHeaderText(headerText);
        this.setGraphic((Node)new ImageView(((Object)((Object)this)).getClass().getResource("/images/mysql.png").toString()));
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        TextField port = new TextField();
        port.setPromptText(ResourceManager.getString("label.mysql.port.place-holder"));
        port.setTooltip(new Tooltip(ResourceManager.getString("label.mysql.port.tooltip")));
        TextField username = new TextField();
        username.setPromptText(ResourceManager.getString("label.mysql.user.place-holder"));
        username.setTooltip(new Tooltip(ResourceManager.getString("label.mysql.user.tooltip")));
        PasswordField password = new PasswordField();
        password.setPromptText(ResourceManager.getString("label.mysql.password.place-holder"));
        password.setTooltip(new Tooltip(ResourceManager.getString("label.mysql.password.tooltip")));
        grid.add((Node)new Label(ResourceManager.getString("label.mysql.port.caption")), 0, 0);
        grid.add((Node)port, 1, 0);
        grid.add((Node)new Label(ResourceManager.getString("label.mysql.user.caption")), 0, 1);
        grid.add((Node)username, 1, 1);
        grid.add((Node)new Label(ResourceManager.getString("label.mysql.password.caption")), 0, 2);
        grid.add((Node)password, 1, 2);
        if (DBUtil.loadDBConfig(SGKms.CONFIG_FOLDER + "/" + "sg-tde.properties")) {
            port.setText(DBUtil.dbConfig.getPort());
            username.setText(DBUtil.dbConfig.getUser());
        } else {
            port.setText("3306");
            username.setText("root");
        }
        Node loginButton = this.getDialogPane().lookupButton(ButtonType.OK);
        loginButton.setDisable(true);
        username.textProperty().addListener((observable, oldValue, newValue) -> loginButton.setDisable(newValue.trim().isEmpty() || port.getText().isEmpty() || password.getText().isEmpty()));
        port.textProperty().addListener((observable, oldValue, newValue) -> loginButton.setDisable(newValue.trim().isEmpty() || username.getText().isEmpty() || password.getText().isEmpty()));
        password.textProperty().addListener((observable, oldValue, newValue) -> loginButton.setDisable(newValue.trim().isEmpty() || port.getText().isEmpty() || username.getText().isEmpty()));
        this.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> password.requestFocus());
        this.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.OK) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("port", port.getText());
                result.put("username", username.getText());
                result.put("password", password.getText());
                return result;
            }
            return null;
        });
    }
}

