/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.gui.ValidatorManager;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class RevokeDADialog
extends Dialog<Map<String, String>> {
    public static final String FNAME_VALUE = "fname";
    public static final String LNAME_VALUE = "lname";
    public static final String EMAIL_VALUE = "email";
    public static final String PHONE_VALUE = "phone";
    public static final String SMK_VALUE = "smk";
    public static final String NEW_MK_VALUE = "new-dmk";
    public static final String NEW_MK_AGAIN_VALUE = "new-dmk-again";
    private TextField tfDAFirst;
    private TextField tfDALast;
    private TextField tfDAEmail;
    private TextField tfDAPhone;
    private PasswordField tfCurrSMK;
    private PasswordField tfNewDMK;
    private PasswordField tfRetypedDMK;
    private Label lbError;
    private Map<String, String> errorsMsgs;
    EventHandler<MouseEvent> mouseEntered = event -> {
        Control control = (Control)event.getSource();
        if (this.errorsMsgs == null || !this.errorsMsgs.containsKey(control.getId())) {
            return;
        }
        this.lbError.setText(this.errorsMsgs.get(control.getId()));
    };
    EventHandler<MouseEvent> mouseExited = event -> {
        if (this.errorsMsgs != null && !this.errorsMsgs.isEmpty()) {
            this.lbError.setText("");
        }
    };
    EventHandler<KeyEvent> keyReleased = event -> {
        Control ctrl;
        if (event.getCode() != KeyCode.UNDEFINED && event.getCode() != KeyCode.TAB && event.getSource() instanceof Control && (ctrl = (Control)event.getSource()).getStyleClass().contains((Object)"invalid-field")) {
            ctrl.getStyleClass().remove((Object)"invalid-field");
            ctrl.getStyleClass().add((Object)"normal-field");
            if (this.errorsMsgs != null && this.errorsMsgs.containsKey(ctrl.getId())) {
                this.errorsMsgs.remove(ctrl.getId());
            }
        }
    };

    public RevokeDADialog(String title, String headerText) {
        this.setTitle(title);
        this.setHeaderText(headerText);
        this.errorsMsgs = new HashMap<String, String>();
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(3.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.tfDAFirst = new TextField();
        this.tfDAFirst.setId(FNAME_VALUE);
        this.tfDALast = new TextField();
        this.tfDAFirst.setId(LNAME_VALUE);
        this.tfDAEmail = new TextField();
        this.tfDAEmail.setId(EMAIL_VALUE);
        this.tfDAPhone = new TextField();
        this.tfDAPhone.setId(PHONE_VALUE);
        this.tfCurrSMK = new PasswordField();
        this.tfCurrSMK.setId(SMK_VALUE);
        this.tfNewDMK = new PasswordField();
        this.tfNewDMK.setId(NEW_MK_VALUE);
        this.tfRetypedDMK = new PasswordField();
        this.tfRetypedDMK.setId(NEW_MK_AGAIN_VALUE);
        Label lbFirst = new Label();
        Label lbLast = new Label();
        Label lbEmail = new Label();
        Label lbPhone = new Label();
        Label lbSMK = new Label();
        Label lbNewMK = new Label();
        Label lbNewMKAgain = new Label();
        lbFirst.setText(ResourceManager.getString("label.fname.caption"));
        this.tfDAFirst.setPromptText(ResourceManager.getString("label.fname.place-holder"));
        this.tfDAFirst.setTooltip(new Tooltip(ResourceManager.getString("label.fname.da.tooltip")));
        lbLast.setText(ResourceManager.getString("label.lname.caption"));
        this.tfDALast.setPromptText(ResourceManager.getString("label.lname.place-holder"));
        this.tfDALast.setTooltip(new Tooltip(ResourceManager.getString("label.lname.da.tooltip")));
        lbEmail.setText(ResourceManager.getString("label.email.caption"));
        this.tfDAEmail.setPromptText(ResourceManager.getString("label.email.place-holder"));
        this.tfDAEmail.setTooltip(new Tooltip(ResourceManager.getString("label.email.da.tooltip")));
        lbPhone.setText(ResourceManager.getString("label.phone.caption"));
        this.tfDAPhone.setPromptText(ResourceManager.getString("label.phone.place-holder"));
        this.tfDAPhone.setTooltip(new Tooltip(ResourceManager.getString("label.phone.da.tooltip")));
        lbNewMK.setText(ResourceManager.getString("label.new-dmk.caption"));
        this.tfNewDMK.setPromptText(ResourceManager.getString("label.new-dmk.place-holder"));
        this.tfNewDMK.setTooltip(new Tooltip(ResourceManager.getString("label.new-dmk.tooltip")));
        lbNewMKAgain.setText(ResourceManager.getString("label.retype-dmk.caption"));
        this.tfRetypedDMK.setPromptText(ResourceManager.getString("label.retype-dmk.place-holder"));
        this.tfRetypedDMK.setTooltip(new Tooltip(ResourceManager.getString("label.retype-dmk.tooltip")));
        lbSMK.setText(ResourceManager.getString("label.smk.caption"));
        this.tfCurrSMK.setPromptText(ResourceManager.getString("label.smk.place-holder"));
        this.tfCurrSMK.setTooltip(new Tooltip(ResourceManager.getString("label.smk.tooltip")));
        this.tfDAFirst.getStyleClass().add((Object)"normal-field");
        this.tfDALast.getStyleClass().add((Object)"normal-field");
        this.tfDAEmail.getStyleClass().add((Object)"normal-field");
        this.tfDAPhone.getStyleClass().add((Object)"normal-field");
        this.tfCurrSMK.getStyleClass().add((Object)"normal-field");
        this.tfNewDMK.getStyleClass().add((Object)"normal-field");
        this.tfRetypedDMK.getStyleClass().add((Object)"normal-field");
        this.lbError = new Label();
        this.lbError.prefHeightProperty().bind((ObservableValue)grid.heightProperty());
        this.lbError.prefWidthProperty().bind((ObservableValue)new SimpleDoubleProperty(150.0));
        this.lbError.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        this.lbError.setTextFill((Paint)Color.RED);
        this.lbError.setAlignment(Pos.TOP_LEFT);
        this.lbError.setWrapText(true);
        grid.add((Node)lbFirst, 0, 0);
        grid.add((Node)this.tfDAFirst, 1, 0);
        grid.add((Node)lbLast, 0, 1);
        grid.add((Node)this.tfDALast, 1, 1);
        grid.add((Node)lbEmail, 0, 2);
        grid.add((Node)this.tfDAEmail, 1, 2);
        grid.add((Node)lbPhone, 0, 3);
        grid.add((Node)this.tfDAPhone, 1, 3);
        grid.add((Node)lbNewMK, 0, 4);
        grid.add((Node)this.tfNewDMK, 1, 4);
        grid.add((Node)lbNewMKAgain, 0, 5);
        grid.add((Node)this.tfRetypedDMK, 1, 5);
        grid.add((Node)lbSMK, 0, 6);
        grid.add((Node)this.tfCurrSMK, 1, 6);
        grid.getStylesheets().add((Object)"/styles/validation.css");
        BorderPane mainPane = new BorderPane(null, null, (Node)this.lbError, null, (Node)grid);
        this.getDialogPane().setContent((Node)mainPane);
        grid.setAlignment(Pos.CENTER_LEFT);
        Platform.runLater(() -> this.tfDAFirst.requestFocus());
        this.tfDAFirst.setOnMouseEntered(this.mouseEntered);
        this.tfDAFirst.setOnMouseExited(this.mouseExited);
        this.tfDAFirst.setOnKeyReleased(this.keyReleased);
        this.tfDALast.setOnMouseEntered(this.mouseEntered);
        this.tfDALast.setOnMouseExited(this.mouseExited);
        this.tfDALast.setOnKeyReleased(this.keyReleased);
        this.tfDAEmail.setOnMouseEntered(this.mouseEntered);
        this.tfDAEmail.setOnMouseExited(this.mouseExited);
        this.tfDAEmail.setOnKeyReleased(this.keyReleased);
        this.tfDAPhone.setOnMouseEntered(this.mouseEntered);
        this.tfDAPhone.setOnMouseExited(this.mouseExited);
        this.tfDAPhone.setOnKeyReleased(this.keyReleased);
        this.tfCurrSMK.setOnMouseEntered(this.mouseEntered);
        this.tfCurrSMK.setOnMouseExited(this.mouseExited);
        this.tfCurrSMK.setOnKeyReleased(this.keyReleased);
        this.tfNewDMK.setOnMouseEntered(this.mouseEntered);
        this.tfNewDMK.setOnMouseExited(this.mouseExited);
        this.tfNewDMK.setOnKeyReleased(this.keyReleased);
        this.tfRetypedDMK.setOnMouseEntered(this.mouseEntered);
        this.tfRetypedDMK.setOnMouseExited(this.mouseExited);
        this.tfRetypedDMK.setOnKeyReleased(this.keyReleased);
        Node loginButton = this.getDialogPane().lookupButton(ButtonType.OK);
        loginButton.addEventFilter(ActionEvent.ACTION, ae -> {
            if (!this.isValid()) {
                ae.consume();
            }
        });
        this.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.OK) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put(FNAME_VALUE, this.tfDAFirst.getText());
                result.put(LNAME_VALUE, this.tfDALast.getText());
                result.put(EMAIL_VALUE, this.tfDAEmail.getText());
                result.put(PHONE_VALUE, this.tfDAPhone.getText());
                result.put(SMK_VALUE, this.tfCurrSMK.getText());
                result.put(NEW_MK_VALUE, this.tfNewDMK.getText());
                result.put(NEW_MK_AGAIN_VALUE, this.tfRetypedDMK.getText());
                return result;
            }
            return null;
        });
    }

    private boolean isValid() {
        boolean result = true;
        this.errorsMsgs.clear();
        this.lbError.setText("");
        if (this.tfDAFirst.getText().isEmpty()) {
            ValidatorManager.setErroneus((Control)this.tfDAFirst);
            this.errorsMsgs.put(this.tfDAFirst.getId(), ResourceManager.getString("error.fname.required"));
            result = false;
        } else {
            ValidatorManager.setNormal((Control)this.tfDAFirst);
        }
        if (this.tfDALast.getText().isEmpty()) {
            ValidatorManager.setErroneus((Control)this.tfDALast);
            this.errorsMsgs.put(this.tfDALast.getId(), ResourceManager.getString("error.lname.required"));
            result = false;
        } else {
            ValidatorManager.setNormal((Control)this.tfDALast);
        }
        if (!this.tfDAEmail.getText().isEmpty() && !this.tfDAEmail.getText().matches("(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*:(?:(?:\\r\\n)?[ \\t])*(?:(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*)(?:,\\s*(?:(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*|(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)*\\<(?:(?:\\r\\n)?[ \\t])*(?:@(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*(?:,@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*)*:(?:(?:\\r\\n)?[ \\t])*)?(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\"(?:[^\\\"\\r\\\\]|\\\\.|(?:(?:\\r\\n)?[ \\t]))*\"(?:(?:\\r\\n)?[ \\t])*))*@(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*)(?:\\.(?:(?:\\r\\n)?[ \\t])*(?:[^()<>@,;:\\\\\".\\[\\] \\000-\\031]+(?:(?:(?:\\r\\n)?[ \\t])+|\\Z|(?=[\\[\"()<>@,;:\\\\\".\\[\\]]))|\\[([^\\[\\]\\r\\\\]|\\\\.)*\\](?:(?:\\r\\n)?[ \\t])*))*\\>(?:(?:\\r\\n)?[ \\t])*))*)?;\\s*)")) {
            ValidatorManager.setErroneus((Control)this.tfDAEmail);
            this.errorsMsgs.put(this.tfDAEmail.getId(), ResourceManager.getString("error.email.invalid", this.tfDAEmail.getText()));
            result = false;
        } else {
            ValidatorManager.setNormal((Control)this.tfDAEmail);
        }
        if (!this.tfDAPhone.getText().isEmpty() && !this.tfDAPhone.getText().matches("([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})|([\\+(]?(\\d){2,}[)]?[- \\.]?(\\d){2,}[- \\.]?(\\d){2,})")) {
            ValidatorManager.setErroneus((Control)this.tfDAPhone);
            this.errorsMsgs.put(this.tfDAPhone.getId(), ResourceManager.getString("error.phone.invalid", this.tfDAPhone.getText()));
            result = false;
        } else {
            ValidatorManager.setNormal((Control)this.tfDAPhone);
        }
        if (this.tfNewDMK.getText().isEmpty() || this.tfNewDMK.getText().length() < 16 || this.tfNewDMK.getText().length() > 60 || !this.tfNewDMK.getText().matches("^([0-9]+[a-zA-Z]+|[a-zA-Z]+[0-9]+)[0-9a-zA-Z]*$")) {
            ValidatorManager.setErroneus((Control)this.tfNewDMK);
            this.errorsMsgs.put(this.tfNewDMK.getId(), ResourceManager.getString("error.dmk.lenght"));
            result = false;
        } else {
            ValidatorManager.setNormal((Control)this.tfNewDMK);
        }
        if (this.tfRetypedDMK.getText().isEmpty() || !this.tfNewDMK.getText().equals(this.tfRetypedDMK.getText())) {
            ValidatorManager.setErroneus((Control)this.tfRetypedDMK);
            this.errorsMsgs.put(this.tfRetypedDMK.getId(), ResourceManager.getString("error.keys.not_match"));
            result = false;
        } else {
            ValidatorManager.setNormal((Control)this.tfRetypedDMK);
        }
        if (this.tfCurrSMK.isVisible() && this.tfCurrSMK.getText().isEmpty()) {
            ValidatorManager.setErroneus((Control)this.tfCurrSMK);
            this.errorsMsgs.put(this.tfCurrSMK.getId(), ResourceManager.getString("error.smk.required"));
            result = false;
        } else {
            ValidatorManager.setNormal((Control)this.tfCurrSMK);
        }
        return result;
    }
}

