/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.DARevokeReassingException;
import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskRevokeReassignDA
extends Task<Boolean> {
    private List<Integer> pwRequested;
    private static final Logger logger = LogManager.getLogger();
    private String revokedDAId;
    private String reassignDAId;

    public TaskRevokeReassignDA(List<Integer> pwRequested, String revokedDAId, String reassingDAId) {
        this.pwRequested = pwRequested;
        this.revokedDAId = revokedDAId;
        this.reassignDAId = reassingDAId;
    }

    protected Boolean call() throws Exception {
        try {
            if (SGAManager.getInstance().revokeReassingDA(this.revokedDAId, this.reassignDAId)) {
                this.updateTitle(ResourceManager.getString("log.info.sgamanager.rev-rea-da.success", this.revokedDAId, this.reassignDAId));
                logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.rev-rea-da.success", this.revokedDAId, this.reassignDAId));
                this.updateValue(Boolean.TRUE);
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            this.updateMessage(ResourceManager.getString("log.error.sgamanager.rev-rea-da.failed", this.revokedDAId, this.reassignDAId));
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, ResourceManager.getString("log.error.sgamanager.rev-rea-da.failed", this.revokedDAId, this.reassignDAId));
        }
        catch (DARevokeReassingException | NoSGAdminException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.updateMessage(ex.getMessage());
            this.updateTitle(ResourceManager.getString("error.operation"));
            logger.log(Level.ERROR, "Fatal ", (Throwable)ex);
        }
        finally {
            if (SGAManager.getInstance() != null) {
                SGAManager.getInstance().clearCache();
            }
        }
        this.updateValue(Boolean.FALSE);
        return Boolean.FALSE;
    }
}

