/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenExecutionPlan
implements Iterable<ExecutionPlanItem> {
    private final List<ExecutionPlanItem> planItem;
    private final Map<String, ExecutionPlanItem> lastMojoExecutionForAllPhases;
    final List<String> phasesInExecutionPlan;

    public MavenExecutionPlan(List<ExecutionPlanItem> planItem, DefaultLifecycles defaultLifecycles) {
        this.planItem = planItem;
        this.lastMojoExecutionForAllPhases = new LinkedHashMap<String, ExecutionPlanItem>();
        LinkedHashSet<String> totalPhaseSet = new LinkedHashSet<String>();
        if (defaultLifecycles != null) {
            for (String phase : MavenExecutionPlan.getDistinctPhasesInOrderOfExecutionPlanAppearance(planItem)) {
                Lifecycle lifecycle = defaultLifecycles.get(phase);
                if (lifecycle == null) continue;
                totalPhaseSet.addAll(lifecycle.getPhases());
            }
        }
        this.phasesInExecutionPlan = new ArrayList<String>(totalPhaseSet);
        HashMap<String, ExecutionPlanItem> lastInExistingPhases = new HashMap<String, ExecutionPlanItem>();
        for (ExecutionPlanItem executionPlanItem : this.getExecutionPlanItems()) {
            lastInExistingPhases.put(executionPlanItem.getLifecyclePhase(), executionPlanItem);
        }
        ExecutionPlanItem lastSeenExecutionPlanItem = null;
        for (String phase : totalPhaseSet) {
            ExecutionPlanItem forThisPhase = (ExecutionPlanItem)lastInExistingPhases.get(phase);
            if (forThisPhase != null) {
                lastSeenExecutionPlanItem = forThisPhase;
            }
            this.lastMojoExecutionForAllPhases.put(phase, lastSeenExecutionPlanItem);
        }
    }

    @Override
    public Iterator<ExecutionPlanItem> iterator() {
        return this.getExecutionPlanItems().iterator();
    }

    public ExecutionPlanItem findLastInPhase(String requestedPhase) {
        return this.lastMojoExecutionForAllPhases.get(requestedPhase);
    }

    private List<ExecutionPlanItem> getExecutionPlanItems() {
        return this.planItem;
    }

    private static Iterable<String> getDistinctPhasesInOrderOfExecutionPlanAppearance(List<ExecutionPlanItem> planItems) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ExecutionPlanItem executionPlanItem : planItems) {
            String phase = executionPlanItem.getLifecyclePhase();
            if (result.contains(phase)) continue;
            result.add(phase);
        }
        return result;
    }

    public void forceAllComplete() {
        for (ExecutionPlanItem executionPlanItem : this.getExecutionPlanItems()) {
            executionPlanItem.forceComplete();
        }
    }

    public void waitUntilAllDone() throws InterruptedException {
        for (ExecutionPlanItem executionPlanItem : this.getExecutionPlanItems()) {
            executionPlanItem.waitUntilDone();
        }
    }

    public boolean containsPhase(String phase) {
        return this.phasesInExecutionPlan.contains(phase);
    }

    public List<MojoExecution> getMojoExecutions() {
        ArrayList<MojoExecution> result = new ArrayList<MojoExecution>();
        for (ExecutionPlanItem executionPlanItem : this.planItem) {
            result.add(executionPlanItem.getMojoExecution());
        }
        return result;
    }

    public Set<Plugin> getNonThreadSafePlugins() {
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        for (ExecutionPlanItem executionPlanItem : this.planItem) {
            MojoExecution mojoExecution = executionPlanItem.getMojoExecution();
            if (mojoExecution.getMojoDescriptor().isThreadSafe()) continue;
            plugins.add(mojoExecution.getPlugin());
        }
        return plugins;
    }

    @Deprecated
    public List<MojoExecution> getExecutions() {
        return this.getMojoExecutions();
    }

    public int size() {
        return this.planItem.size();
    }
}

