/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceManager {
    private static final Logger logger = LogManager.getLogger();
    public static final ResourceBundle resourceBundle = ResourceBundle.getBundle("strings", Locale.ENGLISH);

    public static String getString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException mre) {
            logger.log(Level.ERROR, "The string key '" + key + "' doesn't found in the resources file");
            return key;
        }
    }

    public static String getString(String key, Object ... args) {
        return MessageFormat.format(ResourceManager.getString(key), args);
    }

    public static ImageView getIcon(final String key) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ImageView>(){

                @Override
                public ImageView run() {
                    String resourceName = ResourceManager.getString(key);
                    URL url = this.getClass().getResource(resourceName);
                    if (url == null) {
                        logger.log(Level.ERROR, "Was not possible to create an image from the key '" + key + "' with resource name '" + resourceName + "' and URL 'null'");
                        return null;
                    }
                    return ResourceManager.getIcon(url);
                }
            });
        }
        catch (Exception ex) {
            logger.log(Level.ERROR, "", (Throwable)ex);
            return null;
        }
    }

    public static ImageView getIcon(URL url) {
        return new ImageView(new Image(url.toString()));
    }
}

