/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sga.SGAGeneralException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.util.NetworkUtil;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OSInfo;
import com.servergeneral.system.OperationCancelledException;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Window;

public class ComplianceReportDialog
extends Dialog<Void>
implements Initializable {
    @FXML
    private Label siDate;
    @FXML
    private Label siHostname;
    @FXML
    private Label siIP;
    @FXML
    private Label siOS;
    @FXML
    private TextArea licenseKey;
    @FXML
    private Label dataVaults;
    @FXML
    private Label admins;
    @FXML
    private Label machines;
    @FXML
    private Label expiryDate;
    @FXML
    private Label type;
    @FXML
    private Label sgaVersion;
    @FXML
    private Label sgaBuild;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.ENGLISH);

    public void initialize(URL url, ResourceBundle rb) {
        Platform.runLater(() -> this.showInformation());
    }

    public ComplianceReportDialog() throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/compliance-report_v2.fxml"), ResourceManager.resourceBundle);
        fxmlLoader.setController((Object)this);
        AnchorPane layout = (AnchorPane)fxmlLoader.load();
        this.getDialogPane().setContent((Node)layout);
        this.setResizable(true);
        this.setTitle(ResourceManager.getString("info.dialog.compliance.report.title"));
        Window window = this.getDialogPane().getScene().getWindow();
        window.setOnCloseRequest(event -> window.hide());
        window.sizeToScene();
    }

    @FXML
    private void closeReport(ActionEvent event) {
        this.getDialogPane().getScene().getWindow().hide();
    }

    public void showInformation() {
        this.showSystemInformation();
        this.showLicenseInformation();
    }

    private void showSystemInformation() {
        this.siDate.setText(this.dateFormat.format(Calendar.getInstance().getTime()));
        this.siHostname.setText(OSInfo.getHostname());
        this.siIP.setText(NetworkUtil.getAllIpAddresses());
        this.siOS.setText(OSInfo.getOs().getName() + " " + OSInfo.getOs().getPlatformName());
    }

    private void showLicenseInformation() {
        try {
            SGAManager.LicenseInfo licenseInfo = SGAManager.getInstance().getSGAInfo();
            if (licenseInfo == null) {
                throw new OperationCancelledException();
            }
            this.sgaVersion.setText(licenseInfo.getVersion());
            this.sgaBuild.setText(licenseInfo.getBuild());
            this.licenseKey.setText(licenseInfo.getLicenseKey());
            this.dataVaults.setText("" + licenseInfo.getMaxDataVaults());
            this.admins.setText("" + licenseInfo.getMaxDataAdmins());
            this.machines.setText("" + licenseInfo.getMaxMachines());
            this.expiryDate.setText(licenseInfo.getExpiryDate());
            this.type.setText("" + licenseInfo.getLicenseType());
        }
        catch (NullUserInfoListenerException | IOException ex) {
            this.sgaVersion.setText("Error");
            this.sgaBuild.setText("Error");
            this.licenseKey.setText("Error");
            this.dataVaults.setText("Error");
            this.admins.setText("Error");
            this.machines.setText("Error");
            this.expiryDate.setText("Error");
            this.type.setText("Error");
        }
        catch (SGAGeneralException | OperationCancelledException ex) {
            this.sgaVersion.setText("Restricted information");
            this.sgaBuild.setText("Restricted information");
            this.licenseKey.setText("Restricted information");
            this.dataVaults.setText("Restricted information");
            this.admins.setText("Restricted information");
            this.machines.setText("Restricted information");
            this.expiryDate.setText("Restricted information");
            this.type.setText("Restricted information");
        }
        finally {
            SGAManager.getInstance().clearCache();
        }
    }
}

