/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAGeneralException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskPolicyReassign
extends Task<Boolean> {
    private List<Integer> pwRequested;
    private static final Logger logger = LogManager.getLogger();
    private String rDAId;
    private String aDAId;
    private String policy;

    public TaskPolicyReassign(String rDAId, String aDAId, String policy) {
        this.rDAId = rDAId;
        this.aDAId = aDAId;
        this.policy = policy;
    }

    public List<Integer> getPwRequested() {
        return this.pwRequested;
    }

    public void setPwRequested(List<Integer> pwRequested) {
        this.pwRequested = pwRequested;
    }

    public String getrDAId() {
        return this.rDAId;
    }

    public void setrDAId(String rDAId) {
        this.rDAId = rDAId;
    }

    public String getaDAId() {
        return this.aDAId;
    }

    public void setaDAId(String aDAId) {
        this.aDAId = aDAId;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    protected Boolean call() throws Exception {
        try {
            if (!SGAManager.getInstance().reassignPolicy(this.policy, this.rDAId, this.aDAId)) {
                this.updateMessage(ResourceManager.getString("error.policy.reassign"));
                this.updateValue(Boolean.FALSE);
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            if (SGKms.getProperty("mmk.gd") == null) {
                SGKms.saveProperty("mmk.gd", String.valueOf(System.currentTimeMillis()));
            }
            this.updateValue(Boolean.TRUE);
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (NoSGAdminException | SGAGeneralException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.updateMessage(ex.getMessage());
            logger.error("", (Throwable)ex);
        }
        finally {
            if (SGAManager.getInstance() != null) {
                SGAManager.getInstance().clearCache();
            }
        }
        this.updateValue(Boolean.FALSE);
        return Boolean.FALSE;
    }
}

