/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.model.Policy;
import com.servergeneral.sgkms.model.PolicyStatus;
import com.servergeneral.sgkms.util.FileUtil;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.GridPane;
import javafx.stage.Window;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecurityStatus
extends Dialog<Void>
implements Initializable {
    @FXML
    private Label fxTitleApp;
    @FXML
    private Hyperlink btnExit;
    @FXML
    private TableView<PolicyStatus> tableView;
    @FXML
    private TableColumn<PolicyStatus, String> policyNameColumn;
    @FXML
    private TableColumn<PolicyStatus, String> pathColumn;
    @FXML
    private TableColumn<PolicyStatus, String> creationColumn;
    @FXML
    private TableColumn<PolicyStatus, String> statusColumn;
    private static final Logger logger = LogManager.getLogger();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
    private final SimpleDateFormat reportFormat = new SimpleDateFormat("yyyy-MMM-dd");

    public void initialize(URL url, ResourceBundle rb) {
        this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.policyNameColumn.setCellValueFactory(cellData -> ((PolicyStatus)cellData.getValue()).getPolicy());
        this.pathColumn.setCellValueFactory(cellData -> ((PolicyStatus)cellData.getValue()).getPath());
        this.creationColumn.setCellValueFactory(cellData -> ((PolicyStatus)cellData.getValue()).getCreationDate());
        this.creationColumn.setStyle("-fx-alignment: CENTER;");
        this.statusColumn.setCellValueFactory(cellData -> ((PolicyStatus)cellData.getValue()).getStatus());
        this.statusColumn.setStyle("-fx-alignment: CENTER;");
        this.pathColumn.prefWidthProperty().bind((ObservableValue)this.tableView.widthProperty().subtract((ObservableNumberValue)this.policyNameColumn.widthProperty()).subtract((ObservableNumberValue)this.creationColumn.widthProperty()).subtract((ObservableNumberValue)this.statusColumn.widthProperty()));
        Platform.runLater(() -> this.loadData());
    }

    public SecurityStatus() throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/security-status.fxml"), ResourceManager.resourceBundle);
        fxmlLoader.setController((Object)this);
        GridPane layout = (GridPane)fxmlLoader.load();
        this.getDialogPane().setContent((Node)layout);
        this.setResizable(true);
        this.setTitle(ResourceManager.getString("info.dialog.compliance.security-status.title"));
        Window window = this.getDialogPane().getScene().getWindow();
        window.setOnCloseRequest(event -> window.hide());
        window.sizeToScene();
    }

    @FXML
    private void close(ActionEvent event) {
        this.getDialogPane().getScene().getWindow().hide();
    }

    private void loadData() {
        FileUtil.chown("/etc/serverg/serverg.conf", "sgadmin", "sgadmin");
        ObservableList<Policy> policies = FileUtil.getPolicyList("/etc/serverg/serverg.conf");
        this.tableView.getItems().clear();
        for (Policy p : policies) {
            String fecha = "N/A";
            Properties props = null;
            try {
                props = FileUtil.loadPropertiesFile("/etc/serverg/sg-tde.properties");
                if (props != null) {
                    try {
                        String fechaNum = props.getProperty("policy.create_date." + p.getPolicy_shortname().getValue());
                        fecha = this.reportFormat.format(new Date(Long.parseLong(fechaNum)));
                    }
                    catch (Exception ex) {
                        logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + ex.getMessage());
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + ex.getMessage());
            }
            String status = "Unknown";
            try {
                status = SGAManager.getInstance().isPolicyMounted(p.getPolicy_shortname().getValue()) ? ResourceManager.getString("info.status.policy.mounted") : ResourceManager.getString("info.status.policy.unmounted");
            }
            catch (NoSGAdminException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
                logger.log(Level.ERROR, ResourceManager.getString("error.operation.execution") + ex.getMessage());
            }
            if (p.getCreated() != null) {
                try {
                    fecha = this.reportFormat.format(this.dateFormat.parse(p.getCreated().getValue()));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.tableView.getItems().add((Object)new PolicyStatus(p.getPolicy_shortname().getValue(), p.getRepo().getValue(), fecha, status));
        }
    }
}

