/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.gui.CustomAlert;
import com.servergeneral.sgkms.gui.ValidatorManager;
import com.servergeneral.sgkms.model.Actor;
import com.servergeneral.sgkms.util.FileUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class SelectRevokingDA
extends Dialog<Map<String, String>> {
    public static final String DAID_VALUE = "da-id";
    public static final String SMK_VALUE = "smk";
    private PasswordField tfCurrSMK;
    private ComboBox<String> cbDAId;
    private Label lbError;
    private Map<String, String> errorsMsgs;
    EventHandler<MouseEvent> mouseEntered = event -> {
        Control control = (Control)event.getSource();
        if (this.errorsMsgs == null || !this.errorsMsgs.containsKey(control.getId())) {
            return;
        }
        this.lbError.setText(this.errorsMsgs.get(control.getId()));
    };
    EventHandler<MouseEvent> mouseExited = event -> {
        if (this.errorsMsgs != null && !this.errorsMsgs.isEmpty()) {
            this.lbError.setText("");
        }
    };
    EventHandler<ActionEvent> actionPerformed = event -> {
        Control ctrl = (Control)event.getSource();
        if (ctrl.getStyleClass().contains((Object)"invalid-field")) {
            ctrl.getStyleClass().remove((Object)"invalid-field");
            ctrl.getStyleClass().add((Object)"normal-field");
            if (this.errorsMsgs != null && this.errorsMsgs.containsKey(ctrl.getId())) {
                this.errorsMsgs.remove(ctrl.getId());
            }
        }
    };
    EventHandler<KeyEvent> keyReleased = event -> {
        Control ctrl;
        if (event.getCode() != KeyCode.UNDEFINED && event.getCode() != KeyCode.TAB && event.getSource() instanceof Control && (ctrl = (Control)event.getSource()).getStyleClass().contains((Object)"invalid-field")) {
            ctrl.getStyleClass().remove((Object)"invalid-field");
            ctrl.getStyleClass().add((Object)"normal-field");
            if (this.errorsMsgs != null && this.errorsMsgs.containsKey(ctrl.getId())) {
                this.errorsMsgs.remove(ctrl.getId());
            }
        }
    };

    public SelectRevokingDA(String title, String headerText) {
        this.setTitle(title);
        this.setHeaderText(headerText);
        this.errorsMsgs = new HashMap<String, String>();
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.cbDAId = new ComboBox();
        this.tfCurrSMK = new PasswordField();
        Label lbDAID = new Label();
        Label lbSMK = new Label();
        lbDAID.setText(ResourceManager.getString("label.da-id.caption"));
        this.cbDAId.setPromptText(ResourceManager.getString("label.da-id.place-holder"));
        this.cbDAId.setTooltip(new Tooltip(ResourceManager.getString("label.da-id.da.tooltip")));
        this.cbDAId.setVisibleRowCount(10);
        this.cbDAId.setId("cbDAId");
        lbSMK.setText(ResourceManager.getString("label.smk.caption"));
        this.tfCurrSMK.setPromptText(ResourceManager.getString("label.smk.place-holder"));
        this.tfCurrSMK.setTooltip(new Tooltip(ResourceManager.getString("label.smk.tooltip")));
        this.tfCurrSMK.setId("tfCurrSMK");
        this.cbDAId.getStyleClass().add((Object)"normal-field");
        this.tfCurrSMK.getStyleClass().add((Object)"normal-field");
        this.lbError = new Label();
        this.lbError.prefHeightProperty().bind((ObservableValue)grid.heightProperty());
        this.lbError.prefWidthProperty().bind((ObservableValue)new SimpleDoubleProperty(150.0));
        this.lbError.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        this.lbError.setTextFill((Paint)Color.RED);
        this.lbError.setAlignment(Pos.TOP_LEFT);
        this.lbError.setWrapText(true);
        grid.add((Node)lbDAID, 0, 0);
        grid.add(this.cbDAId, 1, 0);
        grid.add((Node)lbSMK, 0, 1);
        grid.add((Node)this.tfCurrSMK, 1, 1);
        grid.getStylesheets().add((Object)"/styles/validation.css");
        grid.getStylesheets().add((Object)"/styles/sg-kms.css");
        BorderPane mainPane = new BorderPane(null, null, (Node)this.lbError, null, (Node)grid);
        this.getDialogPane().setContent((Node)mainPane);
        grid.setAlignment(Pos.CENTER_LEFT);
        Platform.runLater(() -> {
            ObservableList<Actor> daList = FileUtil.getDAList("/etc/serverg/da.conf");
            for (Actor element : daList) {
                this.cbDAId.getItems().add((Object)element.getId().getValue());
            }
        });
        Platform.runLater(() -> this.cbDAId.requestFocus());
        this.cbDAId.getStyleClass().add((Object)"required-field");
        this.cbDAId.setOnAction(this.actionPerformed);
        this.cbDAId.setOnMouseEntered(this.mouseEntered);
        this.cbDAId.setOnMouseExited(this.mouseExited);
        this.tfCurrSMK.getStyleClass().add((Object)"required-field");
        this.tfCurrSMK.setOnKeyReleased(this.keyReleased);
        this.tfCurrSMK.setOnMouseEntered(this.mouseEntered);
        this.tfCurrSMK.setOnMouseExited(this.mouseExited);
        Node loginButton = this.getDialogPane().lookupButton(ButtonType.OK);
        loginButton.addEventFilter(ActionEvent.ACTION, ae -> {
            if (!this.isValid()) {
                ae.consume();
            }
        });
        this.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.OK) {
                CustomAlert alert = new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, ResourceManager.getString("info.dialog.revokeDA.title"), ResourceManager.getString("info.da.revoking"), ResourceManager.getString("info.dialog.revokeDA.headerDetail", this.cbDAId.getValue()));
                Optional confirmation = alert.showAndWait();
                if (confirmation.get() != CustomAlert.YES) {
                    return null;
                }
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(DAID_VALUE, this.cbDAId.getValue());
                result.put(SMK_VALUE, this.tfCurrSMK.getText());
                return result;
            }
            return null;
        });
    }

    private boolean isValid() {
        boolean result = true;
        this.errorsMsgs.clear();
        this.lbError.setText("");
        if (this.cbDAId.getValue() == null) {
            ValidatorManager.setErroneus(this.cbDAId);
            this.errorsMsgs.put(this.cbDAId.getId(), ResourceManager.getString("error.da-id.required"));
            result = false;
        } else {
            ValidatorManager.setNormal(this.cbDAId);
        }
        if (this.tfCurrSMK.isVisible() && this.tfCurrSMK.getText().isEmpty()) {
            ValidatorManager.setErroneus((Control)this.tfCurrSMK);
            this.errorsMsgs.put(this.tfCurrSMK.getId(), ResourceManager.getString("error.smk.required"));
            result = false;
        } else {
            ValidatorManager.setNormal((Control)this.tfCurrSMK);
        }
        return result;
    }
}

