/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.tasks;

import com.servergeneral.sga.DAAddException;
import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.SGKms;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DACreateTask
extends Task<Boolean> {
    private final String configFilePath;
    private String da_id;
    private List<Integer> pwRequested;
    private static final Logger logger = LogManager.getLogger();

    public DACreateTask(String configFilePath, String da_id) {
        this.configFilePath = configFilePath;
        this.da_id = da_id;
    }

    public DACreateTask(String configFilePath, List<Integer> pwRequested, String da_id) {
        this.configFilePath = configFilePath;
        this.pwRequested = pwRequested;
        this.da_id = da_id;
    }

    public String getDa_id() {
        return this.da_id;
    }

    public void setDa_id(String da_id) {
        this.da_id = da_id;
    }

    protected Boolean call() throws Exception {
        try {
            this.pwRequested.clear();
            if (!SGAManager.getInstance().addDA(this.configFilePath)) {
                this.updateMessage(ResourceManager.getString("error.da.add"));
                this.updateValue(Boolean.FALSE);
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            logger.log(Level.INFO, ResourceManager.getString("log.info.sgamanager.da-mk.rotate.success", this.da_id));
            SGKms.saveProperty("dmk.gd_" + this.da_id, String.valueOf(System.currentTimeMillis()));
            this.updateValue(Boolean.TRUE);
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (DAAddException | NoSGAdminException | MaxPwTryiesException | NullUserInfoListenerException | OperationCancelledException ex) {
            this.updateMessage(ex.getMessage());
            logger.error("", (Throwable)ex);
        }
        finally {
            if (SGAManager.getInstance() != null) {
                SGAManager.getInstance().clearCache();
            }
        }
        this.updateValue(Boolean.FALSE);
        return Boolean.FALSE;
    }
}

