/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.resolution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactDescriptorRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactDescriptorResult {
    private final ArtifactDescriptorRequest request;
    private List<Exception> exceptions;
    private List<Artifact> relocations;
    private Collection<Artifact> aliases;
    private Artifact artifact;
    private ArtifactRepository repository;
    private List<Dependency> dependencies;
    private List<Dependency> managedDependencies;
    private List<RemoteRepository> repositories;
    private Map<String, Object> properties;

    public ArtifactDescriptorResult(ArtifactDescriptorRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("version request has not been specified");
        }
        this.request = request;
        this.artifact = request.getArtifact();
        this.exceptions = new ArrayList<Exception>(2);
        this.relocations = new ArrayList<Artifact>(2);
        this.aliases = new ArrayList<Artifact>(1);
        this.dependencies = new ArrayList<Dependency>();
        this.managedDependencies = new ArrayList<Dependency>();
        this.repositories = new ArrayList<RemoteRepository>();
        this.properties = Collections.emptyMap();
    }

    public ArtifactDescriptorRequest getRequest() {
        return this.request;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public ArtifactDescriptorResult setExceptions(List<Exception> exceptions) {
        this.exceptions = exceptions == null ? new ArrayList<Exception>(2) : exceptions;
        return this;
    }

    public ArtifactDescriptorResult addException(Exception exception) {
        if (exception != null) {
            this.exceptions.add(exception);
        }
        return this;
    }

    public List<Artifact> getRelocations() {
        return this.relocations;
    }

    public ArtifactDescriptorResult setRelocations(List<Artifact> relocations) {
        this.relocations = relocations == null ? new ArrayList<Artifact>(2) : relocations;
        return this;
    }

    public ArtifactDescriptorResult addRelocation(Artifact artifact) {
        if (artifact != null) {
            this.relocations.add(artifact);
        }
        return this;
    }

    public Collection<Artifact> getAliases() {
        return this.aliases;
    }

    public ArtifactDescriptorResult setAliases(Collection<Artifact> aliases) {
        this.aliases = aliases == null ? new ArrayList<Artifact>(0) : aliases;
        return this;
    }

    public ArtifactDescriptorResult addAlias(Artifact alias) {
        if (alias != null) {
            this.aliases.add(alias);
        }
        return this;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactDescriptorResult setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public ArtifactDescriptorResult setRepository(ArtifactRepository repository) {
        this.repository = repository;
        return this;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public ArtifactDescriptorResult setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies == null ? new ArrayList<Dependency>() : dependencies;
        return this;
    }

    public ArtifactDescriptorResult addDependency(Dependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("no dependency specified");
        }
        this.dependencies.add(dependency);
        return this;
    }

    public List<Dependency> getManagedDependencies() {
        return this.managedDependencies;
    }

    public ArtifactDescriptorResult setManagedDependencies(List<Dependency> dependencies) {
        this.managedDependencies = dependencies == null ? new ArrayList<Dependency>() : dependencies;
        return this;
    }

    public ArtifactDescriptorResult addManagedDependency(Dependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("no dependency specified");
        }
        this.managedDependencies.add(dependency);
        return this;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public ArtifactDescriptorResult setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories == null ? new ArrayList<RemoteRepository>(2) : repositories;
        return this;
    }

    public ArtifactDescriptorResult addRepository(RemoteRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException("no repository specified");
        }
        this.repositories.add(repository);
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public ArtifactDescriptorResult setProperties(Map<String, Object> properties) {
        this.properties = properties == null ? Collections.emptyMap() : properties;
        return this;
    }

    public String toString() {
        return this.getArtifact() + " -> " + this.getDependencies();
    }
}

