/*
 * Decompiled with CFR 0.152.
 */
package com.servergeneral.sgkms.gui;

import com.servergeneral.sga.NoSGAdminException;
import com.servergeneral.sga.SGAManager;
import com.servergeneral.sgkms.ResourceManager;
import com.servergeneral.sgkms.gui.CustomAlert;
import com.servergeneral.sgkms.gui.DaFormController;
import com.servergeneral.sgkms.gui.PasswordDialog;
import com.servergeneral.sgkms.gui.PolicyFormController;
import com.servergeneral.sgkms.gui.SGKmsOPControllerv2;
import com.servergeneral.sgkms.model.Actor;
import com.servergeneral.sgkms.model.Policy;
import com.servergeneral.sgkms.util.FileUtil;
import com.servergeneral.system.MaxPwTryiesException;
import com.servergeneral.system.NullUserInfoListenerException;
import com.servergeneral.system.OperationCancelledException;
import java.io.IOException;
import java.util.Optional;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SgKmsGui
extends Application {
    private static final Logger logger = LogManager.getLogger();
    private Stage primaryStage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Stage stage) {
        SGAManager.getInstance().setUserInfoListener(new UserData());
        try {
            Scene scene;
            if (!SGAManager.isSGAdmin()) {
                throw new NoSGAdminException();
            }
            this.primaryStage = stage;
            if (SGAManager.getInstance().isLicensed() && SGAManager.getInstance().isSOCreated()) {
                FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/sg-kms-op-v2.fxml"), ResourceManager.resourceBundle);
                AnchorPane root = (AnchorPane)loader.load();
                scene = new Scene((Parent)root);
                SGKmsOPControllerv2 controller = (SGKmsOPControllerv2)loader.getController();
                controller.setSgKmsGui(this);
                controller.setPrimaryStage(this.primaryStage);
            } else {
                logger.log(Level.INFO, "sga is not configured proceeding to setup");
                FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/sg-kms-setup.fxml"), ResourceManager.resourceBundle);
                AnchorPane root = (AnchorPane)loader.load();
                scene = new Scene((Parent)root);
            }
            stage.setTitle("SG-TDE User Interface");
            stage.setScene(scene);
            stage.sizeToScene();
            stage.setResizable(false);
            stage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("/images/sg-kms.png")));
            stage.show();
        }
        catch (NoSGAdminException | MaxPwTryiesException | OperationCancelledException ex) {
            CustomAlert alert = new CustomAlert(Alert.AlertType.ERROR, "SG-KMS Error", "Error starting SG-KMS", ex.getMessage());
            alert.showAndWait();
        }
        catch (NullUserInfoListenerException ex) {
            CustomAlert alert = new CustomAlert("SG-KMS Error", null, "Error starting SG-KMS", ex);
            alert.showAndWait();
        }
        catch (IOException ex) {
            logger.log(Level.FATAL, "", (Throwable)ex);
            CustomAlert alert = new CustomAlert("SG-KMS Error", null, "Error starting SG-KMS", ex);
            alert.showAndWait();
        }
        finally {
            if (SGAManager.getInstance() != null) {
                SGAManager.getInstance().clearCache();
            }
        }
    }

    public static char[] promptForPassword(int dataType, String errMsg) {
        PasswordDialog pwDialog;
        Optional result;
        String headerText = null;
        String prompt = null;
        switch (dataType) {
            case 7: {
                headerText = ResourceManager.getString("label.data-request.sg-dmk.msg");
                prompt = ResourceManager.getString("label.dmk.caption");
                break;
            }
            case 5: {
                headerText = ResourceManager.getString("label.data-request.sg-new-dmk.msg");
                prompt = ResourceManager.getString("label.new-dmk.caption");
                break;
            }
            case 6: {
                headerText = ResourceManager.getString("label.data-request.sg-new-dmk-again.msg");
                prompt = ResourceManager.getString("label.retype-dmk.caption");
                break;
            }
            case 4: {
                headerText = ResourceManager.getString("label.data-request.sg-smk.msg");
                prompt = ResourceManager.getString("label.smk.caption");
                break;
            }
            case 2: {
                headerText = ResourceManager.getString("label.data-request.sg-new-smk.msg");
                prompt = ResourceManager.getString("label.new-smk.caption");
                break;
            }
            case 3: {
                headerText = ResourceManager.getString("label.data-request.sg-new-smk-again.msg");
                prompt = ResourceManager.getString("label.retype-smk.caption");
                break;
            }
            case 1: {
                headerText = ResourceManager.getString("label.data-request.sudo-pw.msg", System.getenv("USER"));
                prompt = ResourceManager.getString("label.sudo.pw.caption");
                break;
            }
            case 8: {
                headerText = ResourceManager.getString("info.alert.overwrite.confirm.header");
                prompt = ResourceManager.getString("label.data-request.sg-overwrite.msg");
                CustomAlert alert = new CustomAlert(CustomAlert.AlertType.YESNOCANCEL, headerText, headerText, prompt);
                Optional confirmation = alert.showAndWait();
                if (confirmation.get() == CustomAlert.YES) {
                    return "YES".toCharArray();
                }
                if (confirmation.get() == CustomAlert.NO) {
                    return "NO".toCharArray();
                }
                return null;
            }
        }
        if (errMsg != null) {
            headerText = errMsg + "\n" + headerText;
        }
        if ((result = (pwDialog = new PasswordDialog("Enter Password", headerText, prompt)).showAndWait()).isPresent()) {
            return ((String)result.get()).toCharArray();
        }
        return null;
    }

    public boolean showSOInterface(String title, Label lblStatusMsg, Label lbError) {
        try {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/so-form.fxml"), ResourceManager.resourceBundle);
            AnchorPane page = (AnchorPane)loader.load();
            Stage dialogStage = new Stage();
            dialogStage.setTitle(title);
            dialogStage.initModality(Modality.WINDOW_MODAL);
            dialogStage.initOwner((Window)this.primaryStage);
            Scene scene = new Scene((Parent)page);
            dialogStage.setScene(scene);
            DaFormController controller = (DaFormController)loader.getController();
            Actor so = FileUtil.getSO("/etc/serverg/so.conf");
            controller.setActor(so);
            controller.setType(2);
            controller.setDialogStage(dialogStage);
            controller.setLblStatusMsg(lblStatusMsg);
            controller.setLbError(lbError);
            dialogStage.showAndWait();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean showDAInterface(String title, Actor daActor, int Type2, Label lblStatusMsg, Label lbError) {
        try {
            FXMLLoader loader = Type2 == 0 ? new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/da-form.fxml"), ResourceManager.resourceBundle) : new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/da-form-edit.fxml"), ResourceManager.resourceBundle);
            AnchorPane page = (AnchorPane)loader.load();
            Stage dialogStage = new Stage();
            dialogStage.setTitle(title);
            dialogStage.initModality(Modality.WINDOW_MODAL);
            dialogStage.initOwner((Window)this.primaryStage);
            Scene scene = new Scene((Parent)page);
            dialogStage.setScene(scene);
            DaFormController controller = (DaFormController)loader.getController();
            controller.setType(Type2);
            if (Type2 == 1) {
                controller.setActor(daActor);
            } else {
                controller.cleanCurrSMK();
            }
            controller.setLblStatusMsg(lblStatusMsg);
            controller.setLbError(lbError);
            controller.setDialogStage(dialogStage);
            dialogStage.showAndWait();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean showPolicyInterface(String title, Policy policy, ObservableList<Actor> dataDA, int type, Label lblStatusMsg, Label lbError) {
        try {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/policy-form.fxml"), ResourceManager.resourceBundle);
            AnchorPane page = (AnchorPane)loader.load();
            Stage dialogStage = new Stage();
            dialogStage.setTitle(title);
            dialogStage.initModality(Modality.WINDOW_MODAL);
            dialogStage.initOwner((Window)this.primaryStage);
            Scene scene = new Scene((Parent)page);
            dialogStage.setScene(scene);
            PolicyFormController controller = (PolicyFormController)loader.getController();
            controller.setPrimaryStage(this.primaryStage);
            controller.setType(type, dataDA, policy == null ? null : policy.getDa_id().getValue(), policy);
            controller.setLbError(lbError);
            controller.setLblStatusMsg(lblStatusMsg);
            controller.setDialogStage(dialogStage);
            dialogStage.showAndWait();
            return controller.isResult();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean showReassignPolicy(String title, Policy policy, ObservableList<Actor> dataDA, Label lblStatusMsg, Label lbError) {
        try {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/policy-reassign.fxml"), ResourceManager.resourceBundle);
            AnchorPane page = (AnchorPane)loader.load();
            Stage dialogStage = new Stage();
            dialogStage.setTitle(title);
            dialogStage.initModality(Modality.WINDOW_MODAL);
            dialogStage.initOwner((Window)this.primaryStage);
            Scene scene = new Scene((Parent)page);
            dialogStage.setScene(scene);
            PolicyFormController controller = (PolicyFormController)loader.getController();
            controller.prepareReassign(dataDA, policy);
            controller.setType(2);
            controller.setLbError(lbError);
            controller.setLblStatusMsg(lblStatusMsg);
            controller.setDialogStage(dialogStage);
            dialogStage.showAndWait();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean showReassignPolicy(String title, ObservableList<Policy> dataPolicy, Label lblStatusMsg, Label lbError) {
        try {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/policy-reassign.fxml"), ResourceManager.resourceBundle);
            AnchorPane page = (AnchorPane)loader.load();
            Stage dialogStage = new Stage();
            dialogStage.setTitle(title);
            dialogStage.initModality(Modality.WINDOW_MODAL);
            dialogStage.initOwner((Window)this.primaryStage);
            Scene scene = new Scene((Parent)page);
            dialogStage.setScene(scene);
            PolicyFormController controller = (PolicyFormController)loader.getController();
            controller.prepareReassign(dataPolicy);
            controller.setType(2);
            controller.setLbError(lbError);
            controller.setLblStatusMsg(lblStatusMsg);
            controller.setDialogStage(dialogStage);
            dialogStage.showAndWait();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static class UserData
    implements SGAManager.SGADataListener {
        private UserData() {
        }

        @Override
        public char[] requestUserData(int dataType, String errMsg) {
            return SgKmsGui.promptForPassword(dataType, errMsg);
        }
    }
}

