#!/bin/bash
# 既存の設定を削除
sudo sed -i -e '/## START TG SFTP ##/,/## END TG SFTP ##/d' /etc/ssh/sshd_config

# 新しい設定を追記
cat << EOF | sudo tee -a /etc/ssh/sshd_config
## START TG SFTP ##
Match Group tg-upload
        PasswordAuthentication yes
        ChrootDirectory /home/uploader
        ForceCommand internal-sftp -l INFO -d /upload

Match Group tg-download
        PasswordAuthentication yes
        ChrootDirectory /home/downloader
        ForceCommand internal-sftp -l INFO -d /download
## END TG SFTP ##
EOF

# SSHサービスを再起動
sudo service ssh restart

echo "SFTP access enabled."
